; ---------------------------------------------------------------------
; c't Slipstreamer Version 2.01, 2.06.08
; Autor: Karsten Violka, kav@ctmagazin.de
; ---------------------------------------------------------------------
; nderungen
; 2.01:		Legt fr SP3 die Dateien win51ip.sp3 und win51ic.sp3 an
; 2.0:		Funktioniert mit XP Service Pack 3
; 1.03:		Unterscheidung zwischen XP Home und Professional
;			Der OEM-Schalter der vorigen Versionen erzeugte
;			stets ein Windows XP Home
; 1.02:		xcopy-Optionen gendert, jetzt funktioniert auch eine XP-CD
;			als Quelle
; 1.01:		Administrator-Abfrage eingebaut 
; 1.0: 		Erstes Release

#include <GUIConstants.au3>
AutoItSetOption("GUIOnEventMode", 1)

$Form2 = GUICreate("c't Slipstreamer 2.01", 478, 450, 10, 10)
GUICtrlSetFont(-1, 20, 400, 0, "Arial")

GUICtrlCreateLabel("Installationsdateien", 16, 18, 119, 20)
$inpInstallFiles = GUICtrlCreateInput("", 144, 14, 289, 22, -1, $WS_EX_CLIENTEDGE)
$btnInstallFiles = GUICtrlCreateButton("...", 440, 15, 20, 20)
$lblVersion = GUICtrlCreateLabel("Version: --", 145, 45, 300, 17)

GUICtrlCreateLabel("Zielordner", 16, 72, 65, 20)
$inpDestination = GUICtrlCreateInput("", 144, 68, 289, 22, -1, $WS_EX_CLIENTEDGE)
$btnDestination = GUICtrlCreateButton("...", 440, 69, 20, 20)

$chkServicePack = GUICtrlCreateCheckbox("Service Pack", 16, 112, 97, 17)
$inpServicePack = GUICtrlCreateInput("", 144, 108, 289, 22, -1, $WS_EX_CLIENTEDGE)
$btnServicePack = GUICtrlCreateButton("...", 440, 109, 20, 20)

$chkOverwriteOEM = GUICtrlCreateCheckbox("OEM-Dateien mit SP-Dateien berschreiben", 144, 142, 400, 17)

$radHome = GUICtrlCreateRadio ("XP Home", 144, 168, 100, 20)
GUICtrlSetState ($radHome,$GUI_CHECKED)
$radPro =  GUICtrlCreateRadio ("XP Professional", 250, 168, 120, 20)

$btnStart = GUICtrlCreateButton("Start", 392, 165, 68, 25)

$edtOutput = GUICtrlCreateEdit("",16,205,445,230,$ES_READONLY + $ES_MULTILINE + $WS_VSCROLL + $ES_AUTOVSCROLL)

;$testbutton = GUICtrlCreateButton("test", 220, 152, 75, 25)

GUISetState(@SW_SHOW)
; ----------------------------------------------------

GUISetOnEvent($GUI_EVENT_CLOSE, "evtClose")
GUICtrlSetOnEvent ($btnInstallFiles, "evtSelectSource")
GUICtrlSetOnEvent ($btnServicePack, "evtSelectSP")
GUICtrlSetOnEvent ($btnDestination, "evtSelectDestination")
GUICtrlSetOnEvent ($chkServicePack, "evtChkSlipstream")
GUICtrlSetOnEvent ($chkOverwriteOEM, "evtChkOverwriteOEM")

GUICtrlSetOnEvent ($btnStart, "evtStartButton")

GUISetState(@SW_SHOW)

$DefaultWorkingDir = @WorkingDir

init()

While 1
 Sleep(1000)   ; Warteschleife fr GUI
WEnd

Func init()
	GUICtrlSetState($inpInstallFiles, $GUI_ENABLE)
	GUICtrlSetState($btnInstallFiles, $GUI_ENABLE)
	GUICtrlSetState($inpDestination, $GUI_ENABLE)
	GUICtrlSetState($btnDestination, $GUI_ENABLE)
	GUICtrlSetState($chkServicePack, $GUI_ENABLE)
	GUICtrlSetState($radHome, $GUI_DISABLE)
	GUICtrlSetState($radPro, $GUI_DISABLE)
	GUICtrlSetState($btnStart, $GUI_DISABLE)
	
	evtChkSlipstream()
	checkInput()
EndFunc

Func evtSelectSource()
  $folder = FileSelectFolder ( "Whlen Sie das Verzeichnis der Windows-Installationsdateien", "", 2 )
	If $folder <> "" Then
		GUICtrlSetData ($inpInstallFiles, $folder)
	EndIf
	checkInput()
EndFunc

Func evtSelectSP()
  $sp = FileOpenDialog("Whlen Sie das Service Pack aus", "", "Service Pack (*.exe)", 2)
	If $sp == 1 Then $sp = ""
	GUICtrlSetData ($inpServicePack, $sp)
	checkInput()
EndFunc

Func evtSelectDestination()
  $folder = FileSelectFolder ( "Whlen Sie das Zielverzeichnis, in das die neuen Installationsdateien kopiert werden", "", 3)
	If $folder <> "" Then
		GUICtrlSetData ($inpDestination, $folder)
	EndIf
	checkInput()
EndFunc

Func evtChkSlipstream()
	If Not IsAdmin() And GUICtrlRead($chkServicePack) == $GUI_CHECKED Then
			MsgBox(48,"Keine Administratorrechte", "Sie bentigen Administratorrechte, um das Service Pack zu integrieren.")
			GUICtrlSetState($chkServicePack, $GUI_UNCHECKED)
	EndIf
	
	If GUICtrlRead($chkServicePack) == $GUI_CHECKED Then
		GUICtrlSetState($inpServicePack, $GUI_ENABLE)
		GUICtrlSetState($btnServicePack, $GUI_ENABLE)
		GUICtrlSetState($chkOverwriteOEM, $GUI_ENABLE)
		evtChkOverwriteOEM()
	Else
		GUICtrlSetState($inpServicePack, $GUI_DISABLE)
		GUICtrlSetState($btnServicePack, $GUI_DISABLE)
		GUICtrlSetState($chkOverwriteOEM, $GUI_DISABLE)
		GUICtrlSetState($radHome, $GUI_DISABLE)
		GUICtrlSetState($radPro, $GUI_DISABLE)
	EndIf
	checkInput()
EndFunc

Func evtChkOverwriteOEM()
	If GUICtrlRead($chkOverwriteOEM) == $GUI_CHECKED Then
		GUICtrlSetState($radHome, $GUI_ENABLE)
		GUICtrlSetState($radPro, $GUI_ENABLE)
	Else
		GUICtrlSetState($radHome, $GUI_DISABLE)
		GUICtrlSetState($radPro, $GUI_DISABLE)
	EndIf
EndFunc

Func evtClose()
  ;Note: at this point @GUI_CTRLID would equal $GUI_EVENT_CLOSE,
  ;and @GUI_WINHANDLE would equal $mainwindow
  ; MsgBox(0, "GUI Event", "You clicked CLOSE! Exiting...")
  Exit
EndFunc

Func checkInput()
	If checkInstallFolder() And GUICtrlRead($inpDestination) <> "" Then
		GUICtrlSetState($btnStart, $GUI_ENABLE)
		If GUICtrlRead($chkServicePack) == $GUI_CHECKED Then
			If Not FileExists(GUICtrlRead($inpServicePack)) Then
				GUICtrlSetState($btnStart, $GUI_DISABLE)
			EndIf
		EndIf
	Else
		GUICtrlSetState($btnStart, $GUI_DISABLE)
	EndIf
EndFunc

Func checkInstallFolder()
	$myPath = GUICtrlRead($inpInstallFiles)
	If $myPath <> "" Then
		If checki386($myPath) Then Return 1
		If FileExists($myPath & "\i386") Then
			If checki386($myPath & "\i386") Then Return 1
		EndIf
	EndIf
	Return 0
EndFunc

Func checki386($path)
	If FileExists($path & "\ntdll.dll") Then
		$ver=FileGetVersion($path & "\ntdll.dll")
		If $ver == "5.1.2600.2180" Then $ver = $ver & " Service Pack 2"
		GUICtrlSetData($lblVersion, "Version: " & $ver)
		Return 1
	Else
		GUICtrlSetData($lblVersion, "Version: --")
		Return 0
	EndIf
EndFunc

Func disableInput()
	GUICtrlSetState($inpInstallFiles, $GUI_DISABLE)
	GUICtrlSetState($btnInstallFiles, $GUI_DISABLE)
	GUICtrlSetState($inpDestination, $GUI_DISABLE)
	GUICtrlSetState($btnDestination, $GUI_DISABLE)
	GUICtrlSetState($chkServicePack, $GUI_DISABLE)
	GUICtrlSetState($inpServicePack, $GUI_DISABLE)
	GUICtrlSetState($btnServicePack, $GUI_DISABLE)
	GUICtrlSetState($chkOverwriteOEM, $GUI_DISABLE)
	GUICtrlSetState($btnStart, $GUI_DISABLE)
	GUICtrlSetState($radHome, $GUI_DISABLE)
	GUICtrlSetState($radPro, $GUI_DISABLE)
EndFunc

Func evtStartButton()
	disableInput()
	doSlipstream()
	init()
EndFunc

Func doSlipstream()
	print("--- Start ------------------------------------------------")
	If Not checkFolders() Then return 0
	
	$source = removeTrailingBackslash(GUICtrlRead($inpInstallFiles))
	$destination = removeTrailingBackslash(GUICtrlRead($inpDestination))
	$destCDRoot = $destination & "\cdroot"
	$desti386 = $destCDRoot & "\i386"

	If Not FileExists($destCDRoot) Then
		DirCreate($destCDRoot)
	EndIf

	If FileExists($source & "\ntdll.dll") Then
		$copydest=$desti386
		print('Erstelle Verzeichnis "' & $copydest & '"')
		DirCreate($copydest)
	Else
		$copydest=$destCDRoot
	EndIf
	
	print('Kopiere ' & '"' & $source & '" nach "' & $copydest & '"...')
	
	$result = RunWait(@ComSpec & ' /c xcopy "' & $source & '" "' & $copydest & '" /r/e/i/s/h/y');, "", @SW_HIDE);
	
	If $result <> 0 Then
		print("--> Fehler: Kopieren fehlgeschlagen")
		Return
	EndIf
	
	If GUICtrlRead($chkServicePack) == $GUI_CHECKED Then
		print ('Entpacke Service Pack nach "' & $destination & "\spfiles" & '" ...')
		
		$ret = RunWait(GUICtrlRead($inpServicePack) & ' /passive /x:"' & $destination & '\spfiles"')
		If $ret<>0 Then
			print ("--> Fehler: Entpacken fehlgeschlagen, Fehlercode: " & $ret)
			Return
		EndIf
		
		print ('Integriere Service Pack in den Zielordner...')
		
		If FileExists($desti386 & "\svcpack.inf") Then FileDelete($desti386 & "\svcpack.inf")
			
		$ret = RunWait($destination & '\spfiles\i386\update\update.exe /o /integrate:"' & $destCDRoot & '"')
		
		If $ret<>0 Then
			print ("--> Fehler: Slipstream fehlgeschlagen, Fehlercode: " & $ret)
			Return
		EndIf
	
		FileChangeDir($DefaultWorkingDir)
		
		If GUICtrlRead($chkOverwriteOEM) == $GUI_CHECKED Then
			If GUICtrlRead($radHome) == $GUI_CHECKED Then
				print("berschreibe OEM-Dateien mit SP-Dateien fr XP Home...")
				$copycmd = @ComSpec & ' /c xcopy "' & $destination & '\spfiles\i386\ic" "' & $desti386 & '" /r/e/i/s/h/y'
				$result = RunWait($copycmd)
				If $result <> 0 Then
					print("--> Fehler: Kopieren fehlgeschlagen")
					Return
				EndIf
			EndIf
			
			If GUICtrlRead($radPro) == $GUI_CHECKED Then
				print("berschreibe OEM-Dateien mit SP-Dateien fr XP Professional...")
				$copycmd = @ComSpec & ' /c xcopy "' & $destination & '\spfiles\i386\ip" "' & $desti386 & '" /r/e/i/s/h/y'
				$result = RunWait($copycmd)
				If $result <> 0 Then
					print("--> Fehler: Kopieren fehlgeschlagen")
					Return
				EndIf
			EndIf
		EndIf
		DirRemove($destination & "\spfiles", 1)
	EndIf
	
	If FileExists($desti386 & '\spcmdcon.sys') Then
		print("Erstelle Bootimage...")
		$spcmdversion = FileGetVersion($desti386 & '\spcmdcon.sys')
		
		If $spcmdversion = "5.1.2600.0" Then	; RTM-Version ohne jedes Service Pack
			$offset=76160
		ElseIf $spcmdversion = "5.1.2600.5512" Then	; Service Pack 3
			print("SP3")
			$offset=84352
		Else
			$offset=84224 ; Service Pack 2 (und 1?)
		EndIf
		$ddcmd = @ComSpec & ' /c dd if="' & $desti386 & '\spcmdcon.sys" of="' & $destCDRoot & '\bootimage.bin" bs=1 skip=' & $offset & ' count=2048'
		RunWait($ddcmd)
	Else
		print("--> Fehler: Datei spcmdcon.sys nicht gefunden")
		return 
	EndIf
	
	createWinFiles($destCDRoot)
	
	;Antwortdatei fr unbeaufsichtigte Installation hinzufgen
	;FileCopy(@WorkingDir & "\winnt.sif", $desti386)
	
	If FileExists($destCDRoot & "\boot.catalog") Then FileDelete($destCDRoot & "\boot.catalog")
	
	$mkisocmd = @ComSpec & ' /c mkisofs -relaxed-filenames -d -D -N -J -b bootimage.bin -no-emul-boot -boot-load-size 4 -hide bootimage.bin -hide boot.catalog -o "' & $destination & '\xpcd.iso" "' & $destCDRoot & '"'
	
	print('Erstelle Image-Datei "' & $destination & '\xpcd.iso"...')
	$ret=RunWait($mkisocmd)
	If $ret <> 0 Then
		print("--> Fehler: Image konnte nicht erstellt werden")
		return
	EndIf
	print("--- Fertig! ----------------------------------------------")
EndFunc

Func checkFolders()
	If FileExists(GUICtrlRead($inpInstallFiles)) Then
		If FileExists(GUICtrlRead($inpDestination)) Then
			Return 1
		Else
			print('Erstelle Zielverzeichnis "' & GUICtrlRead($inpDestination) & '"')			
			If DirCreate($inpDestination) Then
				Return 1
			Else
				print("--> Fehler: Zielverzeichnis konnte nicht erstellt werden")
				Return 0
			EndIf
		EndIf
	Else
		print("--> Fehler: Pfad zu den Installationsdateien existiert nicht!")
		Return 0
	EndIf
EndFunc

Func createWinFiles($path)
	print("Fge Markierungsdateien hinzu...")

	$file = FileOpen($path & "\win51",2)
	FileWrite($file, "Windows " & @CRLF)
	FileClose($file)
	
	$file = FileOpen($path & "\win51ic",2)
	FileWrite($file, "Windows " & @CRLF)
	FileClose($file)
		
	$file = FileOpen($path & "\win51ic.sp1",2)
	FileWrite($file, @CRLF)
	FileClose($file)
		
	$file = FileOpen($path & "\win51ic.sp2",2)
	FileWrite($file, @CRLF)
	FileClose($file)	
	
	$file = FileOpen($path & "\win51ic.sp3",2)
	FileWrite($file, @CRLF)
	FileClose($file)	

	$file = FileOpen($path & "\win51ip",2)
	FileWrite($file, "Windows " & @CRLF)
	FileClose($file)
	
	$file = FileOpen($path & "\win51ip.sp1",2)
	FileWrite($file, @CRLF)
	FileClose($file)
	
	$file = FileOpen($path & "\win51ip.sp2",2)
	FileWrite($file, @CRLF)
	FileClose($file)
	
	$file = FileOpen($path & "\win51ip.sp3",2)
	FileWrite($file, @CRLF)
	FileClose($file)
EndFunc

; ----- Hilfsfunktionen

Func removeTrailingBackslash($path)
	If StringRight($path, 1) == "\" Then
		return StringTrimRight($path, 1)
	Else
		return $path
	EndIf
EndFunc

Func print($text)
	GUICtrlSetData ($edtOutput, GUICtrlRead($edtOutput) & $text & @CRLF)
EndFunc