#include <QApplication>
#include <QTranslator>
#include "ExpenseHelper.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QTranslator* translator = new QTranslator( &a );
    translator->load( "expensehelper_de.qm" );
    a.installTranslator( translator );

    // Read the exchange rates
    ExchangeRateReader reader;

    ExpenseHelper expenseHelper( reader.rates() );
    QObject::connect( &reader, SIGNAL( ratesParsed() ),
                      &expenseHelper, SLOT( slotRatesParsed() ) );
    return expenseHelper.exec();
}
