#ifndef EXCHANGERATEREADER_H
#define EXCHANGERATEREADER_H

#include <QMap>
#include <QPair>
#include <QDate>
#include <QObject>
#include <QHttp>
#include <QTemporaryFile>
#include "ExchangeRateParserThread.h"
class QProgressDialog;

class ExchangeRateReader : public QObject
{
    Q_OBJECT

public:
    ExchangeRateReader();

    const ExchangeRates* rates() const { return &mExchangeRates; }

signals:
    void ratesParsed();

private slots:
    void slotDownloadDone( bool );
    void slotReadProgress( int, int );

private:
    ExchangeRates mExchangeRates;

    QHttp mHttp;
    QTemporaryFile mFile;
    ExchangeRateParserThread mParserThread;
    QProgressDialog* mProgressDialog;
};



#endif /* EXCHANGERATEREADER_H */

