/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: mcu.h
 * Info: Allgemeine Definitionen
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.04
*/

/************************************************************
* Module switches, to make code smaller if features are not needed
************************************************************/
#define RTC_AVAILABLE		// Real Time Clock
#define RTC_HTTPTIME_AVAILABLE	// RTC fetches Time from HTTP-Server
#define RTC_FULL_AVAILABLE	// Full means RTC counts days, month, years
#define EVENT_AVAILABLE		// Eventmanagement, needs RTC

#define LED_AVAILABLE		// LEDs for local control
#define KEY_AVAILABLE		// Keys for local control
#define IR_AVAILABLE		// Infrared Remote Control
#define RC5_AVAILABLE		// Key-Mapping for IR-RC	

#define UART_AVAILABLE		// Serial Communication
#define COMMAND_AVAILABLE	// High-Level Communication over Uart, needs UART 

#define DISPLAY_AVAILABLE	// Display for local control
//#define TICKER_AVAILABLE	// Just nice Info, needs DISPLAY
#define WELCOME_AVAILABLE	// Just nice Info, needs DISPLAY

//#define ADC_AVAILABLE		// A/D-Converter for sensing Power
//#define FILTER_AVAILABLE	// Filter for ADC, eliminates 100 Hz noise
//#define PT100_AVAILABLE		// Temperatur sensors

#define TOOLS_AVAILABLE		// String-Tools and Beep

//#define DREH_AVAILABLE	// Local control by "drehgeber"

/************************************************************
* Some Dependencies!!!
************************************************************/

#ifndef DISPLAY_AVAILABLE
	#undef TICKER_AVAILABLE
	#undef WELCOME_AVAILABLE
#endif

#ifndef RTC_AVAILABLE
	#undef EVENT_AVAILABLE
	#undef RTC_HTTPTIME_AVAILABLE
	#undef RTC_FULL_AVAILABLE
#endif

#ifndef IR_AVAILABLE
	#undef RC5_AVAILABLE
#endif

#ifndef UART_AVAILABLE
	#undef COMMAND_AVAILABLE
	#undef RTC_HTTPTIME_AVAILABLE
#endif



#define uint16                  word

#define XTAL	14745600L    // Crystal frequency in Hz

#ifndef CDEF_H
	#define CDEF_H
	
	typedef unsigned char byte;                       /* vorzeichenlose 8-Bit-Zahl */
	typedef unsigned int word;                        /* vorzeichenlose 16-Bit-Zahl */
	typedef signed char int8;                         /* vorzeichenbehaftete 8-Bit-Zahl */
	typedef signed int int16;                         /* vorzeichenbehaftete 16-Bit-Zahl */
	typedef byte bool;                                /* True/False Aussage */
//	typedef unsigned long dword;                      /* Long-Zahl */
//	typedef signed long int32;
	
	#define True                  1
	#define False                 0
	
	#define On                    1
	#define Off                   0
	
	#define NULL 0
#endif

