/* c't-Netz-Schalter Demo Source
 * Datei: rc5.c
 * Info: RC5-Fernbedienung
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.04
*/
#include "../mcu.h"
#include "ir.h"
#include "schalt.h"

#ifdef RC5_AVAILABLE

#define RC5_CODE_RELAIS_1	0x3941
#define RC5_CODE_RELAIS_2	0x3942
#define RC5_CODE_RELAIS_3	0x3943
#define RC5_CODE_RELAIS_4	0x3944
#define RC5_CODE_RELAIS_5	0x3945
#define RC5_CODE_RELAIS_6	0x3946
#define RC5_CODE_RELAIS_7	0x3947
#define RC5_CODE_RELAIS_ALL	0x394C

uint16 RC5_Code;        // Last received RC5-Code

/*reads a RC5-Codeword and switches Relais */
void rc5_control(void){
	char relais;
	uint16 rc5=ir_read();
	if (rc5 !=0) {
		relais=Relais_get();
		RC5_Code=rc5|0x0800;
		
		switch(RC5_Code){
			case RC5_CODE_RELAIS_1:
				relais= (relais & (~0x01)) | (~relais & (0x01)); 
				break;
			case RC5_CODE_RELAIS_2:
				relais= (relais & (~0x02)) | (~relais & (0x02)); 
				break;
			case RC5_CODE_RELAIS_3:
				relais= (relais & (~0x04)) | (~relais & (0x04)); 
				break;
			case RC5_CODE_RELAIS_4:
				relais= (relais & (~0x08)) | (~relais & (0x08)); 
				break;
			case RC5_CODE_RELAIS_5:
				relais= (relais & (~0x10)) | (~relais & (0x10)); 
				break;
			case RC5_CODE_RELAIS_6:
				relais= (relais & (~0x20)) | (~relais & (0x20)); 
				break;
			case RC5_CODE_RELAIS_7:
				relais= (relais & (~0x40)) | (~relais & (0x40)); 
				break;
			case RC5_CODE_RELAIS_ALL:
				if (relais==0)
					relais=0x7F;
				else
					relais=0x00;
				break;
	
		}
		Relais_set(relais);
	}
}
#endif
