/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: led.c 
 * Info: Routinen zur LED-Steuerung
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <avr/io.h>
#include "led.h"
#include "../mcu.h"

#ifdef LED_AVAILABLE

void LED_init(){
	DDRD|= LED_ALL;	// LED-Ports als Ausgang
	LED_off(LED_ALL);
}

void LED_on(char LED){
	PORTD &= ~(LED & LED_ALL);
}

void LED_off(char LED){
	PORTD |= (LED & LED_ALL);	// LED ausschalten
}

//Der Wert der Variablen LED wird mit den LEDs (allen vier) angezeigt. Rot=Bit0
void LED_set(char LED){
	PORTD= (PORTD & ~LED_ALL) | ((~LED << 3) & LED_ALL); 
}

/*
#include "delay.h"
void lauflicht(char runs){
	LED_off(LED_ALL);
	int i=0;
	while (i<runs){
		LED_on(LED_ROT);
		delay_100ms();
		LED_off(LED_ROT);
		
		LED_on(LED_ORANGE);
		delay_100ms();
		LED_off(LED_ORANGE);
		
		LED_on(LED_GELB);
		delay_100ms();
		LED_off(LED_GELB);
		
		LED_on(LED_GRUEN);
		delay_100ms();
		LED_off(LED_GRUEN);
		i++;
	}
}
*/
#endif
