; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               ThesauroToolTip
; -----------------------------------------------------------------------------
; Prefix:             ttt_
; Version:            0.2
; Date:               2006-02-24
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

; Initialisierungsroutine, welche beim Start von ac'tivAid aufgerufen wird.
init_ThesauroToolTip:
   Prefix = ttt
   %Prefix%_ScriptName    = ThesauroToolTip
   %Prefix%_ScriptVersion = 0.2
   %Prefix%_Author        = Wolfgang Reszel
   RequireExtensions      =
   CustomHotkey_ThesauroToolTip = 1           ; automatisches benutzerdefinierbares Tastaturkrzel? (1 = ja)
   Hotkey_ThesauroToolTip       = ^+t         ; Standard-Hotkey
   HotkeyPrefix_ThesauroToolTip =             ; Prfix, welches vor immer vor dem Tastaturkrzel gesetzt wird

   ; Sprachabhngige Variablen
   If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %ttt_ScriptName% - Synonyme vom markierten Wort
      Description                   = Zeigt mittels des Thesaurus von wortschatz.uni-leipzig.de Synonyme fr das markierte Wort als Tooltip an.
      lng_ttt_NothingFound          = Suchbegriff nicht gefunden`nBitte auch die Gro-/Kleinschreibung beachten
      lng_ttt_Error                 = Fehler beim Zugriff auf wortschatz.uni-leipzig.de.
      lng_ttt_LeoOnMbutton          = Suche automatisch ausfhren, wenn ein Wort mit der mittleren Maustaste markiert wird. (MouseClip)
      lng_ttt_Searching             = Verbinde mit
      lng_ttt_UseBasicForm          = Verwende Grundform von
      lng_ttt_BasicForm             = Grundform
   }
   else        ; = Alternativ-Sprache (wenn nicht Deutsch und keine language.ini vorhanden)
   {
      MenuName                      = %ttt_ScriptName% - synonyms of the selected word
      Description                   = Shows synonyms of the selected word as an tooltip via the thesaurus of wortschatz.uni-leipzig.de. This works only for the german language.
      lng_ttt_NothingFound          = search item not found`nplease mind the case
      lng_ttt_Error                 = Error while accessing wortschatz.uni-leipzig.de.
      lng_ttt_LeoOnMbutton          = Search automatically when selecting a word with the middle mouse-button. (MouseClip)
      lng_ttt_Searching             = Connecting to
      lng_ttt_UseBasicForm          = Using basic form of
      lng_ttt_BasicForm             = Basic form
   }

   IniRead, ttt_EnableMButton, %ConfigFile%, ThesauroToolTip, LeoOnMButton, 0

   ttt_WebBrowsers = OpWindow,MozillaUIWindowClass,IEFrame
Return

SettingsGui_ThesauroToolTip:
   If Enable_MouseClip = 1
      Gui, Add, Checkbox, -Wrap xs+10 y+5 gttt_sub_MouseClip vttt_EnableMButton Checked%ttt_EnableMButton%, %lng_ttt_LeoOnMbutton%
Return

ttt_sub_MouseClip:
   Gosub, sub_CheckIfSettingsChanged
   GuiControlGet, ttt_EnableMButton_tmp,,ttt_EnableMButton
   If (ttt_EnableMButton_tmp = 1 AND Enable_LeoToolTip <> "")
      GuiControl,,leo_EnableMButton,0
Return

SaveSettings_ThesauroToolTip:
   IniWrite, %ttt_EnableMButton%, %ConfigFile%, ThesauroToolTip, LeoOnMButton
Return

AddSettings_ThesauroToolTip:
Return

CancelSettings_ThesauroToolTip:
Return

DoEnable_ThesauroToolTip:
   If (ttt_EnableMButton = 1 AND Enable_MouseClip =1)
   {
      Extend_MButton3 = sub_MButton_ThesauroToolTip
      mc_NoPaste = yes
   }
Return

DoDisable_ThesauroToolTip:
   If (ttt_EnableMButton = 1 AND Enable_MouseClip =1)
   {
      Extend_MButton3 =
      mc_NoPaste =
   }
Return

DefaultSettings_ThesauroToolTip:
Return

OnExitAndReload_ThesauroToolTip:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

; Unterroutine fr das automatische Tastaturkrzel
sub_Hotkey_ThesauroToolTip:
   WinGetClass, ttt_WinClass, A

   If ttt_WinClass Contains %ttt_WebBrowsers%
   {
      ttt_ttX =
      ttt_ttY =
   }
   Else
   {
      ttt_ttX := A_CaretX+10
      ttt_ttY := A_CaretY+10
   }
   gosub, ttt_sub_Search
   SetTimer, ttt_tim_ToolTipOff, 10000
   If A_OSType <> WIN32_WINDOWS
   {
      Input,ttt_GetKey, L1,{PrintScreen}{ScrollLock}{Pause}{PgUp}{PgDn}{Home}{End}{Ins}{Del}{BackSpace}{F1}{F2}{F3}{F4}{F5}{F6}{F7}{F8}{F9}{F10}{F11}{F12}{F13}{F14}{F15}{F16}{F17}{F18}{F19}{F20}{F21}{F22}{F23}{F24}{F25}{F26}{F27}{F28}{F29}{F30}{Space}{Left}{Right}{Up}{Down}{NumLock}{NumPad1}{NumPad2}{NumPad3}{NumPad4}{NumPad5}{NumPad6}{NumPad7}{NumPad8}{NumPad9}{NumPad0}{NumPadAdd}{NumPadSub}{NumPadMult}{NumPadDiv}{NumPadDot}{NumPadEnter}{NumPadDot}abcdefghijklmnopqrstuvwxyz1234567890!"$`%&/()=+#-.`,*'_:`;<>^``{AppsKey}{Esc}{Tab}{Enter}{CtrlBreak}{Help}{Sleep}{Browser_Back}{Browser_Forward}{Browser_Refresh}{Browser_Stop}{Browser_Search}{Browser_Favorites}{Browser_Home}{Volume_Mute}{Volume_Down}{Volume_Up}{Media_Next}{Media_Prev}{Media_Stop}{Media_Play_Pause}{Launch_Mail}{Launch_Media}{Launch_App1}{Launch_App2}{NumpadDel}{NumpadIns}{NumpadClear}{NumpadUp}{NumpadDown}{NumpadLeft}{NumpadRight}{NumpadHome}{NumpadEnd}{NumpadPgUp}{NumpadPgDn}[]\?|~{{}{}}
      If ErrorLevel contains Endkey:
      {
         StringReplace, ttt_GetKey, ErrorLevel, Endkey:,
         If StrLen(ttt_GetKey) > 1
            ttt_GetKey = {%ttt_GetKey%}
         StringLower, ttt_GetKey, ttt_GetKey
      }
      Getkeystate,ttt_GetKeyCtrl,Ctrl
      Getkeystate,ttt_GetKeyAlt,Alt
      Getkeystate,ttt_GetKeyShift,Shift
      Getkeystate,ttt_GetKeyLWin,LWin,
      Getkeystate,ttt_GetKeyRWin,RWin,
      Getkeystate,ttt_GetKeyCapsLock,CapsLock

      If ttt_GetKeyShift = D
         ttt_GetKey = +%ttt_GetKey%
      If ttt_GetKeyAlt = D
         ttt_GetKey = !%ttt_GetKey%
      If ttt_GetKeyCtrl = D
         ttt_GetKey = ^%ttt_GetKey%
      If (ttt_GetKeyLWin = "D" OR ttt_GetKeyRWin = "D")
         ttt_GetKey = #%ttt_GetKey%
      If ttt_GetKeyCapsLock = D
         ttt_GetKey = ~CapsLock & %ttt_GetKey%

      Send, %ttt_GetKey%
      Gosub, ttt_tim_ToolTipOff
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

sub_MButton_ThesauroToolTip:
   ttt_ttX =
   ttt_ttY =
   gosub, ttt_sub_Search
Return

ttt_sub_Search:
   AutoTrim, On

   ttt_searchOrig := func_GetSelection()
   ttt_searchFor := ttt_func_URLEncode(ttt_searchOrig)

   tooltip, , , , 7

   StringCaseSense, On
   If ( ( ttt_searchFor <> ttt_lastSearch AND ttt_searchFor <> "" ) OR (ttt_lastSearch = "" AND ttt_searchFor ="") )
   {
      StringCaseSense, Off
      tooltip, %lng_ttt_Searching% wortschatz.uni-leipzig.de ..., %ttt_ttX%, %ttt_ttY%, 7
      URLDownloadToFile, http://wortschatz.uni-leipzig.de/cgi-bin/wort_www?site=1&Wort=%ttt_searchFor%&sprache=de&cs=1, %A_Temp%\tttahk.tmp
      FileRead, ttt_Query, %A_Temp%\tttahk.tmp
      FileDelete, %A_Temp%\tttahk.tmp

      StringGetPos, ttt_found, ttt_Query,  <B>Relationen zu anderen W&ouml`;rtern:</B><UL>
      StringTrimLeft, ttt_Result, ttt_Query, %ttt_found%

      ttt_AddResult =

      If ttt_found = -1
      {
         StringGetPos, ttt_tmp, ttt_Query, <LI>Grundform:%A_Space%%A_Space%`n
         StringTrimLeft, ttt_Result, ttt_Query, %ttt_tmp%
         StringSplit, ttt_Result, ttt_Result, `n
         StringGetPos, ttt_tmp, ttt_Result3, <
         StringLeft, ttt_searchFor, ttt_Result3, %ttt_tmp%
         ttt_searchFor := ttt_func_StripHtml(ttt_searchFor)

         tooltip, %lng_ttt_UseBasicForm% %ttt_searchOrig% ..., %ttt_ttX%, %ttt_ttY%, 7
         URLDownloadToFile, http://wortschatz.uni-leipzig.de/cgi-bin/wort_www?site=1&Wort=%ttt_searchFor%&sprache=de&cs=1, %A_Temp%\tttahk.tmp
         FileRead, ttt_Query, %A_Temp%\tttahk.tmp
         FileDelete, %A_Temp%\tttahk.tmp

         StringGetPos, ttt_found, ttt_Query,  <B>Relationen zu anderen W&ouml`;rtern:</B><UL>
         StringTrimLeft, ttt_Result, ttt_Query, %ttt_found%

         If ttt_found = -1
            ttt_FinalResult = %lng_ttt_NothingFound%

         ttt_AddResult := "    " lng_ttt_BasicForm ": " ttt_searchFor
      }
      ttt_AddResult := ttt_func_StripHtml(ttt_searchOrig) ttt_AddResult "`n`n"

      StringGetPos, ttt_tmp, ttt_Result, <B>Links zu anderen W&ouml`;rtern:</B><UL>
      StringLeft, ttt_Result, ttt_Result, %ttt_tmp%
      StringReplace, ttt_Result, ttt_Result, <B>Relationen zu anderen W&ouml`;rtern:</B><UL>`n,
      ttt_Result := ttt_func_StripHtml(ttt_Result)
                                         ; anders
      StringReplace, ttt_Result, ttt_Result, `,%A_Space%`n`n, `,%A_Space% , A
      StringReplace, ttt_Result, ttt_Result, :%A_Space%%A_Space%`n`n, :`n%A_Space%%A_Space%%A_Space%%A_Space% , A

      StringReplace, ttt_Result, ttt_Result, ist Synonym von:, `n`nist Synonym von:, A
      StringReplace, ttt_Result, ttt_Result, wird referenziert von:, `n`nwird referenziert von:, A
      StringReplace, ttt_Result, ttt_Result, vergleiche:, `n`nvergleiche:, A

      If ( func_StrLeft(ttt_Result, 2) = "`n`n" )
         StringTrimLeft, ttt_Result, ttt_Result, 2

      If ttt_found > 0
      {
         ttt_FinalResult =
         Loop, Parse, ttt_Result, `,
         {
            IfInstring, A_LoopField, :
               ttt_Words = 0
            ttt_Words++
            If ttt_Words > 5
            {
               ttt_Words = 0
               ttt_FinalResult := ttt_FinalResult A_LoopField ",`n   "
            }
            Else
               ttt_FinalResult := ttt_FinalResult A_LoopField ", "
         }
         ttt_FinalResult = %ttt_AddResult%%ttt_FinalResult%

         Loop
         {
            StringRight, ttt_tmp, ttt_FinalResult, 1
            If (ttt_tmp = " " OR ttt_tmp = "," OR ttt_tmp = "`n")
               StringTrimRight, ttt_FinalResult, ttt_FinalResult, 1
            Else
               Break
         }
      }
   }
   Else
      ttt_searchFor = %ttt_lastSearch%

   StringCaseSense, Off

   ttt_lastSearch = %ttt_searchFor%
   MouseGetPos, ttt_startX, ttt_startY
   tooltip, %ttt_FinalResult%, %ttt_ttX%, %ttt_ttY%, 7
   SetTimer, ttt_tim_WatchToolTip, 20
   SetTimer, ttt_tim_ToolTipOff, 5000
Return

ttt_func_URLEncode(ttt_url)
{
   SetFormat, integer, hex
   StringReplace, ttt_url, ttt_url, %A_Space%, `%20
   Loop, 127
   {
      ttt_HexCode := A_Index+127
      Transform, ttt_HighChar, Chr, %ttt_HexCode%
      StringReplace, ttt_HexCode, ttt_HexCode, 0x,`%
      StringReplace, ttt_url, ttt_url, %ttt_HighChar%, %ttt_HexCode%
   }
   SetFormat, integer, dec
   Return %ttt_url%
}

ttt_tim_ToolTipOff:
   SetTimer, ttt_tim_ToolTipOff, Off
   tooltip,,,,7
   SetTimer, ttt_tim_WatchToolTip, Off
Return

ttt_tim_WatchToolTip:
   MouseGetPos, ttt_X, ttt_Y, ttt_WinID
   If ttt_startX <>
   {
      If (ttt_X > ttt_StartX+4 OR ttt_Y > ttt_StartY+4 OR ttt_X < ttt_StartX-4 OR ttt_Y < ttt_StartY-4)
      {
         ttt_startX =
         SetTimer, ttt_tim_ToolTipOff, 2000
      }
   }
   WinGetTitle, ttt_TipText, ahk_id %ttt_WinID%
   If ttt_TipText = %ttt_FinalResult%
   {
      GetKeyState, ttt_LButton, LButton
      GetKeyState, ttt_RButton, RButton
      If ttt_LButton = D
         Gosub, ttt_tim_ToolTipOff
      Else If ttt_RButton = D
      {
         Gosub, ttt_tim_ToolTipOff
         Run, http://wortschatz.uni-leipzig.de/cgi-bin/wort_www?site=1&Wort=%ttt_searchFor%&sprache=de&cs=1
      }
      Else
         SetTimer, ttt_tim_ToolTipOff, 1000
   }
   GetKeyState, ttt_ESC, ESC
   If ttt_ESC = D
      SetTimer, ttt_tim_ToolTipOff, 1
Return

ttt_func_StripHtml(ttt_string)
{
   Loop
   {
      StringGetPos, ttt_begin, ttt_string, <
      StringGetPos, ttt_end, ttt_string, >,, %ttt_begin%
      If (ttt_begin = -1 OR ttt_end = -1)
         Break
      StringLeft, ttt_new1, ttt_string, %ttt_begin%
      StringTrimLeft, ttt_new2, ttt_string, % ttt_end+1
      ttt_string = %ttt_new1%%ttt_new2%
   }
   StringReplace, ttt_string, ttt_string, &auml`;, , A
   StringReplace, ttt_string, ttt_string, &uuml`;, , A
   StringReplace, ttt_string, ttt_string, &ouml`;, , A
   StringReplace, ttt_string, ttt_string, &Auml`;, , A
   StringReplace, ttt_string, ttt_string, &Ouml`;, , A
   StringReplace, ttt_string, ttt_string, &Uuml`;, , A
   StringReplace, ttt_string, ttt_string, &szlig`;, , A
   StringReplace, ttt_string, ttt_string, &nbsp`;, %A_Space%, A
   Return ttt_string
}
