; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               ReadingRuler
; -----------------------------------------------------------------------------
; Prefix:             rr_
; Version:            0.6
; Date:               2006-03-09
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_ReadingRuler:
   Prefix = rr
   %Prefix%_ScriptName    = ReadingRuler
   %Prefix%_ScriptVersion = 0.6
   %Prefix%_Author        = Wolfgang Reszel

   CustomHotkey_ReadingRuler = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_ReadingRuler       = #+   ; Standard-Hotkey
   HotkeyPrefix_ReadingRuler =      ; 'Durchgeschleiftes' Hotkey

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %rr_ScriptName% - Lese-Lineal
      Description                   = Zeigt ein Lese-Lineal oder Fadenkreuz an, welches der Maus folgt. Erleichtert das Lesen am Bildschirm.
      lng_rr_Crosshair              = Fadenkreuz
      lng_rr_Color                  = Linien-Farbe
      lng_rr_Red                    = Rot:
      lng_rr_Green                  = Grn:
      lng_rr_Blue                   = Blau:
      lng_rr_Coord                  = Koordinaten anzeigen:
      lng_rr_CoordNoOpt             = keine
      lng_rr_CoordOpt2              = nur aktuelle Position
      lng_rr_CoordOpt3              = mit Distanz von der Position wo ReadingRuler aufgerufen wurde
      lng_rr_ShowStart              = Startposition als Fadenkreuz anzeigen
      lng_rr_LineThickness          = Linienstrke
   }
   else        ; = other languages (english)
   {
      MenuName                      = %rr_ScriptName% - ruler that helps reading
      Description                   = Shows a horizontal line or a crosshair to help you reading texts on screen
      lng_rr_Crosshair              = Crosshair
      lng_rr_Color                  = ruler-colour
      lng_rr_Red                    = Red:
      lng_rr_Green                  = Green:
      lng_rr_Blue                   = Blue:
      lng_rr_Coord                  = Show coordinates:
      lng_rr_CoordNoOpt             = none
      lng_rr_CoordOpt2              = only actual position
      lng_rr_CoordOpt3              = distance from where ReadingRuler was activated
      lng_rr_ShowStart              = show starting point as crosshair
      lng_rr_LineThickness          = line thickness
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, rr_crosshair, %ConfigFile%, %rr_ScriptName%, Crosshair, 0
   IniRead, rr_ColHex, %ConfigFile%, %rr_ScriptName%, CrosshairColor, cc9900
   IniRead, rr_CoordMode, %ConfigFile%, %rr_ScriptName%, ShowCoordinates, 1
   IniRead, rr_ShowStart, %ConfigFile%, %rr_ScriptName%, ShowStartingPoint, 0
   IniRead, rr_LineWidth, %ConfigFile%, %rr_ScriptName%, LineWidth, 1
   If (rr_LineWidth < 0 AND rr_LineWidth > 5)
      rr_LineWidth = 1

   rr_Ruler = Off
Return

SettingsGui_ReadingRuler:
   rr_LastRuler =
   Gui, Add, CheckBox, -Wrap gsub_CheckIfSettingsChanged XS+10 Y+5 Checked%rr_crosshair% vrr_Crosshair, %lng_rr_Crosshair%
   rr_0 = 0
   rr_255 = 255
   Gui, Add, GroupBox, y+15 w180 h150, %lng_rr_Color%
   Gui, Add, Text, XS+20 yp+25 w30, %lng_rr_Red%
   Gui, Add, Slider, x+5 yp-5 vrr_ColR Range0-255 AltSubmit TickInterval8 ToolTip Line8 Buddy1rr_0 Buddy2rr_255 grr_sub_Color, %rr_ColR%
   Gui, Add, Text, XS+20 y+3 w30, %lng_rr_Green%
   Gui, Add, Slider, x+5 yp-5 vrr_ColG Range0-255 AltSubmit TickInterval8 ToolTip Line8 Buddy1rr_0 Buddy2rr_255 grr_sub_Color, %rr_ColG%
   Gui, Add, Text, XS+20 y+3 w30, %lng_rr_Blue%
   Gui, Add, Slider, x+5 yp-5 vrr_ColB Range0-255 AltSubmit TickInterval8 ToolTip Line8 Buddy1rr_0 Buddy2rr_255 grr_sub_Color, %rr_ColB%
   Gui, Font,S%FontSize20%, Wingdings
   Gui, Add, Text, xs+60 y+3 vrr_ShowColor, n
   Gui, Font,S%FontSize%, Courier New
   Gui, Add, Edit, x+5 yp+4 w55 vrr_ColHex Limit6 grr_sub_EditColor, %rr_ColHex%
   Gui, Font
   Gui, Font, S%FontSize%
   Gui, Add, Text, xs+10 y+20, %lng_rr_Coord%
   lng_rr_CoordOpt1 = rr_CoordMode
   Gui, Add, Radio, -Wrap vrr_CoordMode y+5 gsub_CheckIfSettingsChanged, %lng_rr_CoordNoOpt%
   Gui, Add, Radio, -Wrap x+10 gsub_CheckIfSettingsChanged, %lng_rr_CoordOpt2%
   Gui, Add, Radio, -Wrap x+10 gsub_CheckIfSettingsChanged, %lng_rr_CoordOpt3%
   Gui, Add, CheckBox, -Wrap gsub_CheckIfSettingsChanged XP+0 Y+5 Checked%rr_ShowStart% vrr_ShowStart, %lng_rr_ShowStart%
   GuiControl,,% lng_rr_CoordOpt%rr_CoordMode%, 1
   Gosub, rr_sub_EditColor
   Gui, Font
   Gui, Font, S%FontSize%
   Gui, Add, Text, xs+200 ys+65, %lng_rr_LineThickness%:
   Gui, Add, Edit, x+5 yp-3 R1 w35 vrr_LineWidth Limit1 gsub_CheckIfSettingsChanged, %rr_LineWidth%
   Gui, Add, UpDown, Range1-5, %rr_LineWidth%
Return

rr_sub_EditColor:
   GuiControlGet, rr_ColHexEdit,,rr_ColHex
   StringMid, rr_ColRHex, rr_ColHexEdit, 1, 2
   StringMid, rr_ColGHex, rr_ColHexEdit, 3, 2
   StringMid, rr_ColBHex, rr_ColHexEdit, 5, 2
   ;SetFormat, Integer, D
   rr_ColRHex = 0x%rr_ColRHex%
   rr_ColGHex = 0x%rr_ColGHex%
   rr_ColBHex = 0x%rr_ColBHex%
   GuiControl,,rr_ColR,%rr_ColRHex%
   GuiControl,,rr_ColG,%rr_ColGHex%
   GuiControl,,rr_ColB,%rr_ColBHex%
   StringReplace, rr_ColRHex, rr_ColRHex, 0x,
   StringReplace, rr_ColGHex, rr_ColGHex, 0x,
   StringReplace, rr_ColBHex, rr_ColBHex, 0x,
   Gui, Font, c%rr_ColRHex%%rr_ColGHex%%rr_ColBHex% S20 , Wingdings
   GuiControl, Font, rr_ShowColor
   If A_IsSuspended <> 1
      func_SettingsChanged( "ReadingRuler" )
Return

rr_sub_Color:
   SetFormat, Integer, H
   GuiControlGet, rr_ColRHex,, rr_ColR
   GuiControlGet, rr_ColGHex,, rr_ColG
   GuiControlGet, rr_ColBHex,, rr_ColB
   StringReplace, rr_ColRHex, rr_ColRHex, 0x, 0
   StringReplace, rr_ColGHex, rr_ColGHex, 0x, 0
   StringReplace, rr_ColBHex, rr_ColBHex, 0x, 0
   StringRight, rr_ColRHex, rr_ColRHex, 2
   StringRight, rr_ColGHex, rr_ColGHex, 2
   StringRight, rr_ColBHex, rr_ColBHex, 2
   GuiControl, , rr_ColHex, %rr_ColRHex%%rr_ColGHex%%rr_ColBHex%
   Gui, Font, c%rr_ColRHex%%rr_ColGHex%%rr_ColBHex% S20 , Wingdings
   GuiControl, Font, rr_ShowColor
   SetFormat, Integer, D
   func_SettingsChanged( "ReadingRuler" )
Return

SaveSettings_ReadingRuler:
   IniWrite, %rr_crosshair%, %ConfigFile%, %rr_ScriptName%, Crosshair
   IniWrite, %rr_ColHex%, %ConfigFile%, %rr_ScriptName%, CrosshairColor
   IniWrite, %rr_CoordMode%, %ConfigFile%, %rr_ScriptName%, ShowCoordinates
   IniWrite, %rr_ShowStart%, %ConfigFile%, %rr_ScriptName%, ShowStartingPoint
   IniWrite, %rr_LineWidth%, %ConfigFile%, %rr_ScriptName%, LineWidth
Return

CancelSettings_ReadingRuler:
Return

DoEnable_ReadingRuler:
   If rr_LastRuler = On
   {
      rr_Ruler = Off
      Gosub, sub_Hotkey_ReadingRuler
   }
Return

DoDisable_ReadingRuler:
   rr_LastRuler = %rr_Ruler%
   If (rr_Ruler = "On")
      Gosub, sub_Hotkey_ReadingRuler
Return

DefaultSettings_ReadingRuler:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_ReadingRuler: ; Feststellen-Taste

   ; Wenn Lineal aus, dann einschalten
   If rr_Ruler = Off
   {
      rr_Ruler = First
      SetTimer, rr_tim_Ruler, 2
      Coordmode, Mouse, Screen            ; Mauskoordinaten beziehen sich auf den gesamten Bildschirm
      MouseGetPos,rr_StartX, rr_StartY    ; Start-Koordinaten
   }
   else ; Sonst wieder ausschalten
   {
      SetTimer,rr_tim_Ruler,Off
      rr_Ruler = Off
      Splashimage,3:Off
      If rr_crosshair = 1
         Splashimage,4:Off
      If rr_ShowStart = 1
      {
         Splashimage,5:Off
         Splashimage,6:Off
      }
      ToolTip,,,,4
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

rr_tim_Ruler:
   SetWindelay,2
   Coordmode, Mouse, Screen    ; Mauskoordinaten beziehen sich auf den gesamten Bildschirm
   Coordmode, Tooltip, Screen
   MouseGetPos,rr_RulerX, rr_RulerY        ; Y-Koordinate der Maus
   rr_RulerY -= 0                 ; 2 Pixel nach oben schieben
   rr_RulerX -= 0                 ; 2 Pixel nach links schieben
   if rr_Ruler = First              ; Beim ersten Aufruf
   {
      Splashimage,3:, B H%rr_LineWidth% W%WorkAreaWidth% X%WorkAreaLeft% Y%rr_RulerY% CW%rr_ColHex%,,,ScreenRulerY
      If rr_crosshair = 1
         Splashimage,4:, B H%WorkAreaHeight% W%rr_LineWidth% X%rr_RulerX% Y%WorkAreaTop% CW%rr_ColHex%,,,ScreenRulerX

      rr_RulerX1 := rr_RulerX-4
      rr_RulerX2 := rr_RulerX+4
      rr_RulerY1 := rr_RulerY-4
      rr_RulerY2 := rr_RulerY+4
      WinSet, Region,0-0 %WorkAreaWidth%-0 %WorkAreaWidth%-%rr_LineWidth% 0-%rr_LineWidth% 0-0  %rr_RulerX1%-0 %rr_RulerX2%-0 %rr_RulerX2%-%rr_LineWidth% %rr_RulerX1%-%rr_LineWidth% %rr_RulerX1%-0,ScreenRulerY
      WinSet, Region,0-0 0-%WorkAreaHeight% %rr_LineWidth%-%WorkAreaHeight% %rr_LineWidth%-0 0-0  0-%rr_RulerY1% 0-%rr_RulerY2% %rr_LineWidth%-%rr_RulerY2% %rr_LineWidth%-%rr_RulerY1% 0-%rr_RulerY1%,ScreenRulerX

      If rr_ShowStart = 1
      {
         Splashimage,5:, B H%rr_LineWidth% W%WorkAreaWidth% X%WorkAreaLeft% Y%rr_StartY% CW%rr_ColHex%,,,ScreenRulerSY
         Splashimage,6:, B H%WorkAreaHeight% W%rr_LineWidth% X%rr_StartX% Y%WorkAreaTop% CW%rr_ColHex%,,,ScreenRulerSX
         WinMove, ScreenRulerSY,,,,%WorkAreaWidth%
         WinMove, ScreenRulerSX,,,,,%WorkAreaHeight%
      }
      rr_Ruler = On                  ; Linie gilt nun als aktiviert
   }
   else If rr_Ruler = On                        ; Linie ist schon an, dann nur verschieben
   {
      WinMove, ScreenRulerY,,, %rr_RulerY%, %WorkAreaWidth%
      If rr_crosshair = 1
         WinMove, ScreenRulerX,, %rr_RulerX%,,,%WorkAreaHeight%
      rr_RulerX1 := rr_RulerX-4
      rr_RulerX2 := rr_RulerX+4
      rr_RulerY1 := rr_RulerY-4
      rr_RulerY2 := rr_RulerY+4
      WinSet, Region,0-0 %WorkAreaWidth%-0 %WorkAreaWidth%-%rr_LineWidth% 0-%rr_LineWidth% 0-0  %rr_RulerX1%-0 %rr_RulerX2%-0 %rr_RulerX2%-%rr_LineWidth% %rr_RulerX1%-%rr_LineWidth% %rr_RulerX1%-0,ScreenRulerY
      WinSet, Region,0-0 0-%WorkAreaHeight% %rr_LineWidth%-%WorkAreaHeight% %rr_LineWidth%-0 0-0  0-%rr_RulerY1% 0-%rr_RulerY2% %rr_LineWidth%-%rr_RulerY2% %rr_LineWidth%-%rr_RulerY1% 0-%rr_RulerY1%,ScreenRulerX
      If (rr_CoordMode = 2 AND rr_Ruler = "On")
         ToolTip, % "X: " rr_RulerX "` | Y: " rr_RulerY , % rr_RulerX+15, % rr_RulerY+15, 4
      If (rr_CoordMode = 3 AND rr_Ruler = "On")
         ToolTip, % "X: " rr_RulerX "` | Y: " rr_RulerY "`ndX: " rr_RulerX-rr_StartX " | dY: " rr_RulerY-rr_StartY, % rr_RulerX+15, % rr_RulerY+15, 4
   }
return

