; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               QuickNote
; -----------------------------------------------------------------------------
; Prefix:             qn_
; Version:            0.8
; Date:               2006-06-06
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_QuickNote:
   Prefix = qn
   %Prefix%_ScriptName    = QuickNote
   %Prefix%_ScriptVersion = 0.8
   %Prefix%_Author        = Wolfgang Reszel

   CustomHotkey_QuickNote = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_QuickNote       = F12  ; Standard-Hotkey
   HotkeyPrefix_QuickNote =      ; 'Durchgeschleiftes' Hotkey

   qn_UndoBufferFile = settings/QuickNote_Undos.dat
   qn_UndoSeparator := Chr(26)

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %qn_ScriptName% - Kurznotiz auf Tastendruck
      Description                   = Per Tastendruck wird ein Notizfenster geffnet bzw. geschlossen, welches sofort alle Eingaben im Hintergrund speichert, womit bei einem Absturz nichts verloren geht.
      lng_qn_NoteFile               = Notizdatei:
      lng_qn_FileType               = Text (*.txt)
      lng_qn_DateTime               = 'Timer:' dd.MM.yyyy ' - ' HH:mm:ss
      lng_qn_Font                   = Schriftart:
      lng_qn_FontSize               = Schriftgre:
      lng_qn_Separator              = Trennlinie (wird ber Strg+L an die Cursorposition eingefgt):
      lng_qn_MsgPrint               = Sollte die Notiz auf dem Standarddrucker ausgedruckt werden? `nWenn Textdateien (.txt) nicht anders konfiguriert sind, wird dazu Notepad verwendet.
      lng_qn_Help                   = F1:`t`tDiese Hilfe`nStrg+Entf:`tWort nach Cursor lschen`nStrg+Lschen:`tWort vor Cursor lschen`nStrg+A:`t`tAlles auswhlen`nStrg+D:`t`tDatum einfgen`nStrg+L:`t`tLinie einfgen`nStrg+R:`t`tAuswahl ausfhren (URLs, Pfade ...)`nStrg+Z:`t`tUndo`nStrg+Y:`t`tRedo`nStrg+S:`t`tFenster schlieen`nStrg+E`t`tAuswahl exportieren`nStrg+P:`t`tNotiz drucken`nStrg+F:`t`tText suchen`nF3:`t`tWeitersuchen`nDrag & Drop:`tDateipfad einfgen
      lng_qn_ExportSelection        = Ausgewhlten Text exportieren
      lng_qn_SearchTerm             = Suchbegriff:
      lng_qn_Minute                 = Minute
      lng_qn_Minutes                = Minuten
      lng_qn_Hour                   = Stunde
      lng_qn_Hours                  = Stunden
      lng_qn_Day                    = Tag
      lng_qn_Days                   = Tage
      lng_qn_Sound                  = Akustisches Signal fr Timer
      lng_qn_SoundOption1           = keins
      lng_qn_SoundOption2           = Soundkarte
      lng_qn_SoundOption3           = PC-Speaker
   }
   else        ; = other languages (english)
   {
      MenuName                      = %qn_ScriptName% - quick notepad with a hotkey
      Description                   = Opens/closes a simple note-window which saves its changes directly to the configured file.
      lng_qn_NoteFile               = File:
      lng_qn_FileType               = Text (*.txt)
      lng_qn_DateTime               = 'Timer:' yyyy-MM-dd ' - ' HH:mm:ss
      lng_qn_Font                   = Font:
      lng_qn_FontSize               = Size:
      lng_qn_Separator              = Separator (will be inserted by Ctrl+L):
      lng_qn_MsgPrint               = The note will directly be printed with the associated`nprogram (Notepad) to the standard-printer. Are you sure?
      lng_qn_Help                   = F1:`t`tthis help`nCtrl+Del:`tdelete word after cursor`nCtrl+Backspace:`tdelete word infront of cursor`nCtrl+A:`t`tselect all`nCtrl+D:`t`tinsert date`nCtrl+L:`t`tinsert separator`nCtrl+R:`t`texecute selection (URLs, paths ...)`nCtrl+Z:`t`tUndo`nCtrl+Y:`t`tRedo`nCtrl+S:`t`tclose window`nCtrl+P:`t`tprint note`nCtrl+F:`t`tFind`nF3:`t`tFind next`nDrag & Drop:`tinsert path of dropped file
      lng_qn_ExportSelection        = export selected text
      lng_qn_SearchTerm             = search term:
      lng_qn_Minute                 = minute
      lng_qn_Minutes                = minutes
      lng_qn_Hour                   = hour
      lng_qn_Hours                  = hours
      lng_qn_Day                    = day
      lng_qn_Days                   = days
      lng_qn_Sound                  = acoustic timer-feedback
      lng_qn_SoundOption1           = no
      lng_qn_SoundOption2           = Soundcard
      lng_qn_SoundOption3           = PC-Speaker
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, qn_File, %ConfigFile%, %qn_ScriptName%, NotesFile, settings\QuickNote.txt
   If qn_File =
      qn_File = settings\QuickNote.txt
   IniRead, qn_DateTime, %ConfigFile%, QuickNote, Timer, None
   IniRead, qn_Line, %ConfigFile%, QuickNote, Line,1
   IniRead, qn_Col, %ConfigFile%, QuickNote, Col,1
   IniRead, qn_Font, %ConfigFile%, QuickNote, Font, Arial
   IniRead, qn_FontSize, %ConfigFile%, QuickNote, FontSize, 9
   IniRead, qn_Separator, %ConfigFile%, QuickNote, Separator, ------------------------------------------------------------
   IniRead, qn_SoundMode, %ConfigFile%, QuickNote, SoundMode, 2

   IfExist, settings\QuickNote.def
   {
      FileMove, settings\QuickNote.def, settings\QuickNote.txt
      FileDelete, settings\QuickNote.def
   }

   ; verfgbare Schriften aus der Registry auslesen
   Loop, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows NT\CurrentVersion\Fonts, 0 ,0
   {
      StringGetPos, qn_tempPos, A_LoopRegname, (
      If qn_tempPos > 2
         StringLeft, qn_LoopRegname, A_LoopRegname, qn_tempPos-1
      Else
         qn_LoopRegname = %A_LoopRegname%
      qn_AllFonts = %qn_LoopRegname%|%qn_AllFonts%
   }

   func_AddMessage(0x100, "qn_OnMessage_EditKeys")

   ; UndoBuffer zurckladen
   qn_UndoCounter = 0
   qn_RedoMax = 0
   qn_ReadLine = 1
   FileRead, qn_UndoBuffer, %qn_UndoBufferFile%
   Loop, Parse, qn_UndoBuffer, %qn_UndoSeparator%
   {
      If A_LoopField =
         continue

      StringReplace, qn_LoopField, A_LoopField, %qn_UndoSeparator%,,All
      StringReplace, qn_LoopField, qn_LoopField, `r`n, `n, All


      If qn_ReadLine = 1
      {
         qn_ReadLine = 2
         qn_UndoBuffer[%qn_UndoCounter%] = %qn_LoopField%
      }
      Else
      {
         qn_ReadLine = 1
         qn_UndoBufferIndex[%qn_UndoCounter%] = %qn_LoopField%
         qn_UndoCounter++
         qn_RedoMax++
       }
   }
   qn_UndoBuffer =

   If activAid_HasChanged = 1
   {
      IfNotExist, extensions\ac'tivAid_QuickNote.wav
      {
         func_UnpackSplash("extensions\ac'tivAid_QuickNote.wav")
         FileInstall, extensions\ac'tivAid_QuickNote.wav, extensions\ac'tivAid_QuickNote.wav
      }
   }
Return

SettingsGui_QuickNote:
   qn_FileOld = %qn_File%
   Gui, Add, Text, xs+10 y+8, %lng_qn_NoteFile%
   Gui, Add, Edit, x+10 yp-3 w390 gsub_CheckIfSettingsChanged vqn_File, %qn_File%
   Gui, Add, Button, -Wrap x+5 W100 gqn_sub_Browse, %lng_Browse%
   Gui, Add, Text, xs+10 y+20, %lng_qn_Separator%
   Gui, Font,s%qn_FontSize%,%qn_Font%
   Gui, Add, Edit, xs+10 y+5 w550 gsub_CheckIfSettingsChanged vqn_Separator, %qn_Separator%
   Gui, Font
   Gui, Font, S%FontSize%

   Gui, Add, Text, xs+10 y+30, %lng_qn_Font%
   Gui, Add, ComboBox, x+5 yp-3 w300 vqn_Font gqn_sub_ChangeFont, %qn_AllFonts%
   Gui, Add, Text, x+10 yp+3, %lng_qn_FontSize%
   Gui, Add, ComboBox, x+5 yp-3 w50 vqn_FontSize gqn_sub_ChangeFont, 8|9|10|11|12|14|16|18|20|24|36|48
   GuiControl,ChooseString, qn_Font, %qn_Font%
   GuiControl,ChooseString, qn_FontSize, %qn_FontSize%

   Gui, Font,s%qn_FontSize%,%qn_Font%
   Gui, Add, Edit, xs+10 y+5 w550 h60 vqn_FontExample, abcdefghijklmnopqrstuvwxyz`nABCDEFGHIJKLMNOPQRSTUVWXYZ`n1234567890,.-_#'+*~!"$`%&/()=?\{}[]

   Gui, Font
   Gui, Font, S%FontSize%
   Gui, Add, Text, y+20, %lng_qn_Sound%:
   Gui, Add, Radio, -Wrap x+5 vqn_SoundMode1 gsub_CheckIfSettingsChanged, %lng_qn_SoundOption1%
   Gui, Add, Radio, -Wrap x+5 vqn_SoundMode2 gsub_CheckIfSettingsChanged, %lng_qn_SoundOption2%
   Gui, Add, Radio, -Wrap x+5 vqn_SoundMode3 gsub_CheckIfSettingsChanged, %lng_qn_SoundOption3%
   GuiControl,,qn_SoundMode%qn_SoundMode%, 1
Return

qn_sub_ChangeFont:
   GuiControlGet, qn_TmpFont,, qn_Font
   GuiControlGet, qn_TmpFontSize,, qn_FontSize
   Gui, Font,s%qn_TmpFontSize%,%qn_TmpFont%
   Gui, 17:Font,s%qn_TmpFontSize%,%qn_TmpFont%
   GuiControl, Font, qn_Separator
   GuiControl, Font, qn_FontExample
   If qn_GUI = yes
      GuiControl, 17:Font, qn_NewContent

   Gosub, sub_CheckIfSettingsChanged
Return

qn_sub_Browse:
   Gosub, doDisable_ComfortDrag
   Gui +OwnDialogs
   Fileselectfile, qn_FileNew, 10,,,%lng_qn_FileType%
   Gosub, doEnable_ComfortDrag
   If qn_FileNew <>
      GuiControl,,qn_File, %qn_FileNew%
Return

SaveSettings_QuickNote:
   IniWrite, %qn_File%, %ConfigFile%, %qn_ScriptName%, NotesFile
   If (qn_File = A_ScriptDir "\" ScriptName " ChangeLog.txt")
      FileRead, ChangeLog, %qn_File%
   If (qn_File = A_ScriptDir "\" ScriptName " Readme" LngCode ".txt")
      FileRead, Readme, %qn_File%
   IniWrite, %qn_Font%, %ConfigFile%, QuickNote, Font
   IniWrite, %qn_FontSize%, %ConfigFile%, QuickNote, FontSize
   IniWrite, %qn_Separator%, %ConfigFile%, QuickNote, Separator
   Loop, 3
   {
      If qn_SoundMode%A_Index% = 1
         qn_SoundMode = %A_Index%
   }
   IniWrite, %qn_SoundMode%, %ConfigFile%, QuickNote, SoundMode
   If qn_FileOld <> %qn_File%
      FileDelete, %qn_UndoBufferFile%
Return

CancelSettings_QuickNote:
   Gui, 17:Font,s%qn_FontSize%,%qn_Font%
   If qn_GUI = yes
      GuiControl, 17:Font, qn_NewContent
Return

DoEnable_QuickNote:
   SetTimer, qn_Timer, 1000
   func_AddMessage(0x100, "qn_OnMessage_EditKeys")
Return

DoDisable_QuickNote:
   SetTimer, qn_Timer, Off
   func_RemoveMessage(0x100, "qn_OnMessage_EditKeys")
   Gui, 17:Destroy
Return

DefaultSettings_QuickNote:
Return

OnExitAndReload_QuickNote:
   If qn_GUI= yes
   {
      GuiControlGet, qn_EditText,17:,qn_NewContent
      If ( qn_EditText <> qn_UndoBuffer[%qn_UndoCounter%] )
         Gosub, qn_sub_UndoBuffer
      Gosub,qn_SaveChanges
      Gosub,qn_sub_SaveUndoBuffer
   }
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_QuickNote:
   Gosub, qn_main_QuickNote
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

qn_main_QuickNote:
   if qn_GUI = yes
      Goto, 17GuiClose

   qn_BorderHeight := BorderHeight
   qn_CaptionHeight :=  SmallCaptionHeight + qn_BorderHeight * 2

   IniRead, qn_X, %ConfigFile%, QuickNote, X, 100
   IniRead, qn_Y, %ConfigFile%, QuickNote, Y, 100
   IniRead, qn_H, %ConfigFile%, QuickNote, H, 200
   IniRead, qn_W, %ConfigFile%, QuickNote, W, 300
   IniRead, qn_BGColour, %ConfigFile%, QuickNote, BackgroundColour, ffffcc
   IniRead, qn_FontColour, %ConfigFile%, QuickNote, FontColour, 000000

   qn_H := qn_H
   qn_W := qn_W

   qn_edH := qn_H - 21
   qn_edW := qn_W

   FileRead, qn_Content, %qn_File%

   Gui, 17:+Resize +LastFound  +AlwaysOnTop +ToolWindow
   Gui, 17:Color, %qn_BGColour%, %qn_BGColour%
   Gui, 17:Font,s%qn_FontSize% c%qn_FontColour%,%qn_Font%
   Gui, 17:Add, Edit, WantTab T8 T16 T24 T32 T40 T48 Multi X0 Y0 H%qn_edH% W%qn_edW% vqn_NewContent gqn_SaveChanges, %qn_Content%
   Gui, 17:Font
   If qn_DateTime =
      qn_DateTime = None

   qn_DateTimeW := qn_edW - 30
   Gui, 17:Add, Button, -Wrap X0 Y%qn_edH% vqn_HelpButton gqn_sub_Help w15 h20 -TabStop, ?

   Gui, 17:Add, DateTime, Range%A_YYYY%%A_MM%%A_DD% Right 2 X+0 Y%qn_edH% W%qn_DateTimeW% Choose%qn_DateTime% vqn_DateTime gqn_sub_DateTime, %lng_qn_DateTime%
   Gui, 17:Add, Button, -Wrap X+0 Y%qn_edH% vqn_CountdownMenu gqn_sub_CountdownMenu w15 h20 -TabStop, &T
   Gui, 17:Add, Button, -Wrap x-100 y-100 g17GuiClose Default -TabStop, &OK
   Gui, 17:Show, X%qn_X% Y%qn_Y% H%qn_H% W%qn_W% %qn_NA%, QuickNote
   WinGet, qn_GUIid, ID
   wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, ahk_id %qn_GUIid% ; Fenstermae ermitteln

   qn_GUI = yes

   qn_Line--
   qn_Col--

   ; Cursor setzen
   SendMessage, 0xBB, %qn_Line%, 0 , Edit1, ahk_id %qn_GUIid%  ; EM_LINEINDEX
   qn_EditIndex := Errorlevel + qn_Col
   SendMessage, 0xB1, %qn_EditIndex%, %qn_EditIndex%, Edit1, ahk_id %qn_GUIid% ; EM_SETSEL
   SendMessage, 0xB7, , , Edit1, ahk_id %qn_GUIid% ; EM_SCROLLCARET

   GuiControlGet, qn_Undo,17:,qn_NewContent
   qn_UndoBuffer[%qn_UndoCounter%] = %qn_Undo%
   qn_UndoBufferIndex[%qn_UndoCounter%] = %qn_EditIndex%
Return

qn_sub_DateTime:
   qn_GuiDateTime = %A_now%
Return

qn_Timer:
   If qn_DateTime <>
   {
      If (A_Now > qn_DateTime AND qn_DateTime > qn_GuiDateTime)
      {
         qn_DateTime =
         qn_NA = NA NoActivate
         Gosub, qn_main_QuickNote
         qn_NA =
         If qn_SoundMode > 1
            SetTimer, qn_tim_Sound, 5
      }
   }
Return

17GuiSize: ;    Fenstergren-berwachung
   Critical
   SetTimer, qn_tim_SizeSaveChanges, off
   SetTitleMatchmode, 3
   wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, QuickNote ; Fenstermae ermitteln
   ;tooltip, %qn_newW% %qn_newH%

   qn_newW := qn_newW - qn_BorderHeight * 2
   qn_newH := qn_newH - qn_CaptionHeight

   ; Differenz des vernderten Fensters zu der Originalgre errechnen
   qn_DiffH := qn_newH - qn_H
   qn_DiffW := qn_newW - qn_W

   if qn_DiffW = %qn_lastDiffW%
   if qn_DiffH = %qn_lastDiffH%
      return

   qn_lastDiffW = %qn_DiffW%
   qn_lastDiffH = %qn_DiffH%

   ; Neue Positionen und Gren berechnen
   qn_newEdH  :=  qn_EdH + qn_DiffH
   qn_newEdW  :=  qn_EdW + qn_DiffW

   qn_DateTimeW := qn_newEdW - 30

   ; Fensterelemente anpassen
   GuiControl, 17:move, Edit1, w%qn_newEdW% h%qn_newEdH%
   GuiControl, 17:move, qn_HelpButton, y%qn_newEdH%
   GuiControl, 17:move, SysDateTimePick321, y%qn_newEdH% w%qn_DateTimeW%
   GuiControl, 17:move, qn_CountdownMenu, % "y"qn_newEdH "x"qn_DateTimeW+15

   SetTimer, qn_tim_SizeSaveChanges, 50
Return

qn_tim_SizeSaveChanges:
   SetTimer, qn_tim_SizeSaveChanges, off
   IniWrite, %qn_newX%, %ConfigFile%, QuickNote, X
   IniWrite, %qn_newY%, %ConfigFile%, QuickNote, Y
   IniWrite, %qn_newH%, %ConfigFile%, QuickNote, H
   IniWrite, %qn_newW%, %ConfigFile%, QuickNote, W
Return

qn_SaveChanges:
   SetTimer, qn_tim_SaveChanges, 200
Return

qn_tim_SaveChanges:
   SetTimer, qn_tim_SaveChanges, Off
   Critical
   GuiControlGet, qn_EditText,17:,qn_NewContent

   wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, ahk_id %qn_GUIid% ; Fenstermae ermitteln
   qn_newW := qn_newW - qn_BorderHeight * 2
   qn_newH := qn_newH - qn_CaptionHeight

   ControlGet, qn_Line, CurrentLine,,Edit1, ahk_id %qn_GUIid%
   ControlGet, qn_Col, CurrentCol,,Edit1, ahk_id %qn_GUIid%

   IniWrite, %qn_Line%, %ConfigFile%, QuickNote, Line
   IniWrite, %qn_Col%, %ConfigFile%, QuickNote, Col

   IniWrite, %qn_newX%, %ConfigFile%, QuickNote, X
   IniWrite, %qn_newY%, %ConfigFile%, QuickNote, Y
   IniWrite, %qn_newH%, %ConfigFile%, QuickNote, H
   IniWrite, %qn_newW%, %ConfigFile%, QuickNote, W

   FileAppend, %qn_EditText%, %A_Temp%\qn_temp.tmp
   FileMove, %A_Temp%\qn_temp.tmp, %qn_File%, 1

   qn_UndosDone--
Return

17GuiClose:
17GuiEscape:
   If, qn_HelpVisible = 1
      Gosub, qn_sub_Help

   wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, ahk_id %qn_GUIid% ; Fenstermae ermitteln
   qn_newW := qn_newW - qn_BorderHeight * 2
   qn_newH := qn_newH - qn_CaptionHeight

   ControlGet, qn_Line, CurrentLine,,Edit1, ahk_id %qn_GUIid%
   ControlGet, qn_Col, CurrentCol,,Edit1, ahk_id %qn_GUIid%

   IniWrite, %qn_Line%, %ConfigFile%, QuickNote, Line
   IniWrite, %qn_Col%, %ConfigFile%, QuickNote, Col
   IniWrite, %qn_newX%, %ConfigFile%, QuickNote, X
   IniWrite, %qn_newY%, %ConfigFile%, QuickNote, Y
   IniWrite, %qn_newH%, %ConfigFile%, QuickNote, H
   IniWrite, %qn_newW%, %ConfigFile%, QuickNote, W
   IniWrite, %qn_DateTime%, %ConfigFile%, QuickNote, Timer

   qn_GUI =

   Gosub, qn_sub_SaveUndoBuffer

   Gui, 17:SubMit
   Gui, 17:Destroy
Return

qn_OnMessage_EditKeys:
   qn_Key = %#wParam%

   If A_GuiControl <> qn_NewContent
      Return

   GetKeyState, qn_CtrlState, Ctrl
   If qn_CtrlState = D
      qn_Key := qn_Key + 1000
   GetKeyState, qn_ShiftState, Shift
   If qn_ShiftState = D
      qn_Key := qn_Key + 2000
   GetKeyState, qn_AltState, Alt
   If qn_AltState = D
      qn_Key := qn_Key + 4000

   ;tooltip, %qn_Key%

   ControlGet, qn_SelectedText, Selected,, Edit1, ahk_id %qn_GUIid%
   If qn_SelectedText <>
      Gosub, qn_sub_UndoBuffer
   Else If qn_Key in 8,9,13,32,46,188,190,2188,2190,189,2219,2056,2057,2049,5055,5056,5057,5058,5226,226,2226
      If qn_Key <> %qn_LastKey%
         Gosub, qn_sub_UndoBuffer
      Else
         qn_SameKey = %qn_Key%

   If qn_SameKey in 8,9,13,32,46,188,190,2188,2190,189,2219,2056,2057,2049,5055,5056,5057,5058,5226,226,2226
      If qn_Key <> %qn_LastKey%
         Gosub, qn_sub_UndoBuffer

   qn_LastKey = %qn_Key%
   if qn_SameKey <> %qn_Key%
      qn_SameKey =

   If (qn_Key = 1065) ; Strg+A
   {
      Send,^{Home}^+{End}
      #Return = 0
   }
   If (qn_Key = 1008) ; Strg+Lschen
   {
      SetKeyDelay,0
      Send,^+{Left}{Del}
      #Return = 0
   }
   If (qn_Key = 1046) ; Strg+Entf
   {
      SetKeyDelay,0
      Send,^+{Right}{Del}
      Gosub, qn_sub_UndoBuffer
      #Return = 0
   }
   If (qn_Key = 1090) ; Strg+Z
   {
      GuiControlGet, qn_EditText,17:,qn_NewContent
      If ( qn_EditText <> qn_UndoBuffer[%qn_UndoCounter%] )
      {
         Gosub, qn_sub_UndoBuffer
         qn_UndoCounter--
      }
      If qn_UndoCounter > 0
      {
         qn_UndoCounter--
         GuiControl,17:,qn_NewContent,% qn_UndoBuffer[%qn_UndoCounter%]
         SendMessage, 0xB1, % qn_UndoBufferIndex[%qn_UndoCounter%], % qn_UndoBufferIndex[%qn_UndoCounter%], Edit1, ahk_id %qn_GUIid% ; EM_SETSEL
         SendMessage, 0xB7, , , Edit1, ahk_id %qn_GUIid% ; EM_SCROLLCARET
      }
      Gosub,qn_SaveChanges
      #Return = 0
   }
   If (qn_Key = 1089 OR qn_Key = 3090) ; Strg+Y oder Strg+Shift+Z
   {
      GuiControlGet, qn_EditText,17:,qn_NewContent
      If ( qn_EditText <> qn_UndoBuffer[%qn_UndoCounter%] )
      {
         msgbox, % qn_EditText "`n----------`n" qn_UndoBuffer[%qn_UndoCounter%] "`n----------`n" StrLen(qn_EditText) ":" StrLen(qn_UndoBuffer[%qn_UndoCounter%])
         #Return = 0
         Return
      }
      If qn_RedoMax > %qn_UndoCounter%
      {
         qn_UndoCounter++
         GuiControl,17:,qn_NewContent,% qn_UndoBuffer[%qn_UndoCounter%]
         SendMessage, 0xB1, % qn_UndoBufferIndex[%qn_UndoCounter%], % qn_UndoBufferIndex[%qn_UndoCounter%], Edit1, ahk_id %qn_GUIid% ; EM_SETSEL
         SendMessage, 0xB7, , , Edit1, ahk_id %qn_GUIid% ; EM_SCROLLCARET
      }
      Gosub,qn_SaveChanges
      #Return = 0
   }
   If (qn_Key = 1068) ; Strg+D
   {
      SetKeyDelay,0
      Send, %A_DD%.%A_MM%.%A_YYYY%, %A_Hour%:%A_Min%%A_Space%
      Gosub, qn_sub_UndoBuffer
      #Return = 0
   }
   If (qn_Key = 1076) ; Strg+L
   {
      SetKeyDelay,0
      Send, {End}`n%qn_Separator%`n
      Gosub, qn_sub_UndoBuffer
      #Return = 0
   }
   If (qn_Key = 1082) ; Strg+R
   {
      func_GetSelection()
      Run, %Selection% ,,UseErrorLevel
      #Return = 0
   }
   If (qn_Key = 112) ; F1
   {
      Gosub, qn_sub_Help
      #Return = 0
   }
   If (qn_Key = 1083) ; Strg+S
   {
      Gosub, qn_main_QuickNote
      #Return = 0
   }
   If (qn_Key = 1080) ; Strg+P
   {
      MsgBox,36,%ScriptName% - QuickNote, %lng_qn_MsgPrint%
      IfMsgbox, yes
         Run, Print %qn_File%
      #Return = 0
   }
   If (qn_Key = 1069) ; Strg+E
   {
      qn_tempClipPlain = %Clipboard%
      func_GetSelection()
      qn_ExportContent := Selection
      If qn_ExportContent =
         GuiControlGet, qn_ExportContent,17:,qn_NewContent

      Gui, 17:+OwnDialogs
      FileSelectFile, qn_ExportFileName, 16,QuickNote.txt,%lng_qn_ExportSelection%,*.txt
      Gui, 17:-OwnDialogs
      If qn_ExportFileName <>
      {
         FileDelete, %qn_ExportFileName%
         FileAppend, %qn_ExportContent%, %qn_ExportFileName%
      }
      #Return = 0
   }
   If (qn_Key = 1070 OR (qn_Key = 114 and qn_SearchTerm ="") ) ; Strg+F
   {
      wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, ahk_id %qn_GUIid% ; Fenstermae ermitteln
      qn_editW := 300 - 27
      qn_buttonX := (327 - 170) / 2
      Gui, 18:+Owner17 AlwaysOnTop +ToolWindow
      Gui, 17:+Disabled
      Gui, 18:Add, Text,, %lng_qn_SearchTerm%
      Gui, 18:Add, Edit, y+5 w%qn_editW% R1 vqn_SearchTerm, %qn_SearchTerm%
      Gui, 18:Add, Button, x%qn_buttonX% y+5 w80 g18GuiClose, &%lng_Cancel%
      Gui, 18:Add, Button, Default x+10 w80 gqn_sub_SearchOK, &%lng_OK%
      Gui, 18:Show, x%qn_newX% y%qn_newY%

      #Return = 0
      Return
   }
   If (qn_Key = 1084) ; Strg+T
   {
      GuiControl, 17:Focus, qn_DateTime
      Send, %A_Space%{Right}
      #Return = 0
      Return
   }
   If (qn_Key = 114) ; F3
   {
      Gosub, qn_sub_SearchOK
   }
Return

17GuiDropFiles:
   WinActivate,ahk_id %qn_GUIid%
   SetKeyDelay,0
   Send, %A_GuiControlEvent%{Enter}
Return

18GuiEscape:
18GuiClose:
   Gui, 17:-Disabled
   Gui, 18:Destroy
Return

qn_sub_SearchOK:
   Gui, 17:-Disabled
   Gui, 18:Submit
   Gui, 18:Destroy
   GuiControlGet, qn_EditText,17:,qn_NewContent
   StringReplace, qn_EditText, qn_EditText, `r`n, `n, a
   StringReplace, qn_EditText, qn_EditText, `n, `r`n, a
   ControlGet, qn_Col, CurrentCol,,Edit1, ahk_id %qn_GUIid%
   ControlGet, qn_Line, CurrentLine,,Edit1, ahk_id %qn_GUIid%
   qn_Col--
   qn_Line--
   SendMessage, 0xBB, %qn_Line%, 0 , Edit1, ahk_id %qn_GUIid%  ; EM_LINEINDEX
   qn_EditIndex := Errorlevel + qn_Col
   StringGetPos, qn_SearchPos, qn_EditText, %qn_SearchTerm%, L, % qn_EditIndex+1

   SendMessage, 0xB1, %qn_SearchPos%, % qn_SearchPos+StrLen(qn_SearchTerm), Edit1, ahk_id %qn_GUIid% ; EM_SETSEL
   SendMessage, 0xB7, , , Edit1, ahk_id %qn_GUIid% ; EM_SCROLLCARET
Return

qn_sub_UndoBuffer:
   qn_UndoCounter++
   qn_RedoMax = %qn_UndoCounter%
   GuiControlGet, qn_EditText,17:,qn_NewContent
   qn_UndoBuffer[%qn_UndoCounter%] = %qn_EditText%

   ControlGet, qn_Line, CurrentLine,,Edit1, ahk_id %qn_GUIid%
   ControlGet, qn_Col, CurrentCol,,Edit1, ahk_id %qn_GUIid%
   qn_Line--
   qn_Col--

   SendMessage, 0xBB, %qn_Line%, 0 , Edit1, QuickNote
   qn_UndoBufferIndex[%qn_UndoCounter%] := Errorlevel + qn_Col
Return

qn_sub_Help:
   If qn_HelpVisible =
   {
      wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, ahk_id %qn_GUIid% ; Fenstermae ermitteln
      CoordMode, ToolTip, Screen
      tooltip, %lng_qn_Help%, % qn_NewX, % qn_NewY+qn_NewH, 7
      qn_HelpVisible = 1
      SetTimer, qn_tim_MoveHelp, 10
   }
   Else
   {
      tooltip, ,,, 7
      qn_HelpVisible =
      SetTimer, qn_tim_MoveHelp, Off
   }

Return

qn_tim_MoveHelp:
   If (qn_HelpVisible = 1 AND qn_Gui = "yes")
   {
      wingetpos,qn_newX,qn_newY,qn_newW,qn_newH, ahk_id %qn_GUIid% ; Fenstermae ermitteln
      if (qn_newX <> qn_lastX OR qn_newY <> qn_lastY OR qn_newH <> qn_lastH)
      {
         CoordMode, ToolTip, Screen
         tooltip, %lng_qn_Help%, % qn_NewX, % qn_NewY+qn_NewH, 7
      }
      qn_lastX := qn_newX
      qn_lastY := qn_newY
      qn_lastH := qn_newH
   }
Return

qn_sub_DeleteAll:
   Gosub, qn_sub_UndoBuffer
   ControlFocus, Edit1, QuickNote
   Send,^{Home}^+{End}{Del}
Return

qn_sub_DrawLine:
  Gosub, qn_sub_UndoBuffer
  ControlFocus, Edit1, QuickNote
  Send, {Home}{Down}`n{Up}%qn_Separator%{Home}{Down}
Return

qn_sub_CountdownMenu:
   CoordMode, Menu, Relative
   Menu, qn_CountdownMenu, Add, 1 %lng_qn_Minute%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 2 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 3 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 4 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 5 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 6 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 7 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 8 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 9 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 10 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 15 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 20 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 25 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 30 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 35 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 40 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 45 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 50 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 55 %lng_qn_Minutes%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add
   Menu, qn_CountdownMenu, Add, 1 %lng_qn_Hour%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 1 %lng_qn_Hours%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 2 %lng_qn_Hours%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 3 %lng_qn_Hours%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 4 %lng_qn_Hours%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 5 %lng_qn_Hours%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 10 %lng_qn_Hours%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add
   Menu, qn_CountdownMenu, Add, 1 %lng_qn_Day%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 2 %lng_qn_Days%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 3 %lng_qn_Days%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 4 %lng_qn_Days%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 5 %lng_qn_Days%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 6 %lng_qn_Days%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Add, 7 %lng_qn_Days%, qn_sub_SelectCountdown
   Menu, qn_CountdownMenu, Show, %qn_NewW%, %qn_NewH%
   Menu, qn_CountdownMenu, DeleteAll
Return

qn_sub_SelectCountdown:
   StringSplit, qn_CountDownVal, A_Thismenuitem, %A_Space%
   StringReplace, qn_CountDownVal1, qn_CountDownVal1, , .5
   qn_DateTime = %A_Now%
   If (qn_CountDownVal2 = lng_qn_Minute OR qn_CountDownVal2 = lng_qn_Minutes)
      EnvAdd, qn_DateTime, qn_CountDownVal1, Minutes
   If (qn_CountDownVal2 = lng_qn_Hour OR qn_CountDownVal2 = lng_qn_Hours)
      EnvAdd, qn_DateTime, qn_CountDownVal1, Hours
   If (qn_CountDownVal2 = lng_qn_Day OR qn_CountDownVal2 = lng_qn_Days)
      EnvAdd, qn_DateTime, qn_CountDownVal1, Days

   GuiControl, 17:,qn_DateTime, %qn_DateTime%
   Gosub, 17GuiClose
Return

qn_tim_Sound:
   SetTimer, qn_tim_Sound, Off
   Critical
   SetBatchlines, 1

   If qn_SoundMode = 3
   {
      SoundBeep, 2600, 60
      SoundBeep, 2000, 60
      SoundBeep, 2600, 60
      SoundBeep, 2000, 60
      SoundBeep, 2600, 60
      SoundBeep, 2000, 60
   }
   Else
   {
      SoundPlay, %A_ScriptDir%\extensions\ac'tivAid_QuickNote.wav, 1
   }
Return

qn_sub_SaveUndoBuffer:
   FileDelete, %qn_UndoBufferFile%.tmp
   If qn_UndoCounter < 1
   {
      FileDelete, %qn_UndoBufferFile%
      Return
   }
   qn_Count := qn_UndoCounter
   If qn_Count > 50
      qn_Count = 50
   Loop, %qn_Count%
   {
      qn_tmp := qn_UndoCounter-qn_Count+A_Index-1
      If qn_UndoBuffer[%qn_tmp%] = %qn_LastUndoBuffer%
         continue
      FileAppend, % qn_UndoBuffer[%qn_tmp%] qn_UndoSeparator, %qn_UndoBufferFile%.tmp
      FileAppend, % qn_UndoBufferIndex[%qn_tmp%] qn_UndoSeparator, %qn_UndoBufferFile%.tmp
      qn_LastUndoBuffer = qn_UndoBuffer[%qn_tmp%]
   }
   qn_LastUndoBuffer =
   FileMove, %qn_UndoBufferFile%.tmp, %qn_UndoBufferFile%, 1
Return
