; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               NewFolder
; -----------------------------------------------------------------------------
; Prefix:             nf_
; Version:            1.0
; Date:               2006-02-06
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

; Initialisierungsroutine, welche beim Start von ac'tivAid aufgerufen wird.
init_NewFolder:
   SetBatchLines, 2000

   ; * Das verwendete Prfix
   Prefix = nf
   %Prefix%_ScriptName    = NewFolder
   %Prefix%_ScriptVersion = 1.0
   %Prefix%_Author        = Wolfgang Reszel

   CustomHotkey_NewFolder = 1          ; automatisches benutzerdefinierbares Tastaturkrzel? (1 = ja)
   Hotkey_NewFolder       = ^n         ; Standard-Hotkey
   HotkeyPrefix_NewFolder = ~          ; Prfix, welches vor immer vor dem Tastaturkrzel gesetzt wird
                                       ; in diesem Fall sorgt es dafr, dass das Tastaturkrzel durchgeschleift wird.
   HideSettings = 0                    ; Wenn 1, dann bekommt die Erweiterung keinen Eintrag im Konfigurationsdialog

   ; Sprachabhngige Variablen
   If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      ; Name des Meneintrags im Tray-Men
      MenuName                      = %nf_ScriptName% - Neuer Ordner per Tastaturkrzel
      ; Beschreibung fr den Erweiterungsmanager und den Konfigurationsdialog
      Description                   = Im Explorer lassen sich direkt mit einem definierten Tastaturkrzel neue Ordner anlegen. ber ein weiteres Krzel kann man einen neuen Ordner anlegen in dem automatisch Unterordner erstellt werden.
      nf_FolderName                 = Neuer Ordner
      lng_nf_ErrorCreating          = Neuer Ordner kann nicht erstellt werden!
      lng_nf_SpecialCreate          = Tastaturkrzel fr neuen Ordner`nmit vordefinierten Unterordnern
      lng_nf_SpecialCreateOnly      = Tastaturkrzel fr die direkte`nErstelleung der Unterordner
      lng_nf_SpecialFolders         = Vordefinierte Unterordner`n(ein Ordner je Zeile)
      lng_nf_DefaultFolders         = Bilder|Entwrfe
      lng_nf_CantCreateFolder       = Es konnte kein neuer Ordner angelegt werden.`nEntweder Sie haben nicht gengend Schreibrechte oder das Verzeichnis ist schreibgeschtzt.
      lng_nf_ShowDialog             = Ordnernamen ber einen Dialog abfragen (nur im Explorer`; Direkte Angabe von Unterordnern mglich)
      lng_nf_CreateFolder           = Name des neuen Ordners (Unterordner mit \ mglich):
   }
   else        ; = other languages (english)
   {
      MenuName                      = %nf_ScriptName% - new folder with hotkey
      Description                   = Extends the windows explorer with a hotkey for creating a new folder. A second hotkey can be used to create a folder with predefined subfolders.
      nf_FolderName                 = new folder
      lng_nf_ErrorCreating          = Can't create new folder!
      lng_nf_SpecialCreate          = Hotkey for a new folder with`npredefined sub-folders
      lng_nf_SpecialCreateOnly      = Hotkey for directly creating`nthe sub-folders
      lng_nf_SpecialFolders         = predefined folders`n(one folder per line)
      lng_nf_DefaultFolders         = images|draft
      lng_nf_CantCreateFolder       = Can't create new Folder!`nEither you've not enough access rights or the folder is write-protected.
      lng_nf_ShowDialog             = Ask for the folder name in a dialog (only in explorer`; sub-folders are possible)
      lng_nf_CreateFolder           = folder name (sub-folders with \ are possible):
   }

   ; zustzliches Hotkey aus der INI-Datei einlesen
   ; Syntax: HotkeyRead ( Name des Tastaturkrzels, INI-Datei, Sektion, INI-Variable, Subroutine des Tastaturkrzels, Standard-Krzel)
   func_HotkeyRead( "nf_SpecialCreate", ConfigFile , nf_ScriptName, "SpecialHotkey", "nf_main_SpecialNewFolder", "~^+n" )
   func_HotkeyRead( "nf_SpecialCreateOnly", ConfigFile , nf_ScriptName, "SpecialOnlyHotkey", "nf_main_SpecialFolders", "~^!+n" )

   ; Die zustzlichen Unterordner aus der INI-Datei auslesen
   IniRead, nf_SpecialFolders, %ConfigFile%, NewFolder, SpecialFolders, %lng_nf_DefaultFolders%
   IniRead, nf_ShowDialog, %ConfigFile%, NewFolder, ShowDialog, 0
Return

; Die folgende Routine enthlt alle Befehle, welche dazu ntig sind den Konfigurationsdialog zu ergnzen
; Das erste GUI-Element sollte immer mit "XS+10 Y+5" positioniert werden, wobei der Y-Wert ggf.
; auch angepasster werden kann.
SettingsGui_NewFolder:
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged xs+10 y+5 vnf_ShowDialog Checked%nf_ShowDialog%, %lng_nf_ShowDialog%
   func_HotkeyAddGuiControl( lng_nf_SpecialCreate, "nf_SpecialCreate", "xs+10 y+20 w160" )
   func_HotkeyAddGuiControl( lng_nf_SpecialCreateOnly, "nf_SpecialCreateOnly", "xs+10 y+18 w160" )
   Gui, Add, Text, xs+10 y+25 w155, %lng_nf_SpecialFolders%:
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, |, `n, a
   Gui, Add, Edit, gsub_CheckIfSettingsChanged x+10 R9 W300 vnf_SpecialFolders, %nf_SpecialFolders%
Return

; wird aufgerufen, wenn im Konfigurationsdialog OK oder bernehmen angeklickt wird
SaveSettings_NewFolder:
   ; Syntax: HotkeyWrite ( Name des Tastaturkrzels, INI-Datei, Sektion, INI-Variable [, Subroutine des Tastaturkrzels] )
   func_HotkeyWrite( "nf_SpecialCreate", ConfigFile , nf_ScriptName, "SpecialHotkey" )
   func_HotkeyWrite( "nf_SpecialCreateOnly", ConfigFile , nf_ScriptName, "SpecialOnlyHotkey" )
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, `n, |, a
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, ||, |, a
   IniWrite, %nf_SpecialFolders%, %ConfigFile%, NewFolder, SpecialFolders
   IniWrite, %nf_ShowDialog%, %ConfigFile%, NewFolder, ShowDialog
Return

; wird beim Abbrechen des Konfigurationsdialogs aufgerufen
CancelSettings_NewFolder:
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, `n, |, a
Return

; wird beim Aktivieren der Erweiterung aufgerufen
DoEnable_NewFolder:
   func_HotkeyEnable("nf_SpecialCreate")
Return

; wird beim Deaktivieren der Erweiterung und auch vor dem Speichern der Einstellungen aufgerufen
DoDisable_NewFolder:
   func_HotkeyDisable("nf_SpecialCreate")
Return

; wird aufgerufen, wenn der Anwender die Erweiterung auf die Standard-Einstellungen zurcksetzt
DefaultSettings_NewFolder:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

; Unterroutine fr das automatische Tastaturkrzel
sub_Hotkey_Newfolder: ; nf
   Gosub, nf_main_NewFolder
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================nf==
; -----------------------------------------------------------------------------

; Neuer Ordner mit vordefinierten Unterordnern
nf_main_SpecialNewFolder:
   Gosub, nf_main_NewFolder
   If nf_SpecialFolders =
      Return
   IfNotExist, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%
      Return

   Loop, Parse, nf_SpecialFolders, |
   {
      If A_LoopField <>
         FileCreateDir, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%\%A_LoopField%
   }
Return

; Vordefinierten Unterordner direkt anlegen
nf_main_SpecialFolders:
   WinGet, nf_ActiveID, ID, A                        ; ID des aktiven Fensters
   WinGetClass, nf_ActiveClass, A                    ; Klasse des aktiven Fensters

   nf_FolderNameAdd =
   If nf_ActiveClass in ExploreWClass,CabinetWClass,Progman,WorkerW  ; Wenn Explorer-Fenster ...
   {
      nf_CurrentExplorerDirectory := func_GetDir( nf_ActiveID )
      Sleep,200
   }

   If nf_SpecialFolders =
      Return
   IfNotExist, %nf_CurrentExplorerDirectory%
      Return

   Loop, Parse, nf_SpecialFolders, |
   {
      If A_LoopField <>
         FileCreateDir, %nf_CurrentExplorerDirectory%\%A_LoopField%
   }
Return

; Neuer Ordner in einem Explorer-Fenster
nf_main_NewFolder:
   WinGet, nf_ActiveID, ID, A                        ; ID des aktiven Fensters
   WinGetClass, nf_ActiveClass, A                    ; Klasse des aktiven Fensters

   nf_FolderNameAdd =
   If nf_ActiveClass in ExploreWClass,CabinetWClass,Progman,WorkerW  ; Wenn Explorer-Fenster ...
   {
      nf_CurrentExplorerDirectory := func_GetDir( nf_ActiveID, "ShowMessage", "Always", nf_ScriptName) "\"
      Sleep,200

      If nf_CurrentExplorerDirectory = \
         Return

      ifNotExist, %nf_CurrentExplorerDirectory%
         Return

      IfExist, %nf_CurrentExplorerDirectory%%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%
      {
         Loop
         {
            nf_FolderNameAdd := " " A_Index+1
            IfNotExist, %nf_CurrentExplorerDirectory%%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%
               break
         }
      }

      If nf_ShowDialog = 1
      {
         InputBox, nf_FolderName, %nf_ScriptName% v%nf_ScriptVersion%, %lng_nf_CreateFolder%,,,115,,,,,%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%
         nf_InputBoxErr = %ErrorLevel%
         nf_SubFolderAdd =

         StringReplace, nf_FolderName, nf_FolderName, /, \, All

         If (InStr(nf_FolderName,":\") = 2)
            nf_CurrentExplorerDirectory =

         If (InStr(nf_FolderName,"\") = 1)
            StringLeft, nf_CurrentExplorerDirectory, nf_CurrentExplorerDirectory, 2

         StringLen, nf_NameAddLen, nf_FolderNameAdd
         If ( func_StrRight(nf_FolderName,nf_NameAddLen) = nf_FolderNameAdd )
         {
            StringTrimRight, nf_FolderName, nf_FolderName, %nf_NameAddLen%
         }
         Else
            nf_FolderNameAdd =

         StringGetPos,nf_SubpathPos, nf_FolderName, \
         If ErrorLevel = 0
         {
            StringTrimLeft, nf_SubFolderAdd, nf_FolderName, %nf_SubpathPos%
            StringLeft, nf_FolderName, nf_FolderName, %nf_SubpathPos%
         }

         If nf_InputBoxErr = 1
            Return

      }
      IfExist, %nf_CurrentExplorerDirectory%%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%
      {
         Loop
         {
            nf_FolderNameAdd := " " A_Index+1
            IfNotExist, %nf_CurrentExplorerDirectory%%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%
               break
         }
      }

      ; Neuen Ordner anlegen
      FileCreateDir, %nf_CurrentExplorerDirectory%%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%

      ; Wenn kein Fehler
      If ErrorLevel = 0
      {
         ; Wenn Ordnerleiste aktiv, zum Ordnerinhalt wechseln
         ControlGetFocus, nf_Control, A
         If nf_Control = SysTreeView321
            ControlFocus, SysListView321, A

         ; 20 mal prfen, ob Ordner exisitert (dauert bei Netzlaufwerken etwas)
         Loop,20
         {
            IfExist, %nf_CurrentExplorerDirectory%%nf_FolderName%%nf_SubFolderAdd%%nf_FolderNameAdd%   ; Prfen ob existiert
            {
               Send,{ESC}{F5}                                         ; Explorer-Ansicht aktualisieren
               Send,%nf_FolderName%%nf_FolderNameAdd%                 ; Ordner auswhlen (durch Eingabe des Namens)
               If nf_ShowDialog = 0
                  Send,{F2}
               Break                                             ; Schleife verlassen
            }
            Sleep,100                                            ; kleine Pause
         }
      }
      Else
         MsgBox, 16, %lng_nf_ErrorCreating%, %lng_nf_CantCreateFolder%
   }

   If nf_ActiveClass = #32770                            ; Ist Dateidialog?
   {
      PostMessage, 0x111, 40962,,,A                      ; Direkten Befehl fr neuer Ordner senden
   }
   If nf_ActiveClass contains bosa_sdm_                  ; Ist Office-Dateidialog?
   {
      Send, !5                                           ; Krzel fr neuer Ordner senden
   }
Return

