; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               MusicControl
; -----------------------------------------------------------------------------
; Prefix:             muc_
; Version:            0.6
; Date:               2006-01-18
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_MusicControl:
   Prefix = muc
   %Prefix%_ScriptName    = MusicControl
   %Prefix%_ScriptVersion = 0.6
   %Prefix%_Author        = Wolfgang Reszel

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                       = %muc_ScriptName% - Tastaturkrzel fr WinAmp und iTunes
      Description                    = Bietet Tastaturkrzel fr WinAmp/iTunes und fr die Systemlautstrke, welche hnlich OS X grafisch dargestellt wird.
      lng_muc_MasterVolume           = Systemlautstrke
      lng_muc_VolUp                  = Lauter
      lng_muc_VolDown                = Leiser
      lng_muc_VolMute                = Stumm/An
      lng_muc_Prev                   = Vorheriges Lied
      lng_muc_Next                   = Nchstes Lied
      lng_muc_Pause                  = Pause
      lng_muc_Rwd                    = Zurckspulen
      lng_muc_FFwd                   = Vorspulen
      lng_muc_Up                     = WinAmp/iTunes lauter
      lng_muc_Down                   = WinAmp/iTunes leiser
      lng_muc_Stop                   = Stop
      lng_muc_Play                   = Play
      lng_muc_ShowOSD                = Grafische Anzeige aktivieren (OSD)
      lng_muc_PlaySound              = akustisches Signal
      lng_muc_NoMasterVol            = Wave-Lautstrke regeln (fr SPDIF)
   }
   else        ; = other languages (english)
   {
      MenuName                       = %muc_ScriptName% - controlling WinAmp and iTunes
      Description                    = Provides hotkeys for conrollling WinAmp/iTunes and the systems' volume. It provides visual feedback like in OS X.
      lng_muc_MasterVolume           = master volume
      lng_muc_VolUp                  = Up
      lng_muc_VolDown                = Down
      lng_muc_VolMute                = Mute/On
      lng_muc_Prev                   = previous song
      lng_muc_Next                   = next song
      lng_muc_Pause                  = pause
      lng_muc_Rwd                    = backwards
      lng_muc_FFwd                   = fast forward
      lng_muc_Up                     = WinAmp/iTunes volume up
      lng_muc_Down                   = WinAmp/iTunes volume down
      lng_muc_Stop                   = Stop
      lng_muc_Play                   = Play
      lng_muc_ShowOSD                = enable visual feedback (OSD)
      lng_muc_PlaySound              = enable acoustic feedback
      lng_muc_NoMasterVol            = apply on wave volume (for SPDIF)
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   If activAid_HasChanged = 1
   {
      IfNotExist, extensions\ac'tivAid_MusicControl_vol.wav
      {
         FileInstall, extensions\ac'tivAid_MusicControl_vol2.gif, extensions\ac'tivAid_MusicControl_vol2.gif
         FileInstall, extensions\ac'tivAid_MusicControl_vol.wav, extensions\ac'tivAid_MusicControl_vol.wav
         FileInstall, extensions\ac'tivAid_MusicControl_vol.gif, extensions\ac'tivAid_MusicControl_vol.gif
         FileInstall, extensions\ac'tivAid_MusicControl_mute.gif, extensions\ac'tivAid_MusicControl_mute.gif
      }
   }

   muc_FadeSpeed = 5

   HideSettings = 0

   func_HotkeyRead( "muc_VolUp",   ConfigFile, muc_ScriptName, "VolUp",   "muc_VolUp",    "#Up" )
   func_HotkeyRead( "muc_VolDown", ConfigFile, muc_ScriptName, "VolDown", "muc_VolDown",  "#Down" )
   func_HotkeyRead( "muc_VolMute", ConfigFile, muc_ScriptName, "VolMute", "muc_VolMute",  "Pause" )
   func_HotkeyRead( "muc_Prev",    ConfigFile, muc_ScriptName, "Prev",    "muc_Prev",     "#Left" )
   func_HotkeyRead( "muc_Next",    ConfigFile, muc_ScriptName, "Next",    "muc_Next",     "#Right" )
   func_HotkeyRead( "muc_Pause",   ConfigFile, muc_ScriptName, "Pause",   "muc_Pause",    "#Delete" )
   func_HotkeyRead( "muc_Rwd",     ConfigFile, muc_ScriptName, "Rwd",     "muc_Rwd",      "#+Left" )
   func_HotkeyRead( "muc_FFwd",    ConfigFile, muc_ScriptName, "FFwd",    "muc_FFwd",     "#+Right" )
   func_HotkeyRead( "muc_Up",      ConfigFile, muc_ScriptName, "Up",      "muc_Up",       "#+Up" )
   func_HotkeyRead( "muc_Down",    ConfigFile, muc_ScriptName, "Down",    "muc_Down",     "#+Down" )
   func_HotkeyRead( "muc_Stop",    ConfigFile, muc_ScriptName, "Stop",    "muc_Stop",     "#End" )
   func_HotkeyRead( "muc_Play",    ConfigFile, muc_ScriptName, "Play",    "muc_Play",     "#Home" )

   IniRead, muc_EnableOSD, %ConfigFile%, %muc_ScriptName%, OSD, 1
   IniRead, muc_EnableSound, %ConfigFile%, %muc_ScriptName%, Sound, 1
   IniRead, muc_NoMasterVol, %ConfigFile%, %muc_ScriptName%, NoMasterVolume, 0

   If muc_EnableOSD = 1
   {
      muc_transparent = 150

      ; Position berechnen
      muc_posY  := A_ScreenHeight - (A_ScreenHeight / 4) - 105

      Gui, 77:+Lastfound +Disabled +ToolWindow -Caption
      Gui, 77:Add, pic, x0 y0 w205 h205 vmuc_OSDvpic, %A_ScriptDir%\extensions\ac'tivAid_MusicControl_vol.gif  ; Bild laden
      Gui, 77:Add, pic, x0 y0 w205 h205 Hidden vmuc_OSDmpic, %A_ScriptDir%\extensions\ac'tivAid_MusicControl_mute.gif  ; Bild laden
      Gui, 77:Color, 959595
      muc_X = 12
      Loop, 20
      {
         Gui, 77:Add, Pic, x%muc_X% y167 w10 h14 vmuc_Volume%A_Index%, %A_ScriptDir%\extensions\ac'tivAid_MusicControl_vol2.gif
         muc_X := muc_X+9
      }
      WinGet,muc_OSDid, ID
      WinSet, TransColor ,0000FF %muc_transparent% ; Transparenz setzen
      WinSet, AlwaysOnTop, On                        ; Immer im Vordergrund

      If muc_NoMasterVol = 1
      {
         SoundGet, muc_LastMaster, Wave
         SoundGet, muc_LastMute, Wave, Mute
      }
      Else
      {
         SoundGet, muc_LastMaster, MASTER
         SoundGet, muc_LastMute, MASTER, Mute
      }
      muc_LastMaster := muc_LastMaster/4.9
   }

   ; Prfen ob WSH aktiv
   RegRead, muc_WSH1, HKEY_CURRENT_USER,Software\Microsoft\Windows Script Host\Settings,Enabled
   RegRead, muc_WSH2, HKEY_LOCAL_MACHINE,Software\Microsoft\Windows Script Host\Settings,Enabled

   If (muc_WSH1 = 0 OR muc_WSH2 = 0 OR FileExist(A_windir "\system32\cscript.exe") = "")
      muc_WSHdisabled = 1
Return


SettingsGui_MusicControl:
   func_HotkeyAddGuiControl( lng_muc_Prev, "muc_Prev",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Next, "muc_Next",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Pause, "muc_Pause",     "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Rwd, "muc_Rwd",         "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_FFwd, "muc_FFwd",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Up, "muc_Up",           "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Down, "muc_Down",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Stop, "muc_Stop",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Play, "muc_Play",       "xs+10 y+3 W150" )

   Gui, Add, GroupBox, xs+10 y+0 h93 w550, %lng_muc_MasterVolume%

   func_HotkeyAddGuiControl( lng_muc_VolUp, "muc_VolUp",     "xs+19 yp+14 W141" )
   func_HotkeyAddGuiControl( lng_muc_VolDown, "muc_VolDown", "xs+19 y+3 W141" )
   func_HotkeyAddGuiControl( lng_muc_VolMute, "muc_VolMute", "xs+19 y+3 W141" )

   Gui, Add, CheckBox, -Wrap gsub_CheckIfSettingsChanged vmuc_EnableOSD xs+20 y+4 Checked%muc_EnableOSD%, %lng_muc_ShowOSD%
   Gui, Add, CheckBox, -Wrap gsub_CheckIfSettingsChanged vmuc_EnableSound x+10 Checked%muc_EnableSound%, %lng_muc_PlaySound%
   Gui, Add, CheckBox, -Wrap gsub_CheckIfSettingsChanged vmuc_NoMasterVol x+10 Checked%muc_NoMasterVol%, %lng_muc_NoMasterVol%
Return

SaveSettings_MusicControl:
   func_HotkeyWrite( "muc_VolUp", ConfigFile, muc_ScriptName, "VolUp")
   func_HotkeyWrite( "muc_VolDown", ConfigFile, muc_ScriptName, "VolDown")
   func_HotkeyWrite( "muc_VolMute", ConfigFile, muc_ScriptName, "VolMute")
   func_HotkeyWrite( "muc_Prev", ConfigFile, muc_ScriptName, "Prev")
   func_HotkeyWrite( "muc_Next", ConfigFile, muc_ScriptName, "Next")
   func_HotkeyWrite( "muc_Pause", ConfigFile, muc_ScriptName, "Pause")
   func_HotkeyWrite( "muc_Rwd", ConfigFile, muc_ScriptName, "Rwd")
   func_HotkeyWrite( "muc_FFwd", ConfigFile, muc_ScriptName, "FFwd")
   func_HotkeyWrite( "muc_Up", ConfigFile, muc_ScriptName, "Up")
   func_HotkeyWrite( "muc_Down", ConfigFile, muc_ScriptName, "Down")
   func_HotkeyWrite( "muc_Stop", ConfigFile, muc_ScriptName, "Stop")
   func_HotkeyWrite( "muc_Play", ConfigFile, muc_ScriptName, "Play")
   IniWrite, %muc_EnableOSD%, %ConfigFile%, %muc_ScriptName%, OSD
   IniWrite, %muc_EnableSound%, %ConfigFile%, %muc_ScriptName%, Sound
   IniWrite, %muc_NoMasterVol%, %ConfigFile%, %muc_ScriptName%, NoMasterVolume
Return

CancelSettings_MusicControl:
Return

DoEnable_MusicControl:
   func_HotkeyEnable( "muc_VolUp" )
   func_HotkeyEnable( "muc_VolDown" )
   func_HotkeyEnable( "muc_VolMute" )
   func_HotkeyEnable( "muc_Prev" )
   func_HotkeyEnable( "muc_Next" )
   func_HotkeyEnable( "muc_Pause" )
   func_HotkeyEnable( "muc_Rwd" )
   func_HotkeyEnable( "muc_FFwd" )
   func_HotkeyEnable( "muc_Up" )
   func_HotkeyEnable( "muc_Down" )
   func_HotkeyEnable( "muc_Stop" )
   func_HotkeyEnable( "muc_Play" )
   If muc_EnableOSD = 1
      SetTimer, muc_tim_VolOSD, 100
Return

DoDisable_MusicControl:
   func_HotkeyDisable( "muc_VolUp" )
   func_HotkeyDisable( "muc_VolDown" )
   func_HotkeyDisable( "muc_VolMute" )
   func_HotkeyDisable( "muc_Prev" )
   func_HotkeyDisable( "muc_Next" )
   func_HotkeyDisable( "muc_Pause" )
   func_HotkeyDisable( "muc_Rwd" )
   func_HotkeyDisable( "muc_FFwd" )
   func_HotkeyDisable( "muc_Up" )
   func_HotkeyDisable( "muc_Down" )
   func_HotkeyDisable( "muc_Stop" )
   func_HotkeyDisable( "muc_Play" )
   SetTimer, muc_tim_VolOSD, Off
Return

DefaultSettings_MusicControl:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

muc_VolUp:
   If muc_NoMasterVol = 1
   {
      SoundSet, 0, Wave, mute
      SoundSet, +5, Wave      ; Wave-Lautstrke Lauter
   }
   Else
   {
      SoundSet, 0, , mute
      SoundSet, +5            ; Gesamtlautstrke Lauter
   }
Return
muc_VolDown:
   If muc_NoMasterVol = 1
   {
      SoundSet, 0, Wave, mute
      SoundSet, -5, Wave      ; Wave-Lautstrke Leise
   }
   Else
   {
      SoundSet, 0, , mute
      SoundSet, -5            ; Gesamtlautstrke Leiser
   }
Return
muc_VolMute:
   If muc_NoMasterVol = 1
      SoundSet, +1, Wave, mute      ; Wave an/aus
   Else
      SoundSet, +1, , mute    ; Ton an/aus
Return
muc_Prev:                        ; Vorheriger Titel
   Detecthiddenwindows,On
   PostMessage, 0x111,40044,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Play();
            iTunesApp.PreviousTrack();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Next:                       ; Nchster Titel
   Detecthiddenwindows,On
   PostMessage, 0x111,40048,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Play();
            iTunesApp.NextTrack();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Pause:                     ; Pause/Play
   Detecthiddenwindows,On
   PostMessage, 0x111,40046,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.PlayPause();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Rwd:                     ; Zurckspulen
   Detecthiddenwindows,On
   PostMessage, 0x111,40144,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            position = iTunesApp.PlayerPosition;
            position = position - 7;
            iTunesApp.PlayerPosition = position;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_FFwd:                     ; Vorspulen
   Detecthiddenwindows,On
   PostMessage, 0x111,40148,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            position = iTunesApp.PlayerPosition;
            position = position + 7;
            iTunesApp.PlayerPosition = position;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Up:                     ; Winamp/iTunes Lauter
   Detecthiddenwindows,On
   PostMessage, 0x111,40058,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            volume = iTunesApp.SoundVolume;
            volume = volume + 7;
            iTunesApp.SoundVolume = volume;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Down:                     ; Winamp/iTunes Leiser
   Detecthiddenwindows,On
   PostMessage, 0x111,40059,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            volume = iTunesApp.SoundVolume;
            volume = volume - 7;
            iTunesApp.SoundVolume = volume;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Stop:                     ; Stop
   Detecthiddenwindows,On
   PostMessage, 0x111,40047,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Stop();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Play:                     ; Play
   Detecthiddenwindows,On
   PostMessage, 0x111,40045,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Play();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %A_windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

muc_tim_VolOSD:
   If LoadingFinished <> 1
      Return

   If muc_EnableOSD <> 1
      Return

   SetControlDelay, -1
   SetWinDelay, -1

   If muc_NoMasterVol = 1
   {
      SoundGet, muc_Master, Wave
      SoundGet, muc_Mute, Wave, Mute
   }
   Else
   {
      SoundGet, muc_Master, MASTER
      SoundGet, muc_Mute, MASTER, Mute
   }
   muc_Master := muc_Master/4.9

   if (muc_Master = muc_LastMaster AND muc_Mute = muc_LastMute)
      Return

   muc_LastMaster = %muc_Master%
   muc_LastMute   = %muc_Mute%

   if muc_Mute <> muc_LastMute
   {
      If muc_Mute = On
      {
        GuiControl,77:Show, muc_OSDmpic
        muc_Master = 0
      }
      Else
      {
        GuiControl,77:Hide, muc_OSDmpic
      }
   }

   Gui, 77:Show, w205 h205 y%muc_posY% NA            ; Symbol darstellen

   Loop, 20
   {
      If A_Index < %muc_Master%
         GuiControl, 77:Show, muc_Volume%A_Index%
      Else
         GuiControl, 77:Hide, muc_Volume%A_Index%
   }
   muc_transparent = 150 ; Anfangstransparenz
   WinSet, TransColor,0000FF %muc_transparent%, ahk_id %muc_OSDid%

   If muc_EnableSound = 1
   {
      SoundPlay,%A_ScriptDir%\extensions\ac'tivAid_MusicControl_vol.wav
   }

   muc_FirstRun =

   Settimer, muc_tim_FadeOSD, 1500
   muc_StartTicks = %A_TickCount%
Return

muc_tim_FadeOSD:
   Settimer, muc_tim_FadeOSD, 5
   muc_Ticks := (A_TickCount-1500-muc_StartTicks) / 500
   muc_transparent := muc_transparent - muc_FadeSpeed * muc_Ticks   ; Transparenz runterzhlen
   if muc_transparent < 1
   {
      Settimer, muc_tim_FadeOSD, Off
      Gui, 77:Hide
      Return
   }
   WinSet, TransColor,0000FF %muc_transparent%, ahk_id %muc_OSDid%  ; Transparenz setzen
Return


