; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               LeoToolTip
; -----------------------------------------------------------------------------
; Prefix:             leo_
; Version:            0.2
; Date:               2006-01-19
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

; Initialisierungsroutine, welche beim Start von ac'tivAid aufgerufen wird.
init_LeoToolTip:
   Prefix = leo
   %Prefix%_ScriptName    = LeoToolTip
   %Prefix%_ScriptVersion = 0.2
   %Prefix%_Author        = Wolfgang Reszel
   RequireExtensions      =
   CustomHotkey_LeoToolTip = 1           ; automatisches benutzerdefinierbares Tastaturkrzel? (1 = ja)
   Hotkey_LeoToolTip       = ^+l         ; Standard-Hotkey
   HotkeyPrefix_LeoToolTip =             ; Prfix, welches vor immer vor dem Tastaturkrzel gesetzt wird

   ; Sprachabhngige Variablen
   If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %leo_ScriptName% - markiertes Wort bersetzen
      Description                   = bersetzt mittels dict.leo.org das markierte Wort und zeigt das Ergebnis als Tooltip an.
      lng_leo_NothingFound          = Suchbegriff nicht gefunden
      lng_leo_Error                 = Fehler beim Zugriff auf LEO.`nVermutlich wurden zu viele Abfragen in Folge an den Server geschickt.`nLEO sperrt in diesem Fall ihre IP-Adresse fr 2 Minuten.`n`nKlicken Sie mit der rechten Maustaste auf diese Meldung,`num die Fehlerseite aufzurufen.
      lng_leo_LeoOnMbutton          = Suche automatisch ausfhren, wenn ein Wort mit der mittleren Maustaste markiert wird. (MouseClip)
      lng_leo_Searching             = Verbinde mit
      lng_leo_Server                = Server
      lng_leo_ServerTip             = pda.leo.org ist schneller, aber bei vielen Anfragen in kurzer Zeit gibt es eine 2-Minuten-Sperrung.
      lng_leo_NumOfResults          = Anzahl der Ergebnisse
   }
   else        ; = Alternativ-Sprache (wenn nicht Deutsch und keine language.ini vorhanden)
   {
      MenuName                      = %leo_ScriptName% - translate selected word
      Description                   = Translates the selected word with dict.leo.org and shows the result as a tooltip.
      lng_leo_NothingFound          = search item not found
      lng_leo_Error                 = Error while accessing LEO.`nMaybe you've sent to many queries in a short time.`nIn that case, LEO locks your IP-address for 2 minutes.
      lng_leo_LeoOnMbutton          = Search automatically when selecting a word with the middle mouse-button. (MouseClip)
      lng_leo_Searching             = Connecting to
      lng_leo_Server                = Server
      lng_leo_ServerTip             = pda.leo.org is faster, but you will be locked for 2 minutes for to many queries in a short time.
      lng_leo_NumOfResults          = Number of results
   }

   IniRead, leo_NumOfResults, %ConfigFile%, LeoToolTip, NumOfResults, 5
   IniRead, leo_EnableMButton, %ConfigFile%, LeoToolTip, LeoOnMButton, 0
   IniRead, leo_Server, %ConfigFile%, LeoToolTip, LeoServerURL, pda.leo.org

   leo_WebBrowsers = OpWindow,MozillaUIWindowClass,IEFrame
Return

SettingsGui_LeoToolTip:
   If Enable_MouseClip = 1
      Gui, Add, Checkbox, -Wrap xs+10 y+5 gleo_sub_MouseClip vleo_EnableMButton Checked%leo_EnableMButton%, %lng_leo_LeoOnMbutton%
   Gui, Add, Text, xs+10 y+20, %lng_leo_Server%:
   Gui, Add, DropDownList, x+5 yp-4 gsub_CheckIfSettingsChanged vleo_Server, dict.leo.org|pda.leo.org
   GuiControl,Choose,leo_Server,%leo_Server%
   Gui, Add, Text, xs+10 y+3, %lng_leo_ServerTip%
   Gui, Add, Text, xs+10 y+20, %lng_leo_NumOfResults%:
   Gui, Add, Edit, x+5 yp-3 -Wrap r1 Number w40 gsub_CheckIfSettingsChanged vleo_NumOfResults, %leo_NumOfResults%
   Gui, Add, UpDown, Range1-20, %leo_NumOfResults%
Return

leo_sub_MouseClip:
   Gosub, sub_CheckIfSettingsChanged
   GuiControlGet, leo_EnableMButton_tmp,,leo_EnableMButton
   If (leo_EnableMButton_tmp = 1 AND Enable_ThesauroToolTip <> "")
      GuiControl,,ttt_EnableMButton,0
Return

SaveSettings_LeoToolTip:
   IniWrite, %leo_NumOfResults%, %ConfigFile%, LeoToolTip, NumOfResults
   IniWrite, %leo_EnableMButton%, %ConfigFile%, LeoToolTip, LeoOnMButton
   IniWrite, %leo_Server%, %ConfigFile%, LeoToolTip, LeoServerURL
Return

AddSettings_LeoToolTip:
Return

CancelSettings_LeoToolTip:
Return

DoEnable_LeoToolTip:
   If (leo_EnableMButton = 1 AND Enable_MouseClip =1)
   {
      Extend_MButton3 = sub_MButton_LeoToolTip
      mc_NoPaste = yes
   }
Return

DoDisable_LeoToolTip:
   If (leo_EnableMButton = 1 AND Enable_MouseClip =1)
   {
      Extend_MButton3 =
      mc_NoPaste =
   }
Return

DefaultSettings_LeoToolTip:
Return

OnExitAndReload_LeoToolTip:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

; Unterroutine fr das automatische Tastaturkrzel
sub_Hotkey_LeoToolTip:
   WinGetClass, leo_WinClass, A
;   msgbox, %leo_WinClass%

   If leo_WinClass Contains %leo_WebBrowsers%
   {
      leo_ttX =
      leo_ttY =
   }
   Else
   {
      leo_ttX := A_CaretX+10
      leo_ttY := A_CaretY+10
   }
   gosub, leo_sub_Search
   SetTimer, leo_tim_ToolTipOff, 10000
   If A_OSType <> WIN32_WINDOWS
   {
      Input,leo_GetKey, L1,{PrintScreen}{ScrollLock}{Pause}{PgUp}{PgDn}{Home}{End}{Ins}{Del}{BackSpace}{F1}{F2}{F3}{F4}{F5}{F6}{F7}{F8}{F9}{F10}{F11}{F12}{F13}{F14}{F15}{F16}{F17}{F18}{F19}{F20}{F21}{F22}{F23}{F24}{F25}{F26}{F27}{F28}{F29}{F30}{Space}{Left}{Right}{Up}{Down}{NumLock}{NumPad1}{NumPad2}{NumPad3}{NumPad4}{NumPad5}{NumPad6}{NumPad7}{NumPad8}{NumPad9}{NumPad0}{NumPadAdd}{NumPadSub}{NumPadMult}{NumPadDiv}{NumPadDot}{NumPadEnter}{NumPadDot}abcdefghijklmnopqrstuvwxyz1234567890!"$`%&/()=+#-.`,*'_:`;<>^``{AppsKey}{Esc}{Tab}{Enter}{CtrlBreak}{Help}{Sleep}{Browser_Back}{Browser_Forward}{Browser_Refresh}{Browser_Stop}{Browser_Search}{Browser_Favorites}{Browser_Home}{Volume_Mute}{Volume_Down}{Volume_Up}{Media_Next}{Media_Prev}{Media_Stop}{Media_Play_Pause}{Launch_Mail}{Launch_Media}{Launch_App1}{Launch_App2}{NumpadDel}{NumpadIns}{NumpadClear}{NumpadUp}{NumpadDown}{NumpadLeft}{NumpadRight}{NumpadHome}{NumpadEnd}{NumpadPgUp}{NumpadPgDn}[]\?|~{{}{}}
      If ErrorLevel contains Endkey:
      {
         StringReplace, leo_GetKey, ErrorLevel, Endkey:,
         If StrLen(leo_GetKey) > 1
            leo_GetKey = {%leo_GetKey%}
         StringLower, leo_GetKey, leo_GetKey
      }
      Getkeystate,leo_GetKeyCtrl,Ctrl
      Getkeystate,leo_GetKeyAlt,Alt
      Getkeystate,leo_GetKeyShift,Shift
      Getkeystate,leo_GetKeyLWin,LWin,
      Getkeystate,leo_GetKeyRWin,RWin,
      Getkeystate,leo_GetKeyCapsLock,CapsLock

      If leo_GetKeyShift = D
         leo_GetKey = +%leo_GetKey%
      If leo_GetKeyAlt = D
         leo_GetKey = !%leo_GetKey%
      If leo_GetKeyCtrl = D
         leo_GetKey = ^%leo_GetKey%
      If (leo_GetKeyLWin = "D" OR leo_GetKeyRWin = "D")
         leo_GetKey = #%leo_GetKey%
      If leo_GetKeyCapsLock = D
         leo_GetKey = ~CapsLock & %leo_GetKey%

      Send, %leo_GetKey%
      Gosub, leo_tim_ToolTipOff
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

sub_MButton_LeoToolTip:
   leo_ttX =
   leo_ttY =
   gosub, leo_sub_Search
   MButton_send =
Return

leo_sub_Search:
   AutoTrim, On

   func_GetSelection()
   leo_searchOrig :=  Selection
   leo_searchFor := leo_func_URLEncode(leo_searchOrig)

   If ( ( leo_searchFor <> leo_lastSearch AND leo_searchFor <> "" ) OR (leo_lastSearch = "" AND leo_searchFor ="") )
   {
      tooltip, %lng_leo_Searching% %leo_Server% ..., %leo_ttX%, %leo_ttY%, 7
      URLDownloadToFile, http://%leo_Server%/?relink=off&sectHdr=off&spellToler=off&search=%leo_searchFor%, %A_Temp%\leoahk.tmp
;      FileCopy, %A_Temp%\leoahk.tmp, %A_Desktop%\LeoToolTip-DebugDatei.txt
      FileRead, leo_Query, %A_Temp%\leoahk.tmp
      FileDelete, %A_Temp%\leoahk.tmp

      StringGetPos, leo_tmp, leo_Query, <td class="td1" valign="middle" width="4
      StringTrimLeft, leo_Result, leo_Query, %leo_tmp%
      StringReplace, leo_Result, leo_Result, <!--`n,`n, A
      StringReplace, leo_Result, leo_Result, <td class="td1" valign="middle" width="45`%">, `n, A
      StringReplace, leo_Result, leo_Result, <td class="td1" valign="middle" width="43`%">, `n, A
      StringReplace, leo_Result, leo_Result, <td class="td1" nowrap width="2`%">,, A
      StringReplace, leo_Result, leo_Result, &nbsp;,%A_Space%, A
      StringReplace, leo_Result, leo_Result, <B>,, A
      StringReplace, leo_Result, leo_Result, </B>,, A
      StringReplace, leo_Result, leo_Result, </td>,, A
      StringReplace, leo_Result, leo_Result, <I>,, A
      StringReplace, leo_Result, leo_Result, </I>,, A
      StringReplace, leo_Result, leo_Result, <small>,, A
      StringReplace, leo_Result, leo_Result, </small>,, A
      StringReplace, leo_Result, leo_Result, <sup>,%A_Space%(, A
      StringReplace, leo_Result, leo_Result, </sup>,), A
      StringReplace, leo_Result, leo_Result, <sub>,%A_Space%(, A
      StringReplace, leo_Result, leo_Result, </sub>,), A
      StringReplace, leo_Result, leo_Result, %A_Tab%,, A
      StringReplace, leo_Result, leo_Result, %A_Space%%A_Space%,%A_Space%, A

      leo_FinalResult =
      leo_Line = 0
      Loop, Parse, leo_Result, `n
      {
         If (A_Index/2 > leo_NumOfResults+1)
            break
         If leo_Line = 1
         {
            leo_Line = 2
            StringGetPos, leo_tmp, A_LoopField, <a
            StringLeft, leo_FromLang, A_LoopField, %leo_tmp%
            If leo_tmp < 1
               leo_FromLang = %A_LoopField%
            IfInstring, A_LoopField, </tr>
               Break
            IfInstring, A_LoopField, <html>
            {
               leo_FinalResult = %lng_leo_NothingFound%: %leo_searchOrig%!
               Break
            }
            If A_LoopField =
               Break
            IfInstring, A_LoopField, <head>
            {
               leo_FinalResult = %lng_leo_Error%!
               Break
            }
         }
         Else If leo_Line = 2
         {
            leo_Line = 1
            StringGetPos, leo_tmp, A_LoopField, <td
            StringLeft, leo_ToLang, A_LoopField, %leo_tmp%
            leo_FinalResult = %leo_FinalResult%%leo_FromLang%  =  %leo_ToLang%`n
         }
         Else
         {
            leo_Line = 1
         }
      }
      StringTrimRight, leo_FinalResult, leo_FinalResult, 1
   }
   Else
      leo_searchFor = %leo_lastSearch%

   leo_lastSearch = %leo_searchFor%
   MouseGetPos, leo_startX, leo_startY
   tooltip, %leo_FinalResult%, %leo_ttX%, %leo_ttY%, 7
   SetTimer, leo_tim_WatchToolTip, 20
   SetTimer, leo_tim_ToolTipOff, 5000
Return

leo_func_URLEncode(leo_url)
{
   SetFormat, integer, hex
   StringReplace, leo_url, leo_url, %A_Space%, `%20
   Loop, 127
   {
      leo_HexCode := A_Index+127
      Transform, leo_HighChar, Chr, %leo_HexCode%
      StringReplace, leo_HexCode, leo_HexCode, 0x,`%
      StringReplace, leo_url, leo_url, %leo_HighChar%, %leo_HexCode%
   }
   SetFormat, integer, dec
   Return %leo_url%
}

leo_tim_ToolTipOff:
   SetTimer, leo_tim_ToolTipOff, Off
   tooltip,,,,7
   SetTimer, leo_tim_WatchToolTip, Off
Return

leo_tim_WatchToolTip:
   MouseGetPos, leo_X, leo_Y, leo_WinID
   If leo_startX <>
   {
      If (leo_X > leo_StartX+4 OR leo_Y > leo_StartY+4 OR leo_X < leo_StartX-4 OR leo_Y < leo_StartY-4)
      {
         leo_startX =
         SetTimer, leo_tim_ToolTipOff, 2000
      }
   }
   WinGetTitle, leo_TipText, ahk_id %leo_WinID%
   If leo_TipText = %leo_FinalResult%
   {
      GetKeyState, leo_LButton, LButton
      GetKeyState, leo_RButton, RButton
      If leo_LButton = D
         Gosub, leo_tim_ToolTipOff
      Else If leo_RButton = D
      {
         Gosub, leo_tim_ToolTipOff
         Run, http://%leo_Server%/?relink=off&sectHdr=off&spellToler=off&search=%leo_searchFor%
      }
      Else
         SetTimer, leo_tim_ToolTipOff, 1000
   }
   GetKeyState, leo_ESC, ESC
   If leo_ESC = D
      SetTimer, leo_tim_ToolTipOff, 1
Return
