; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               HotStrings
; -----------------------------------------------------------------------------
; Prefix:             hs_
; Version:            0.7
; Date:               2006-03-05
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

#include *i settings\Hotstrings.ini

init_HotStrings:
   Prefix = hs
   %Prefix%_ScriptName          = HotStrings
   %Prefix%_ScriptVersion       = 0.7
   %Prefix%_Author              = Wolfgang Reszel
   ConfigFile_Hotstrings        = settings\Hotstrings.ini
   AddSettings_Hotstrings       = 1
   DisableIfCompiled_Hotstrings = 1

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %hs_ScriptName% - Automatische Textbausteine
      Description                   = Ersetzt eingegebene Abkrzungen automatisch mit Textbausteinen.
      DescriptionEXE                = Ersetzt eingegebene Abkrzungen automatisch mit Textbausteinen. (In der EXE-Version von ac'tivAid ist HotStrings nicht konfigurierbar.)
      DescriptionSelf               = Ersetzt eingegebene Abkrzungen automatisch mit Textbausteinen. (Nicht konfigurierbar da die Hotstrings.ini Kommentare enthlt. Die Datei wird scheinbar mit einem Texteditor gepflegt.)
      lng_hs_Name                   = Abkrzung/Krzel
      lng_hs_OptionDirect           = Direkt ersetzen (sonst bei Leerzeichen, Enter ...)
      lng_hs_OptionOmitEnd          = Zeichen, welches die Ersetzung aufruft ignorieren
      lng_hs_OptionInside           = Ersetzung auch innerhalb von Wrtern
      lng_hs_OptionRaw              = Steuerbefehle wie z.B. {Enter}{Left} nicht umsetzen und in Klartext ausgegeben
      lng_hs_OptionAutoBS           = Abkrzung/Krzel nicht durch Textbaustein ersetzen, sondern ergnzen
      lng_hs_OptionAutoEscape       = !, +, ^, und # in Alt, Shift, Strg und Windows umsetzen
      lng_hs_OptionCase             = Klein-/Groschreibung der Abkrzung
      lng_hs_OptionCase1            = beachten
      lng_hs_OptionCase2            = ignorieren
      lng_hs_OptionCase3            = ignorieren und nicht umsetzen
      lng_hs_New                    = (neu)
      lng_hs_Duplicate              = Doppelter Eintrag`nbei HotStrings
      lng_hs_TextMode1              = Textbaustein
      lng_hs_TextMode2              = AutoHotkey-Befehle
      lng_hs_SyntaxCheck            = auf Fehler berprfen
      lng_hs_NoErrors               = Keine Syntax-Fehler gefunden!
      lng_hs_Application            = Nur fr Programm (Fenstertitel)
      lng_hs_AllApps                = Alle Programme
      lng_hs_ClipSave               = Zwischenablage in Datei speichern
      tooltip_hs_HotstringOption_Direct    = Die Ersetzung durch den Textbaustein erfolgt direkt `nnach der Eingabe des letzten Zeichens des Krzels.`nNtzlich fr eigene Ersetzungszeichen (ahk#, mfg# ...)
      tooltip_hs_HotstringOption_OmitEnd   = Das Zeichen woraufhin der Textbaustein eingefgt wird, `nwird nicht mit ausgegeben. Ntzlich wenn z.B. hinter `ndem Textbaustein direkt weitergeschrieben werden soll.
      tooltip_hs_HotstringOption_Inside    = Eine Abkrzung wird auch dann erkannt, `nwenn sie innerhalb eines Wortes steht.
      tooltip_hs_HotstringOption_AutoBS    = Die Abkrzung wird nicht durch den Textbaustein ersetzt, `nsondern der Textbaustein wird hinter die eingegebene `nAbkrzung eingefgt.
      tooltip_hs_HotstringOption_Raw       = Der Textbaustein wird genau wie hier eingetragen ausgegeben, `nSteuerbefehle wie {Enter}, {Left}, {Home} etc. werden `nnicht durch die entsprechenden Tastatureingaben ersetzt.
      tooltip_hs_HotstringOption_AutoEscape= Mit dieser Option werden die Zeichen !, +, ^, und # wie von AutoHotkey `ngewohnt als Steuerzeichen fr Alt, Shift, Strg und Windows umgesetzt.`n1+1 steht dann z.B. fr 1 gefolgt von Shift+1.
      tooltip_hs_HotstringOption_Case1     = Die Abkrzung wird nur erkannt und duch den Textbaustein`nersetzt, wenn sie exakt in ihrer definierten Schreibweise eingegeben wurde.
      tooltip_hs_HotstringOption_Case2     = Die Abkrzung wird unabhngig von ihrer Schreibweise erkannt.`nWird die Abkrzung allerdings komplett in Grobuchstaben`ngeschrieben, wird ebenfalls der Textbaustein komplett in `nGrobuchstaben ausgegeben.
      tooltip_hs_HotstringOption_Case3     = Die Abkrzung wird unabhngig von ihrer Schreibweise erkannt.`nDer Textbaustein wird immer so ausgegeben wie er hier eingetragen wurde.
   }
   else        ; = other languages (english)
   {
      MenuName                      = %hs_ScriptName% - automatic text replacement
      Description                   = Replaces typed abbreviations automatically with text.
      DescriptionEXE                = Replaces typed abbreviations automatically with text. (Not configurable in the exe-version of ac'tivAid)
      DescriptionSelf               = Replaces typed abbreviations automatically with text. (Not configurable because Hotstrings.ini contains comments. It assumes that the file will be administered with a text-editor.)
      lng_hs_Name                   = Abbreviation
      lng_hs_OptionDirect           = replace immediately (otherwise after Space, Enter ...)
      lng_hs_OptionOmitEnd          = ignore the character which causes the replacement
      lng_hs_OptionInside           = replace inside words
      lng_hs_OptionRaw              = output control-commands like {Enter}{Left} as plain text
      lng_hs_OptionAutoBS           = don't replace abbreviation but append the text
      lng_hs_OptionAutoEscape       = substitute !, +, ^, and # with Alt, Shift, Strg or Windows
      lng_hs_OptionCase             = case sensitivity
      lng_hs_OptionCase1            = yes
      lng_hs_OptionCase2            = ignore case
      lng_hs_OptionCase3            = ignore case and don't transpose case
      lng_hs_New                    = (new)
      lng_hs_Duplicate              = duplicate entry`nat HotStrings
      lng_hs_TextMode1              = Text
      lng_hs_TextMode2              = AutoHotkey-commands
      lng_hs_SyntaxCheck            = syntax-check
      lng_hs_NoErrors               = No syntax-errors found!
      lng_hs_Application            = Only for application (window title)
      lng_hs_AllApps                = All applications
      lng_hs_ClipSave               = Save clipboard as file
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   If Enable_Hotstrings <> 1
      hs_FilenameAdd = .disabled

   If A_IsCompiled <> 1
   {
      IfNotExist, %ConfigFile_Hotstrings%
         IfNotExist, %ConfigFile_Hotstrings%.disabled
            FileAppend, `:*C1`:ahk#`:`:AutoHotkey`n`:*`:se#`:`:Stephan Ehrmann`n`:O`:mfg`:`:Mit freundlichen Gren``r``rIhre c't-Redaktion+{Home} `; don't escape modifiers`n`:*`:wr#`:`:Wolfgang Reszel`n`:*`:sg#`:`:Sehr geehrte Damen und Herren{Left 17}+{Right 17} `; don't escape modifiers, %ConfigFile_Hotstrings%%hs_FilenameAdd%
   }
   Else
   {
      ConfigFile_Hotstrings        = settings\Hotstrings_exe.ini
      IfNotExist, settings\Hotstrings.ini
         FileInstall, settings\Hotstrings.ini, settings/hotstrings_exe.ini, 1
      Description = %DescriptionEXE%
   }

   FileReadLine, hs_ReadLine, %ConfigFile_Hotstrings%%hs_FilenameAdd%, 1
   If (func_StrLeft(hs_ReadLine,1) = "`;")
      Description = %DescriptionSelf%
Return

SettingsGui_HotStrings:
   func_AddMessage(0x100, "hs_func_OnMessage_Keys")
   AutoTrim, Off
   hs_Selected =
   hs_Hotstrings = 0
   hs_MultiLineHotstrings = 0
   hs_Apps =
   Loop, Read, %ConfigFile_Hotstrings%%hs_FilenameAdd%
   {
      If (A_LoopReadLine = "")
         continue
      hs_Hotstrings++
      If (func_StrLeft(A_LoopReadLine,1) = "`;")
      {
         If (hs_BeginComment = "" AND hs_Hotstrings > 1)
         {
            hs_HotstringName[%hs_Hotstrings%] = %A_Space%
            hs_Hotstrings++
         }
         If hs_BeginComment = 1
            hs_Hotstrings--
         AutoTrim,On
         StringTrimLeft, hs_LoopReadLine, A_LoopReadLine, 1
         hs_LoopReadLine = %hs_LoopReadLine%
         If hs_HotstringName[%hs_Hotstrings%] =
         {
            hs_HotstringName[%hs_Hotstrings%] =  %hs_LoopReadLine% 
            If A_OSversion = WIN_NT4
               StringReplace, hs_HotstringName[%hs_Hotstrings%], hs_HotstringName[%hs_Hotstrings%], , --, All
            hs_UndoHotstringName[%hs_Hotstrings%] := hs_HotstringName[%hs_Hotstrings%]
         }
         hs_HotstringText[%hs_Hotstrings%] := hs_HotstringText[%hs_Hotstrings%] hs_LoopReadLine "`r`n"
         hs_UndoHotstringText[%hs_Hotstrings%] := hs_HotstringText[%hs_Hotstrings%]
         AutoTrim,Off
         hs_DisableEditing = 1
         hs_BeginComment = 1
         continue
      }
      hs_BeginComment =
      hs_Hotstring4 =
      IfInstring, A_LoopReadLine, #IfWinActive
      {
         AutoTrim, On
         StringReplace, hs_AppTmp, A_LoopReadLine, #IfWinActive,
         StringReplace, hs_AppTmp, hs_AppTmp, `, ,
         hs_AppTmp = %hs_AppTmp%
         If hs_AppTmp <>
            hs_Apps := hs_Apps "|" hs_AppTmp " "

         AutoTrim, Off
         hs_HotStrings--
         continue
      }
      hs_HotstringApp[%hs_Hotstrings%] = %hs_AppTmp%
      hs_UndoHotstringApp[%hs_Hotstrings%] = %hs_AppTmp%
      If hs_MultiLineHotstrings = 0
      {
         StringReplace, hs_Hotstring, A_LoopReadLine, :,
         StringReplace, hs_Hotstring, hs_Hotstring, :, 
         StringReplace, hs_Hotstring, hs_Hotstring, :`:, 
         StringReplace, hs_Hotstring, hs_Hotstring, % " `; " , 
         StringSplit, hs_Hotstring, hs_Hotstring, 
         hs_HotstringOptions[%hs_Hotstrings%] = %hs_Hotstring1%
         AutoTrim, On
         hs_HotstringName[%hs_Hotstrings%] = %hs_Hotstring2%
         AutoTrim, Off
         hs_HotstringText[%hs_Hotstrings%] = %hs_Hotstring3%
         If hs_HotstringText[%hs_Hotstrings%] =
            hs_MultiLineHotstrings = 1

         hs_TextMode[%hs_HotStrings%] = 1

         If hs_Hotstring4 contains don't escape modifiers
            hs_HotstringESC[%hs_Hotstrings%] = 1
         Else
            hs_HotstringESC[%hs_Hotstrings%] = 0
         hs_UndoHotstringOptions[%hs_Hotstrings%] = %hs_Hotstring1%
         hs_UndoHotstringName[%hs_Hotstrings%] = %hs_Hotstring2%
         hs_UndoHotstringText[%hs_Hotstrings%] = %hs_Hotstring3%
         hs_UndoHotstringESC[%hs_Hotstrings%] := hs_HotstringESC[%A_Index%]
      }
      Else
      {
         hs_HotStrings--
         AutoTrim, On
         hs_LoopReadLine = %A_LoopReadLine%
         If hs_LoopReadLine = Return
         {
            hs_MultiLineHotstrings = 0
            continue
         }
         hs_HotstringESC[%hs_Hotstrings%] = 1
         If hs_HotstringText[%hs_Hotstrings%] <>
            hs_HotstringText[%hs_Hotstrings%] := hs_HotstringText[%hs_Hotstrings%] "__NewLine__"
         hs_HotstringText[%hs_Hotstrings%] := hs_HotstringText[%hs_Hotstrings%] hs_LoopReadLine
         hs_UndoHotstringText[%hs_Hotstrings%] := hs_HotstringText[%hs_Hotstrings%]
         hs_TextMode[%hs_Hotstrings%] = 2
         AutoTrim, Off
      }
   }

   hs_HotstringBox =
   Loop, %hs_Hotstrings%
   {
      if hs_HotstringApp[%A_Index%] =
         hs_HotstringBox := hs_HotstringBox hs_HotstringName[%A_Index%] " |"
   }

   If (A_IsCompiled = 1 OR hs_DisableEditing = 1)
      hs_Disabled = Disabled
   Else
      hs_Disabled =

   Sort, hs_Apps, D| U
   hs_Apps = %lng_hs_AllApps%%hs_Apps%

   Gui, Add, DropDownList, xs+10 y+3 W150 vhs_AppFilter ghs_sub_SelectApp, %hs_Apps%
   GuiControl, ChooseString, hs_AppFilter, %lng_hs_AllApps%

   Gui, Add, ListBox, xs+10 y+5 R16 W150 vhs_HotstringBox ghs_sub_Select, %hs_HotstringBox%
   Gui, Add, Text, x+10 yp-23 %hs_Disabled%, %lng_hs_Name%:
   Gui, Add, Edit, Limit30 x+5 ghs_sub_Store yp-3 W180 vhs_HotstringName %hs_Disabled%,
   Gui, Add, Radio, y+7 xs+170 vhs_TextMode1 ghs_sub_Store -Wrap %hs_Disabled%, %lng_hs_TextMode1%
   Gui, Add, Radio, x+10 vhs_TextMode2 ghs_sub_Store -Wrap %hs_Disabled%, %lng_hs_TextMode2%:
   Gui, Add, Button, -Wrap xs+439 yp+0 w120 h15 vhs_SyntaxCheck ghs_sub_SyntaxCheck %hs_Disabled%, %lng_hs_SyntaxCheck%
   Gui, Add, Edit, y+2 xs+170 ghs_sub_Store vhs_HotstringText R4 W390 %hs_Disabled%,
   Gui, Add, Checkbox, y+3 ghs_sub_Store vhs_HotstringOption_Direct -Wrap %hs_Disabled%,%lng_hs_OptionDirect%
   Gui, Add, Checkbox, y+3 ghs_sub_Store vhs_HotstringOption_OmitEnd -Wrap %hs_Disabled%,%lng_hs_OptionOmitEnd%
   Gui, Add, Checkbox, y+3 ghs_sub_Store vhs_HotstringOption_Inside -Wrap %hs_Disabled%,%lng_hs_OptionInside%
   Gui, Add, Checkbox, y+3 ghs_sub_Store vhs_HotstringOption_AutoBS -Wrap %hs_Disabled%,%lng_hs_OptionAutoBS%
   Gui, Add, Checkbox, y+3 ghs_sub_Store vhs_HotstringOption_Raw -Wrap %hs_Disabled%,%lng_hs_OptionRaw%
   Gui, Add, Checkbox, y+3 ghs_sub_Store vhs_HotstringOption_AutoEscape -Wrap %hs_Disabled%,%lng_hs_OptionAutoEscape%
   Gui, Add, Text, y+9 %hs_Disabled%, %lng_hs_OptionCase%:
   Gui, Add, Radio, y+3 ghs_sub_Store vhs_HotstringOption_Case1 -Wrap %hs_Disabled%,%lng_hs_OptionCase1%
   Gui, Add, Radio, x+5 ghs_sub_Store vhs_HotstringOption_Case2 -Wrap %hs_Disabled%,%lng_hs_OptionCase2%
   Gui, Add, Radio, x+5 ghs_sub_Store vhs_HotstringOption_Case3 -Wrap %hs_Disabled%,%lng_hs_OptionCase3%

   Gui, Add, Text, xs+170 y+12 w160 %hs_Disabled%, %lng_hs_Application%:
   Gui, Add, Edit, x+5 ghs_sub_Store yp-3 W225 vhs_HotstringApp %hs_Disabled%,

   Gui, Add, Button, -Wrap xs+10 ys+255 w25 ghs_sub_ListBox_add %hs_Disabled%, +
   Gui, Add, Button, -Wrap x+5 w25 vhs_Remove_HotstringBox ghs_sub_ListBox_remove %hs_Disabled%, %MinusString%

   Gui, Add, Button, -Wrap xs+515 ys+122 ghs_sub_Undo w45 h15 %hs_Disabled%, Undo

   Gui, Add, Button, xs+390 w180 ys+290 %hs_Disabled% h15 ghs_sub_ClipSave, %lng_hs_ClipSave%

   GuiControl,Choose, hs_HotstringBox, 1
   Gosub, hs_sub_Select
   AutoTrim, On
Return

AddSettings_HotStrings:
   If AddFreshSettings = 1
      hs_HotStrings = 0

   AddResult = 0
   hs_AppTmp =
   Loop, Read, %AddFile%
   {
      If (A_LoopReadLine = "" AND A_Index = 1)
         continue
      IfInstring, A_LoopReadLine, `; [Hot
         continue
      IfInstring, A_LoopReadLine, #IfWinActive
      {
         AutoTrim, On
         StringReplace, hs_AppTmp, A_LoopReadLine, #IfWinActive,
         StringReplace, hs_AppTmp, hs_AppTmp, `, ,
         hs_AppTmp = %hs_AppTmp%
         AutoTrim, Off
         If hs_AppTmp <>
         {
            StringReplace, hs_Apps, hs_Apps, "|" hs_AppTmp " ",, A
            hs_Apps := hs_Apps "|" hs_AppTmp " "
         }
         continue
      }
      hs_Hotstring4 =
      StringReplace, hs_Hotstring, A_LoopReadLine, :,
      StringReplace, hs_Hotstring, hs_Hotstring, :, 
      StringReplace, hs_Hotstring, hs_Hotstring, :`:, 
      StringReplace, hs_Hotstring, hs_Hotstring, % " `; " , 
      StringSplit, hs_Hotstring, hs_Hotstring, 
      hs_HotstringOptionsTmp = %hs_Hotstring1%
      AutoTrim, On
      hs_HotstringNameTmp = %hs_Hotstring2%
      AutoTrim, Off
      hs_HotstringTextTmp = %hs_Hotstring3%
      If hs_Hotstring4 contains don't escape modifiers
         hs_HotstringESCTmp = 1
      Else
         hs_HotstringESCTmp = 0

      hs_Duplicates = 0

      hs_Line2 :=  ":" hs_HotstringNameTmp ":`:"

      Loop, %hs_Hotstrings%
      {
         hs_Line1 :=  ":" hs_HotstringName[%A_Index%] ":`:"
;         hs_Line1 :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:"
;         hs_Line2 :=  ":" hs_HotstringOptionsTmp ":" hs_HotstringNameTmp ":`:"
         If (hs_Line1 = hs_Line2)
         {
            hs_Duplicates++
            break
         }
      }
      If hs_Duplicates = 0
      {
         hs_Hotstrings++
         hs_HotstringApp[%hs_Hotstrings%] = %hs_AppTmp%
         hs_HotstringOptions[%hs_Hotstrings%] = %hs_HotstringOptionsTmp%
         hs_HotstringName[%hs_Hotstrings%] = %hs_HotstringNameTmp%
         hs_HotstringText[%hs_Hotstrings%] = %hs_HotstringTextTmp%
         hs_HotstringESC[%hs_Hotstrings%] := hs_HotstringESCTmp
         hs_UndoHotstringApp[%hs_Hotstrings%] = %hs_AppTmp%
         hs_UndoHotstringOptions[%hs_Hotstrings%] = %hs_HotstringOptionsTmp%
         hs_UndoHotstringName[%hs_Hotstrings%] = %hs_HotstringNameTmp%
         hs_UndoHotstringText[%hs_Hotstrings%] = %hs_HotstringTextTmp%
         hs_UndoHotstringESC[%hs_Hotstrings%] := hs_HotstringESCTmp
      }
   }

   Gosub, hs_sub_Refresh
   func_SettingsChanged("Hotstrings")
   ;Gosub, hs_sub_Store
Return

hs_sub_SelectApp:
   GuiControlGet, hs_AppFilter
   StringReplace, hs_AppFilter, hs_AppFilter, %lng_hs_AllApps%
   StringTrimRight, hs_AppFilter, hs_AppFilter, 1
   hs_HotstringBox = |
   Loop, %hs_Hotstrings%
   {
      if (hs_HotstringApp[%A_Index%] = hs_AppFilter)
      {
         hs_HotstringBox := hs_HotstringBox hs_HotstringName[%A_Index%] " |"
      }
   }
   GuiControl,,hs_HotStringBox, %hs_HotstringBox%
   GuiControl,Choose,hs_HotStringBox, 1
   Gosub, hs_sub_Select
Return

hs_sub_Select:
   Critical
   AutoTrim, Off
   If hs_Store = 1
      return

   hs_NoStore = 2

   GuiControlGet, hs_Selected,, hs_HotstringBox
   StringTrimRight, hs_Selected, hs_Selected, 1
   Loop, %hs_Hotstrings%
   {
      If hs_HotstringName[%A_Index%] = %hs_Selected%
      {
         hs_Selected = %A_Index%
         break
      }
   }

   hs_TextMode := hs_TextMode[%hs_selected%]
   GuiControl,,hs_TextMode%hs_TextMode%, 1

   hs_HotstringText := hs_HotstringText[%hs_Selected%]
   If hs_TextMode <> 2
   {
      StringReplace, hs_HotstringText, hs_HotstringText,``n,`r`n, All
      StringReplace, hs_HotstringText, hs_HotstringText, ``r, `r`n, All
   }
   StringReplace, hs_HotstringText, hs_HotstringText,__NewLine__,`r`n, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``t, %A_Tab%, All
   StringReplace, hs_HotstringText, hs_HotstringText, ```;, `;, All
   StringReplace, hs_HotstringText, hs_HotstringText, ```:, `:, All

   If hs_HotstringESC[%hs_Selected%] = 0
   {
      StringReplace, hs_HotstringText, hs_HotstringText, {!}, !, All
      StringReplace, hs_HotstringText, hs_HotstringText, {^}, ^, All
      StringReplace, hs_HotstringText, hs_HotstringText, {+}, +, All
      StringReplace, hs_HotstringText, hs_HotstringText, {#}, #, All
   }
   StringReplace, hs_HotstringText, hs_HotstringText,````,``, All

   GuiControl,,hs_HotstringText, %hs_HotstringText%
   GuiControl,,hs_HotstringName, % hs_HotstringName[%hs_Selected%]
   GuiControl,,hs_HotstringApp, % hs_HotstringApp[%hs_Selected%]
   hs_OptionDirect = 0
   hs_OptionAutoBS = 0
   hs_OptionInside = 0
   hs_OptionOmitEnd = 0
   hs_OptionRaw = 0
   hs_OptionCase1 = 0
   hs_OptionCase2 = 0
   hs_OptionCase3 = 0
   hs_HotstringOptions := hs_HotstringOptions[%hs_Selected%]
   IfInString, hs_HotstringOptions, *
      hs_OptionDirect = 1
   IfInString, hs_HotstringOptions, ?
      hs_OptionInside = 1
   IfInString, hs_HotstringOptions, B0
      hs_OptionAutoBS = 1
   IfInString, hs_HotstringOptions, O
      hs_OptionOmitEnd = 1
   IfInString, hs_HotstringOptions, R
      hs_OptionRaw = 1
   IfInString, hs_HotstringOptions, C1
   {
      hs_OptionCase3 = 1
      StringReplace, hs_HotstringOptions, hs_HotstringOptions, C1,
   }
   IfInString, hs_HotstringOptions, C0
   {
      hs_OptionCase2 = 1
      StringReplace, hs_HotstringOptions, hs_HotstringOptions, C0,
   }
   IfInString, hs_HotstringOptions, C
      hs_OptionCase1 = 1

   If (hs_OptionCase1 = 0 AND hs_OptionCase2 = 0 AND hs_OptionCase3 = 0 )
      hs_OptionCase2 = 1

   If hs_Disabled <> Disabled
      If hs_TextMode = 2
      {
         GuiControl, Disable, hs_HotstringOption_Raw
         GuiControl, Disable, hs_HotstringOption_AutoEscape
         GuiControl, Show, hs_SyntaxCheck
      }
      Else
      {
         GuiControl, Enable, hs_HotstringOption_Raw
         GuiControl, Enable, hs_HotstringOption_AutoEscape
         GuiControl, Hide, hs_SyntaxCheck
      }

   GuiControl,,hs_HotstringOption_Direct, %hs_OptionDirect%
   GuiControl,,hs_HotstringOption_AutoBS, %hs_OptionAutoBS%
   GuiControl,,hs_HotstringOption_OmitEnd, %hs_OptionOmitEnd%
   GuiControl,,hs_HotstringOption_Inside, %hs_OptionInside%
   GuiControl,,hs_HotstringOption_Raw, %hs_OptionRaw%
   GuiControl,,hs_HotstringOption_Case1, %hs_OptionCase1%
   GuiControl,,hs_HotstringOption_Case2, %hs_OptionCase2%
   GuiControl,,hs_HotstringOption_Case3, %hs_OptionCase3%
   GuiControl,,hs_HotstringOption_AutoEscape, % hs_HotstringESC[%hs_Selected%]
   If hs_Disabled =
   {
      GuiControl,Focus,hs_HotStringName
      Send,+{End}
   }
   AutoTrim, On
Return

hs_sub_Store:
   Critical
   If hs_NoStore > 0
   {
      hs_NoStore--
      Return
   }

   Gosub, sub_CheckIfSettingsChanged
   AutoTrim, On
   GuiControlGet,hs_HotstringName,,,
   hs_HotStringName = %hs_HotStringName%
   AutoTrim, Off
   GuiControlGet,hs_HotstringText,,,
   GuiControlGet,hs_HotstringApp,,,
   GuiControlGet,hs_HotstringOption_Direct,,,
   GuiControlGet,hs_HotstringOption_AutoBS,,,
   GuiControlGet,hs_HotstringOption_OmitEnd,,,
   GuiControlGet,hs_HotstringOption_Inside,,,
   GuiControlGet,hs_HotstringOption_Raw,,,
   GuiControlGet,hs_HotstringOption_Case1,,,
   GuiControlGet,hs_HotstringOption_Case2,,,
   GuiControlGet,hs_HotstringOption_Case3,,,
   GuiControlGet,hs_HotstringOption_AutoEscape,,,
   GuiControlGet,hs_TextMode2,,,

   If hs_TextMode2 = 1
   {
      GuiControl, Disable, hs_HotstringOption_Raw
      GuiControl, Disable, hs_HotstringOption_AutoEscape
      hs_HotstringOption_AutoEscape = 1
      hs_HotstringOption_Raw = 0
      GuiControl,, hs_HotstringOption_AutoEscape, %hs_HotstringOption_AutoEscape%
      GuiControl, Show, hs_SyntaxCheck
   }
   Else
   {
      GuiControl, Enable, hs_HotstringOption_Raw
      GuiControl, Enable, hs_HotstringOption_AutoEscape
      GuiControl, Hide, hs_SyntaxCheck
   }

   if hs_HotstringName =
      hs_HotstringName = |

   StringReplace, hs_HotstringText, hs_HotstringText, ``, ````, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``!, __altsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``^, __ctrlsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``+, __shiftsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``#, __winsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, `r`n, __NewLine__, All
   StringReplace, hs_HotstringText, hs_HotstringText, `n, __NewLine__, All
   StringReplace, hs_HotstringText, hs_HotstringText, %A_Tab%, ``t, All
   StringReplace, hs_HotstringText, hs_HotstringText, `;, ```;, All
   StringReplace, hs_HotstringText, hs_HotstringText, `:, ```:, All

   If (func_StrRight( hs_HotstringText, 11) = "__NewLine__")
      StringTrimRight, hs_HotstringText,hs_HotstringText, 11

   If hs_HotstringOption_AutoEscape = 0
   {
      StringReplace, hs_HotstringText, hs_HotstringText, !, {!}, All
      StringReplace, hs_HotstringText, hs_HotstringText, ^, {^}, All
      StringReplace, hs_HotstringText, hs_HotstringText, +, {+}, All
      StringReplace, hs_HotstringText, hs_HotstringText, #, {#}, All
   }
   StringReplace, hs_HotstringText, hs_HotstringText, __altsym__, ``!, All
   StringReplace, hs_HotstringText, hs_HotstringText, __ctrlsym__, ``^, All
   StringReplace, hs_HotstringText, hs_HotstringText, __shiftsym__, ``+, All
   StringReplace, hs_HotstringText, hs_HotstringText, __winsym__, ``#, All

   hs_HotstringName[%hs_Selected%] := hs_HotstringName
   hs_AppOld := hs_HotstringApp[%hs_Selected%]
   hs_HotstringApp[%hs_Selected%] := hs_HotstringApp

   hs_HotstringText[%hs_Selected%] := hs_HotstringText
   hs_HotstringESC[%hs_Selected%] := hs_HotstringOption_AutoEscape
   If hs_TextMode2 = 1
      hs_TextMode[%hs_Selected%] := 2
   Else
      hs_TextMode[%hs_Selected%] := 1

   hs_HotstringOptions[%hs_Selected%] =

   If hs_HotstringOption_Direct = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "*"
   If hs_HotstringOption_Inside = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "?"
   If hs_HotstringOption_AutoBS = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "B0"
   If hs_HotstringOption_OmitEnd = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "O"
   If hs_HotstringOption_Raw = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "R"
   If hs_HotstringOption_Case3 = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "C1"
   If hs_HotstringOption_Case2 = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] ""
   If hs_HotstringOption_Case1 = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "C"

   AutoTrim, On

   hs_AppFilterOld = %hs_AppFilter%

   If hs_HotstringApp <> hs_AppOld
      hs_AppFilter = %hs_HotStringApp%

   hs_HotStringBoxSelected := hs_HotStringName " "

   Gosub, hs_sub_Refresh
Return

hs_sub_Refresh:
   AutoTrim, On

   If hs_HotStringBoxSelected =
      GuiControlGet,hs_HotStringBoxSelected,, hs_HotstringBox

   if hs_AppFilter = %lng_hs_AllApps%
      hs_AppFilter =

   hs_AppFilter = %hs_AppFilter%

   AutoTrim, Off

   hs_HotstringBox = |
   hs_Apps =
   hs_Duplicates = 0
   Loop, %hs_Hotstrings%
   {
      hs_AppTmp := hs_HotstringApp[%A_Index%]
      If hs_AppTmp <>
         hs_Apps := hs_Apps "|" hs_AppTmp " "

      if (hs_HotstringApp[%A_Index%] = hs_AppFilter)
         hs_HotstringBox := hs_HotstringBox hs_HotstringName[%A_Index%] " |"

      hs_Index1 := A_Index
      hs_Line1 :=  ":" hs_HotstringOptions[%hs_Index1%] ":" hs_HotstringName[%hs_Index1%] ":`:"
      Loop, %hs_HotStrings%
      {
         hs_Line2 :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:"
         If (hs_Line1 = hs_Line2 AND hs_Index1 <> A_Index)
         {
            hs_Duplicates++
         }
      }
   }
   Sort, hs_Apps, D| U
   ;Sort, hs_HotStringBox, D|

   hs_Apps = |%lng_hs_AllApps%%hs_Apps%

   if (hs_AppFilter = "" OR !InStr(hs_Apps, hs_AppFilter) )
      hs_AppFilter := lng_hs_AllApps
   Else
      hs_AppFilter := hs_AppFilter " "

   GuiControl,, hs_AppFilter, %hs_Apps%
   GuiControl,ChooseString, hs_AppFilter, % hs_AppFilter

   StringTrimLeft, hs_Apps, hs_Apps, 1

   Coordmode, ToolTip, Relative
   if hs_Duplicates > 0
   {
      GuiControl, Disable, MainGuiOK
      GuiControl, Disable, MainGuiApply
      ToolTip, %lng_hs_Duplicate%, 550, 415
   }
   Else
   {
      GuiControl, Enable, MainGuiOK
      GuiControl, Enable, MainGuiApply
      ToolTip
   }

   Loop, %hs_Hotstrings%
   {
      If hs_HotstringName[%A_Index%] = %hs_HotstringBoxSelected%
      {
         hs_Selected = %A_Index%
         break
      }
   }
   GuiControl,, hs_HotstringBox, %hs_HotstringBox%
   GuiControl,ChooseString,hs_HotstringBox, %hs_HotstringBoxSelected%

   AutoTrim, On
   hs_HotStringBoxSelected =
Return

hs_sub_SyntaxCheck:
   If hs_HotstringText not contains If%A_Space%,Send,SendRaw,IfWin,WinGet,MsgBox,Loop
   {
      hs_HotstringText := "Send, " hs_HotstringText
      GuiControl, , hs_HotStringText, %hs_HotStringText%
      StringReplace, hs_HotstringText, hs_HotstringText, __NewLine__, % "`n   ", All
   }
   Else
      StringReplace, hs_HotstringText, hs_HotstringText, __NewLine__, % "`n   ", All

   FileAppend, #NoTrayIcon`nExitApp`n, hs_syntaxcheck.tmp
   FileAppend, #Include HotStrings_SyntaxCheck.tmp`n, hs_syntaxcheck.tmp
   FileAppend, %hs_HotStringText%, HotStrings_SyntaxCheck.tmp
   RunWait, %A_AhkPath% hs_syntaxcheck.tmp
   If ErrorLevel = 0
      MsgBox, 64, %hs_ScriptName%, %lng_hs_NoErrors%
   FileDelete, HotStrings_SyntaxCheck.tmp
   FileDelete, hs_syntaxcheck.tmp
Return

hs_sub_ListBox_remove:
   AutoTrim, Off
   Gosub, hs_sub_Store

   GuiControl, +AltSubmit, hs_HotStringBox
   GuiControlGet,hs_SelectedPrev,, hs_HotstringBox

   Loop, %hs_Hotstrings%
   {
      If A_Index < %hs_Selected%
         continue
      hs_Index := A_Index + 1
      hs_HotstringName[%A_Index%] := hs_HotstringName[%hs_Index%]
      hs_HotstringApp[%A_Index%] := hs_HotstringApp[%hs_Index%]
      hs_HotstringText[%A_Index%] := hs_HotstringText[%hs_Index%]
      hs_HotstringOptions[%A_Index%] := hs_HotstringOptions[%hs_Index%]
      hs_HotstringESC[%A_Index%] := hs_HotstringESC[%hs_Index%]
      hs_UndoHotstringApp[%A_Index%] := hs_UndoHotstringApp[%hs_Index%]
      hs_UndoHotstringName[%A_Index%] := hs_UndoHotstringName[%hs_Index%]
      hs_UndoHotstringText[%A_Index%] := hs_UndoHotstringText[%hs_Index%]
      hs_UndoHotstringOptions[%A_Index%] := hs_UndoHotstringOptions[%hs_Index%]
      hs_UndoHotstringESC[%A_Index%] := hs_UndoHotstringOptionsESC[%hs_Index%]
   }

   hs_Hotstrings--

   If hs_Hotstrings < 1
      hs_Hotstrings = 1

   Gosub, hs_sub_Refresh

   StringReplace, hs_HotStringBox, hs_HotStringBox, |, |, A UseErrorLevel

   If (hs_SelectedPrev >= ErrorLevel)
      hs_SelectedPrev := ErrorLevel-1

   GuiControl, Choose, hs_HotStringBox, %hs_SelectedPrev%
   GuiControl, -AltSubmit, hs_HotStringBox

   Gosub, hs_sub_Refresh
   Gosub, hs_sub_Select

   ;Gosub, hs_sub_Refresh
Return

hs_sub_ListBox_add:
   AutoTrim, Off
   Gosub, hs_sub_Store
   hs_Hotstrings++
   hs_HotstringName[%hs_Hotstrings%] = %lng_hs_New%
   hs_UndoHotstringName[%hs_Hotstrings%] = %lng_hs_New%
   If hs_AppFilter = %lng_hs_AllApps%
      hs_HotstringApp[%hs_Hotstrings%] =
   Else
      hs_HotstringApp[%hs_Hotstrings%] = %hs_AppFilter%
   hs_HotstringText[%hs_Hotstrings%] =
   hs_HotstringOptions[%hs_Hotstrings%] =
   hs_HotstringESC[%hs_Hotstrings%] = 0
   hs_NoStore = 1
   hs_HotstringBoxSelected := lng_hs_New " "
   GuiControl,,hs_HotstringBox,% lng_hs_New " "
   GuiControl,ChooseString,hs_HotstringBox, %lng_hs_New%
   Gosub, hs_sub_Refresh
   Gosub, hs_sub_Select
   hs_NoStore = 0
   AutoTrim, On
Return

hs_sub_Undo:
   AutoTrim, Off
   hs_HotstringOptions[%hs_Selected%] := hs_UndoHotstringOptions[%hs_Selected%]
   hs_HotstringName[%hs_Selected%] := hs_UndoHotstringName[%hs_Selected%]
   hs_HotstringText[%hs_Selected%] := hs_UndoHotstringText[%hs_Selected%]
   hs_HotstringESC[%hs_Selected%] := hs_UndoHotstringESC[%hs_Selected%]
   hs_HotstringApp[%hs_Selected%] := hs_UndoHotstringApp[%hs_Selected%]
   hs_NoStore = 1
   hs_HotstringBoxSelected := hs_UndoHotstringName[%hs_Selected%] " "
   Gosub, hs_sub_Refresh
   Gosub, hs_sub_Select
   hs_NoStore = 0
   AutoTrim, On
Return

SaveSettings_HotStrings:
   func_RemoveMessage(0x100, "hs_func_OnMessage_Keys")
   If hs_DisableEditing = 1
      Return
   AutoTrim, Off
   Gosub, hs_sub_SortHotstring
   hs_AllHotStrings =
   Loop, Parse, hs_Apps, |
   {
      AutoTrim, On
      hs_App = %A_LoopField%
      AutoTrim, Off
      If hs_App =
         continue

      If hs_App = %lng_hs_AllApps%
         hs_App =

      hs_AllHotStrings = %hs_AllHotStrings%#IfWinActive,%hs_App%`n

      Loop, %hs_Hotstrings%
      {
         If (hs_HotstringName[%A_Index%] = "" OR hs_HotstringName[%A_Index%] = " " OR hs_HotstringText[%A_Index%]="" OR hs_HotstringApp[%A_Index%] <> hs_App)
            continue
         If (func_StrRight(hs_HotstringText[%A_Index%],1) = " ")
         {
            StringTrimRight, hs_HotstringText[%A_Index%], hs_HotstringText[%A_Index%], 1
            hs_HotstringText[%A_Index%] :=  hs_HotstringText[%A_Index%] "{Space}"
         }
         If hs_HotstringESC[%A_Index%] = 1
            hs_LineESC := " `; don't escape modifiers"
         Else
            hs_LineESC =

         If hs_TextMode[%A_Index%] = 2
         {
            If hs_HotstringText[%A_Index%] not contains If%A_Space%,Send,SendRaw,IfWin,WinGet,MsgBox,Loop
            {
               hs_HotstringText[%A_Index%] := "Send, " hs_HotstringText[%A_Index%]
               StringReplace, hs_HotstringText[%A_Index%], hs_HotstringText[%A_Index%], __NewLine__, % "`n   ", All
            }
            Else
            {
               StringReplace, hs_HotstringText[%A_Index%], hs_HotstringText[%A_Index%], ```;, `;, All
               StringReplace, hs_HotstringText[%A_Index%], hs_HotstringText[%A_Index%], __NewLine__, % "`n   ", All
            }
            hs_HotstringText[%A_Index%] := "`n   " hs_HotstringText[%A_Index%] "`nReturn"
            hs_Line :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:" hs_HotstringText[%A_Index%] "`n"
         }
         Else
         {
            StringReplace, hs_HotstringText[%A_Index%], hs_HotstringText[%A_Index%], __NewLine__, ``r, All
            hs_Line :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:" hs_HotstringText[%A_Index%] hs_LineESC "`n"
         }
         hs_AllHotStrings = %hs_AllHotStrings%%hs_Line%
         hs_UndoHotstringText[%A_Index%] := hs_HotstringText[%A_Index%]
      }
   }
   hs_AllHotStrings = %hs_AllHotStrings%#IfWinActive,`n
   FileCopy, %ConfigFile_Hotstrings%.disabled, %ConfigFile_Hotstrings%.bak, 1
   FileAppend, %hs_AllHotStrings% , %ConfigFile_Hotstrings%.tmp

   FileRead, hs_F1, %ConfigFile_Hotstrings%.disabled
   FileRead, hs_F2, %ConfigFile_Hotstrings%.tmp

   FileMove, %ConfigFile_Hotstrings%.tmp, %ConfigFile_Hotstrings%.disabled, 1
   AutoTrim, On

   IfExist, settings/Clipboards
      Gosub, hs_sub_CleanUpClipSaves

   If hs_F1 <> %hs_F2%
   {
      Reload = 1
   }
Return

CancelSettings_HotStrings:
   IfExist, settings/Clipboards
      Gosub, hs_sub_CleanUpClipSaves
   func_RemoveMessage(0x100, "hs_func_OnMessage_Keys")
   ToolTip
Return

DoEnable_HotStrings:
   IfNotExist, %ConfigFile_Hotstrings%.disabled
      return

   Reload = 1
   FileMove, %ConfigFile_Hotstrings%.disabled, %ConfigFile_Hotstrings%,1
Return

DoDisable_HotStrings:
   IfNotExist, %ConfigFile_Hotstrings%
      return

   Reload = 1
   FileMove, %ConfigFile_Hotstrings%, %ConfigFile_Hotstrings%.disabled,1
Return

DefaultSettings_HotStrings:
   FileDelete, %ConfigFile_Hotstrings%
   FileDelete, %ConfigFile_Hotstrings%.disabled
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------


; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

hs_sub_SortHotstring:
   hs_SortList =
   Loop, %hs_Hotstrings%
   {
      hs_SortList :=  hs_SortList hs_HotstringName[%A_Index%] "`t" hs_HotstringOptions[%A_Index%] "`t" hs_HotstringText[%A_Index%] "`t" hs_HotstringESC[%A_Index%] "`t" hs_TextMode[%A_Index%] "`t" hs_HotstringApp[%A_Index%] "`n"
   }
   Sort, hs_SortList
   Loop, Parse, hs_SortList, `n
   {
      StringSplit, hs_Split, A_LoopField, %A_Tab%
      hs_HotstringName[%A_Index%] = %hs_Split1%
      hs_HotstringOptions[%A_Index%] = %hs_Split2%
      hs_HotstringText[%A_Index%] = %hs_Split3%
      hs_HotstringESC[%A_Index%] = %hs_Split4%
      hs_TextMode[%A_Index%] = %hs_Split5%
      hs_HotstringApp[%A_Index%] = %hs_Split6%
   }
Return

hs_func_OnMessage_Keys:
   If (A_GuiControl <> "hs_HotstringName")
      return
   hs_Key = %#wParam%

   GetKeyState, hs_CtrlState, Ctrl
   If hs_CtrlState = D
      hs_Key := hs_Key + 1000
   GetKeyState, hs_ShiftState, Shift
   If hs_ShiftState = D
      hs_Key := hs_Key + 2000
   GetKeyState, hs_AltState, Alt
   If hs_AltState = D
      hs_Key := hs_Key + 4000

;   tooltip,% hs_Key

   if (hs_Key = 38 AND hs_Selected > 1)
   {
      GuiControl, Focus, hs_HotstringBox
      Send, {Up}
   }
   if (hs_Key = 40 AND hs_Selected < hs_HotStrings)
   {
      GuiControl, Focus, hs_HotstringBox
      Send, {Down}
   }
   if ( (hs_Key = 1035 OR hs_Key = 1040) AND hs_Selected < hs_HotStrings )
   {
      GuiControl, Focus, hs_HotstringBox
      Send, {End}
   }
   if ( (hs_Key = 1036 OR hs_Key = 1038) AND hs_Selected > 1 )
   {
      GuiControl, Focus, hs_HotstringBox
      Send, {Home}
   }
Return

hs_sub_ClipSave:
   IfNotExist, settings/Clipboards
      FileCreateDir, settings/Clipboards
   Loop
   {
      hs_ClipFileName = settings/Clipboards/HS_ClipSave%A_Index%.dat
      IfNotExist, %hs_ClipFileName%
         break
   }
   FileAppend, %ClipBoardAll%, %hs_ClipFileName%
   GuiControl,,hs_HotstringText, hs_Temp = `%ClipBoardAll`%`nFileRead, Clipboard, *c %hs_ClipFileName%`nSend, ^v`nSleep, 100`nClipBoard = `%hs_Temp`%
   GuiControl,,hs_TextMode2, 1
   Gosub, hs_sub_Store
Return

hs_sub_CleanUpClipSaves:
   Loop, settings/Clipboards/HS_*.*
   {
      hs_FileName = %A_LoopFileName%
      hs_DeleteFile = 1
      Loop, %hs_hotStrings%
      {
         IfInString, hs_UndoHotStringText[%A_Index%], FileRead, Clipboard, *c settings/Clipboards/%hs_FileName%
            hs_DeleteFile = 0
      }
      If hs_DeleteFile = 1
         FileDelete, settings/Clipboards/%A_LoopFileName%
   }
Return
