; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               FreeSpace
; -----------------------------------------------------------------------------
; Prefix:             fs_
; Version:            0.8
; Date:               2006-06-06
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_FreeSpace:
   Prefix = fs
   %Prefix%_ScriptName    = FreeSpace
   %Prefix%_ScriptVersion = 0.8
   %Prefix%_Author        = Wolfgang Reszel

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %fs_ScriptName% - Zeigt den freien Speicherplatz
      Description                   = Zeigt in der Titelleiste aller Explorer-Fenster den freien Speicherplatz an.
      lng_fs_FreeSpace              = Freier Speicherplatz
      lng_fs_FreeSpaceShort         = frei
      lng_fs_ShortDisplay           = verkrzte Darstellung (Anzeige funktioniert nicht, wenn ein Verzeichnisname mit " frei)" endet.)
      lng_fs_DisplayGB              = Anzeige in Gigabyte
      lng_fs_DecimalPoint           = ,
      lng_fs_RefreshOnlyInExplorer  = Anzeige nur aktualisieren, wenn ein Explorer-Fenster aktiv ist (verhindert z.B. Mausruckler in Photoshop)
      lng_fs_UseStaturbar           = freien Speicherplatz in der Statusleiste statt der Titelleiste anzeigen
      lng_fs_NoBallooTips           = Sprechblasenhinweise "Adressleiste muss sichtbar sein" deaktivieren
   }
   else        ; = other languages (english)
   {
      MenuName                      = %fs_ScriptName% - shows free drive-space
      Description                   = Shows the free drive-space in the title-bar of explorer-windows.
      lng_fs_FreeSpace              = free space
      lng_fs_FreeSpaceShort         = free
      lng_fs_ShortDisplay           = shortened display
      lng_fs_DisplayGB              = show free space in gigabyte
      lng_fs_DecimalPoint           = .
      lng_fs_RefreshOnlyInExplorer  = refresh value only if an explorer-window is active (eg. prevents mouse-lag in Photoshop)
      lng_fs_UseStaturbar           = show free space in the status-bar instead of the title-bar
      lng_fs_NoBallooTips           = disable BalloonTip messages "address bar must be visible"
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, fs_DisplayGB, %ConfigFile%, %fs_ScriptName%, DisplayGigaByte, 0
   IniRead, fs_ShortDisplay, %ConfigFile%, %fs_ScriptName%, ShortDisplay, 0
   IniRead, fs_RefreshOnlyInExplorer, %ConfigFile%, %fs_ScriptName%, RefreshOnlyInExplorer, 0
   IniRead, fs_UseStatusBar, %ConfigFile%, %fs_ScriptName%, UseStatusBar, 0
   IniRead, fs_NoBalloonTips, %ConfigFile%, %fs_ScriptName%, NoBalloonTips, 0
Return

SettingsGui_FreeSpace:
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+5 vfs_DisplayGB -Wrap Checked%fs_DisplayGB%, %lng_fs_DisplayGB%
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+5 vfs_ShortDisplay -Wrap Checked%fs_ShortDisplay%, %lng_fs_ShortDisplay%
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+5 vfs_RefreshOnlyInExplorer -Wrap Checked%fs_RefreshOnlyInExplorer%, %lng_fs_RefreshOnlyInExplorer%
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+5 vfs_UseStatusBar -Wrap Checked%fs_UseStatusBar%, %lng_fs_UseStaturbar%
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+15 vfs_NoBalloonTips -Wrap Checked%fs_NoBalloonTips%, %lng_fs_NoBallooTips%
Return

SaveSettings_FreeSpace:
   IniWrite, %fs_DisplayGB%, %ConfigFile%, %fs_ScriptName%, DisplayGigaByte
   IniWrite, %fs_ShortDisplay%, %ConfigFile%, %fs_ScriptName%, ShortDisplay
   IniWrite, %fs_RefreshOnlyInExplorer%, %ConfigFile%, %fs_ScriptName%, RefreshOnlyInExplorer
   IniWrite, %fs_UseStatusBar%, %ConfigFile%, %fs_ScriptName%, UseStatusBar
   IniWrite, %fs_NoBalloonTips%, %ConfigFile%, %fs_ScriptName%, NoBalloonTips
Return

CancelSettings_FreeSpace:
Return

DoEnable_FreeSpace:
   SetTimer, fs_tim_FreeSpace, 200
Return

DoDisable_FreeSpace:
   SetTimer, fs_tim_FreeSpace, Off
   fs_RestoreTitle = 1
   Gosub, fs_tim_FreeSpace
   fs_RestoreTitle =
Return

DefaultSettings_FreeSpace:
Return

OnExitAndReload_FreeSpace:
   Gosub, DoDisable_FreeSpace
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------


; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

fs_tim_FreeSpace:
   If LoadingFinished <> 1
      Return

   WinGet, fs_WinIDs, List
   WinGetClass, fs_actClass, A
   If ( fs_RefreshOnlyInExplorer = 1 AND fs_RestoreTitle <> 1 AND ( fs_actClass <> "CabinetWClass" AND fs_actClass <> "ExploreWClass" AND fs_actClass <> "Progman" AND fs_actClass <> "Shell_TrayWnd" ) )
      Return

   Loop, %fs_WinIDs%
   {
      fs_WinID := fs_WinIDs%A_Index%
      WinGetClass, fs_WinClass, ahk_id %fs_WinID%
      WinGetTitle, fs_WinT, ahk_id %fs_WinID%

      If fs_WinClass in CabinetWClass,ExploreWClass
      {
         If fs_NoBalloonTips = 1
            fs_Path := func_GetDir( fs_WinID, "ShowBalloonTip", "Never", fs_ScriptName )
         Else
         fs_Path := func_GetDir( fs_WinID, "ShowBalloonTip", "Once", fs_ScriptName )

         IfNotExist, %fs_Path%
            continue

         If fs_UseStatusBar = 1
            StatusBarGetText, fs_Title, 1, ahk_id %fs_WinID%
         Else
            WinGetTitle, fs_Title, ahk_id %fs_WinID%
         fs_WinTitle := fs_Title
         fs_Path := fs_func_GetDrive(fs_Path, "RealPath")
         DriveSpaceFree, fs_FreeSpace, %fs_Path%
         StringReplace, fs_Path, fs_Path, :\,

         If fs_Path =
            fs_Path := fs_lastPath%fs_WinID%

         If fs_ShortDisplay = 1
         {
            StringGetPos, fs_Len, fs_WinTitle, %A_Space%(%fs_Path%:%A_Space%
            if fs_Len < 1
            {
               StringGetPos, fs_Len1, fs_WinTitle, %A_Space%(
               StringGetPos, fs_Len2, fs_WinTitle, :%A_Space%
               If (fs_Len1 = fs_Len2-3)
                  fs_Len = %fs_Len1%
            }
         }
         Else
            StringGetPos, fs_Len, fs_WinTitle, %A_Space%(%lng_fs_FreeSpace%

         if fs_Len > 1
            StringLeft, fs_WinTitle, fs_WinTitle, %fs_Len%

         SetFormat, float, 0.2

         if (fs_DisplayGB = 1 AND fs_FreeSpace > 1024)
         {
            fs_FreeSpace /= 1024.0
            StringReplace, fs_FreeSpace, fs_FreeSpace, . , %lng_fs_DecimalPoint%
            If fs_ShortDisplay = 1
               fs_NewTitle = %fs_WinTitle% (%fs_Path%: %fs_FreeSpace% GB %lng_fs_FreeSpaceShort%)
            Else
               fs_NewTitle = %fs_WinTitle% (%lng_fs_FreeSpace% %fs_Path%: %fs_FreeSpace% GB)
         }
         Else
         {
            If fs_ShortDisplay = 1
               fs_NewTitle = %fs_WinTitle% (%fs_Path%: %fs_FreeSpace% MB %lng_fs_FreeSpaceShort%)
            Else
               fs_NewTitle = %fs_WinTitle% (%lng_fs_FreeSpace% %fs_Path%: %fs_FreeSpace% MB)
         }

         If (fs_FreeSpace = fs_lastFreeSpace%fs_WinID% AND fs_Title = fs_LastTitle%fs_WinID% AND fs_RestoreTitle <> 1)
            continue

         fs_lastFreeSpace%fs_WinID% = %fs_FreeSpace%
         if fs_Path <>
            fs_lastPath%fs_WinID% = %fs_Path%

         if fs_RestoreTitle = 1
            fs_NewTitle = %fs_WinTitle%

         If fs_UseStatusBar = 1
            ControlSetText, msctls_statusbar321, %fs_NewTitle%, ahk_id %fs_WinID%
         Else
            WinSetTitle, ahk_id %fs_WinID%,,%fs_NewTitle%

         If fs_RestoreTitle <> 1
            fs_LastTitle%fs_WinID% = %fs_NewTitle%
      }
   }
Return

fs_func_GetDrive( Path, RealPath = "" )
{
   StringLeft, Drive, Path, 1
   If Drive = \
   {
      StringSplit, Path, Path, \
      If RealPath = RealPath
         Drive = \\%Path3%\%Path4%
      Else
         Drive := func_StrTranslate(Path3 "#" Path4, "-+ !&()'", "______[]_")
   }
   Else If RealPath = RealPath
      Drive = %Drive%:\

   Return %Drive%
}

