; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               FilePaste
; -----------------------------------------------------------------------------
; Prefix:             fp_
; Version:            0.9
; Date:               2006-01-21
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_FilePaste:
   Prefix = fp
   %Prefix%_ScriptName    = FilePaste
   %Prefix%_ScriptVersion = 0.9
   %Prefix%_Author        = Wolfgang Reszel

   CustomHotkey_FilePaste = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_FilePaste       = ^!+v ; Standard-Hotkey
   HotkeyPrefix_FilePaste = $    ; Hook

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %fp_ScriptName% - kopierte Dateien als Text einfgbar
      Description                   = Fgt den Inhalt der Zwischenablage ohne Metainformationen ein. Im Explorer kopierte Dateien lassen sich so als Dateinamen in Textform in andere Anwendungen einfgen.
      lng_fp_PastePaths             = Kompletten Dateipfad einfgen
      lng_fp_PasteRelative          = Texte die vor dem Einfgen entfernt werden (Ntzlich, um relative Pfade zu erhalten)
   }
   else        ; = other languages (english)
   {
      MenuName                      = %fp_ScriptName% - paste filenames as plain text
      Description                   = Pastes text without meta-information. Thus it is possible to paste copied filenames as text into other applications.
      lng_fp_PastePaths             = paste whole path
      lng_fp_PasteRelative          = Strings to remove before pasting (useful to get relative paths)
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, fp_PastePaths, %ConfigFile%, %fp_ScriptName%, PastePaths, 0
   IniRead, fp_RemoveFromPaths, %ConfigFile%, %fp_ScriptName%, RemoveFromPaths
   If fp_RemoveFromPaths = ERROR
      fp_RemoveFromPaths =

   StringReplace, fp_RemoveFromPaths, fp_RemoveFromPaths, |, `n, All
Return

SettingsGui_FilePaste:
   Gui, Add, CheckBox, gsub_fp_Checkboxes xs+10 y+10 vfp_PastePaths -Wrap Checked%fp_PastePaths%, %lng_fp_PastePaths%
   Gui, Add, Text, y+15, %lng_fp_PasteRelative%:
   Gui, Add, Edit, y+5 R13 vfp_RemoveFromPaths w540 gsub_CheckIfSettingsChanged, %fp_RemoveFromPaths%
   Gosub, sub_fp_Checkboxes
Return

sub_fp_Checkboxes:
   Critical
   Gosub, sub_CheckIfSettingsChanged
   GuiControlGet, fp_PastePaths_tmp,,fp_PastePaths
   If fp_PastePaths_tmp = 1
   {
      GuiControl,Enable, fp_RemoveFromPaths
      GuiControl,Enable, %lng_fp_PasteRelative%:
   }
   Else
   {
      GuiControl,Disable, fp_RemoveFromPaths
      GuiControl,Disable, %lng_fp_PasteRelative%:
   }
Return


SaveSettings_FilePaste:
   IniWrite, %fp_PastePaths%, %ConfigFile%, %fp_ScriptName%, PastePaths
   StringReplace, fp_RemoveFromPaths, fp_RemoveFromPaths, `n, |, All
   IniWrite, %fp_RemoveFromPaths%, %ConfigFile%, %fp_ScriptName%, RemoveFromPaths
Return

CancelSettings_FilePaste:
Return

DoEnable_FilePaste:
Return

DoDisable_FilePaste:
Return

DefaultSettings_FilePaste:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_FilePaste:
   StringReplace, fp_LastHotkey, A_ThisHotkey, $,

   If Enable_FilePaste = 1
      Gosub, fp_main_FilePaste_paste
   Else
      Send, {%fp_LastHotkey%}

   If Extend_CtrlAltShiftV <>
      Gosub, %Extend_CtrlAltShiftV%
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

; Textversion der Zwischenablage einfgen
fp_main_FilePaste_paste:
   fp_ClipTemp = %ClipboardAll%
   fp_text = %Clipboard%
   If (fp_PastePaths = 0)
   {
      fp_text2 =
      Loop, Parse, fp_text, `n, `r
      {
         If A_LoopField =
            continue
         IfNotExist, %A_LoopField%
         {
            fp_text2 = %fp_text2%%A_LoopField%`r`n
            continue
         }
         SplitPath, A_LoopField, fp_tmp
         fp_text2 = %fp_text2%%fp_tmp%`r`n
      }
      fp_text = %fp_text2%
   }
   Else
   {
      Loop, Parse, fp_RemoveFromPaths, `n
      {
         Transform, fp_RemoveString, Deref, %A_LoopField%
         StringReplace, fp_text, fp_text, %fp_RemoveString% ,,
      }
   }

   Clipboard =
   Clipboard = %fp_text%
   ClipWait, 2

   ; Folgendes sorgt dafr, dass man Unformatierten Text auch in Adobe-Anwendungen einfgen kann.
   WinGet, fp_actID, ID, A
   IfWinActive, Adobe
   {
      WinActivate,ahk_class Progman ; Aktiviert kurz den Desktop
      WinWaitActive, ahk_class Progman
      WinActivate,ahk_ID %fp_actID% ; und dann wieder die ursprngliche Anwendung
      WinWaitActive,ahk_ID %fp_actID%
   }

   Send, ^v
   Sleep,100
   Clipboard = %fp_ClipTemp%
Return

