; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               ac'tivAid
; -----------------------------------------------------------------------------
; Version:            1.0.7.20
; Date:               2006-06-06 12:09
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; AutoHotkey Version: 1.0.44.04
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Global Settings ===================================== ====================
; -----------------------------------------------------------------------------
dbginitTime = %A_TickCount%
A_Priority = A
Process, Priority,, %A_Priority%
#HotkeyInterval 500
#singleinstance force
;#Winactivateforce
DetectHiddenWindows, Off
SetTitlematchMode, 2
SetBatchLines, -1
SetControlDelay, 0
SetWinDelay, 0
SetKeyDelay,0
#NoTrayIcon
#ClipboardTimeout 4000
SendMode, Input

#NoEnv

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

ScriptName         = activAid
ScriptNameFull     = ac'tivAid
ScriptVersion      = 1.0.7.20
neededAHKversion   = 1.0.44.04

ScriptTitle        = %ScriptNameFull% v%ScriptVersion%

;IniRead, PerUserSettings, settings\%ScriptNameFull%.ini, %ScriptName%, PerUserSettings, 0
;If PerUserSettings = 1

FileAppend, write, %A_ScriptDir%\_temp.tmp
If ErrorLevel <> 0
   MainDirNotWriteable = 1
FileDelete, %A_ScriptDir%\_temp.tmp

APPDATA = %A_AppData%
If APPDATA =
{
   RegRead, APPDATA, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders,AppData
}

If (A_IsAdmin <> 1 AND A_WorkingDir = A_ScriptDir AND MainDirNotWriteable = 1)
{
   FileCreateDir, %APPDATA%\ac'tivAid\settings
   If A_Iscompiled = 1
      FileCreateShortcut,%A_ScriptFullPath%, %APPDATA%\ac'tivAid\%ScriptNameFull%.lnk,%APPDATA%\ac'tivAid,,,
   Else
   {
      IfExist, %A_ScriptDir%\settings\ac'tivAid.ico
         FileCreateShortcut,%A_ScriptFullPath%, %APPDATA%\ac'tivAid\%ScriptNameFull%.lnk,%APPDATA%\ac'tivAid,,,%A_ScriptDir%\settings\ac'tivAid.ico
      Else
         FileCreateShortcut,%A_ScriptFullPath%, %APPDATA%\ac'tivAid\%ScriptNameFull%.lnk,%APPDATA%\ac'tivAid,,,
   }
   FileCopyDir, %A_ScriptDir%\settings\*.ini, %APPDATA%\ac'tivAid\settings
   FileCopyDir, %A_ScriptDir%\settings\*.txt, %APPDATA%\ac'tivAid\settings
   Run, %APPDATA%\ac'tivAid\%ScriptNameFull%.lnk
   ExitApp
}

SettingsDir = settings
A_Quote = "

If A_WorkingDir <> %A_ScriptDir%
   UsingUserDir = 1
Else
   UsingUserDir = 0

;msgbox, %SettingsDir%`n%A_WorkingDir%`n%A_ScriptDir%`n%A_ScriptFullPath%`n%UsingUserDir%

ConfigFile = %SettingsDir%\%ScriptNameFull%.ini

If (A_IsAdmin = 0 AND If MainDirNotWriteable <> 1)
   IniDelete, %ConfigFile%, %ScriptName%, tempAdminMode
If MainDirNotWriteable = 1
   DisabledIfNotAdmin = Disabled

IniRead, tempAdminMode, %ConfigFile%, %ScriptName%, tempAdminMode, 0

UnpackSplashStyle = b1 FS9 W400 CWeeeeee
IfNotExist, %SettingsDir%
   FileCreateDir, %SettingsDir%

IfNotExist, extensions
   FileCreateDir, extensions

SplitPath, A_AhkPath,,A_AutoHotkeyPath

RegRead, RecentPath, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders, Recent

RegRead, SystemDPI, HKEY_CURRENT_USER,Control Panel\Desktop\WindowMetrics,AppliedDPI
If SystemDPI =
   SystemDPI = 96

FontSize := 96/SystemDPI * 8
FontSize6 := 96/SystemDPI * 6
FontSize7 := 96/SystemDPI * 7
FontSize12 := 96/SystemDPI * 12
FontSize14 := 96/SystemDPI * 14
FontSize20 := 96/SystemDPI * 20
FontSize25 := 96/SystemDPI * 25
If SystemDPI = 120
   FontSize = 7

; -----------------------------------------------------------------------------
; Hier werden alle verwendeten Funktionen eingetragen. Mit diesem Array
; wird automatisch das Tray-Men erzeugt.
; -----------------------------------------------------------------------------
Extension[1] = ComfortDrag  ; cd_
Extension[2] = MouseClip    ; md_

; eigene Funktionen/Erweiterungen laden (includes)
#Include *i extensions\_header.ahk

; -----------------------------------------------------------------------------

IniRead, activAid_LastDateTime, %ConfigFile%, %ScriptName%, activAid_DateTime
FileGetTime, activAid_CurrDateTime, %A_ScriptFullPath%, C
IfExist, %ConfigFile%
   IniWrite, %activAid_CurrDateTime%, %ConfigFile%, %ScriptName%, activAid_DateTime
If (A_IsCompiled = 1 AND activAid_CurrDateTime <> activAid_LastDateTime)
   activAid_HasChanged = 1

#Include *i exe-distribution.ahk

If A_IsCompiled = 1
{
   If ExeDistribution <> 1
   {
      IfNotExist, settings\ac'tivAid.ini
      {
         func_UnpackSplash("settings\ac'tivAid.ini")
         FileInstall, settings\ac'tivAid.ini, settings\ac'tivAid.ini
      }
      IfNotExist, settings\ac'tivAid.ico
      {
         func_UnpackSplash("settings\ac'tivAid.ico")
         FileInstall, settings\ac'tivAid.ico, settings\ac'tivAid.ico
      }
      IfNotExist, settings\ac'tivAid_on.ico
      {
         func_UnpackSplash("settings\ac'tivAid_on.ico")
         FileInstall, settings\ac'tivAid_on.ico, settings\ac'tivAid_on.ico
      }
      IfNotExist, settings\ac'tivAid_off.ico
      {
         func_UnpackSplash("settings\ac'tivAid_off.ico")
         FileInstall, settings\ac'tivAid_off.ico, settings\ac'tivAid_off.ico
      }
      IfNotExist, ac'tivAid LiesMich.txt
      {
         func_UnpackSplash("ac'tivAid LiesMich.txt")
         FileInstall, ac'tivAid LiesMich.txt, ac'tivAid LiesMich.txt
      }
      IfNotExist, ac'tivAid ChangeLog.txt
      {
         func_UnpackSplash("ac'tivAid ChangeLog.txt")
         FileInstall, ac'tivAid ChangeLog.txt, ac'tivAid ChangeLog.txt
      }
   }
}

Suspend, On
IsLoading = 1

IniRead, ListBox_selected, %ConfigFile%, %ScriptName%, GUIselected
If ListBox_selected <> ERROR
   SetTimer, tim_Loading, 10

If ListBox_selected = ERROR
   ListBox_selected =

; sprachabhngige Variablen, Systemsprache wird ermittelt
IniRead, Lng, %ConfigFile%, %ScriptName%, Language
If (Lng = "ERROR" OR Lng = "")
   StringRight, Lng, A_Language, 2 ; Sprache ermitteln, wenn nicht in INI festgelegt

IniRead, Betatester, %ConfigFile%, %ScriptName%, Betatester, 0
If A_IsCompiled = 1
   Betatester = 0
BetatesterLast = %Betatester%

If ExeDistribution = 1
{
   UpdateArchive = activaid_exe.zip
   ScriptTitle := ScriptTitle "e"
   ScriptVersion := ScriptVersion "e"
   StringReplace, ScriptTitle, ScriptTitle, %A_Space%betae, e beta
   StringReplace, ScriptVersion, ScriptVersion, %A_Space%betae, e beta
}
Else
   UpdateArchive = activaid.zip

If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   lng_Info                      = %ScriptTitle% konfigurieren ...
   lng_downloadingActivAid       = Die neueste Version von ac'tivAid wird heruntergeladen ...
   lng_ProblemSolver             = Problembehebung
   lng_ProbSolvHidden            = Alle von %ScriptNameFull% verschobenen und minimierten Fenster wurden wiederhergestellt!
   lng_ProbSolvResult            = Folgende Probleme wurden behoben:
   lng_ProbSolvWhy               = Beim Starten von %ScriptNameFull% wurden nicht wiederhergestellte Fenster gefunden.
   lng_ProbSolvNoRes             = Es wurden keine zu behebende Probleme gefunden.`nVersuchen sie evtl. %ScriptNameFull% zu deaktivieren, neu zu laden oder Erweiterungen zu deinstallieren.
   lng_update                    = Auf Aktualisierung prfen
   lng_AutoCheckUpdtBeta         = automatisch bei jedem Start von ac'tivAid prfen
   lng_AutoCheckUpdt             = Jede Woche automatisch prfen
   lng_AskUpdate                 = Soll eine automatische Aktualisierung durchgefhrt werden?`nSie mssen dazu online sein und mindestens den Internet Explorer 3 installiert haben.`n`nDie aktuelle Version finden Sie auch unter: http://www.heise.de/ct/ftp/05/22/210
   lng_NeedNoUpdate              = %ScriptTitle% ist bereits auf dem aktuellen Stand!
   lng_NeedUpdate                = Es ist eine neue Version von %ScriptNameFull% verfgbar.`nSoll sie heruntergeladen und automatisch aktualisiert werden?`nEs werden dabei keine Einstellungen in den INI-Dateien gendert!`n`nMomentane Version: %ScriptVersion%`nAktuelle Version:
   lng_UpdateError               = Die aktuelle Version konnte nicht ermittelt werden, prfen Sie ggf. ihre Internetverbindung.`nDamit die Aktualisierung funktioniert, muss Internet Explorer 3 oder hher installiert sein.
   lng_UpdateFinished            = %ScriptNameFull% wurde aktualisiert und wird nun neu geladen.
   lng_UpdateSuccess             = Die Aktualisierung auf %ScriptTitle% war erfolgreich.
   lng_UpdateNewExtension        = In der Aktualisierung sind folgende neue Erweiterungen enthalten:
   lng_UpdateFailed              = Aktualisierung fehlgeschlagen. Prfen Sie Ihre Internetverbindung und versuchen es noch einmal.`n`nDie aktuelle Version finden Sie auch unter: http://www.heise.de/ct/ftp/05/22/210
   lng_autostart                 = %ScriptNameFull% beim Anmelden bzw. Systemstart laden
   lng_reload                    = %ScriptNameFull% neu laden
   lng_deactivate                = %ScriptNameFull% deaktivieren
   lng_deactivateM               = %lng_deactivate%
   lng_Extension                 = Erweiterung
   lng_Extensions                = Erweiterungen
   lng_ExtOff                    = Alle Erweiterungen verstecken
   lng_ExtOn                     = Alle Erweiterungen wieder anzeigen
   lng_ExtDeinst                 = Alle Erweiterungen verstecken und Einstellungs-Datei umbenennen
   lng_ExtDeinstAsk              = Sollen wirklich alle Erweiterungen versteckt und die Einstellungs-Datei in 'ac'tivAid_ProblemSolver.ini' umbenannt werden?
   lng_SwitchExtErr              = Kein Zugriff auf das extensions-Verzeichnis mit den Erweiterungen, evtl. sind noch Skript-Dateien in einem Texteditor geffnet!
   lng_ShowInTrayMenu            = Erweiterung im Tray-Men anzeigen
   lng_GetKey                    = Bitte eine Tastenkombination drcken`n(ESC = Abbruch, Entf = Lschen):
   lng_GetSingleKey              = Bitte eine Taste drcken`n(ESC = Abbruch, Entf = Lschen):
   lng_AddApps                   = Bitte das gewnschte Fenster auswhlen und Enter drcken (ESC = Abbruch):
   lng_Debugmenu                 = AutoHotkey-Men ins Tray-Men einbeziehen (Window Spy, etc.)
   lng_MainGUI                   = Konfigurationsdialog
   lng_DuplicateHotkey           = Tastaturkrzel wird schon verwendet fr:
   lng_DuplicateTempHotkey       = Dieses Tastaturkrzel wurde gerade zugewiesen,`njedoch noch nicht gespeichert
   lng_Chapter                   = Kapitel:
   lng_DevelMode                 = Entwicklermodus (ac'tivAid wird automatisch neu geladen, wenn eine Skript-Datei gespeichert wurde)
   lng_WritingSettings           = Einstellungen werden gespeichert
   lng_requires                  = bentigt
   lng_requiresAddMsg            = Diese Erweiterung funktioniert nur,`nwenn folgende Erweiterungen installiert sind:`n
   lng_requiresRemMsg            = Diese Erweiterung kann nicht deinstalliert werden,`nda sie von folgenden Erweiterungen bentigt wird:`n
   lng_getClassMsg               = Bitte den Mauszeiger ber das gewnschte Fensterelement `nbewegen und Enter drcken. (ESC = Abbruch)
   lng_Loading                   = %ScriptNameFull% wird neu geladen ...
   lng_Apply                     = bernehmen
   lng_installed                 = installierte
   lng_available                 = verfgbare (deinstallierte)
   lng_exit                      = Beenden
   lng_Left                      = linke
   lng_Right                     = rechte
   lng_Middle                    = mittlere
   lng_MouseButton               = Maustaste
   lng_Key                       = Taste
   lng_KbWin                     = Windows
   lng_KbAlt                     = Alt
   lng_KbShift                   = Umschalt
   lng_KbCtrl                    = Strg
   lng_KbCapsLock                = Feststelltaste
   lng_KbNumpad                  = Ziffernblock
   lng_KbNumpadShort             = Num
   lng_KbScrollLock              = Rollen
   lng_KbPgUp                    = Bild hoch
   lng_KbPgDn                    = Bild runter
   lng_KbEnd                     = Ende
   lng_KbDel                     = Entf
   lng_KbHome                    = Pos1
   lng_KbIns                     = Einfg
   lng_KbPrintScreen             = Druck
   lng_KbCtrlBreak               = Pause/Untbr
   lng_KbBackspace               = Lschen
   lng_KbSpace                   = Leertaste
   lng_KbEnter                   = Enter
   lng_KbTab                     = Tab
   lng_KbPause                   = Pause/Untbr
   lng_KbCurUp                   = Cursor hoch
   lng_KbCurDown                 = Cursor runter
   lng_KbCurLeft                 = Cursor links
   lng_KbCurRight                = Cursor rechts
   lng_KbHelp                    = Hilfe
   lng_KbSleep                   = Standby
   lng_KbBrowser_Back            = Browser Zurck
   lng_KbBrowser_Forward         = Browser Vorwrts
   lng_KbBrowser_Refresh         = Browser Aktualisieren
   lng_KbBrowser_Stop            = Browser Abbrechen
   lng_KbBrowser_Search          = Browser Suchen
   lng_KbBrowser_Favorites       = Browser Favoriten
   lng_KbBrowser_Home            = Browser Startseite
   lng_KbVolume_Mute             = Lautstrke Stumm
   lng_KbVolume_Down             = Lautstrke Leiser
   lng_KbVolume_Up               = Lautstrke Lauter
   lng_KbMedia_Next              = Media Vor
   lng_KbMedia_Prev              = Media Zurck
   lng_KbMedia_Stop              = Media Stop
   lng_KbMedia_Play_Pause        = Media Play/Pause
   lng_KbLaunch_Mail             = Start Mail
   lng_KbLaunch_Media            = Start Media
   lng_KbLaunch_App1             = Start Anwendung1
   lng_KbLaunch_App2             = Start Anwendung2
   lng_Readme                    = Hilfe
   lng_Changelog                 = nderungen
   lng_Browse                    = &Durchsuchen ...
   lng_activated                 = aktiviert
   lng_deactivated               = deaktiviert
   lng_OK                        = OK
   lng_cancel                    = Abbrechen
   lng_Hotkey                    = Tastaturkrzel
   lng_Hotkeys                   = Tastaturkrzel
   lng_Command                   = Befehl
   lng_SettingsMenu              = 8
   lng_DefaultSettings           = auf Standard-Einstellungen zurcksetzen
   lng_ExportSettings            = Einstellungen exportieren
   lng_ImportSettings            = Einstellungen importieren
   lng_AddSettings               = Einstellungen hinzufgen
   lng_ExportAsk                 = Sollen die Einstellungen der derzeit sichtbaren Erweiterung exportiert werden?`nnderungen die hier noch nicht mit OK oder bernehmen besttigt wurden, werden nicht exportiert.
   lng_ImportAsk                 = Beim Importieren werden alle Einstellungen der sichtbaren Erweiterung berschrieben.`nSollen die Einstellungen wirklich importiert werden?
   lng_ImportAsk2                = Beim Importieren werden alle Einstellungen der sichtbaren Erweiterung berschrieben.`nnderungen die hier und in anderen Erweiterungen noch nicht mit OK oder bernehmen besttigt wurden, werden nicht bernommen.`nSollen die Einstellungen wirklich importiert werden?
   lng_AddAsk                    = Sollen die Einstellungen wirklich hinzugefgt werden?`nEs werden nur nicht vorhandene Eintrge hinzugefgt.
   lng_ImportImpossible          = Diese Einstellungs-Datei passt nicht zu der sichtbaren Erweiterung!
   lng_SaveAllSettings           = Komplette Einstellungs-Datei aller Erweiterungen sichern
   lng_LoadAllSettings           = Einstellungs-Datei aller Erweiterungen laden
   lng_SaveAllAsk                = Sollen die gesamten Einstellungen gesichert werden?`nnderungen die hier noch nicht mit OK oder bernehmen besttigt wurden, werden nicht gesichert.
   lng_LoadAllAsk                = Sollen die Einstellungen aller Erweiterungen durch die neue Einstellungs-Datei berschrieben werden?
   lng_DefaultMsg                = Sollen die Einstellungen und Krzel dieser Erweiterung auf die Standard-Werte zurckgesetzt werden?`nAchtung: In anderen Erweiterungen gehen nicht mit OK oder bernehmen besttigte Einstellungen verloren.
   lng_ExtensionManagerHelp      = Installierte Erweiterungen mssen unter Umstnden noch im Konfigurations- fenster oder im Kontextmen des Tray-Symbols aktiviert werden.`n`nAlle bei 'Verfgbare Erweiterungen' aufgelisteten Erweiterungen werden nicht mit ac'tivAid geladen und mssen zur Verwendung hier installiert werden.
   lng_Settings                  = %ScriptName%
   lng_IsInList                  = Das ausgewhlte Verzeichnis befindet sich schon in der Liste!
   lng_HasSubfolder              = Vom ausgewhlte Verzeichnis befinden sich schon Unterverzeichnisse in der Liste!`nDiese mssen vorher entfernt werden.
   lng_IsSubfolder               = Das ausgewhlte Verzeichnis ist ein Unterverzeichnis von:
   lng_EnableDisable             = Erweiterung aktivieren/deaktivieren
   lng_ShowHotkeyList            = Tastaturkrzel-bersicht einblenden
   lng_NoTrayIcon                = Programm-Symbol (Tray-Icon) in der Taskleiste verstecken`nAchtung: Der Konfigurationsdialog ist dann nur noch ber das oben aufgefhrte Tastaturkrzel zu erreichen.
   lng_Betatester                = Auch Beta-Versionen beziehen, welche allerdings auch unerwartetes Verhalten aufweisen knnten.
   lng_ManualUpdate              = manuell aktualisieren
   lng_ManualUpdateText          = Falls automatische Updates z.B. durch einen Proxy verhindert werden, knnen Sie auch die aktuelle Version manuell herunterladen und hier automatisch installieren lassen. Die aktuelle Version finden Sie unter folgender Adresse:
   lng_ManualUpdateText2         = In den meisten Fllen wird auch noch die neueste Version von AutoHotkey bentigt, welche Sie direkt hier herunterladen knnen:
   lng_ManualUpdateTextUnzip     = Zustzlich muss auch die Datei 'unzip.exe' im Verzeichnis 'settings' existieren, welche Sie von folgender Adresse herunterladen knnen:
   lng_ManualUpdatePath          = Verzeichnis mit dem heruntergeladenen Update-Archiv (%UpdateArchive%)
   lng_ManualUpdateFailure       = In dem angegebenen Verzeichnis befindet sich kein Archiv `nmit einer aktuellen Version von ac'tivAid (%UpdateArchive%).`nAchten Sie auch darauf, dass in diesem Verzeichnis`noder im Verzeichnis '%SettingsDir%' die Datei 'unzip.exe' existiert.
   lng_SelectLanguage            = Sprache whlen / select language
   lng_RunAsAdmin                = ac'tivAid mit Administrator-Rechten starten
   lng_AdminName                 = Benutzer mit Administrator-Rechten
   lng_Password                  = Passwort
   lng_WrongAdmin                = Bitte berprfen Sie den Benutzernamen und das Passwort.`nDer angegebene Benutzer muss Administrator-Rechte besitzen.`n`nSind alle Angaben richtig, knnte es daran liegen, dass mehrere Benutzer`ngleichzeitig angemeldet sind (schneller Benutzerwechsel).`nMelden Sie bitte alle anderen Benutzer ab.
   lng_LeaveAdmin                = Administrator abmelden (ac'tivAid wird beendet)
   lng_UserMode00                = Einzelbenutzer-Modus
   lng_UserMode10                = Einzelbenutzer-Modus, Admin
   lng_UserMode01                = Mehrbenutzer-Modus
   lng_UserMode11                = Mehrbenutzer-Modus, Admin
   lng_CheckYourFolderOptions    = In den Ordneroptionen muss eingestellt werden, dass im`nFenstertitel oder in der (sichtbaren!) Adressleiste der`nvollstndige Pfad angezeigt wird. Da der Fenstertitel im`nExplorer eine Lngenbeschrnkung hat, empfiehlt sich`ngenerell die Adressleiste.
   lng_ChangeDirFailed           = Fr den Verzeichniswechsel muss ein Explorerfenster mit Adressleiste oder ein Dateidialog aktiv sein.
   lng_FolderDoesNotExist        = Das Verzeichnis existiert nicht:
   lng_AdminAttention            = Achtung: ac'tivAid luft weiterhin mit Administrator-Rechten
   lng_AskUninstall              = Soll ac'tivAid samt allen Einstellungen der Benutzer deinstalliert werden?
   lng_CreateUninstaller         = Ac'tivAid wird zum ersten mal ausgefhrt.`n`nSoll ac'tivAid unter Systemsteuerung/Software eingetragen werden,`ndamit es spter einfach deinstalliert werden kann?`n`nDies erfordert Zugriff auf die Registry.
   lng_by                        = von

   tooltip_8                     = 'Pfeil'-Men mit weiteren Funktionen

   ReadMeFile                    = %A_ScriptDir%\ac'tivAid LiesMich.txt
}
else        ; = other languages (english)
{
   lng_Info                      = configure %ScriptTitle% ...
   lng_ProblemSolver             = resolve keyboard and mouse-problems
   lng_ProbSolvHidden            = All by %ScriptNameFull%' hidden windows have been restored!
   lng_ProbSolvResult            = The following problems have been solved:
   lng_ProbSolvWhy               = %ScriptNameFull% has found some hidden windows.
   lng_ProbSolvNoRes             = No problems found.`nTry to deactivate or reload %ScriptNameFull% or uninstall all extensions.
   lng_update                    = check for online-updates
   lng_AutoCheckUpdtBeta         = automatically check every script-launch
   lng_AutoCheckUpdt             = automatically check every week
   lng_AskUpdate                 = Should the script check for an update?`nYou have to be online and at least Internet Explorer 3 has to be installed.`n`nA new version could also be found at: http://www.heise.de/ct/ftp/05/22/210
   lng_NeedNoUpdate              = %ScriptTitle% needs no update!
   lng_NeedUpdate                = There's a new version of %ScriptNameFull% available.`nShould %ScriptNameFull% be downloaded and automatically updated?`nThe INI-files won't be changed!`n`ncurrent version: %ScriptVersion%`nactual version:
   lng_UpdateError               = Could not get the actual version, please check your internet connection.`nInternet Explorer 3 or greater must be installed for this function to work.
   lng_UpdateFinished            = %ScriptNameFull% has been updated, it will be reloaded now.
   lng_UpdateSuccess             = Update successful: %ScriptTitle%
   lng_UpdateNewExtension        = The update has installed the following new extensions:
   lng_UpdateFailed              = The downloaded file is not correct, please try it again later.
   lng_autostart                 = load %ScriptNameFull% at login or system-start
   lng_reload                    = reload %ScriptNameFull%
   lng_deactivate                = deactivate %ScriptNameFull%
   lng_deactivateM               = %lng_deactivate%
   lng_Extension                 = Extension
   lng_Extensions                = Extensions
   lng_ExtOff                    = hide all extensions
   lng_ExtOn                     = show all extensions
   lng_ExtDeinst                 = hide all extensions and rename the settings-file
   lng_ExtDeinstAsk              = Do you really want to hide all extensions and rename the settings-file to 'ac'tivAid_ProblemSolver.ini'?
   lng_SwitchExtErr              = No access to the extensions-folder, maybe you have files open!
   lng_ShowInTrayMenu            = visible in tray-menu
   lng_GetKey                    = Please press a hotkey`n(ESC = cancel, Del = delete):
   lng_GetSingleKey              = Please press a key`n(ESC = cancel, Del = delete):
   lng_AddApps                   = Please activate a window and press Enter (ESC = cancel):
   lng_Debugmenu                 = include AutoHotkey-menu in tray-menu (for debugging)
   lng_MainGUI                   = Settings-window
   lng_DuplicateHotkey           = This hotkey is already in use by:
   lng_DuplicateTempHotkey       = this is an already assigned but not confirmed hotkey
   lng_Chapter                   = Chapter:
   lng_DevelMode                 = Development-mode (ac'tivAid reloads automatically, if a script-file has been updated)
   lng_WritingSettings           = Saving settings ...
   lng_requires                  = requires
   lng_requiresAddMsg            = This extension requires the following extension to be installed:`n
   lng_requiresRemMsg            = This extension can't be uninstalled because it's required by the following extensions:`n
   lng_getClassMsg               = Please position the mouse-cursor`nover a windows-control and press Enter. (ESC = cancel)
   lng_Loading                   = reloading %ScriptNameFull% ...
   lng_Apply                     = Apply
   lng_installed                 = installed
   lng_available                 = available
   lng_exit                      = Exit
   lng_Left                      = left
   lng_Right                     = right
   lng_Middle                    = middle
   lng_MouseButton               = Mousebutton
   lng_Key                       = key
   lng_KbWin                     = Windows
   lng_KbAlt                     = Alt
   lng_KbShift                   = Shift
   lng_KbCtrl                    = Ctrl
   lng_KbCapsLock                = CapsLock
   lng_KbNumpad                  = Numpad
   lng_KbNumpadShort             = Num
   lng_KbScrollLock              = ScrollLock
   lng_KbPgUp                    = Page up
   lng_KbPgDn                    = Page down
   lng_KbEnd                     = End
   lng_KbDel                     = Del
   lng_KbHome                    = Home
   lng_KbIns                     = Ins
   lng_KbPrintScreen             = Print
   lng_KbCtrlBreak               = Break
   lng_KbBackspace               = Backspace
   lng_KbSpace                   = Space
   lng_KbEnter                   = Enter
   lng_KbTab                     = Tab
   lng_KbPause                   = Pause
   lng_KbCurUp                   = Cursor up
   lng_KbCurDown                 = Cursor down
   lng_KbCurLeft                 = Cursor left
   lng_KbCurRight                = Cursor right
   lng_KbHelp                    = Help
   lng_KbSleep                   = Standby
   lng_KbBrowser_Back            = Browser Back
   lng_KbBrowser_Forward         = Browser Forward
   lng_KbBrowser_Refresh         = Browser Refresh
   lng_KbBrowser_Stop            = Browser Cancel
   lng_KbBrowser_Search          = Browser Search
   lng_KbBrowser_Favorites       = Browser Favorites
   lng_KbBrowser_Home            = Browser Home
   lng_KbVolume_Mute             = Volume mute
   lng_KbVolume_Down             = Volume down
   lng_KbVolume_Up               = Volume up
   lng_KbMedia_Next              = Media Next
   lng_KbMedia_Prev              = Media Previous
   lng_KbMedia_Stop              = Media Stop
   lng_KbMedia_Play_Pause        = Media Play/Pause
   lng_KbLaunch_Mail             = Start Mail
   lng_KbLaunch_Media            = Start Media
   lng_KbLaunch_App1             = Start App1
   lng_KbLaunch_App2             = Start App2
   lng_Readme                    = Help
   lng_Changelog                 = Changes
   lng_Browse                    = &Browse ...
   lng_activated                 = active
   lng_deactivated               = inactive
   lng_cancel                    = Cancel
   lng_OK                        = OK
   lng_Hotkey                    = Hotkey
   lng_Hotkeys                   = Hotkeys
   lng_Command                   = Command
   lng_SettingsMenu              = 8
   lng_DefaultSettings           = reset to default settings
   lng_ExportSettings            = import settings
   lng_ImportSettings            = export settings
   lng_AddSettings               = add settings
   lng_ExportAsk                 = Do you really want to export the settings of the shown extension?`nUnconfirmed changes (with OK) won't be exported.
   lng_ImportAsk                 = Importing will overwrite all settings of the shown extension`nDo you really want to import?
   lng_ImportAsk2                = Importing will overwrite all settings of the shown extension`nUnconfirmed changes (with OK) won't be exported.`nDo you really want to import?
   lng_AddAsk                    = Do you really want to add the settings?`nOnly non-existent settings will be added.
   lng_ImportImpossible          = Wrong settings-file, it does no match to the shown extension!
   lng_SaveAllSettings           = Save complete settings-file
   lng_LoadAllSettings           = load settings-file
   lng_SaveAllAsk                = Should the whole settings-file be saved?`nUnconfirmed changes (with OK) won't be exported.
   lng_LoadAllAsk                = Do you really want to overwrite all settings?
   lng_DefaultMsg                = Should the settings of the shown extension really be set to default?`nAttention: unconfirmed changes (with OK) get lost.
   lng_ExtensionManagerHelp      = Installed extensions possibly have to be activated in the settings-window or the tray-menu`n`nAll 'available extensions' won't be loaded with ac'tivAid and have to be installed here if you want to use them.
   lng_Settings                  = %ScriptName%
   lng_IsInList                  = The selected folder already exist in the list!
   lng_HasSubfolder              = There are sub-folders from the selected folder in the list!`nYou have to remove them first.
   lng_IsSubfolder               = The selected folder or is a sub-folder of:
   lng_EnableDisable             = enable/disable extension
   lng_ShowHotkeyList            = show overview of all hotkeys
   lng_NoTrayIcon                = no tray-icon (Attention: with this option the settings are only accessible via the hotkey)
   lng_Betatester                = also load beta-versions, which could contain expected bugs
   lng_ManualUpdate              = manual update
   lng_ManualUpdateText          = If automatic update fail (blocked by a proxy), you could download the latest version manually and let it install automatically with this function. The latest version can be downloaded at:
   lng_ManualUpdateText2         = In the most cases you will also need to update AutoHotkey. You can download it directly from this url:
   lng_ManualUpdateTextUnzip     = Additionally the file 'unzip.exe' should exist in the settings-directory, which can be downloaded at:
   lng_ManualUpdatePath          = Directory with the downloaded update-archive (%UpdateArchive%)
   lng_ManualUpdateFailure       = There is no archive with the latest version`nof ac'tivAid (%UpdateArchive%) in that directory.`nCheck if the file 'unzip.exe' does exist there`nor in the settings-directory.
   lng_SelectLanguage            = select language / Sprache whlen
   lng_RunAsAdmin                = start ac'tivAid with administrator rights
   lng_AdminName                 = user with administrator rights
   lng_Password                  = password
   lng_WrongAdmin                = Please check the name and password.`nThe specified user must habe administrator rights.`n`nIf everything is alright, there could be problems with fast-user-switching.`nLog off all other users.
   lng_LeaveAdmin                = logoff administrator (ac'tivAid will be terminated)
   lng_UserMode00                = single-user-mode
   lng_UserMode10                = single-user-mode, Admin
   lng_UserMode01                = multi-user-mode
   lng_UserMode11                = multi-user-mode, Admin
   lng_CheckYourFolderOptions    = Please configure windows explorer to show the`nfull path either in the window-title or the address-bar.
   lng_ChangeDirFailed           = Changing a directory does only work if an explorer-window with address-bar or a file-dialog is active.
   lng_FolderDoesNotExist        = The directory does not exist:
   lng_AdminAttention            = Attention: ac'tivAid is still running with administrator rights
   lng_AskUninstall              = Do you really want to uninstall ac'tivAid and the user-settings?
   lng_CreateUninstaller         = Ac'tivAid has been started the first time.`n`nShould ac'tivAid be added to Control Panel/Software`nso it can be easily uninstalled?`n`nThis will modify the Registry.
   lng_by                        = by

   ReadMeFile                    = %A_ScriptDir%\ac'tivAid Readme.txt
}
IfNotExist, %ReadMeFile%
   ReadMeFile                    = %A_ScriptDir%\ac'tivAid LiesMich.txt

Gosub, CustomLanguage

Random, Random1, 1, 99999
Random, Random2, 1, 99999

lng_UpdateSuccess := lng_UpdateSuccess "                                         "
StringLeft, lng_UpdateSuccess, lng_UpdateSuccess, 75
If tempAdminMode = 1
   lng_UpdateSuccess = %lng_UpdateSuccess%`n`n  %lng_AdminAttention%

; Wenn ac'tivAid mit dem Parameter 'kill' aufgerufen wird, wird es direkt beendet.
; Wird fr das Auto-Update der EXE-Datei bentigt
If 1 = kill
   ExitApp

Gosub, sub_GetAllEnv

If 1 = uninstall
   Gosub, DoUninstall

OnExit, sub_OnExit

ScriptIcon# = 1
ScriptOnIcon# = 1
ScriptOffIcon# = 1

IniRead, NoTrayIcon, %ConfigFile%, %ScriptName%, NoTrayIcon, 0
IniRead, ScriptIcon, %ConfigFile%, %ScriptName%, Icon, %A_ScriptDir%\settings\%ScriptNameFull%.ico
IniRead, ScriptOnIcon, %ConfigFile%, %ScriptName%, TrayIcon_On, %A_ScriptDir%\settings\%ScriptNameFull%_on.ico
IniRead, ScriptOffIcon, %ConfigFile%, %ScriptName%, TrayIcon_Off, %A_ScriptDir%\settings\%ScriptNameFull%_off.ico

; Falls das Skript als EXE-Datei vorliegt, verwendet es sich selber fr die Icons
; das setzt voraus, dass die AutoHotkeySC.bin im Compilerverzeichnis modifiziert wurde
If A_Iscompiled = 1
{
   IfNotExist, %ScriptIcon%
   {
      ScriptIcon = %A_ScriptFullPath%
      ScriptIcon# = 1
   }
   IfNotExist, %ScriptOnIcon%
   {
      ScriptOnIcon = %A_ScriptFullPath%
      ScriptOnIcon# = 6
   }
   IfNotExist, %ScriptOffIcon%
   {
      ScriptOffIcon = %A_ScriptFullPath%
      ScriptOffIcon# = 7
   }
   If ExeDistribution = 1
      ScriptTitle := ScriptTitle
   Else
      ScriptTitle := ScriptTitle " (exe)"
}
Else
{
   IfNotExist, %ScriptIcon%
   {
      ScriptIcon = %A_AhkPath%
      ScriptIcon# = 1
   }
   IfNotExist, %ScriptOnIcon%
   {
      ScriptOnIcon = %A_AhkPath%
      ScriptOnIcon# = 6
   }
   IfNotExist, %ScriptOffIcon%
   {
      ScriptOffIcon = %A_AhkPath%
      ScriptOffIcon# = 7
   }
}

ChangeDirClasses = #32770,ExploreWClass,CabinetWClass,Afx:400000:0,FileZilla Main Window,bosa_sdm,TTOTAL_CMD,SC11MainFrame,SC10MainFrame,WinRarWindow

; Prfen ob NiftyWindows aktiv ist
DetectHiddenWindows, On
IfWinExist,NiftyWindows,,.zip
   niftyWindows = on
Else
   IfWinExist,,NiftyWindows.ahk,.zip,NiftyWindows.ini
      niftyWindows = on
DetectHiddenWindows, Off

; Prfen ob die Sprechblasen (BalloonTips) deaktiviert sind
RegRead, EnableBalloonTips, HKEY_CURRENT_USER, Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced, EnableBalloonTips

IniRead, ExtensionsInExtDir, %ConfigFile%, %ScriptName%, AvailableExtensions
IniRead, Debug, %ConfigFile%, %ScriptName%, Debug, 0
IniRead, Devel, %ConfigFile%, %ScriptName%, Devel, 0
IniRead, ShowHotkeyListX, %ConfigFile%, %ScriptName%, ShowHotkeyListX, %A_Space%
IniRead, ShowHotkeyListY, %ConfigFile%, %ScriptName%, ShowHotkeyListY, %A_Space%
IniRead, ShowHotkeyListH, %ConfigFile%, %ScriptName%, ShowHotkeyListH, h330
If A_IsCompiled = 1
{
   Debug = 0
   Devel = 0
}

func_HotkeyRead( "ProblemSolver" , ConfigFile, ScriptName, "Hotkey_ProblemSolver", "sub_ProblemSolver", "#+#" )
func_HotkeyRead( "MainGUI" , ConfigFile, ScriptName, "Hotkey_MainGUI", "sub_MainGUI", "#a" )
func_HotkeyRead( "DisableEnable" , ConfigFile, ScriptName, "Hotkey_DisableEnable", "sub_MenuSuspend", "#+ESCAPE" )
func_HotkeyRead( "ShowHotkeyList" , ConfigFile, ScriptName, "Hotkey_ShowHotkeyList", "sub_ShowHotkeyList", "#^F1")

; Skript-berwachung, damit es bei nderung neu geladen wird
If ( Devel <> 0 AND A_IsCompiled <> 1)
   SetTimer, tim_UPDATEDSCRIPT, 1000

; Gelegentlich auf NiftyWindows prfen
SetTimer, tim_CheckForNifty, 2000

; Anzahl der Monitore und Arbeitsflche ermitteln
SysGet, NumOfMonitors, 80

SysGet, WorkArea, MonitorWorkArea

SysGet, WorkAreaPrimary, MonitorWorkArea
WorkAreaPrimaryWidth := WorkAreaPrimaryRight - WorkAreaPrimaryLeft
WorkAreaPrimaryHeight := WorkAreaPrimaryBottom - WorkAreaPrimaryTop
If NumOfMonitors < 1
   NumOfMonitors = 1

Loop, %NumOfMonitors%
{
   SysGet, tempArea, Monitor, %A_Index%
   SysGet, WorkArea%A_Index%, MonitorWorkArea, %A_Index%
   SysGet, Monitor%A_Index%, Monitor, %A_Index%
   WorkArea%A_Index%Width := WorkArea%A_Index%Right - WorkArea%A_Index%Left
   WorkArea%A_Index%Height := WorkArea%A_Index%Bottom - WorkArea%A_Index%Top
   Monitor%A_Index%Width := Monitor%A_Index%Right - Monitor%A_Index%Left
   Monitor%A_Index%Height := Monitor%A_Index%Bottom - Monitor%A_Index%Top

   If tempAreaLeft < %WorkAreaLeft%
      WorkAreaLeft := tempAreaLeft
   If tempAreaRight > %WorkAreaRight%
      WorkAreaRight := tempAreaRight
   If tempAreaTop < %WorkAreaTop%
      WorkAreaTop := tempAreaTop
   If tempAreaBottom > %WorkAreaBottom%
      WorkAreaBottom := tempAreaBottom

}

WorkAreaWidth  := WorkAreaRight-WorkAreaLeft
WorkAreaHeight := WorkAreaBottom-WorkAreaTop

SysGet, BorderHeight, 32
SysGet, CaptionHeight, 4
SysGet, SmallCaptionHeight, 51
SysGet, ScrollBarVWeight, 9
SysGet, ScrollBarHWeight, 10

; -----------------------------------------------------------------------------
; Tray-Men und Icon erstellen
; -----------------------------------------------------------------------------
Menu, Tray, Tip, %ScriptTitle%

Menu, Tray, NoStandard
Menu, Tray, Add, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 ) , sub_MainGUI
Menu, Tray, ToggleEnable, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )
Menu, Tray, Add, %lng_update%, sub_getUpdates
Menu, Tray, Add
Menu, Tray, Add, % lng_ProblemSolver "`t" func_HotkeyDecompose( Hotkey_ProblemSolver, 1 ) , sub_ProblemSolver

If (A_IsCompiled <> 1 AND Extension[3] <> "")
{
   IfExist, extensions
   {
      Menu, Tray, Add, %lng_ExtDeinst%, sub_HideAllExtensions
   }
}

Menu, Tray, Add, %lng_reload%, sub_MenuReload
Menu, Tray, Add, %lng_exit% , sub_MenuExit
Menu, Tray, Add
TrayMenu = 7

TrayMenuFirstExtension := TrayMenu - 1

; Menpunkt fr jede eingebundenen Funktionen erstellen
Loop
{
   time = %A_Tickcount%
   If (A_Index = 3 AND Extension[3] <> "")
   {
      Menu, Tray, Add
      TrayMenu++
   }

   actFunct := Extension[%A_Index%]
   actEnable = Enable_%actFunct%
   actEnableTray = EnableTray_%actFunct%

   If actFunct =
      Break

   IniRead, %actEnable%, %ConfigFile%, %ScriptName%, %actEnable%, 1
   If %actEnable% =
         %actEnable% = 1

   HideSettings = 0

   If IsLabel( "init_" actFunct )
      Gosub, init_%actFunct%
   Else
   {
      HideSettings = 1
      Enable_%actFunct% = 0
      EnableTray_%actFunct% = 0
   }
   If HideSettings = 1
      EnableTray_%actFunct% = 0

   If (DisableIfCompiled_%actFunct% = 1 AND A_IsCompiled = 1)
      EnableTray_%actFunct% = 0


   If %actEnableTray% <> 0
   {
      IniRead, %actEnableTray%, %ConfigFile%, %ScriptName%, %actEnableTray%, 1
      If %actEnableTray% =
            %actEnableTray% = 1
   }

   EnableTrayAll := EnableTrayAll %actEnableTray%

   EnableTray_%actFunct%_tmp := %actEnableTray%

   ExtensionCleanMenuName[%A_Index%] = %MenuName%

   if CustomHotkey_%actFunct% = 1
   {
      func_HotkeyRead( actFunct, ConfigFile, actFunct, "Hotkey_" actFunct, "sub_Hotkey_" actFunct, Hotkey_%actFunct%, HotkeyPrefix_%actFunct% )
      MenuName := MenuName "`t" func_HotkeyDecompose( Hotkey_%actFunct%, 1 )
   }

   if (CustomHotkey_%actFunct% <> 1 AND CustomHotkey_%actFunct% <> "")
   {
      CustomHotkeyVar := "Hotkey_" CustomHotkey_%actFunct%
      MenuName := MenuName "`t" func_HotkeyDecompose( %CustomHotkeyVar%, 1 )
   }

   ExtensionPrefix[%A_Index%] = %Prefix%
   ExtensionPrefix[%actFunct%] = %Prefix%
   ExtensionMenuName[%A_Index%] = %MenuName%
   ExtensionHideSettings[%A_Index%] = %HideSettings%
   Extension[%actFunct%] = 1
   ExtensionDescription[%actFunct%] = %Description%
   ExtensionVersion[%actFunct%] := %Prefix%_ScriptVersion

   If ExeDistribution = 1
      ExtensionsInExtDir = %ExtensionsInExtDir%%actFunct%|

   If IsLabel( "init_" actFunct )
   {
      if %actEnable% = 1
         Gosub, DoEnable_%actFunct%
      Else
         Gosub, DoDisable_%actFunct%
      Gosub, sub_MenuCreate
      SubMenu =
   }


   NumFunctions = %A_Index%
   If Debug = 1
      OutputDebug, % actFunct ": " A_Tickcount - time
}

Menu, Tray, Delete, %lng_reload%
Menu, Tray, Delete, %lng_exit%

; Unterer Teil des Mens mit 'deaktivieren' und 'beenden'.
Menu, Tray, Add
Menu, Tray, Add, %lng_reload%, sub_MenuReload
Menu, Tray, Add, % lng_deactivate "`t" func_HotkeyDecompose( Hotkey_DisableEnable, 1 ), sub_MenuSuspend
;Menu, Tray, Default, %lng_deactivate%
Menu, Tray, Default, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )
If Debug = 1
{
   Menu, Tray, Add
   Menu, AHKMenu, Standard
   Menu, Tray, Add, AutoHotkey, :AHKMenu
}
Menu, Tray, Add
Menu, Tray, Add, %lng_exit% , sub_MenuExit
; -----------------------------------------------------------------------------

AutoTrim, Off

; Readme-Datei einlesen
gosub, sub_GetReadme

; Changelog-Datei einlesen
gosub, sub_GetChangeLog

AutoTrim, On

; Problembehebung erforderlich?
; Prfe ob versteckte Fenster nicht wiederhergestellt wurden
IniRead, TempDeskWindowsToMaximize, %ConfigFile%, TemporaryDesktop, WindowsToMaximize
If TempDeskWindowsToMaximize = ERROR
   TempDeskWindowsToMaximize =
IniRead, HiddenWindows, %ConfigFile%, HiddenWindows, WindowList
If HiddenWindows = ERROR
   HiddenWindows =
If HiddenWindows <>
   HiddenWindows = %HiddenWindows%|
StringReplace, HiddenWindows, HiddenWindows, ||,, a

IniRead, TempDeskWindows, %ConfigFile%, TemporaryDesktop, Windows
If TempDeskWindows = ERROR
   TempDeskWindows =

Loop, Parse, TempDeskWindows, |
{
   If A_LoopField =
      continue
   IniRead, TempDeskWindowX[%A_LoopField%], %ConfigFile%, TemporaryDesktop, WindowPosX%A_LoopField%
   IniRead, TempDeskWindowY[%A_LoopField%], %ConfigFile%, TemporaryDesktop, WindowPosY%A_LoopField%
   IniRead, TempDeskWindowMax[%A_LoopField%], %ConfigFile%, TemporaryDesktop, WindowMax%A_LoopField%
}

If HiddenWindows = ERROR
   HiddenWindows =

If ( HiddenWindows <> "" OR TempDeskWindows <> "" )
{
   ProbSolvStartMessage = %lng_ProbSolvWhy%`n`n
   Gosub, sub_ProblemSolver
}

IniRead, ShowGUI, %ConfigFile%, %ScriptName%, ShowGUI, 0

; Skript aktualisiert?
WorkingDir = %A_WorkingDir%
SetWorkingDir, %A_ScriptDir%
IfExist, update.zip
{
   FileSetAttrib,-A,%A_ScriptFullPath%
   FileDelete, update.zip
   FileDelete, update.cmd
   IniRead, newext, %ConfigFile%, activAid, newext, %A_Space%
   IniRead, updScriptVersion, %ConfigFile%, activAid, newver
   newext = %newext%
   updScriptExtension =
   Loop, Parse, newext, `,
   {
      IfNotInstring, ExtensionsInExtDir, %A_LoopField%`,
         updScriptExtension := updScriptExtension A_LoopField "`, "
   }
   If ExtensionsInExtDir = ERROR
      updScriptExtension =
   StringTrimRight, updScriptExtension, updScriptExtension, 2
   IniDelete, %ConfigFile%, activAid, newver
   IniDelete, %ConfigFile%, activAid, newext
   ListBox_selected = 2
   ShowGui = 1
}
SetWorkingDir, %WorkingDir%

; Wchentliches Update
IniRead, UpdateImmediatly, %ConfigFile%, %ScriptName%, CheckForUpdates
IniDelete, %ConfigFile%, %ScriptName%, CheckForUpdates
IniRead, AutoUpdate, %ConfigFile%, %ScriptName%, AutoUpdate
IniRead, LastUpdate, %ConfigFile%, %ScriptName%, LastUpdate
IniRead, ManualUpdatePath, %ConfigFile%, %ScriptName%, ManualUpdatePath, %A_ScriptDir%
If ManualUpdatePath =
   ManualUpdatePath = %A_ScriptDir%
UpdateDiff := (A_YYYY A_YDay) - LastUpdate

; Update-URLs
IniRead, UpdateURL, %ConfigFile%, %ScriptName%, UpdateURL

If ((UpdateURL = "ERROR" OR UpdateURL = "") AND Betatester = 1)
   UpdateURL = http://activaid.rumborak.de/ahk-versions.ini

If (UpdateURL = "ERROR" OR UpdateURL = "" OR ExeDistribution = 1)
   UpdateURL = http://www.heise.de/ct/ftp/05/22/210/versions.ini
Else
   LastUpdate = ERROR

If ( ( (AutoUpdate = "1" AND (LastUpdate = "" OR LastUpdate = "ERROR" OR UpdateDiff >6 )) AND func_CheckIfOnline() = 1 ) OR UpdateImmediatly = 1 )
{
   URLDownloadToFile,%UpdateURL%?dl=%Random1%&ul=%Random2%,versions.ini

   If ErrorLevel = 0
   {
      IniRead, newScriptVersion, versions.ini, activAid, version
      If ExeDistribution = 1
      {
         IniRead, newScriptURL, versions.ini, activAid, exeurl
         IniRead, newScriptSize, versions.ini, activAid, exesize
         newAHKVersion = %A_AHKversion%
      }
      Else
      {
         IniRead, newScriptURL, versions.ini, activAid, url
         IniRead, newScriptSize, versions.ini, activAid, size
         IniRead, newAHKVersion, versions.ini, activAid, AHKversion, %A_AHKversion%
      }
      IniRead, newScriptUnzipURL, versions.ini, activAid, unzip
      IniRead, newScriptExtension, versions.ini, activAid, Extensions
      IniRead, newScriptHideUpdate, versions.ini, activAid, hideupdate, 0
      FileDelete, versions.ini

      if newScriptHideUpdate <> 1
      {
         If newScriptVersion <> ERROR
         {
            StringSplit, newScriptVersion, newScriptVersion, .
            StringSplit, ScriptVersion, ScriptVersion, .
            StringReplace, ScriptVersion4, ScriptVersion4, %A_Space%Beta,
            StringReplace, newScriptVersion4, newScriptVersion4, %A_Space%Beta,
            StringReplace, ScriptVersion3, ScriptVersion3, e,
            StringReplace, ScriptVersion4, ScriptVersion4, e,

            newScriptVersion3 := "0000000000" newScriptVersion3
            StringRight, newScriptVersion3, newScriptVersion3, 10
            newScriptVersion4 := "0000000000" newScriptVersion4
            StringRight, newScriptVersion4, newScriptVersion4, 10
            ScriptVersion3 := "0000000000" ScriptVersion3
            StringRight, ScriptVersion3,ScriptVersion3, 10
            ScriptVersion4 := "0000000000" ScriptVersion4
            StringRight, ScriptVersion4, ScriptVersion4, 10
            newScriptVersionCon = %newScriptVersion1%.%newScriptVersion2%.%newScriptVersion3%.%newScriptVersion4%
            ScriptVersionCon = %ScriptVersion1%.%ScriptVersion2%.%ScriptVersion3%.%ScriptVersion4%

            if newScriptVersionCon > %ScriptVersionCon%
            {
               ToolTip
               Gosub, sub_NewVersion
            }
            IniWrite, % A_YYYY A_YDay, %ConfigFile%, %ScriptName%, LastUpdate
         }
      }
   }
}
If (FileExist(ManualUpdatePath "\" UpdateArchive ) AND ((FileExist(ManualUpdatePath "\unzip.exe") OR FileExist("settings\unzip.exe") OR FileExist("unzip.exe") ) ))
{
   FileGetTime, activAid_ArchiveUpdateTime, %ManualUpdatePath%\%UpdateArchive%, C
   IniRead, activAid_ManualUpdateTime, %ConfigFile%, %ScriptName%, ManualUpdateTime
   If (activAid_ManualUpdateTime <> activAid_ArchiveUpdateTime)
      gosub, sub_DoManualUpdate
}
; Sprachen ermitteln
IfExist, language.ini
{
   FileReadLine, iniLanguage, language.ini, 1
   StringTrimLeft, iniLanguage, iniLanguage, 31
}

Languages = [ automatisch ermitteln / autodetect ]|Deutsch (German)|English|language-files

LanguageNum = 4
Loop, %A_ScriptDir%\settings\languages\language_*.ini,0,1
{
   FileReadLine, tempLanguage, %A_LoopFileFullPath%, 1
   IfNotInString, tempLanguage, `; Language-file for ac'tivAid:
      continue
   LanguageNum++
   StringTrimLeft, tempLanguage, tempLanguage, 31
   Languages = %Languages%|%tempLanguage%
   LanguagesFile[%LanguageNum%] = %A_LoopFileFullPath%
   If tempLanguage = %iniLanguage%
      actLanguage = %LanguageNum%
}
IfNotExist, language.ini
{
   If Lng = 07
      actLanguage = 2
   Else
      actLanguage = 3
}
Else If actLanguage =
{
   LanguageNum++
   actLanguage := LanguageNum
   Languages = %Languages%|%iniLanguage%
   LanguagesFile[%actLanguage%] = language.ini
}
If LanguageNum < 5
   StringReplace, Languages, Languages, |language-files,,

MinusString = 
If A_OSversion = WIN_NT4
{
   StringReplace, Languages, Languages, , --, All
   MinusString = --
}

If NoTrayIcon <> 1
{
   Menu, Tray, Icon, %ScriptOnIcon%, %ScriptOnIcon#%, 1
   Menu, Tray, Icon
}
SetTimer, tim_Loading, Off
IsLoading =
ToolTip
Suspend, Off

Menu, Tray, ToggleEnable, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )

If Debug = 1
   OutputDebug, % "InitTime: " A_TickCount - dbginitTime

If ShowGUI = 1
{
   IniDelete, %ConfigFile%, %ScriptName%, ShowGUI
   SetTimer, tim_LaunchGUI, 10
}

Gosub, sub_RestoreKeyStates
LoadingFinished = 1
SplashImage, Off

SetTimer, CreateUninstallFile, 10

Return

tim_LaunchGUI:
   SetTimer, tim_LaunchGUI, Off
   Gosub, sub_MainGUI
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

CreateUninstallFile:
   SetTimer, CreateUninstallFile, Off

   IniRead, CreateUninstaller, %ConfigFile%, %ScriptName%, CreateUninstaller
   RegRead, InstallLocation, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, In   If (InstallLocation <> A_ScriptDir AN)
   If (InstallLocation <> A_ScriptDir AND CreateUninstaller = "ERROR" AND ErrorLevel = 0)
      CreateUninstaller = 1

   If (CreateUninstaller = "ERROR" OR CreateUninstaller = "")
   {
      MsgBox, 36, %ScriptTitle%, %lng_CreateUninstaller%
      IfMsgBox, Yes
         CreateUninstaller = 1
      IfMsgBox, No
         CreateUninstaller = 0
   }
   IniWrite, %CreateUninstaller%, %ConfigFile%, %ScriptName%, CreateUninstaller
   If CreateUninstaller = 1
   {
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, DisplayName, %ScriptTitle%
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, InstallLocation, %A_ScriptDir%
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, DisplayVersion, %ScriptVersion%
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, HelpLink, http://activaid.rumborak.de
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, URLUpdateInfo, http://www.heise.de/ct/ftp/05/22/210/
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, URLInfoAbout, http://www.heise.de/ct
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, Publisher, Heise Zeitschriften Verlag GmbH & Co. KG
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, Author, Wolfgang Reszel
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, Contact, Stephan Ehrmann, Wolfgang Reszel
      If A_IsCompiled = 1
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, UninstallString, %A_ScriptFullPath% uninstall
      Else
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, UninstallString, %A_AHKPath% "%A_ScriptFullPath%" uninstall
      RegWrite, REG_DWORD, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, NoModify, 1
      RegWrite, REG_DWORD, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, NoRepair, 1
      RegWrite, REG_DWORD, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, EstimatedSize, 800
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, Size, 123
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, Readme, %ReadMeFile%
   }
Return

DoUninstall:
   RegRead, InstallLocation, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid, InstallLocation
   If ErrorLevel = 1
      Return
   MsgBox, 36, %ScriptTitle%, %lng_AskUninstall%
   IfMsgBox, Yes
   {
      SplitPath,USERPROFILE,,CrawlDir
      SplitPath,APPDATA,AppDataName
      RegRead, StartMenuName, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders,Start Menu
      RegRead, AutoStartName, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders,Startup
      SplitPath, StartMenuName, StartMenuName
      SplitPath, AutoStartName, AutoStartName
      Loop, %CrawlDir%\ac'tivAid.lnk,0,1
      {
         IfInString, A_LoopFileFullPath, \%AppDataName%
         {
            SplitPath, A_LoopFileFullPath, , LoopFilePath
            Loop, %LoopFilePath%\*.*, 0, 1
            {
               FileDelete, %A_LoopFilefullpath%
            }
            Loop, %LoopFilePath%\*.*, 2, 1
            {
               FileRemoveDir, %A_LoopFilefullpath%, 1
            }
         }
         IfInString, A_LoopFileFullPath, \%StartMenuName%\
            IfInString, A_LoopFileFullPath, \%AutoStartName%
            {
               FileDelete, %A_LoopFileFullPath%
            }

      }
      RegDelete, HKEY_LOCAL_MACHINE,SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ac'tivAid
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce, %ScriptName%, %comspec% /c del "%InstallLocation%\ac'tivAid.*" && rd /q "%InstallLocation%"
      FileDelete, %InstallLocation%\ac'tivAid*.*
      FileDelete, %InstallLocation%\deveject.exe
      Loop, %InstallLocation%\settings\*.*, 0, 1
      {
         FileDelete, %A_LoopFilefullpath%
      }
      Loop, %InstallLocation%\extensions\*.*, 0, 1
      {
         FileDelete, %A_LoopFilefullpath%
      }
      FileRemoveDir, %InstallLocation%\settings, 1
      FileRemoveDir, %InstallLocation%\extensions, 1
      FileRemoveDir, %InstallLocation%, 0
   }
   ExitApp
Return

CustomLanguage:
   ; Sprachdatei laden (lng-Variablen werden berschrieben)
   #Include *i language.ini
   Description := %Prefix%_Description
   MenuName := %Prefix%_MenuName
Return

; eigene Funktionen laden (include)
#Include *i extensions\_main.ahk

sub_GetReadme:
   ReadIndex = 1
   ReadmeGotoLine[1] = 1
   FileRead, Readme, %ReadMeFile%
   If Devel <> -1
      StringReplace, Readme, Readme, aktiv: ###, aktiv: %A_AHKversion%

   ReadmeDropDown =
   ReadmeGotoLine =
   ReadmeEditIndex = 0
   Loop, Parse, Readme, `n, `r
   {
      ReadmeEditIndex := ReadmeEditIndex + StrLen( A_LoopField ) +2
      IfNotInstring, A_LoopField, % ". "
      {
         PrevReadmeEditIndex = %ReadmeEditIndex%
         continue
      }
      StringSplit, ReadLineSplit, A_LoopField, %A_Space%
      StringReplace, ReadLineTest1, ReadLineSplit2, ., , A
      ReadLineTest2 = %ReadLineTest1%
      ReadLineTest2++
      ReadLineTest2--
      If ((ReadLineTest1 = ReadLineTest2) AND ReadLineTest1 <> "")
      {
         ReadmeIndent = 0
         Loop, Parse, ReadLineSplit2
         {
            If A_LoopField = .
               ReadmeIndent++
         }
         ReadmeSpaces := "             "
         StringLeft, ReadmeSpaces, ReadmeSpaces, % ReadmeIndent * 3
         StringTrimLeft, ReadmeSpaces, ReadmeSpaces, 3
         StringTrimLeft, ReadLine, A_LoopField, 1
         ReadIndex++
         ReadmeDropDown = %ReadmeDropDown%|%ReadmeSpaces%%ReadLine%
         ReadmeGotoLine[%ReadIndex%] = %PrevReadmeEditIndex% ; %A_Index%
      }
      PrevReadmeEditIndex = %ReadmeEditIndex%

      ReadLineSplit2 =
   }
   FileSetAttrib,-A, %ReadMeFile%
Return

sub_GetChangeLog:
   FileRead,ChangeLog, %A_ScriptDir%\%ScriptNameFull% Changelog.txt
   FileSetAttrib,-A, %A_ScriptDir%\%ScriptNameFull% Changelog.txt
Return

tim_Loading:
   CoordMode, ToolTip, Screen
   tooltip, %lng_Loading%
Return

; Menpunkt fr Funktion erstellen und Haken setzen
sub_MenuCreate:
   If EnableTray_%actFunct% <> 1
      Return
   If SubMenu <>
   {
      Menu, Tray, add, %MenuName%, :%SubMenu%
      TrayMenu[%TrayMenu%] = %actFunct%
      TrayMenu[%actFunct%] = %TrayMenu%
      TrayMenuName[%TrayMenu%] = %MenuName%
      TrayMenuName[%SubMenu%] = %MenuName%
      TrayMenu++
      EnableMenu := %actFunct%_EnableMenu
      if Enable_%actFunct% = 1
      {
         If CustomHotkey_%actFunct% = 1
         {
            func_HotkeyEnable( actFunct )
         }

         Menu, %SubMenu%, Check, %EnableMenu%
         Menu, Tray, Check, %MenuName%
      }
      Else
      {
         If CustomHotkey_%actFunct% = 1
         {
            func_HotkeyDisable( actFunct )
         }

         Menu, %SubMenu%, UnCheck, %EnableMenu%
         Menu, Tray, UnCheck, %MenuName%
      }
   }
   Else
   {
      Menu, Tray, add, %MenuName%, sub_MenuCall
      TrayMenu[%TrayMenu%] = %actFunct%
      TrayMenu[%actFunct%] = %TrayMenu%
      TrayMenuName[%TrayMenu%] = %MenuName%
      TrayMenu++
      if Enable_%actFunct% = 1
      {
         If CustomHotkey_%actFunct% = 1
         {
            func_HotkeyEnable( actFunct )
         }
         Menu, Tray, Check, %MenuName%
       }
      Else
      {
         If CustomHotkey_%actFunct% = 1
         {
            func_HotkeyDisable( actFunct )
         }
         Menu, Tray, UnCheck, %MenuName%
      }
   }

   SubMenu =
Return

GuiDefaultFont:
   Gui, Font
   Gui, Font, S%FontSize% ; , Modern MS Sans Serif
Return

2GuiDefaultFont:
   Gui, 2:Font
   Gui, 2:Font, S%FontSize% ;, Modern MS Sans Serif
Return

4GuiDefaultFont:
   Gui, 4:Font
   Gui, 4:Font, S%FontSize% ;, Modern MS Sans Serif
Return

; Wird von den Menpunkten aufgerufen.
sub_MenuCall:
   Critical
   DoReload =
   Reload =

   If A_ThisMenu = Tray
   {
      MenuItem := TrayMenu[%A_ThisMenuItemPos%]
   }
   Else
   {
      MenuID = 0
      StringSplit, MenuItem, A_ThisMenu, _
      MenuItem = %MenuItem1%
   }

   ; Menupunkt de/aktivieren
   if Enable_%MenuItem% = 1
   {
      Menu, %A_ThisMenu%, UnCheck, %A_ThisMenuItem%
      If A_ThisMenu <> Tray
         Menu, Tray, UnCheck, % TrayMenuName[%A_ThisMenu%]

      Enable_%MenuItem% = 0

      If Hotkey_%actFunct% <>
      {
         func_HotkeyDisable(actFunct)
      }

      Gosub, DoDisable_%MenuItem%
   }
   Else
   {
      Menu, %A_ThisMenu%, Check, %A_ThisMenuItem%
      If A_ThisMenu <> Tray
         Menu, Tray, Check, % TrayMenuName[%A_ThisMenu%]

      Enable_%MenuItem% = 1

      If Hotkey_%actFunct% <>
      {
         func_HotkeyEnable(actFunct)
      }

      Gosub, DoEnable_%MenuItem%
   }

   ; Einstellung speichern
   actEnable = Enable_%MenuItem%

   IniWrite, % %actEnable% , %ConfigFile%, %ScriptName%, %actEnable%

   If (Reload = 1 OR DoReload = 1)
      Reload
Return

; ProblemSolver versucht 'festhngende' Tasten und Maustasten zu lsen
sub_ProblemSolver:
   Gosub, sub_RestoreKeyStates  ; Korrigiert die Modifier-Tasten
   If (HiddenWindows <> "" OR TempDeskWindows <> "")
   {
      Gosub, cd_sub_RestoreTempDeskWindows
      Gosub, cd_sub_RestoreHiddenWindows
      ProbSolvMessage = %ProbSolvMessage%%lng_ProbSolvHidden%
      ProbSolv=
      IniDelete,%ConfigFile%,TemporaryDesktop
      IniDelete,%ConfigFile%,HiddenWindows
   }

   If ProbSolvMessage =
      BalloonTip(ScriptTitle, ProbSolvStartMessage lng_ProbSolvNoRes,"Info",0,0,8)
   Else
      BalloonTip(ScriptTitle, ProbSolvStartMessage lng_ProbSolvResult "`n`n" ProbSolvMessage, "Info",0,0,8)
   ProbSolvStartMessage =
Return

sub_HideAllExtensions:
   Critical
   MsgBox,36,%ScriptTitle%,%lng_ExtDeinstAsk%
   IfMsgBox, yes
   {
      FileMove, %ConfigFile%, %SettingsDir%\ac'tivAid_ProblemSolver.ini
      gosub, sub_ExtensionsOff
   }
Return

sub_MenuReload:
   Critical
   Reload
return

; Alle Funktionen deaktivieren
sub_MenuSuspend:
   Suspend, Toggle
   Loop
   {
      If Extension[%A_Index%] =
         break
      Function := Extension[%A_Index%]
      If ( IsLabel("OnSuspend_" Function) )
         Gosub, OnSuspend_%Function%

      If A_IsSuspended = 1
         Gosub, DoDisable_%Function%
      Else If Enable_%Function% = 1
         Gosub, DoEnable_%Function%
   }
   If MainGUiVisible =
      Gosub, sub_ChangeIcon
Return

sub_ChangeIcon:
   If LoadingFinished <> 1
      Return
   If A_IsSuspended <> 1
   {
      If NoTrayIcon <> 1
         If A_IconFile = %ScriptOffIcon%
            Menu, Tray, Icon, %ScriptOnIcon%, %ScriptOnIcon#%, 1
      Menu, Tray, UnCheck, % lng_deactivate "`t" func_HotkeyDecompose( Hotkey_DisableEnable, 1 )
      Loop, % TrayMenu - TrayMenuFirstExtension
      {
         Index := A_Index + TrayMenuFirstExtension
         If TrayMenuName[%Index%] =
            continue
         Menu, Tray, Enable, % TrayMenuName[%Index%]
      }
   }
   Else
   {
      If NoTrayIcon <> 1
         If A_IconFile = %ScriptOnIcon%
            Menu, Tray, Icon, %ScriptOffIcon%, %ScriptOffIcon#%, 1
      Menu, Tray, Check, % lng_deactivate "`t" func_HotkeyDecompose( Hotkey_DisableEnable, 1 )
      Loop, % TrayMenu - TrayMenuFirstExtension
      {
         Index := A_Index + TrayMenuFirstExtension
         If TrayMenuName[%Index%] =
            continue
         Menu, Tray, Disable, % TrayMenuName[%Index%]
      }
   }
Return

sub_temporarySuspend:
   If temporarySuspended = 1
   {
      If IsSuspended <> 1
      {
         Suspend, Off
         If NoTrayIcon <> 1
            Menu, Tray, Icon, %ScriptOnIcon%, %ScriptOnIcon#%, 1
      }
      temporarySuspended =
   }
   Else
   {
      IsSuspended = %A_IsSuspended%
      If IsSuspended <> 1
      {
         Suspend, On
         If NoTrayIcon <> 1
            Menu, Tray, Icon, %ScriptOffIcon%, %ScriptOffIcon#%, 1
      }
      temporarySuspended = 1
   }
Return

; Konfigurations-Dialog anzeigen
sub_MainGUI:
   If MainGuiVisible <>
   {
      DetectHiddenWindows, On
      IfWinNotActive, %ScriptTitle%
         WinActivate, %ScriptTitle%
      Return
   }

   Hotkey_AllNewHotkeys = %Hotkey_AllHotkeys%

   If ( FileExist( ReadMeFile ) contains "A" )
      Gosub, sub_GetReadme
   If ( FileExist( A_ScriptDir "\" ScriptNameFull " ChangeLog.txt") contains "A" )
      Gosub, sub_GetChangeLog

   If (updScriptVersion <> "ERROR" AND updScriptVersion <> "")
   {
      If (updScriptExtension <> "ERROR" AND updScriptExtension <> "")
         Changelog = =============================================================================`n  %lng_UpdateSuccess%`n`n  %lng_UpdateNewExtension%`n  %updScriptExtension%`n=============================================================================`n`n%Changelog%
      Else
         Changelog = =============================================================================`n  %lng_UpdateSuccess%`n=============================================================================`n`n%Changelog%
   }
   If DontShowMainGUI =
      Menu, Tray, ToggleEnable, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )

   Reload = 0
   IniWrite, 1, %ConfigFile%, %ScriptName%, ShowGUI

   MaxProgress := NumFunctions*2+4
   Progress,B2 H30 R0-%MaxProgress%
   GuiProgress=0
   Gosub, GuiProgress

   MainGuiVisible = 1

   IniRead, AutoUpdate, %ConfigFile%, %ScriptName%, AutoUpdate

   Gui, +Disabled
   If DontShowMainGUI =
   {
      Loop, % TrayMenu - TrayMenuFirstExtension
      {
         Index := A_Index + TrayMenuFirstExtension
         If TrayMenuName[%Index%] =
            continue
         Menu, Tray, Disable, % TrayMenuName[%Index%]
      }
      Gui, Show, W706 H450, %ScriptTitle%
   }

   Gui, Add, Picture,H32 W32 Icon%ScriptIcon#%, %ScriptIcon%
   Gui, Font, S%FontSize25% bold italic,Arial
   Gui, Font, S%FontSize25% bold italic,Verdana
   Gui, Add, Text, x+10 yp-2 , ac'tivAid%A_Space%
   Gui, Font, S%FontSize% norm italic
   Gui, Add, Text, x+70 yp+5 , v%ScriptVersion% von Wolfgang Reszel fr c't`n 2006 Heise Zeitschriften Verlag GmbH && Co. KG
   Gosub, GuiDefaultFont
   Gui, Add, Edit, h17 Disabled w520 x1 y432, %A_WorkingDir%
   Gui, Add, Edit, h17 Disabled w182 Center x523 y432, % lng_UserMode%A_IsAdmin%%UsingUserDir%
   Gui, Font, S%FontSize7% norm
   Gosub, sub_temporarySuspend
   If Extension[3] <>
      IfExist extensions
         Exts = 1

   GuiTabs[%lng_Readme%]=1
   GuiTabs[1]=%lng_Readme%
   GuiTabs[%lng_Changelog%]=2
   GuiTabs[2]=%lng_Changelog%
   GuiTabs[%lng_Settings%]=4
   GuiTabs[4]=%lng_Settings%

   If A_IsCompiled = 1
   {
      OptionsListBox = %lng_Readme%||%lng_Changelog%||%lng_Settings%|
      GuiTabs = 6
   }
   Else
   {
      OptionsListBox = %lng_Readme%||%lng_Changelog%||%lng_Settings%|%lng_Extensions%|
      GuiTabs[%lng_Extensions%]=5
      GuiTabs[5]=%lng_Extensions%
      GuiTabs = 7
   }

   Loop, 2
   {
      Gosub, GuiProgress
      OptionsListBox := OptionsListBox "|" Extension[%A_Index%]
      Function := Extension[%A_Index%]
      GuiTabs[%Function%] = %GuiTabs%
      GuiTabs[%GuiTabs%] = %Function%
      GuiTabs++
   }
   If Exts = 1
   {
      OptionsListBox = %OptionsListBox%|
      GuiTabs++
   }

   If A_OSversion = WIN_NT4
      StringReplace, OptionsListBox, OptionsListBox, , --, All

   Loop
   {
      Gosub, GuiProgress

      Index := A_Index + 2
      If Extension[%Index%] =
         break
      If ExtensionHideSettings[%Index%] = 1
         continue
      OptionsListBox := OptionsListBox "|" Extension[%Index%]
      Function := Extension[%Index%]
      GuiTabs[%Function%] = %GuiTabs%
      GuiTabs[%GuiTabs%] = %Function%
      GuiTabs++
   }

   GuiControl, -Redraw, OptionsListBox
   Gui, Add, ListBox, Section AltSubmit X8 Y50 H338 W120 vOptionsListBox gsub_OptionsListBox, %OptionsListBox%
   GuiControl, +Redraw, OptionsListBox

   Gui, Add, GroupBox, Section XS+125 YS+26 H287 W570

   Gui, Add, Tab,vDlgTabs Y0 X-1000, %OptionsListBox%

   If DontShowMainGUI =
      Gui, Show, W706 H450, %ScriptTitle%

   GuiControl,Choose, OptionsListBox, %ListBox_selected%
   Gosub, sub_OptionsListBox

   Gui, Tab, % GuiTabs[%lng_Readme%]
   Gui, Add, Text, XS YS-23 gsub_DevCopyIndex, %lng_Chapter%
   Gui, Add, DropDownList, X+5 YP-4 W400 AltSubmit vReadmeChapter gsub_Chapter, %ReadmeDropDown%
   Gui, Font, S%FontSize%, Courier New
   Gui, Font, S%FontSize%, Lucida Console

   Gui, Add, Edit, XS Y+5 Readonly T100 H300 W570 vReadme gsub_CheckIfSettingsChanged, ...
   GuiControl,,Readme, %Readme%%Readme_Hotkeys%
   Gui, Tab, % GuiTabs[%lng_Changelog%]
   Gui, Add, Edit, XS YS-26 Readonly T100 H330 W570 vChangelog gsub_CheckIfSettingsChanged
   GuiControl,,Changelog, %Changelog%

   Gosub, GuiDefaultFont

   Gui, Tab, % GuiTabs[%lng_Settings%]
   Gui, Add, Text, -Wrap XS+3 YS-17, %lng_SelectLanguage%:
   Gui, Add, DropDownList, -Wrap X+10 YP-3 w300 vselectedLanguage gsub_CheckIfSettingsChanged AltSubmit, %Languages%
   GuiControl, Choose, selectedLanguage, %actLanguage%

   Gui, Add, Button, -Wrap XS+10 YS+20 W150 gsub_getUpdates, &%lng_Update%
   If Betatester = 1
      Gui, Add, CheckBox, X+11 YP+6 vAutoUpdate w250 gsub_CheckIfSettingsChanged -Wrap Checked%AutoUpdate%, &%lng_AutoCheckUpdtBeta%
   Else
      Gui, Add, CheckBox, X+11 YP+6 vAutoUpdate w250 gsub_CheckIfSettingsChanged -Wrap Checked%AutoUpdate%, &%lng_AutoCheckUpdt%
   Gui, Add, Button, -Wrap %DisabledIfNotAdmin% XS+430 YP-6 W130 gsub_getManualUpdates, &%lng_ManualUpdate%
   If A_IsCompiled <> 1
      Gui, Add, CheckBox, XS+10 Y+5 vBetatester gsub_BetaMode Checked%Betatester%, %lng_Betatester%

   IfExist %A_Startup%\%ScriptNameFull%.lnk
      AutoStart = 1
   Else
      AutoStart = 0
   Gui, Add, CheckBox, XS+10 Y+25 vAutoStart gsub_CheckIfSettingsChanged -Wrap Checked%AutoStart%, %lng_autostart%
   Gui, Add, CheckBox, XS+10 Y+5 vDebug gsub_CheckIfSettingsChanged -Wrap Checked%Debug%, %lng_Debugmenu%
   If A_IsCompiled <> 1
   {
      Gui, Add, CheckBox, XS+10 Y+5 vDevel gsub_CheckIfSettingsChanged -Wrap Checked%Devel%, %lng_DevelMode%
   }

   Function = ac'tivAid

   func_HotkeyAddGuiControl( lng_MainGUI, "MainGUI", "xs+10 y+15 W190")
   func_HotkeyAddGuiControl( lng_ProblemSolver, "ProblemSolver", "xs+10 y+5 W190")
   func_HotkeyAddGuiControl( lng_deactivate, "DisableEnable", "xs+10 y+5 W190")
   func_HotkeyAddGuiControl( lng_ShowHotkeyList, "ShowHotkeyList", "xs+10 y+5 W190")

   Gui, Add, CheckBox, XS+10 YS+255 vNoTrayIcon gsub_CheckIfSettingsChanged Checked%NoTrayIcon%, %lng_NoTrayIcon%

   If A_IsCompiled <> 1
   {
      Gui, Tab, % GuiTabs[%lng_Extensions%]
      IfNotExist, extensions\_main_off.ahk
      {
         Gui, Add, Button, -Wrap %DisabledIfNotAdmin% XS+10 YS-21 gsub_ExtensionsOff, %A_Space%%A_Space%%lng_ExtOff%%A_Space%%A_Space%
         Gosub, sub_ExtensionManager
      }
      Else IfExist, extensions\_main_off.ahk
      {
         Gui, Add, Button, -Wrap %DisabledIfNotAdmin% XS+10 YS-21 gsub_ExtensionsOn, %A_Space%%A_Space%%lng_ExtOn%%A_Space%%A_Space%
      }
   }

   Loop
   {
      Gosub, GuiProgress
      Progress, %GuiProgress%
      Function := Extension[%A_Index%]
      If Function =
         Break
      If ExtensionHideSettings[%A_Index%] <> 1
      {
         Gui, Tab, % GuiTabs[%Function%]

         If (DisableIfCompiled_%Function% = 1 AND A_IsCompiled = 1)
            DisableIfCompiled = Disabled
         Else
            DisableIfCompiled =
         Enabled := Enable_%Function%
         EnableTray := EnableTray_%Function%
         Gui, Add, GroupBox, XS+0 YS-32 H37 W570
         Gui, Add, Button, -Wrap XS+550 YS-24 h27 w18 vCH_%Function% gsub_ContextHelp, ?
         If Enabled = 1
         {
            If OnlyForConfigDialog_%Function% <> 1
            {
               Gui, Add, Text, XS+30 YP+0 W515 R2 vInfo_%Function%, % Function " " ExtensionVersion[%Function%] " - " ExtensionDescription[%Function%]
               Gui, Add, Checkbox, XS+5 YS-22 +E0x1 +0x8000 W20 H21 -Wrap vEnable_%Function% Checked%Enabled% gsub_ExtEnableDisable %DisableIfCompiled%, %lng_activated%
            }
            Else
               Gui, Add, Text, XS+10 YP+0 W515 R2 vInfo_%Function%, % Function " " ExtensionVersion[%Function%] " - " ExtensionDescription[%Function%]
         }
         Else
         {
            If OnlyForConfigDialog_%Function% <> 1
            {
               Gui, Add, Text, XS+30 YP+0  W515 R2 Disabled vInfo_%Function%, % Function " " ExtensionVersion[%Function%] " - " ExtensionDescription[%Function%]
               Gui, Add, Checkbox, XS+5 YS-22 +E0x1 +0x8000 W20 H21 -Wrap vEnable_%Function% Checked%Enabled% gsub_ExtEnableDisable %DisableIfCompiled%, %lng_deactivated%
            }
            Else
               Gui, Add, Text, XS+10 YP+0  W515 R2 Disabled vInfo_%Function%, % Function " " ExtensionVersion[%Function%] " - " ExtensionDescription[%Function%]
         }
         tooltip_Enable_%Function% = %lng_EnableDisable%
         Gosub, GuiDefaultFont

         If OnlyForConfigDialog_%Function% <> 1
            Gui, Add, Checkbox, XS+10 YS+290 vEnableTray_%Function%_tmp gsub_CheckIfSettingsChanged -Wrap Checked%EnableTray% %DisableIfCompiled%, %lng_ShowInTrayMenu%
         Gui, Add, Picture, YS+1 h10
      }
      If CustomHotkey_%Function% = 1
      {
         func_HotkeyAddGuiControl( lng_Hotkey, Function, "y+3 xs+10" )
      }

      If IsLabel( "init_" Function )
         Gosub, SettingsGui_%Function%

      Gosub, GuiDefaultFont
   }

   Gui, Tab
   Gosub, GuiDefaultFont
   Gui, Add, Button, -Wrap X260 YS+320 W80 vMainGuiOK Default gsub_SettingsOK, &%lng_OK%
   Gui, Add, Button, -Wrap X+5 W80 vMainGuiCancel gGuiClose, &%lng_cancel%
   Gui, Add, Button, -Wrap X+20 Disabled W80 vMainGuiApply gsub_SettingsOK, &%lng_Apply%
   Gui, Font,S%FontSize12%, Marlett
   Gui, Add, Button, -Wrap X8 YP+0 W20 H20 gsub_SettingsMenu, %lng_SettingsMenu%
   Gosub, GuiDefaultFont
   Gui, -Disabled

   Progress, Off

   Gosub, sub_temporarySuspend

   GuiControl,1:Focus, OptionsListBox

   If (updScriptVersion <> "ERROR" AND updScriptVersion <> "" AND Listbox_selected = 2)
   {
      GuiControl, Focus, ChangeLog
      Send, ^{Home}{Down}+{Down}
      updScriptVersion =
   }

   MainGuiVisible = 2

   If DontShowMainGUI = 1
   {
       DontShowMainGUI =
       MainGuiVisible =
       Gui, Cancel
   }
   Else
   {
      func_AddMessage(0x200, "GuiTooltip")
      func_AddMessage(0x6, "RemoveGuiTooltip")
   }
Return

sub_BetaMode:
   Gosub, sub_CheckIfSettingsChanged
   GuiControlGet, BetatesterTmp,,Betatester
   If BetatesterTmp = 1
      GuiControl,,AutoUpdate,%lng_AutoCheckUpdtBeta%
   Else
      GuiControl,,AutoUpdate,%lng_AutoCheckUpdt%
Return

GuiTooltip:
   func_ShowGuiToolTip(A_GuiControl)
Return

RemoveGuiTooltip:
   SetTimer, tim_ShowGuiToolTip, Off
   tooltip, ,,,9
   lastTooltip =
Return

func_ShowGuiToolTip(Control)
{
   global lastTooltip, thisTooltip

   control := func_StrTranslate(Control, "-+ !&()'<>:,./\", "________________")
   MouseGetPos,tt_x,tt_y,, tt_ThisControl
   If (!Control )
   {
      tooltip,,,,9
      lastTooltip =
      SetTimer, tim_ShowGuiToolTip, Off
   }
   Else If (Control And tt_ThisControl)
   {
      thisTooltip := tooltip_%Control%
      If thisTooltip <> %lastTooltip%
         SetTimer, tim_ShowGuiToolTip, 600
      Else
         SetTimer, tim_ShowGuiToolTip, Off
   }
}

tim_ShowGuiToolTip:
   SetTimer, tim_ShowGuiToolTip, Off
   tooltip, %thisTooltip% ,,,9
   lastTooltip := thisTooltip
Return


sub_CheckIfSettingsChanged:
   If (A_GuiControl = "" OR StrLen(A_GuiControl) < 3 OR MainGuiVisible <> 2 OR SkipChecking = 1)
      return

   Control := func_StrTranslate(A_GuiControl, "-+ !&()'<>:,./\", "________________")

   GuiControlGet, activeTab,,DlgTabs
   GuiControlGet, activeControlValue,,%A_GuiControl%
   StringReplace, ChangedSettings[%activeTab%], ChangedSettings[%activeTab%], %A_GuiControl%|,,A
   If Control <> A_GuiControl
   {
      ChangedSettings[%activeTab%] := ChangedSettings[%activeTab%] A_GuiControl "|"
   }
   Else If %A_GuiControl% <> %activeControlValue%
   {
      ChangedSettings[%activeTab%] := ChangedSettings[%activeTab%] A_GuiControl "|"
   }


   Gosub, sub_EnableDisable_ApplyButton
Return

func_SettingsChanged( Extension )
{
   Global
   ChangedSettings[%Extension%] := ChangedSettings[%Extension%] Extension "|"
   Gosub, sub_EnableDisable_ApplyButton
}

sub_EnableDisable_ApplyButton:
   SettingsChanged = 0
   If ChangedSettings[activAid] <>
      SettingsChanged++
   Loop
   {
      tmpFunct := Extension[%A_Index%]
      If tmpFunct =
         break
      If ChangedSettings[%tmpFunct%] <>
      {
         SettingsChanged++
         Break
      }
   }

   If SettingsChanged > 0
      GuiControl, 1:Enable, MainGuiApply
   Else
      GuiControl, 1:Disable, MainGuiApply
Return

sub_Chapter:
   GuiControlGet, ReadmeChapter
   GuiControl, Focus, Readme
   Gui, 1:+LastFound
   SendMessage, 0xB1, % ReadmeGotoLine[%ReadmeChapter%], % ReadmeGotoLine[%ReadmeChapter%], Edit3 ; EM_SETSEL
   SendMessage, 0xB7, , , Edit3 ; EM_SCROLLCARET
   SetKeyDelay,0
   ControlSend, Edit3, {Up 2}{Down 26}{Up 24}+{End}
Return

sub_DevCopyIndex:
   If (A_GuiControlEvent = "DoubleClick" AND Debug = 1)
   {
      StringReplace, Clipboard, ReadmeDropDown, |, `r`n, A
   }
   tooltip, %A_GuiControlEvent%
Return


sub_ExtEnableDisable:
   StringReplace, Function, A_GuiControl, Enable_
   GuiControlGet, Enable_%Function%_tmp,,%A_GuiControl%
   If Enable_%Function%_tmp = 1
   {
      GuiControl,Enable, Info_%Function%
   }
   Else
   {
      ;Gui, Font, C666666 normal
      GuiControl,Disable, Info_%Function%
   }
   gosub, sub_CheckIfSettingsChanged
Return

sub_OptionsListBox:
   Critical
   GuiControlGet, ListBox_selected, , OptionsListBox

   If GuiTabs[%ListBox_selected%] =
      Return

   SetTimer,tim_StoreSelection, 20

   GuiControl, Choose, DlgTabs, %ListBox_selected%
Return

tim_StoreSelection:
   SetTimer, tim_StoreSelection, Off
   IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected
Return

GuiProgress:
   GuiProgress++
   Progress, %GuiProgress%
Return

GuiEscape:
GuiClose:
   If MainGUiVisible = 1
      Return
   MainGuiVisible =
   Hotkey_AllNewHotkeys =
   IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected

   Gui, Destroy
   Loop
   {
      Function := Extension[%A_Index%]
      If Function =
         Break

      If Enable_%Function% =1
         Gosub, DoEnable_%Function%

      ChangedSettings[%Function%] =

      If IsLabel( "init_" Function )
         Gosub, CancelSettings_%Function%
   }
   Menu, Tray, ToggleEnable, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )

   IniDelete, %ConfigFile%, %ScriptName%, ShowGUI

   Gosub, sub_ChangeIcon
   func_RemoveMessage(0x200, "GuiTooltip")
   func_RemoveMessage(0x6, "RemoveGuiTooltip")
Return

sub_SettingsOK:
   Critical
   Gosub, sub_temporarySuspend
   FileCopy, %ConfigFile%, %ConfigFile%.bak, 1

   DontReload = 1
   Loop
   {
      Function := Extension[%A_Index%]
      If Function =
         Break
      If ChangedSettings[%Function%] =
         continue
      Gosub, DoDisable_%Function%
   }
   DontReload = 0

   Hotkey_ProblemSolver_old2 = %Hotkey_ProblemSolver%
   Hotkey_MainGUI_old2 = %Hotkey_MainGUI%
   Hotkey_DisableEnable_old2 = %Hotkey_DisableEnable%
   Hotkey_ShowHotkeyList_old2 = %Hotkey_ShowHotkeyList%

   Hotkey_ProblemSolver_old = %Hotkey_ProblemSolver%
   Hotkey_MainGUI_old = %Hotkey_MainGUI%
   Hotkey_DisableEnable_old = %Hotkey_DisableEnable%
   Hotkey_ShowHotkeyList_old = %Hotkey_ShowHotkeyList%

   DebugLast = %Debug%
   DevelLast = %Devel%

   Gui, Submit, NoHide

   IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected

   Gui, +Disabled

   ChangedSettings = 0

   If ChangedSettings[activAid] <>
   {
      SplashImage,,b1 FS9 W400, %lng_WritingSettings%
      IniWrite, %Debug%, %ConfigFile%, %ScriptName%, Debug
      IniWrite, %Devel%, %ConfigFile%, %ScriptName%, Devel
      IniWrite, %AutoUpdate%, %ConfigFile%, %ScriptName%, AutoUpdate
      IniWrite, %NoTrayIcon%, %ConfigFile%, %ScriptName%, NoTrayIcon
      IniWrite, %Betatester%, %ConfigFile%, %ScriptName%, Betatester

      If (selectedLanguage <> 4 AND actLanguage <> selectedLanguage)
      {
         IniDelete, %ConfigFile%, %ScriptName%, Language
         If selectedLanguage < 4
            FileDelete, language.ini
         If selectedLanguage = 2
            IniWrite, 07, %ConfigFile%, %ScriptName%, Language
         If selectedLanguage = 3
            IniWrite, 09, %ConfigFile%, %ScriptName%, Language
         If selectedLanguage > 4
            FileCopy, % LanguagesFile[%selectedLanguage%], language.ini, 1

         Reload = 1
      }

      If (Devel <> DevelLast OR Debug <> DebugLast OR A_IconHidden <> NoTrayIcon OR Betatester <> BetatesterLast)
         Reload = 1

      func_HotkeyWrite( "ProblemSolver", ConfigFile, ScriptName, "Hotkey_ProblemSolver" )
      If Hotkey_ProblemSolver_old2 <> %Hotkey_ProblemSolver_old%
         Menu, Tray, Rename, % lng_ProblemSolver "`t" func_HotkeyDecompose( Hotkey_ProblemSolver_old2, 1 ),  % lng_ProblemSolver "`t" func_HotkeyDecompose( Hotkey_ProblemSolver, 1 )
      func_HotkeyWrite( "MainGUI", ConfigFile, ScriptName, "Hotkey_MainGUI" )
      If Hotkey_MainGUI_old2 <> %Hotkey_MainGUI_old%
         Menu, Tray, Rename, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI_old2, 1 ), % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )
      func_HotkeyWrite( "DisableEnable", ConfigFile, ScriptName, "Hotkey_DisableEnable" )
      If Hotkey_DisableEnable_old2 <> %Hotkey_DisableEnable_old%
         Menu, Tray, Rename, % lng_deactivate "`t" func_HotkeyDecompose( Hotkey_DisableEnable_old2, 1 ), % lng_deactivate "`t" func_HotkeyDecompose( Hotkey_DisableEnable, 1 )
      func_HotkeyWrite( "ShowHotkeyList", ConfigFile, ScriptName, "Hotkey_ShowHotkeyList" )

      ChangedSettings[activAid] =
      ChangedSettings++
   }
   Gosub, sub_MenuAutostart

   EnableTray =
   Loop
   {
      Function := Extension[%A_Index%]
      If Function =
         Break

      EnableTray := EnableTray EnableTray_%Function%_tmp
   }

   If EnableTray <> %EnableTrayAll%
      Reload = 1

   Loop
   {
      Function := Extension[%A_Index%]
      If Function =
         Break

      If ((ChangedSettings[%Function%] = "" AND ExtensionHideSettings[%A_Index%] <> 1) OR Function = "")
         continue

      ChangedSettings[%Function%] =
      ChangedSettings++
      If ChangedSettings = 1
         SplashImage,,b1 FS9 W400, %lng_WritingSettings%

      SplashImage,,, %lng_WritingSettings%: %Function%

      IniWrite, % Enable_%Function%, %ConfigFile%, %ScriptName%, Enable_%Function%
      IniWrite, % EnableTray_%Function%_tmp, %ConfigFile%, %ScriptName%, EnableTray_%Function%

      If CustomHotkey_%Function% = 1
      {
         func_HotkeyDisable(Function)
         func_HotkeyWrite( Function, ConfigFile, Function, "Hotkey_" Function )
      }

      If ExtensionMenuName[%A_Index%] =
         continue

      If (IsLabel( "SaveSettings_" Function ))
         Gosub, SaveSettings_%Function%

      If Enable_%Function% = 1
      {
         If CustomHotkey_%Function% =1
         {
            func_HotkeyEnable( Function )
         }
         Gosub, DoEnable_%Function%
         If ((EnableTray_%Function% = 1 OR (EnableTray_%Function% = 1 AND EnableTray = EnableTrayAll)) AND Reload <> 1 AND ExtensionHideSettings[%A_Index%] <> 1)
            Menu, Tray, Check, % ExtensionMenuName[%A_Index%]
      }
      Else
      {
         If CustomHotkey_%Function% =1
         {
            func_HotkeyDisable( Function )
         }
         If (IsLabel( DoDisable_%Function% ) )
            Gosub, DoDisable_%Function%
         If ((EnableTray_%Function% = 1 OR (EnableTray_%Function% = 1 AND EnableTray = EnableTrayAll)) AND Reload <> 1 AND ExtensionHideSettings[%A_Index%] <> 1)
            Menu, Tray, UnCheck, % ExtensionMenuName[%A_Index%]
      }

      If CustomHotkey_%Function% = 1
      {
         MenuName := ExtensionCleanMenuName[%A_Index%] "`t" func_HotkeyDecompose( Hotkey_%Function%, 1 )
         If (ExtensionMenuName[%A_Index%] <> MenuName AND Reload <> 1 AND ExtensionHideSettings[%A_Index%] <> 1 AND EnableTray_%Function% = 1)
         {
            Menu, Tray, Rename, % ExtensionMenuName[%A_Index%], %MenuName%
            ExtensionMenuName[%A_Index%] = %MenuName%
            Index := TrayMenu[%Function%]
            TrayMenuName[%Index%] = %MenuName%
         }
      }

      If (CustomHotkey_%Function% <> 1 AND CustomHotkey_%Function% <> "")
      {
         CustomHotkeyVar := "Hotkey_" CustomHotkey_%Function%
         MenuName := ExtensionCleanMenuName[%A_Index%] "`t" func_HotkeyDecompose( %CustomHotkeyVar%, 1 )
         If (ExtensionMenuName[%A_Index%] <> MenuName AND Reload <> 1 AND ExtensionHideSettings[%A_Index%] <> 1 AND EnableTray_%Function% = 1)
         {
            Menu, Tray, Rename, % ExtensionMenuName[%A_Index%], %MenuName%
            ExtensionMenuName[%A_Index%] = %MenuName%
            Index := TrayMenu[%Function%]
            TrayMenuName[%Index%] = %MenuName%
         }
      }
   }

   Gosub, sub_ExtInstall

   SplashImage, Off

   If ChangedSettings > 0
   {
      func_HotkeyEnable("MainGUI")
      func_HotkeyEnable("DisableEnable")
      func_HotkeyEnable("ProblemSolver")
      func_HotkeyEnable("ShowHotkeyList")

      GuiControl, Disable, MainGuiApply

      If A_GuiControl <> MainGuiApply
         IniDelete, %ConfigFile%, %ScriptName%, ShowGUI

      gosub, sub_BeautifyINI

      If Reload = 1
         Reload
   }

   Gosub, sub_temporarySuspend
   Gosub, sub_ChangeIcon

   If A_GuiControl = MainGUIapply
   {
      Gui, -Disabled
   }
   Else
   {
      MainGuiVisible =
      Menu, Tray, ToggleEnable, % lng_Info "`t" func_HotkeyDecompose( Hotkey_MainGUI, 1 )
      func_RemoveMessage(0x200, "GuiTooltip")
      func_RemoveMessage(0x6, "RemoveGuiTooltip")
   }
   Readme_Hotkeys =
   If A_GuiControl <> MainGUIapply
      Gui, Destroy
   Hotkey_AllNewHotkeys = %Hotkey_AllHotkeys%
Return

sub_MenuExit:
   ExitApp
Return

; INI-Datei verschnern
sub_BeautifyINI:
   func_BeautifyIniFile( ConfigFile )
Return

sub_SettingsMenu:
   Menu, SettingsMenu, Add, %lng_SaveAllSettings%, sub_SaveAllSettings
   Menu, SettingsMenu, Add, %lng_LoadAllSettings%, sub_LoadAllSettings

   actFunct := GuiTabs[%ListBox_selected%]
   If (Enable_%actFunct% <> "")
   {
      Menu, SettingsMenu, Add
      Menu, SettingsMenu, Add, %actFunct% %lng_DefaultSettings%, sub_DefaultSettings
      Menu, SettingsMenu, Add
      Menu, SettingsMenu, Add, %actFunct%-%lng_ExportSettings%, sub_ExportSettings
      Menu, SettingsMenu, Add, %actFunct%-%lng_ImportSettings%, sub_ImportSettings
      If AddSettings_%actFunct% = 1
      {
         Menu, SettingsMenu, Add
         Menu, SettingsMenu, Add, %actFunct% %lng_AddSettings%, sub_AddSettings
      }
   }
   Menu, SettingsMenu, Add
   Menu, SettingsMenu, Add, %lng_ShowHotkeyList%, sub_ShowHotkeyList
   If (UsingUserDir = 1 AND MainDirNotWriteable <> 1)
   {
      Menu, SettingsMenu, Add
      Menu, SettingsMenu, Add, %lng_UserMode00%, sub_SingleUser
   }
   Else If (MainDirNotWriteable <> 1)
   {
      Menu, SettingsMenu, Add
      Menu, SettingsMenu, Add, %lng_UserMode01%, sub_MultiUser
   }
   If A_IsAdmin <> 1
   {
      Menu, SettingsMenu, Add
      Menu, SettingsMenu, Add, %lng_RunAsAdmin%, sub_RunAsAdmin
   }
   Else If ( tempAdminMode = 1 )
   {
      Menu, SettingsMenu, Add
      Menu, SettingsMenu, Add, %lng_LeaveAdmin%, sub_LeaveAdmin
   }

   CoordMode, Menu, Relative
   Menu, SettingsMenu, Show
   Menu, SettingsMenu, DeleteAll
Return

sub_RunAsAdmin:
   Gui, 1:+Disabled
   Gui, 5:+Owner1
   IniRead, AdminName, %ConfigFile%, %ScriptName%, AdminName, Administrator
   Gui, 5:Add, Text, , %lng_RunAsAdmin%`n`n%lng_AdminNAme%:
   Gui, 5:Add, Edit, w200 vAdminName, %AdminName%
   Gui, 5:Add, Text, , %lng_Password%:
   Gui, 5:Add, Edit, w200 vAdminPass Password, %AdminPass%
   Gui, 5:Add, Button, -Wrap x25 w80 Default gsub_RunAsAdminOk, %lng_Ok%
   Gui, 5:Add, Button, -Wrap x+5 w80 g5GuiClose, %lng_Cancel%
   Gui, 5:Show, w220, %ScriptTitle%
Return

sub_RunAsAdminOK:
   Gui, 1:-Disabled
   Gui, 5:Submit
   Gui, 5:Destroy
   Gui, 5:+OwnDialogs
   If AdminName <>
   {
      IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected
      IniWrite, %AdminName%, %ConfigFile%, %ScriptName%, AdminName
      IniWrite, 1, %ConfigFile%, %ScriptName%, tempAdminMode
      IniWrite, 1, %ConfigFile%, %ScriptName%, ShowGUI

      IniWrite, %ListBox_selected%, %A_ScriptDir%\%ConfigFile%, %ScriptName%, GUIselected
      IniWrite, %AdminName%, %A_ScriptDir%\%ConfigFile%, %ScriptName%, AdminName
      IniWrite, 1, %A_ScriptDir%\%ConfigFile%, %ScriptName%, tempAdminMode
      IniWrite, 1, %A_ScriptDir%\%ConfigFile%, %ScriptName%, ShowGUI

      RunAs, %AdminName%, %AdminPass%, @%USERDOMAIN%
      If UsingUserDir = 1
      {
         IniWrite, %A_WorkingDir%, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir
         Run, %A_AhkPath% "%A_ScriptFullPath%", %A_WorkingDir%, UseErrorLevel
      }
      Else
      {
         IniRead, WorkingDir, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir
         If WorkingDir <> ERROR
            IniWrite, %WorkingDir%, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir
         Else
            IniWrite, %APPDATA%\ac'tivAid, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir
         Run, %A_AhkPath% "%A_ScriptFullPath%" ,%A_ScriptDir%, UseErrorLevel
      }
      If ErrorLevel = ERROR
      {
         RunAs
         Msgbox, 16, %ScriptTitle% %lng_RunAsAdmin%, %lng_WrongAdmin%
         IniDelete, %ConfigFile%, %ScriptName%, tempAdminMode
      }
   }
Return

sub_LeaveAdmin:
   IniDelete, %ConfigFile%, %ScriptName%, tempAdminMode
   Run, %A_WorkingDir%
   ExitApp
Return

sub_MultiUser:
   UsingUserDir = 1
   Gosub, sub_MenuAutostart
   If tempAdminMode = 1
   {
      IniRead, WorkingDir, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir, %A_Space%
      IniDelete, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir
      IniWrite, %ListBox_selected%, %WorkingDir%\%ConfigFile%, %ScriptName%, GUIselected
      IniWrite, 1, %WorkingDir%\%ConfigFile%, %ScriptName%, ShowGUI
      IniWrite, 1, %WorkingDir%\%ConfigFile%, %ScriptName%, tempAdminMode
      Run, %A_AhkPath% "%A_ScriptFullPath%", %WorkingDir%
   }
   Else
   {
      IniWrite, %ListBox_selected%, %APPDATA%\ac'tivAid\%ConfigFile%, %ScriptName%, GUIselected
      IniWrite, 1, %APPDATA%\ac'tivAid\%ConfigFile%, %ScriptName%, ShowGUI
      IfNotExist, %APPDATA%\ac'tivAid
         FileCreateDir, %APPDATA%\ac'tivAid
      Run, %A_AhkPath% "%A_ScriptFullPath%", %APPDATA%\ac'tivAid
   }
Return

sub_SingleUser:
   UsingUserDir = 0
   Gosub, sub_MenuAutostart
   If tempAdminMode = 1
   {
      IniWrite, %A_WorkingDir%, %A_ScriptDir%\%ConfigFile%, %ScriptName%, WorkingDir
      IniWrite, 1, %A_ScriptDir%\%ConfigFile%, %ScriptName%, tempAdminMode
   }
   IniWrite, %ListBox_selected%, %A_ScriptDir%\%ConfigFile%, %ScriptName%, GUIselected
   IniWrite, 1, %A_ScriptDir%\%ConfigFile%, %ScriptName%, ShowGUI
   Run, %A_AhkPath% "%A_ScriptFullPath%" ,%A_ScriptDir%
   ExitApp
Return


sub_ShowHotkeyList:
   If ShowHotkeyListVisible = 1
   {
      ShowHotkeyListVisible = 0
      Gui, 4:Cancel
      Return
   }
   If Readme_Hotkeys =
   {
      DontShowMainGUI = 1
      Gosub, sub_MainGUI
   }
   If ReadmeContent =
   {
      StringTrimLeft, ReadmeContent, Readme_Hotkeys, 4
      Gui, 4:Color , FFFFFF, FFFFFF
      Gui, 4:+ToolWindow +AlwaysOnTop Resize +0xF2C0
      Gui, 4:Font
      Gui, 4:Font, S%FontSize%, Courier New
      Gui, 4:Font, S%FontSize%, Lucida Console
      Gui, 4:Add, Edit,Readonly Y0 X0 T100 H330 W580 vReadmeContent, %ReadmeContent%
      Gosub, 4GuiDefaultFont
      Gui, 4:Show, %ShowHotkeyListX% %ShowHotkeyListY% w580 %ShowHotkeyListH% , %ScriptTitle% - %lng_Hotkeys%
      Send,^{Home}
   }
   Gui, 4:Show
   ShowHotkeyListVisible = 1
Return

4GuiEscape:
4GuiClose:
   Gui, 4:Cancel
   ShowHotkeyListVisible = 0
Return

4GuiSize:
   Gui, 4:+LastFound
   WinMove,,,,,580
   GuiControl, 4:Move, ReadmeContent, w%A_GuiWidth% h%A_GuiHeight%
Return

sub_DefaultSettings:
   Critical
   Gui, 1:+OwnDialogs
   MsgBox, 36, %actFunct%, %lng_DefaultMsg%
   IfMsgBox, Yes
   {
      If actFunct <> %ScriptName%
      {
         Gosub, DefaultSettings_%actFunct%
         IfExist, % ConfigFile_%actFunct%
            FileDelete, % ConfigFile_%actFunct%
      }
      IniDelete, %ConfigFile%, %actFunct%
      IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected
      Reload
   }
Return

sub_SaveAllSettings:
   Gui +OwnDialogs
   Msgbox, 36, %ScriptTitle% ,%lng_SaveAllAsk%

   IfMsgBox, yes
   {
      Gui +OwnDialogs
      FileSelectFile, tempFile, S 16, %ScriptNameFull%_exported.ini, %lng_SaveAllSettings%, *.ini
      If ErrorLevel <> 0
         Return

      tempFound = 0
      FileCopy, %ConfigFile%, %tempFile%, 1
   }
Return

sub_LoadAllSettings:
   Critical
   Gui +OwnDialogs
   FileSelectFile, tempFile, 1, %A_ScriptDir%, %lng_LoadAllSettings%, *.ini
   If ErrorLevel <> 0
      Return

   FileRead, tempContent, %tempFile%
   IfNotInString, tempContent, [%ScriptName%]`r`n
   {
      Msgbox, 16, %ScriptTitle%, %lng_ImportImpossible%
      return
   }
   Msgbox, 36, %ScriptTitle%, %lng_LoadAllAsk%

   IfMsgBox, yes
   {
      FileCopy, %tempFile%, %ConfigFile%, 1
      IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected
      Reload
   }
Return

sub_ExportSettings:
   Gui +OwnDialogs
   Msgbox, 36, %actFunct% ,%lng_ExportAsk%

   IfMsgBox, yes
   {
      Gui +OwnDialogs
      FileSelectFile, tempFile, S 16, %actFunct%_exported.ini, %lng_ExportSettings%, *.ini
      If ErrorLevel <> 0
         Return

      tempFound = 0
      FileDelete, %tempFile%

      If ConfigFile_%actFunct% <>
      {
         FileAppend, `; [%actFunct%]`r`n, %tempFile%
         Loop, Read, % ConfigFile_%actFunct%, %tempFile%
         {
            FileAppend, %A_LoopReadLine%`r`n
         }
      }
      Else
      {
         Loop, Read, %ConfigFile%, %tempFile%
         {
            IfInString, A_LoopReadLine, [%actFunct%]
            {
               tempFound = 1
               FileAppend, %A_LoopReadLine%`r`n
               continue
            }

            If tempFound < 1
               continue

            If (func_StrLeft(A_LoopReadLine,1) = "[")
               break

            FileAppend, %A_LoopReadLine%`r`n
         }
      }
   }
Return

sub_ImportSettings:
   Critical
   Gui +OwnDialogs
   FileSelectFile, tempFile, 1, %A_ScriptDir%, %lng_ImportSettings%, *.ini
   If ErrorLevel <> 0
      Return

   FileReadLine, tempContent, %tempFile%, 1
   IfNotInString, tempContent, [%actFunct%]
   {
      Msgbox, 16, %actFunct%, %lng_ImportImpossible%
      return
   }
   If AddSettings_%actFunct% = 1
      Msgbox, 36, %actFunct%, %lng_ImportAsk%
   Else
      Msgbox, 36, %actFunct%, %lng_ImportAsk2%

   IfMsgBox, yes
   {
      If ConfigFile_%actFunct% <>
      {
         If AddSettings_%actFunct% = 1
         {
            AddFreshSettings = 1
            AddFile = %tempFile%
            Gosub, AddSettings_%actFunct%
         }
         Else
         {
            FileCopy, %tempFile%, % ConfigFile_%actFunct%, 1
         }
      }
      Else
      {
         If AddSettings_%actFunct% = 1
         {
            AddFreshSettings = 1
            AddFile = %tempFile%
            Gosub, AddSettings_%actFunct%
         }
         FileRead, tempContent, %tempFile%
         IniDelete, %ConfigFile%, %actFunct%
         FileAppend, %tempContent%, %ConfigFile%
         Gosub, sub_BeautifyINI
      }
      If AddSettings_%actFunct% <> 1
      {
         IniWrite, %ListBox_selected%, %ConfigFile%, %ScriptName%, GUIselected
         Reload
      }
      AddFreshSettings = 0
   }
Return

sub_AddSettings:
   Gui +OwnDialogs
   FileSelectFile, AddFile, 1, %A_ScriptDir%, %lng_AddSettings%, *.ini
   If ErrorLevel <> 0
      Return

   FileReadLine, tempContent, %AddFile%, 1
   IfNotInString, tempContent, [%actFunct%]
   {
      Msgbox, 16, %actFunct%, %lng_ImportImpossible%
      return
   }
   Msgbox, 36, %actFunct%, %lng_AddAsk%

   IfMsgBox, yes
   {
      Gosub, AddSettings_%actFunct%
   }
Return


sub_ExtensionManager:
   AvailableExtensions =
   InstalledExtensions =
   ExtensionsInExtDir =
   AutoTrim, On
   ExtensionsToParse=
   Loop, %A_ScriptDir%\extensions\*.ahk, 0, 0
   {
      ExtensionsToParse=%ExtensionsToParse%%A_LoopFileFullPath%`n
   }
   Loop, %A_ScriptDir%\beta_extensions\*.ahk, 0, 0
   {
      ExtensionsToParse=%ExtensionsToParse%%A_LoopFileFullPath%`n
   }

   Loop, Parse, ExtensionsToParse, `n
   {
      LoopFileName = %A_LoopField%
      IfInString, LoopFileName, extensions\_
         continue

      EMExtName =
      EMReqExtName =
      Loop, Read, %LoopFileName%
      {
         IfInString, A_LoopReadLine, Prefix ; And
         IfNotInString, A_LoopReadLine, `%
         {
            StringSplit, ext_temp, A_LoopReadLine, =

            StringReplace, Prefix, ext_temp2, %A_Space%,, A
         }
         IfInString, A_LoopReadLine, `%Prefix`%_ScriptName
         {
            StringSplit, ext_temp, A_LoopReadLine, =

            StringReplace, EMExtName, ext_temp2, %A_Space%,, A
            ExtensionsInExtDir = %ExtensionsInExtDir%%EMExtName%`,

            If Extension[%EMExtName%] <> 1
               AvailableExtensions = %AvailableExtensions%%EMExtName%|
            Else
               InstalledExtensions = %InstalledExtensions%%EMExtName%|

            ExtensionPrefix[%EMExtName%] = %Prefix%
         }
         IfInString, A_LoopReadLine, `%Prefix`%_ScriptVersion
         {
            StringSplit, ext_temp, A_LoopReadLine, =

            ExtensionVersion[%EMExtName%] = %ext_temp2%
         }
         IfInString, A_LoopReadLine, `%Prefix`%_Author
         {
            StringSplit, ext_temp, A_LoopReadLine, =

            %Prefix%_Author = %ext_temp2%
         }
         IfInString, A_LoopReadLine, RequireExtensions
         {
            StringSplit, ext_temp, A_LoopReadLine, =

            StringReplace, EMReqExtName, ext_temp2, %A_Space%,, A

            FunctionRequireExt[%EMExtName%] = %EMReqExtName%

            Loop, Parse, EMReqExtName, `,
            {
               If FunctionRequiredFromExt[%A_LoopField%] =
                  FunctionRequiredFromExt[%A_LoopField%] = %EmExtName%
               Else
                  IfNotInstring, FunctionRequiredFromExt[%A_LoopField%], %EmExtName%
                     FunctionRequiredFromExt[%A_LoopField%] := FunctionRequiredFromExt[%A_LoopField%] "," EmExtName
            }
         }
         IfInString, A_LoopReadLine, FileInstall
         {
            IfNotInstring, A_LoopReadLine, .exe
               continue
            StringSplit, ext_temp, A_LoopReadLine, `,
            ExtensionExtraCompile[%EMExtName%] = %ext_temp2%
         }
         IfInString, A_LoopReadLine, SettingsGui_
            break

         Continue
      }
      If EMExtName =
         continue
      ExtensionFile[%EMExtName%] = %LoopFileName%
      StringReplace, ExtensionFile[%EMExtName%], ExtensionFile[%EMExtName%], %A_ScriptDir%\,

      EMfound = 0
      Loop, Read, %LoopFileName%
      {
         StringReplace,EMline,A_LoopReadLine,%A_Space%,,A

         IfInString, EMline, IfLng=%Lng%
            EMfound = 1

         IfNotInString, EMline, Description=
            Continue
         StringSplit, ext_temp, A_LoopReadLine, =

         If ExtensionDescription[%EMExtName%] =
            ExtensionDescription[%EMExtName%] = %ext_temp2%

         If EMfound = 1
            break
      }
      EMFound = 0
      If Extension[%EMExtName%] =
      {
         Prefix := ExtensionPrefix[%EMExtName%]
         tmpHelp =
         Loop, Read, %LoopFileName%
         {
            If EMFound = 0
               IfNotInString, A_LoopReadLine, Help_%EMExtName%`:
                  Continue
               Else
                  EMFound = 1

            If EMFound < 4
            {
               EMFound++
               continue
            }
            If A_LoopReadLine = )
               break

            tmpHelp := tmpHelp "`r`n" A_LoopReadLine
         }
         %Prefix%_Help = %tmpHelp%
      }
   }
   IniWrite, %ExtensionsInExtDir%, %ConfigFile%, %ScriptName%, AvailableExtensions
   GuiControl, -Redraw, InstalledExtensionsBox
   GuiControl, -Redraw, AvailableExtensionsBox
   Gui, Add, Text, XS+240 YS+13, %lng_installed% %lng_Extensions%:
   Gui, Add, ListBox, h200 w200 vInstalledExtensionsBox gsub_ExtISelect , %InstalledExtensions%
   Gui, Add, Text, XS+10 YS+13, %lng_available% %lng_Extensions%:
   Gui, Add, ListBox, h200 w200 vAvailableExtensionsBox gsub_ExtASelect , %AvailableExtensions%
   Gui, Add, Button, -Wrap XS+10 Y+3 h47 gsub_EMContextHelp, ?
   Gui, Font, Underline
   Gui, Add, Text, X+5 YP+3 w530 -Wrap vEMAuthor ReadOnly,
   Gosub, GuiDefaultFont
   Gui, Add, Text, XP+0 Y+3 w530 R2 vEMDescription ReadOnly,
   Gui, Add, Button, -Wrap XS+213 YS+70 gsub_AllExtAdd, >>
   Gui, Add, Button, -Wrap XS+216 Y+5 gsub_ExtAdd, >
   Gui, Add, Button, -Wrap Y+5 gsub_ExtRem, <
   Gui, Add, Button, -Wrap XS+213 Y+5 gsub_AllExtRem, <<
   Gui, Font, S%FontSize7%, Arial
   Gui, Add, Text, YS+32 XS+450 W110 R16, %lng_ExtensionManagerHelp%
   Gosub, GuiDefaultFont
   InstalledExtensionsBefore = %InstalledExtensions%
   GuiControl, +Redraw, InstalledExtensionsBox
   GuiControl, +Redraw, AvailableExtensionsBox
Return

sub_ExtISelect:
   GuiControlGet, ExtI_selected, , InstalledExtensionsBox
   If ExtI_selected =
      Return
   ExtAppend =
   If FunctionRequireExt[%ExtI_selected%] <>
      ExtAppend := " (" lng_requires " " FunctionRequireExt[%ExtI_selected%] ")"
   Prefix := ExtensionPrefix[%ExtI_selected%]
   GuiControl,, EMAuthor, % ExtI_selected " v" ExtensionVersion[%ExtI_selected%] " " lng_by " " %Prefix%_Author
   GuiControl,, EMDescription, % ExtensionDescription[%ExtI_selected%] ExtAppend
   Context = %ExtI_selected%

   If A_GuiControlEvent = DoubleClick
      Gosub, sub_ExtRem
Return

sub_ExtASelect:
   GuiControlGet, ExtA_selected, , AvailableExtensionsBox
   If ExtA_selected =
      Return
   ExtAppend =
   If FunctionRequireExt[%ExtA_selected%] <>
      ExtAppend := " (" lng_requires " " FunctionRequireExt[%ExtA_selected%] ")"
   Prefix := ExtensionPrefix[%ExtA_selected%]
   GuiControl,, EMAuthor, % ExtA_selected " v" ExtensionVersion[%ExtA_selected%] " " lng_by " " %Prefix%_Author
   GuiControl,, EMDescription, % ExtensionDescription[%ExtA_selected%] ExtAppend
   Context = %ExtA_selected%

   If A_GuiControlEvent = DoubleClick
      Gosub, sub_ExtAdd
Return

sub_ExtAdd:
   GuiControlGet, ExtA_selected, , AvailableExtensionsBox
   If ExtA_selected =
      Return

   If FunctionRequireExt[%ExtA_selected%] <>
   {
      Loop, Parse, FunctionRequireExt[%ExtA_selected%], `,
      {
         If A_LoopField =
            break
         IfNotInstring, InstalledExtensions, %A_LoopField%
         {
            Gui, +OwnDialogs
            ext_temp := lng_requiresAddMsg "`n" FunctionRequireExt[%ExtA_selected%]
            msgbox,16,%ScriptTitle%, %ext_temp%
            return
         }
      }
   }

   If InstalledExtensions =
      InstalledExtensions = %ExtA_selected%|
   Else
      InstalledExtensions = %ExtA_selected%|%InstalledExtensions%
   Sort, InstalledExtensions, D|
   StringReplace, InstalledExtensions, InstalledExtensions, ||, |, A
   GuiControl,,InstalledExtensionsBox, |%InstalledExtensions%
   StringReplace, AvailableExtensions, AvailableExtensions, %ExtA_selected%|,|
   StringReplace, AvailableExtensions, AvailableExtensions, ||, |, A
   StringLeft, EMfirst, AvailableExtensions, 1
   If EMfirst = |
      StringTrimLeft, AvailableExtensions, AvailableExtensions, 1
   GuiControl,,AvailableExtensionsBox, |%AvailableExtensions%

   StringGetPos, pos, InstalledExtensions, %ExtA_selected%|
   StringLeft, tmp, InstalledExtensions, %pos%
   StringReplace, tmp, tmp, |,, A UseErrorLevel
   tmp := ErrorLevel+1

   GuiControl,Focus,InstalledExtensionsBox
   GuiControl,Choose,InstalledExtensionsBox, %tmp%

   ChangedSettings[activAid]= |
   Gosub, sub_EnableDisable_ApplyButton
Return

sub_AllExtAdd:
   InstalledExtensions = %InstalledExtensions%|%AvailableExtensions%
   AvailableExtensions =
   StringLeft, EMfirst, InstalledExtensions, 1
   If EMfirst = |
      StringTrimLeft, InstalledExtensions, InstalledExtensions, 1
   GuiControl,,InstalledExtensionsBox, |%InstalledExtensions%
   GuiControl,,AvailableExtensionsBox, |%AvailableExtensions%
   ChangedSettings[activAid]= |
   Gosub, sub_EnableDisable_ApplyButton
Return

sub_ExtRem:
   GuiControlGet, ExtI_selected, , InstalledExtensionsBox
   If ExtI_selected =
      Return

   If FunctionRequiredFromExt[%ExtI_selected%] <>
   {
      Loop, Parse, FunctionRequiredFromExt[%ExtI_selected%], `,
      {
         If A_LoopField =
            break
         IfInstring, InstalledExtensions, %A_LoopField%
         {
            Gui, +OwnDialogs
            ext_temp := lng_requiresRemMsg "`n" FunctionRequiredFromExt[%ExtI_selected%]
            msgbox,16,%ScriptTitle%,%ext_temp%
            return
         }
      }
   }

   If AvailableExtensions =
      AvailableExtensions = %ExtI_selected%|
   Else
      AvailableExtensions = %ExtI_selected%|%AvailableExtensions%
   Sort, AvailableExtensions, D|
   StringReplace, AvailableExtensions, AvailableExtensions, ||, |, A
   GuiControl,,AvailableExtensionsBox, |%AvailableExtensions%
   StringReplace, InstalledExtensions, InstalledExtensions, %ExtI_selected%|,|
   StringReplace, InstalledExtensions, InstalledExtensions, ||, |, A
   StringLeft, EMfirst, InstalledExtensions, 1
   If EMfirst = |
      StringTrimLeft, InstalledExtensions, InstalledExtensions, 1
   GuiControl,,InstalledExtensionsBox, |%InstalledExtensions%

   StringGetPos, pos, AvailableExtensions, %ExtI_selected%|
   StringLeft, tmp, AvailableExtensions, %pos%
   StringReplace, tmp, tmp, |,, A UseErrorLevel
   tmp := ErrorLevel+1

   GuiControl,Focus,AvailableExtensionsBox
   GuiControl,Choose,AvailableExtensionsBox, %tmp%

   ChangedSettings[activAid]= |
   Gosub, sub_EnableDisable_ApplyButton
Return

sub_AllExtRem:
   AvailableExtensions = %AvailableExtensions%|%InstalledExtensions%
   InstalledExtensions =
   StringLeft, EMfirst, AvailableExtensions, 1
   If EMfirst = |
      StringTrimLeft, AvailableExtensions, AvailableExtensions, 1
   GuiControl,,InstalledExtensionsBox, |%InstalledExtensions%
   GuiControl,,AvailableExtensionsBox, |%AvailableExtensions%

   ChangedSettings[activAid]= |
   Gosub, sub_EnableDisable_ApplyButton
Return

sub_ExtInstall:
   StringReplace, InstalledExtensions, InstalledExtensions, ||, |, A
   StringSplit, InstalledExtensions, InstalledExtensions, |

   If InstalledExtensions = %InstalledExtensionsBefore%
      Return

   ChangedSettings++

   FileDelete, settings\_temp.tmp

   Loop, Read, extensions\_header.ahk, settings\_temp.tmp
   {
      IfNotInString A_LoopReadLine, CustomIncludes
      {
         FileAppend, %A_LoopReadLine%`n
         continue
      }
      break
   }
   FileAppend, CustomIncludes = 1`n, settings\_temp.tmp
   Loop
   {
      If InstalledExtensions%A_Index% =
         break
      ext_temp := A_Index + 2
      FileAppend, % "Extension[" ext_temp "] = " InstalledExtensions%A_Index% "`n", settings\_temp.tmp
   }
   FileMove, settings\_temp.tmp, extensions\_header.ahk, 1
   FileDelete, settings\_temp.tmp

   Loop, Read, extensions\_main.ahk, settings\_temp.tmp
   {
      IfNotInString, A_LoopReadLine, #Include *i
      {
         FileAppend, %A_LoopReadLine%`n
         continue
      }
      break
   }
   Loop
   {
      If InstalledExtensions%A_Index% =
         break
      ExtensionName := InstalledExtensions%A_Index%
      ExtensionFile := ExtensionFile[%ExtensionName%]
      If UsingUserDir = 1
         FileAppend, % "#Include *i " A_ScriptDir "\" ExtensionFile " `;" ExtensionName "`n", settings\_temp.tmp
      Else
         FileAppend, % "#Include *i " ExtensionFile " `;" ExtensionName "`n", settings\_temp.tmp
   }
   FileDelete, extensions\_main.ahk
   FileMove, settings\_temp.tmp, extensions\_main.ahk, 1
   FileDelete, settings\_temp.tmp

   Reload = 1
Return

; Prfen, ob NiftyWindows luft und dieses Skript ggf. mit doppeltem Suspend *vor* Nifty setzen
tim_CheckForNifty:
   DetectHiddenWindows, On
   IfWinExist,NiftyWindows,,.zip
   {
      if niftyWindows <> on
      {
         Suspend, Toggle
         Suspend, Toggle
         niftyWindows = on
      }
   }
   Else IfWinExist,NiftyWindows.ahk,,.zip,NiftyWindows.ini
   {
      if niftyWindows <> on
      {
         Suspend, Toggle
         Suspend, Toggle
         niftyWindows = on
      }
   }
   Else
      NiftyWindows =

   DetectHiddenWindows, Off

   IfWinExist,,NiftyWindows is resumed now.
   {
      WinGetClass, NiftyClass, A
      If ( NiftyClass = "tooltips_class32" AND NiftyTip <> "on" )
      {
         Suspend, Toggle
         Suspend, Toggle
         niftyWindows = on
         NiftyTip = on
      }
   }
   Else
      NiftyTip =
Return

sub_ExtensionsOff:
   Critical
   Gui +OwnDialogs
   FileMove, extensions\_main.ahk, extensions\_main_off.ahk, 1
   FileMove, extensions\_header.ahk, extensions\_header_off.ahk, 1
   If ErrorLevel = 0
      Reload
   Else
      MsgBox, 16, %ScriptTitle%, %lng_SwitchExtErr%
return

sub_ExtensionsOn:
   Critical
   Gui +OwnDialogs
   FileMove, extensions\_main_off.ahk, extensions\_main.ahk, 1
   FileMove, extensions\_header_off.ahk, extensions\_header.ahk, 1
   If ErrorLevel = 0
      Reload
   Else
      MsgBox, 16, %ScriptTitle%, %lng_SwitchExtErr%
return

; Unterroutine vom ProblemSolver, welche die Tasten prft und zurcksetzt
sub_RestoreKeyStates:
   ProbSolvMessage =

   Suspend, Toggle
   Suspend, Toggle

   GetKeyState,stateL,LButton
   GetKeyState,stateP,LButton, P
   if (stateL <> stateP)
   {
      Send,{LButton Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_MouseButton%-%lng_Key%`n
   }

   GetKeyState,stateL,RButton
   GetKeyState,stateP,RButton, P
   if (stateL <> stateP)
   {
      Send,{RButton Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_MouseButton%-%lng_Key%`n
   }

   GetKeyState,stateL,MButton
   GetKeyState,stateP,MButton, P
   if (stateL <> stateP)
   {
      Send,{MButton Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Middle% %lng_MouseButton%-%lng_Key%`n
   }

   If LoadingFinished = 1
   {
      GetKeyState,stateL,LWin
      GetKeyState,stateP,LWin, P
      if (stateL <> stateP)
      {
         Send,{LWin Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_KbWin%-%lng_Key%`n
      }

      GetKeyState,stateL,RWin
      GetKeyState,stateP,RWin, P
      if (stateL <> stateP)
      {
         Send,{RWin Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_KbWin%-%lng_Key%`n
      }

      GetKeyState,stateL,LAlt
      GetKeyState,stateP,LAlt, P
      if (stateL <> stateP)
      {
         Send,{LAlt Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_KbAlt%-%lng_Key%`n
      }

      GetKeyState,stateL,RAlt
      GetKeyState,stateP,RAlt, P
      if (stateL <> stateP)
      {
         Send,{RAlt Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_KbAlt%-%lng_Key%`n
      }

      GetKeyState,stateL,LCtrl
      GetKeyState,stateP,LCtrl, P
      if (stateL <> stateP)
      {
         Send,{LCtrl Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_KbCtrl%-%lng_Key%`n
      }

      GetKeyState,stateL,RCtrl
      GetKeyState,stateP,RCtrl, P
      if (stateL <> stateP)
      {
         Send,{RCtrl Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_KbCtrl%-%lng_Key%`n
      }

      GetKeyState,stateL,LShift
      GetKeyState,stateP,LShift, P
      if (stateL <> stateP)
      {
         Send,{LShift Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_KbShift%-%lng_Key%`n
      }

      GetKeyState,stateL,RShift
      GetKeyState,stateP,RShift, P
      if (stateL <> stateP)
      {
         Send,{RShift Up}
         ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_KbShift%-%lng_Key%`n
      }
   }
Return

; Nach Updates im Internet suchen
sub_getUpdates:
   Gosub, sub_temporarySuspend
   Sleep,100

   If AutoUpdate <> 1
   {
      If MainGuiVisible <>
         Gui, 1:+OwnDialogs
      MsgBox, 36, %ScriptTitle% - %lng_update%, %lng_AskUpdate%
      IfMsgBox, No
      {
         Gosub, sub_temporarySuspend
         Return
      }
   }

   If MainGUiVisible <>
   {
      GuiControlGet, Betatester_tmp,,Betatester
      If Betatester_tmp = 1
         UpdateURL = http://activaid.rumborak.de/ahk-versions.ini
      Else
         UpdateURL = http://www.heise.de/ct/ftp/05/22/210/versions.ini
   }

   If func_CheckIfOnline()
      URLDownloadToFile,%UpdateURL%?dl=%Random1%&ul=%Random2%,versions.ini

   If ( ErrorLevel = 1 OR func_CheckIfOnline() = 0)
   {
      MsgBox, 16, %ScriptTitle% - %lng_update%, %lng_UpdateError%
      Gosub, sub_temporarySuspend
      Return
   }

   IniRead, newScriptVersion, versions.ini, activAid, version

   If ExeDistribution = 1
   {
      IniRead, newScriptURL, versions.ini, activAid, exeurl
      IniRead, newScriptSize, versions.ini, activAid, exesize
      newAHKVersion = %A_AHKversion%
   }
   Else
   {
      IniRead, newScriptURL, versions.ini, activAid, url
      IniRead, newScriptSize, versions.ini, activAid, size
      IniRead, newAHKVersion, versions.ini, activAid, AHKversion, %A_AHKversion%
   }
   IniRead, newScriptUnzipURL, versions.ini, activAid, unzip
   IniRead, newScriptExtension, versions.ini, activAid, Extensions
   IniRead, newScriptHideUpdate, versions.ini, activAid, hideupdate, 0
   FileDelete, versions.ini

   If newScriptVersion = ERROR
   {
      MsgBox, 16, %ScriptTitle% - %lng_Update%, %lng_UpdateError%
      Gosub, sub_temporarySuspend
      Return
   }

   StringSplit, newScriptVersion, newScriptVersion, .
   StringSplit, ScriptVersion, ScriptVersion, .
   StringReplace, ScriptVersion4, ScriptVersion4, %A_Space%Beta,
   StringReplace, newScriptVersion4, newScriptVersion4, %A_Space%Beta,
   StringReplace, ScriptVersion3, ScriptVersion3, e,
   StringReplace, ScriptVersion4, ScriptVersion4, e,

   newScriptVersion3 := "0000000000" newScriptVersion3
   StringRight, newScriptVersion3, newScriptVersion3, 10
   newScriptVersion4 := "0000000000" newScriptVersion4
   StringRight, newScriptVersion4, newScriptVersion4, 10
   ScriptVersion3 := "0000000000" ScriptVersion3
   StringRight, ScriptVersion3,ScriptVersion3, 10
   ScriptVersion4 := "0000000000" ScriptVersion4
   StringRight, ScriptVersion4, ScriptVersion4, 10
   newScriptVersionCon = %newScriptVersion1%.%newScriptVersion2%.%newScriptVersion3%.%newScriptVersion4%
   ScriptVersionCon = %ScriptVersion1%.%ScriptVersion2%.%ScriptVersion3%.%ScriptVersion4%

   if ( newScriptVersionCon > ScriptVersionCon AND newScriptHideUpdate = 0 )
   {
      Gosub, sub_NewVersion
   }
   Else
   {
      If newScriptHideUpdate = 1
         newScriptVersion = %ScriptVersion%

      MsgBox, 64, %ScriptTitle% - %lng_Update%, %lng_NeedNoUpdate% (Online: %newScriptVersion%)
   }

   Gosub, sub_temporarySuspend
Return

sub_getManualUpdates:
   Gui, 1:+Disabled
   Gui, 5:+Owner1
   Gui, 5:Add, Text, Wrap w380, %lng_ManualUpdateText%
   Gui, 5:Font, C000066 Underline
   Gui, 5:Add, Text, y+3 gsub_OpenDownloadURL, http://www.heise.de/ct/ftp/05/22/210/
   Gui, 5:Font
   Gui, 5:Font, S%FontSize%
   Gui, 5:Add, Text, Wrap w380, %lng_ManualUpdateText2%
   Gui, 5:Font, C000066 Underline
   Gui, 5:Add, Text, y+3 gsub_OpenDownloadAhk, http://home.tampabay.rr.com/kodi/ahk/AutoHotkeyInstall.exe
   Gui, 5:Font
   Gui, 5:Font, S%FontSize%
   IfNotExist, settings/unzip.exe
   {
      Gui, 5:Add, Text, Wrap w380, %lng_ManualUpdateTextUnzip%
      Gui, 5:Font, C000066 Underline
      Gui, 5:Add, Text, y+3 gsub_OpenDownloadURLUnzip, http://www.heise.de/ct/ftp/05/22/210/unzip.exe
      Gui, 5:Font
      Gui, 5:Font, S%FontSize%
   }
   Gui, 5:Add, Text,, %lng_ManualUpdatePath%:
   Gui, 5:Add, Edit, w280 R1 vManualUpdatePath, %ManualUpdatePath%
   Gui, 5:Add, Button, -Wrap w100 x+5 gsub_ManualUpdatePath, %lng_Browse%
   Gui, 5:Add, Button, -Wrap X115 Y+10 W80 vMainGuiOK Default gsub_DoManualUpdate, &%lng_OK%
   Gui, 5:Add, Button, -Wrap X+5 W80 vMainGuiCancel g5GuiClose, &%lng_cancel%
   Gui, 5:Show, w400, %ScriptTitle% %lng_ManualUpdate%
Return

sub_OpenDownloadAhk:
   Run, http://home.tampabay.rr.com/kodi/ahk/AutoHotkeyInstall.exe
Return
sub_OpenDownloadURL:
   Run, http://www.heise.de/ct/ftp/05/22/210/
Return
sub_OpenDownloadURLUnzip:
   Run, http://www.heise.de/ct/ftp/05/22/210/unzip.exe
Return

5GuiEscape:
5GuiClose:
   Gui,1:-Disabled
   Gui,5:Destroy
Return

sub_DoManualUpdate:
   Critical
   Gui,1:-Disabled
   Gui,1:+OwnDialogs
   Gui,5:Submit
   IniWrite, %ManualUpdatePath%, %ConfigFile%, %ScriptName%, ManualUpdatePath
   If (!FileExist(ManualUpdatePath "\" UpdateArchive ) OR ((!FileExist(ManualUpdatePath "\unzip.exe") AND !FileExist("settings\unzip.exe") AND !FileExist("unzip.exe"))) )
   {
      Msgbox, 16, %ScriptTitle% %lng_ManualUpdate%, %lng_ManualUpdateFailure%
      Gosub, 5GuiClose
      Return
   }
   Else
   {
      WorkingDir = %A_WorkingDir%
      SetWorkingDir, %A_ScriptDir%

      IfNotExist, settings\unzip.exe
         FileMove, %ManualUpdatePath%\unzip.exe, settings\

      FileCopy, %ManualUpdatePath%\%UpdateArchive%, .\update.zip

      FileGetTime, activAid_ManualUpdateTime, %ManualUpdatePath%\%UpdateArchive%, C
      IfExist, %ConfigFile%
        IniWrite, %activAid_ManualUpdateTime%, %ConfigFile%, %ScriptName%, ManualUpdateTime

      If A_IsCompiled = 1
      {
         FileAppend, %ScriptNameFull%.exe kill`n, update.cmd
         If CustomIncludes = 1
            FileAppend, settings\unzip -o update.zip -x settings\*.* extensions\_header.ahk extensions\_main.ahk`n, update.cmd
         Else
            FileAppend, settings\unzip -o update.zip -x settings\*.*`n, update.cmd
         FileAppend, settings\unzip -n update.zip`n, update.cmd
         FileAppend, %ScriptNameFull%.exe`n, update.cmd
         RunWait, update.cmd,, Hide
         ExitApp
      }
      If CustomIncludes = 1
         RunWait, settings\unzip -o update.zip -x settings\*.* extensions\_header.ahk extensions\_main.ahk,, Hide
      Else
         RunWait, settings\unzip -o update.zip -x settings\*.*,, Hide
      RunWait, settings\unzip -n update.zip,, Hide
      If ErrorLevel = 0
      {
         MsgBox, 64, %ScriptTitle% - %lng_Update%, %lng_UpdateFinished%, 10
      }
      Else
      {
         MsgBox, 16, %ScriptTitle% - %lng_Update%, %lng_UpdateFailed%
         FileDelete, update.zip
         FileDelete, update.cmd
         SetWorkingDir, %WorkingDir%
         return
      }
      Reload
   }
   Gosub, 5GuiClose
Return

sub_ManualUpdatePath:
   Gui,5:+OwnDialogs
   FileSelectFolder, ManualUpdatePathTmp
   If ManualUpdatePathTmp <>
   {
      GuiControl, 5:, ManualUpdatePath, %ManualUpdatePathTmp%
   }
Return

sub_NewVersion:
   ;Critical
   If MainGuiVisible <>
      Gui,+OwnDialogs
   IfExist, settings\unzip.exe
      newScriptSize := newScriptSize - 58
   If newAHKVersion > %A_AHKversion%
      newScriptSize := newScriptSize + 1619
   If UpdateImmediatly <> 1
      MsgBox, 36, %ScriptTitle% - %lng_Update%, %lng_NeedUpdate% %newScriptVersion% (ca. %newScriptSize% Kb)

   IfMsgBox, Yes
      msgbox = yes
   Else
      msgbox = no

   If (MsgBox = "yes" OR UpdateImmediatly = 1)
   {
      If MainDirNotWriteable = 1
      {
         ;Msgbox, Sorry, das Update funktioniert womglich noch nicht korrekt im Mehrbenutzermodus.
         IniWrite, 1, %ConfigFile%, %ScriptName%, CheckForUpdates
         Gosub, sub_RunAsAdmin
         Return
      }
      WorkingDir = %A_WorkingDir%
      SetWorkingDir, %A_ScriptDir%
      Settimer, tim_UPDATEDSCRIPT, Off
      IniWrite, %newScriptExtension%, %ConfigFile%, activAid, newext
      IniWrite, %newScriptVersion%, %ConfigFile%, activAid, newver

      IfNotExist, settings
         FileCreateDir, settings

      IfNotExist, settings\unzip.exe
      {
         URL2 = %newScriptUnzipURL%
         File2 = settings\unzip.exe
      }
      If newAHKVersion > %A_AHKversion%
      {
         URL3 = http://home.tampabay.rr.com/kodi/ahk/AutoHotkeyInstall.exe
         File3 = AutoHotkeyInstall.exe
      }

      func_Download( newScriptURL, "update.zip", lng_downloadingActivAid , ScriptTitle " Update", newScriptSize, URL2, File2, URL3, File3)

      If A_IsCompiled = 1
      {
         FileAppend, %ScriptNameFull%.exe kill`n, update.cmd
         If CustomIncludes = 1
            FileAppend, settings\unzip -o update.zip -x settings\*.* extensions\_header.ahk extensions\_main.ahk`n, update.cmd
         Else
            FileAppend, settings\unzip -o update.zip -x settings\*.*`n, update.cmd
         FileAppend, settings\unzip -n update.zip`n, update.cmd
         FileAppend, %ScriptNameFull%.exe`n, update.cmd
         RunWait, update.cmd,, Hide
         ExitApp
      }
      If CustomIncludes = 1
         RunWait, settings\unzip -o update.zip -x settings\*.* extensions\_header.ahk extensions\_main.ahk,, Hide
      Else
         RunWait, settings\unzip -o update.zip -x settings\*.*,, Hide
      RunWait, settings\unzip -n update.zip,, Hide
      If ErrorLevel = 0
         MsgBox, 64, %ScriptTitle% - %lng_Update%, %lng_UpdateFinished%, 10
      Else
      {
         MsgBox, 16, %ScriptTitle% - %lng_Update%, %lng_UpdateFailed%
         FileDelete, update.zip
         FileDelete, update.cmd
         SetWorkingDir, %WorkingDir%
         return
      }
      Reload
   }
Return

; Skript bei nderung automatisch neu laden
tim_UPDATEDSCRIPT:
   Critical
   WinGetActiveTitle, act_Title
   IfNotInstring, act_Title, .ahk
      Return

   Loop, %A_ScriptDir%\*.ahk, 0, 1
   {
      If (func_StrLeft(A_LoopFileName,1) = "_" OR func_StrLeft(A_LoopFileName,1) = ".")
         continue
      If A_LoopFileAttrib contains A
      {

         IfNotInString, act_Title, %A_LoopFileName%
            continue

         FileSetAttrib,-A,%A_LoopFileFullpath%
         Reload
      }
   }
Return

; Falls BalloonTips deaktiviert sind, normale Meldung ausgeben
BalloonTip(Title, Text, Symbol="", OnlyOnce=0, AlwaysMessageBox=0, TimeOut="")
{
   Global

   If (OnlyOnce = 1 AND LoadingFinished = 1)
   {
      OnceVar =
      OnceVar := "OnceVar" func_StrLeft(func_Hex(Title),16) func_StrRight(func_Hex(Title) func_Hex(Text),16)
      If %OnceVar% = 1
         Return
   }

   If OnlyOnce = Reset
   {
      OnceVar =
      OnceVar := "OnceVar" func_StrLeft(func_Hex(Title),16) func_StrRight(func_Hex(Title) func_Hex(Text),16)
      %OnceVar% =
      Return
   }

   If (OnlyOnce <> "" AND OnlyOnce <> 1 AND OnlyOnce <> "Reset")
   {
      OnceVar =
      OnceVar := "OnceVar" func_StrLeft(func_Hex(OnlyOnce),16) func_StrRight(func_Hex(OnlyOnce),16)
      If %OnceVar% = 1
         Return
   }

   If (EnableBalloonTips = 0 OR AlwaysMessageBox = 1)
   {
      Gui +OwnDialogs
      If Symbol = Info
         MsgBox,64, %Title%, %Text%, %TimeOut%
      If Symbol = Warning
         MsgBox,48, %Title%, %Text%, %TimeOut%
      If Symbol = Error
         MsgBox,16, %Title%, %Text%, %TimeOut%
   }
   Else
   {
      If Symbol = Info
         Symbol = 1
      If Symbol = Warning
         Symbol = 2
      If Symbol = Error
         Symbol = 3
      TrayTip, %Title%, %Text%,, %Symbol%
      If TimeOut <>
      {
         TimeOut := TimeOut * 1000
         SetTimer, tim_BalloonTipTimeout, %TimeOut%
      }
   }
   If (OnlyOnce <> "" AND OnlyOnce <> 0 AND LoadingFinished = 1)
      %OnceVar% = 1
}

tim_BalloonTipTimeout:
   SetTimer, tim_BalloonTipTimeout, Off
   TrayTip
Return

; ac'tivAid im Autostart-Ordner eintragen
sub_MenuAutostart:
   If AutoStart = 0
   {
      FileDelete, %A_Startup%\%ScriptNameFull%.lnk
   }
   Else
   {
      If UsingUserDir = 1
         FileCreateShortcut,%A_ScriptFullPath%, %APPDATA%\ac'tivAid\%ScriptNameFull%.lnk,%APPDATA%\ac'tivAid,,,%ScriptIcon%
      If A_Iscompiled = 1
         FileCreateShortcut,%A_ScriptFullPath%,%A_Startup%\%ScriptNameFull%.lnk,%A_ScriptDir%,,,%A_ScriptFullPath%
      Else
      {
         If UsingUserDir = 1
            FileCreateShortcut,%APPDATA%\ac'tivAid\%ScriptNameFull%.lnk, %A_Startup%\%ScriptNameFull%.lnk,%APPDATA%\ac'tivAid,,,%ScriptOnIcon%
         Else
            FileCreateShortcut,%A_ScriptFullPath%,%A_Startup%\%ScriptNameFull%.lnk,%A_ScriptDir%,,,%ScriptOnIcon%
      }
   }
Return

sub_EMContextHelp:
sub_ContextHelp:
   IfInString, A_GuiControl, CH_
      StringReplace, Context, A_GuiControl, CH_,

   ContextBegin   = 0
   ContextContent =

   Loop, Parse, ReadMe, `n, `r
   {
      If ContextBegin = 1
      {
         If ( InStr(A_LoopField, ". " Context) > 2 AND InStr(A_LoopField, ". " Context) < 8)
         {
            ContextBegin++
         }
         Continue
      }
      If ContextBegin = 2
      {
         ContextBegin++
         Continue
      }
      If ContextBegin = 3
      {
         If A_LoopField contains _________________________
            break
         ContextContent = %ContextContent%%A_LoopField%`n
      }

      If A_LoopField contains ________________________
      {
         ContextBegin++
         Continue
      }


   }
   Prefix := ExtensionPrefix[%Context%]
   If %Prefix%_Help <>
      ContextContent := %Prefix%_Help
   Gui, 2:Destroy
   Gui, 2:-Maximize -Minimize +ToolWindow +AlwaysOnTop
   Gui, 2:Font, S%FontSize14% bold, Arial
   Gui, 2:Add, Text,, %Context%
   Gui, 2:Font
   Gui, 2:Add, Text,x+5 yp+7, % "v" ExtensionVersion[%Context%] " " lng_by " " %Prefix%_Author
   Gui, 2:Font, S%FontSize%, Courier New
   Gui, 2:Font, S%FontSize%, Lucida Console
   Gui, 2:Add, Edit,Readonly x10 Y+5 T100 H330 W570 vContextHelp, %ContextContent%
   Gosub, 2GuiDefaultFont
   Gui, 2:Add, Button, -Wrap w50 Default X270 g2GuiClose, &%lng_OK%
   Gui, 2:Show, , %ScriptTitle% - %Context%
   Send,^{Home}
Return

2GuiClose:
2GuiEscape:
   Gui, 2:Destroy
Return

sub_OnExit:
   Gosub, cd_sub_RestoreTempDeskWindows
   Gosub, cd_sub_RestoreHiddenWindows
   Loop
   {
      If Extension[%A_Index%] =
         break
      Function := Extension[%A_Index%]
      If ( IsLabel("OnExitAndReload_" Function) )
         Gosub, OnExitAndReload_%Function%
   }

   Gui, 4:+LastFound
   WinGetPos, ShowHotkeyListX , ShowHotkeyListY , , ShowHotkeyListH

   If ShowHotkeyListH <> 0
   {
      IniWrite, x%ShowHotkeyListX%, %ConfigFile%, %ScriptName%, ShowHotkeyListX
      IniWrite, y%ShowHotkeyListY%, %ConfigFile%, %ScriptName%, ShowHotkeyListY
      IniWrite, h%ShowHotkeyListH%, %ConfigFile%, %ScriptName%, ShowHotkeyListH
   }

   If A_ExitReason <> Reload
   {
      IniDelete, %ConfigFile%, %ScriptName%, GUIselected
      IniDelete, %ConfigFile%, %ScriptName%, ShowGUI
      IniDelete, %ConfigFile%, %ScriptName%, LastExitReason
   }
   Else
      IniWrite, Reload, %ConfigFile%, %ScriptName%, LastExitReason

   ExitApp
Return

;---HotKeys------------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

~#ESC::
   Sleep, 300
   Suspend, Toggle
   Suspend, Toggle
   niftyWindows = on

   If Extend_WinESC <>
      Gosub, %Extend_WinESC%
Return

$MButton:: ; mc cd
   mc_DownTick = %A_TickCount%
   StringReplace, mbutton_LastHotkey, A_ThisHotkey, $,
;<---ComfortDrag---
   GetKeyState,cd_LButtonstate,LButton
   If cd_LButtonstate = D
   {
      If Enable_ComfortDrag = 1
         Gosub, cd_main_ComfortDrag_MButton
   }
   Else
   {
;---ComfortDrag--->
;---MouseClip--->
      If Enable_MouseClip = 1
         Gosub, mc_main_MouseClip
;<---MouseClip---

      If Extend_MButton <>
         Gosub, %Extend_MButton%
      If (Extend_MButton2 <> "" AND Extend_MButton_Executed = "")
         Gosub, %Extend_MButton2%
      If (Extend_MButton3 <> "" AND Extend_MButton_Executed = "")
         Gosub, %Extend_MButton3%
   }

   If (MButton_send = "" OR MButton_send = "yes")
   {
      If (mc_UpTick <> mc_DownTick)
      {
         Send, {%mbutton_LastHotkey% Down}
         MBdown = yes
      }
         Send, {%mbutton_LastHotkey% Up}
   }

   MButton_send =
Return

$MButton Up::
   mc_UpTick = %mc_DownTick%
   If Extend_MButtonUp <>
      Gosub, %Extend_MButtonUp%

   If MBdown = yes
   {
      Send, {%mbutton_LastHotkey% Up}
      MBdown =
   }
Return


;---ComfortDrag--->
; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               ComfortDrag
; -----------------------------------------------------------------------------
; Prefix:             cd_
; Version:            0.9
; Date:               2005-10-24
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================cd==
; -----------------------------------------------------------------------------

init_ComfortDrag:
   Prefix = cd
   %Prefix%_ScriptName    = ComfortDrag
   %Prefix%_ScriptVersion = 0.9
   %Prefix%_Author        = Wolfgang Reszel

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                    = %cd_ScriptName% - Fensterwechsel bei Drag&&Drop
      Description                 = Interaktives Wechseln und Verstecken von Fenstern whrend einer Drag&&Drop-Aktion.
      lng_cd_MenuGestures         = Web-Browser nur ber die Titelleiste mit der rechte Maustaste versteckbar
      lng_cd_TempDesk             = kurzfristiger Desktop
      lng_cd_ExcludeApps          = Folgende Anwendungen fr eine 'Drag'-Aktion ignorieren ('Droppen' ist weiterhin mglich)
      lng_cd_MoveSteps            = Animationsgeschwindigkeit des kurzfristigen Desktops (1=Schnell, 40=Langsam)`nFr langsame PCs sind Einstellungen grer 1 nicht empfehlenswert.
      lng_cd_MoveStepsOut         = beim Rausfliegen
      lng_cd_MoveStepsIn          = beim Reinfliegen
      lng_cd_activateTargetWindow = Zielfenster einer Drag&&Drop-Aktion immer in den Vordergrund holen
      lng_cd_FullScreenFix        = Problem mit festhngenden maximierten Fenstern umgehen
      lng_cd_HideOnlyOnDragging   = Fenster verstecken mit linker und rechter Maustaste nur bei Drag&&Drop-Aktionen
      tooltip_cd_FullScreenFix    = Aus = es wird versucht maximierte Fenster einfach zu verschieben`nAktiviert = maximierte Fenster werden vor dem Verschieben in normale Fenster umgewandelt`nGrau/Grn = wie oben, jedoch werden die normalen Fenstermae berschrieben, um Flackern zu verhindern
      tooltip_cd_activateTargetWindow = ... kann auch temporr bei einer Drag&Drop-Aktion`ndurch halten der Feststelltaste erreicht werden
   }
   else        ; = other languages (english)
   {
      MenuName                    = %cd_ScriptName% - window-switching while drag&&drop
      Description                 = Switching and hiding windows while drag && drop operations.
      lng_cd_MenuGestures         = web browsers only hideable from the title-bar with the right mouse-button
      lng_cd_TempDesk             = temporary desktop
      lng_cd_ExcludeApps          = Exclude the following applications from drag-actions (dropping is furthermore possible)
      lng_cd_MoveSteps            = animation speed of temporary Desktop (1=fast, 40=slow)`nOn slow PC's it's not recommended to set above 1.
      lng_cd_MoveStepsOut         = flying out
      lng_cd_MoveStepsIn          = flying in
      lng_cd_activateTargetWindow = always activate destination window
      lng_cd_FullScreenFix        = resolve problems with maximized windows
      lng_cd_HideOnlyOnDragging   = hide windows with left and right mousebutton only at drag&&drop operations
      tooltip_cd_FullScreenFix    = off = just trying to move a maximized window`nactive = simulating maximized windows by resizing`nalternate = like active, but to avoid flickering, the normal window-size will be overwritten
   }

   IniRead, cd_onGestures, %ConfigFile%, %cd_ScriptName%, GestureApplications, 1

   ; Variable ExcludeApps aus der INI einlesen
   IniRead, cd_ExcludeApps, %ConfigFile%, %cd_ScriptName%, ExcludeApps, Illustrator.exe|Photoshop.exe|InDesign.exe

   IniRead, cd_onTempDesk, %ConfigFile%, %cd_ScriptName%, TemporaryDesktop, 1
   IniRead, cd_FullScreenFix, %ConfigFile%, %cd_ScriptName%, AlternateMaxWinHandling, 0
   IniRead, cd_HideOnlyOnDragging, %ConfigFile%, %cd_ScriptName%, HideWithRBOnlyOnDragging, 0

   func_HotkeyRead( "cd_TempDesk" , ConfigFile, cd_ScriptName, "Hotkey_TempDesk", "cd_main_ComfortDrag_TempDesk", "F10" )
   func_HotkeyDisable( "cd_TempDesk" )

   IniRead, cd_MoveStepsOut, %ConfigFile%, %cd_ScriptName%, MoveStepsOut_TempDesk, 1
   IniRead, cd_MoveStepsIn, %ConfigFile%, %cd_ScriptName%, MoveStepsIn_TempDesk, 1
   IniRead, cd_activateTargetWindow, %ConfigFile%, %cd_ScriptName%, activateTargetWindow, 0

   ;Hotkey,$+ESC, off
   ;Hotkey,$ESC, off
   Hotkey,~*ESC, off
   Hotkey,$RButton, off
   Hotkey,$PgUp, off
   Hotkey,$PgDn, off
   Hotkey, ~CTRL, cd_sub_actImmediately
   Hotkey, ~CTRL, Off

   Gesture_Exclusions = OperaWindowClass,MozillaWindowClass,Internet Explorer_Server
Return

SettingsGui_ComfortDrag:
   Gui, Add, CheckBox, XS+10 YP+10 gsub_CheckIfSettingsChanged vcd_onGestures -Wrap Checked%cd_onGestures%, %lng_cd_MenuGestures%
   Gui, Add, CheckBox, XS+10 Y+3 gsub_CheckIfSettingsChanged vcd_activateTargetWindow -Wrap Checked%cd_activateTargetWindow%, %lng_cd_activateTargetWindow%
   Gui, Add, CheckBox, XS+10 Y+3 gsub_CheckIfSettingsChanged vcd_HideOnlyOnDragging -Wrap Checked%cd_HideOnlyOnDragging%, %lng_cd_HideOnlyOnDragging%
   Gui, Add, Text, XS+10 Y+8, %lng_cd_ExcludeApps%:
   StringReplace, cd_ExcludeApps_Box, cd_ExcludeApps , `, , | , a
   Gui, Add, ListBox, Y+5 vcd_ExcludeApps_Box_tmp W200 R8, %cd_ExcludeApps_Box%
   Gui, Add, Button, -Wrap x+5 w20 vcd_Add_ExcludeApps_Box gsub_ListBox_addApp, +
   Gui, Add, Button, -Wrap y+5 w20 vcd_Remove_ExcludeApps_Box gsub_ListBox_remove, %MinusString%

   Gui, Add, CheckBox, XS+10 Y+70 gsub_CheckIfSettingsChanged vcd_onTempDesk -Wrap Checked%cd_onTempDesk%, %lng_cd_TempDesk%
   func_HotkeyAddGuiControl( lng_Hotkey, "cd_TempDesk", "x+20" )

   Gui, Add, Text, xs+10 y+8, %lng_cd_MoveSteps%:
   Gui, Add, Text, y+8, %lng_cd_MoveStepsOut%:
   Gui, Add, Dropdownlist, gsub_CheckIfSettingsChanged x+5 yp-3 w50 vcd_MoveStepsOut, 1|2|3|4|5|6|7|8|9|10|15|20|25|30|35|40
   Gui, Add, Text, x+10 yp+3, %lng_cd_MoveStepsIn%:
   Gui, Add, Dropdownlist, gsub_CheckIfSettingsChanged x+5 yp-3 w50 vcd_MoveStepsIn, 1|2|3|4|5|6|7|8|9|10|15|20|25|30|35|40
   Gui, Add, Checkbox, x+75 yp-3 w190 R2 Check3 gsub_CheckIfSettingsChanged vcd_FullScreenFix Checked%cd_FullScreenFix%, %lng_cd_FullScreenFix%
   GuiControl, ChooseString, cd_MoveStepsOut, %cd_MoveStepsOut%
   GuiControl, ChooseString, cd_MoveStepsIn, %cd_MoveStepsIn%
Return

SaveSettings_ComfortDrag:
   IniWrite, %cd_activateTargetWindow%, %ConfigFile%, %cd_ScriptName%, activateTargetWindow
   IniWrite, %cd_onGestures%, %ConfigFile%, %cd_ScriptName%, GestureApplications
   IniWrite, %cd_onTempDesk%, %ConfigFile%, %cd_ScriptName%, TemporaryDesktop
   If (func_StrLeft(cd_ExcludeApps_Box,1) = "|")
      StringTrimleft, cd_ExcludeApps_Box, cd_ExcludeApps_Box, 1
   StringReplace, cd_ExcludeApps, cd_ExcludeApps_Box, | , `, , a
   IniWrite, %cd_ExcludeApps%, %ConfigFile%, %cd_ScriptName%, ExcludeApps
   IniWrite, %cd_MoveStepsOut%, %ConfigFile%, %cd_ScriptName%, MoveStepsOut_TempDesk
   IniWrite, %cd_MoveStepsIn%, %ConfigFile%, %cd_ScriptName%, MoveStepsIn_TempDesk
   func_HotkeyWrite( "cd_TempDesk", ConfigFile, cd_ScriptName, "Hotkey_TempDesk" )
   IniWrite, %cd_FullScreenFix%, %ConfigFile%, %cd_ScriptName%, AlternateMaxWinHandling
   IniWrite, %cd_HideOnlyOnDragging%, %ConfigFile%, %cd_ScriptName%, HideWithRBOnlyOnDragging
Return

CancelSettings_ComfortDrag:
Return

DoEnable_ComfortDrag:
   If Enable_ComfortDrag = 1
   {
      Settimer, cd_tim_LButtonWatch, 10

      If cd_onTempDesk = 1
         func_HotkeyEnable( "cd_TempDesk" )
   }
Return

DoDisable_ComfortDrag:
   func_HotkeyDisable( "cd_TempDesk" )
   Settimer, cd_tim_LButtonWatch, Off

   Hotkey, $MButton, Off
   Hotkey, ~CTRL, Off
   ;Hotkey, $+ESC, Off
   ;Hotkey, $ESC, Off
   Hotkey,~*ESC, off
   Hotkey, $PgDn, Off
   Hotkey, $PgUp, Off
   Hotkey, $RButton, Off
Return

DefaultSettings_ComfortDrag:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =============================================================cd==
; -----------------------------------------------------------------------------

;$+ESC:: ; cd
;$ESC::  ; cd
~*ESC::
   If Enable_ComfortDrag = 1
      Gosub, cd_main_ComfortDrag_ESC

;   If cd_tempDesktop <>
;      gosub, cd_main_ComfortDrag_TempDesk

   If Extend_ESC <>
      Gosub, %Extend_ESC%

   Send, {ESC}
Return

$RButton:: ; cd
   Gosub, cd_main_ComfortDrag_RButton

   If Extend_RButton <>
      Gosub, %Extend_RButton%
Return

$PgUp::    ; cd
   Gosub, cd_main_ComfortDrag_RButton

   If Extend_PgUp <>
      Gosub, %Extend_PgUp%
Return

$PgDn:: ;cd
   StringReplace, pgdn_LastHotkey, A_ThisHotkey, $,

   If Enable_ComfortDrag = 1
      Gosub, cd_main_ComfortDrag_MButton

   If Extend_PgDn <>
      Gosub, %Extend_PgDn%

   If MButton_send =
      Send, {%pgdn_LastHotkey%}

   MButton_send =
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================cd==
; -----------------------------------------------------------------------------

cd_tim_LButtonWatch:
   GetKeyState,cd_LBstateP,LButton
   if ( cd_LBstateP = "D" AND cd_LastLBstateP = "U" )
   {
      Gosub, cd_main_ComfortDrag_LButton
   }
   if ( cd_LBstateP = "U" AND cd_LastLBstateP = "D" )
   {
;---MouseClip--->
      If Enable_MouseClip = 0
         Hotkey,$MButton, Off
;<---MouseClip---
      Hotkey, ~CTRL, Off
      ;Hotkey, $+ESC, Off
      ;Hotkey, $ESC, Off
      Hotkey,~*ESC, off
      Hotkey, $PgDn, Off
      Hotkey, $PgUp, Off
      Hotkey, $RButton, Off
      Gosub, cd_main_ComfortDrag_LButtonUp
   }

   cd_LastLBstateP = %cd_LBstateP%

   WinGet, cd_bwWinID, ID, A
   If (cd_bwWinID <> "" AND TempDeskWindows = "" AND cd_WinBeforeTD="")
      IfInString, TempDeskWindowsToMaximize, %cd_bwWinID%|
      {
         StringReplace, TempDeskWindowsToMaximize, TempDeskWindowsToMaximize, %cd_bwWinID%|,
         If cd_FullScreenFix = 1
            WinMove, ahk_id %cd_bwWinID%,, % TempDeskWindowX2[%cd_bwWinID%], % TempDeskWindowY2[%cd_bwWinID%], % TempDeskWindowW2[%cd_bwWinID%], % TempDeskWindowH2[%cd_bwWinID%]
         WinMaximize, ahk_id %cd_bwWinID%
         IniWrite, %TempDeskWindowsToMaximize%, %ConfigFile%, TemporaryDesktop, WindowsToMaximize
      }

Return

; linke Maustaste gedrckt
cd_main_ComfortDrag_LButton:
   cd_activeWindowHasChanged =
   cd_MouseStartCursor =

   WinGet, cd_activeStartWinID, ID, A

   CoordMode,Mouse,Screen
   MouseGetPos, cd_MouseStartDragX, cd_MouseStartDragY, cd_MouseStartWinID, cd_MouseStartControl
   WinGetPos, cd_WinStartX, cd_WinStartY,,, ahk_id %cd_MouseStartWinID%

   WinGetTitle, cd_MouseStartWinName, ahk_id %cd_MouseStartWinID%
   WinGet, cd_MouseStartProcName, ProcessName, ahk_id %cd_MouseStartWinID%

   If cd_ExcludeApps <>
      If cd_MouseStartProcName contains %cd_ExcludeApps%
         Return

   Hotkey, $PgDn, On
   Hotkey, $PgUp, On
   Hotkey, $RButton, On
   ;Hotkey, $+ESC, On
   ;Hotkey, $ESC, On
   Hotkey, ~*ESC, On
   Hotkey, ~CTRL, On

   SetTimer, cd_tim_whileDragging, 50

;---MouseClip--->
   If Enable_MouseClip = 0
      Hotkey,$MButton, On
;<---MouseClip---
Return

; linke Maustaste losgelassen
cd_main_ComfortDrag_LButtonUP:
   SetTimer, cd_tim_whileDragging, OFF
   SetTimer, cd_tim_ShowTree, Off

   CoordMode,Mouse,Screen
   MouseGetPos, cd_actMouseX, cd_actMouseY, cd_actWinID

   If cd_temporaryTreeID <>
   {
      If (cd_HTMouseWinControl <> "SysTreeView321")
      {
         PostMessage, 0x111, 41525, 0, , ahk_id %cd_temporaryTreeID%
         cd_STMouseStartWinID =
         cd_hideTreeTimer =
         cd_temporaryTreeID =
      }
   }

   GetKeyState, cd_CapsLockState, CapsLock, P

   If cd_CapsLockState = D
      Send,{CapsLock}

   MouseGetPos,,,cd_activateWinID
   Sleep, 600
   WinGet,cd_activateID,ID,A
   WinGetClass,cd_activateClass, A

   If ((cd_CapsLockState = "D" OR (cd_activateTargetWindow = 1 AND cd_DraggingActive <> "") OR cd_activateClass = "#32770") AND cd_activeWindowHasChanged = "yes")
   {
      If cd_activateClass = #32770
         cd_activateWinID = %cd_activateID%
      Else
         IfWinNotActive, ahk_id %cd_activateWinID%
            WinActivate, ahk_id %cd_activateWinID%

      WinGet, cd_ExStyle, ExStyle, ahk_id %cd_activateWinID%

      If (cd_ExStyle & 0x8) ; 0x8 = WS_EX_TOPMOST.
         cd_actStartWin_AOT = yes
      Else
         cd_actStartWin_AOT = no

      If cd_actStartWin_AOT = no
         WinSet, AlwaysOnTop, On, ahk_id %cd_activateWinID%

      cd_activeStartWinID = %cd_activateWinID%
   }
   Else
      cd_activateWinID =

   If HiddenWindows <>
   {
      Gosub, cd_sub_RestoreHiddenWindows
   }
   If cd_activeWindowHasChanged = yes
   {
      SetTimer, cd_tim_activateUnderMouse, OFF
      cd_activateUnderMouseTimer = off
      IfWinNotActive, ahk_id %cd_activeStartWinID%
        WinActivate, ahk_id %cd_activeStartWinID%
   }

   If ((cd_CapsLockState = "D" OR cd_activateTargetWindow = 1) AND cd_activeWindowHasChanged = "yes")
   {
      If cd_actStartWin_AOT = no
         WinSet, AlwaysOnTop, Off, ahk_id %cd_activateWinID%

      IfWinNotActive, ahk_id %cd_activateWinID%
         WinActivate, ahk_id %cd_activateWinID%
   }

   If TempDeskWindows <>
   {
      MouseGetPos,,,cd_tmpWinID
      WinGetTitle, cd_tmpTitle, ahk_id %cd_tmpWinID%
      IfInString, cd_TmpTitle, TMPDSKaid
      {
         Gosub, cd_sub_RestoreTempDeskWindows
;         WinSet, Redraw,, ahk_class Progman
      }
      If cd_activeWindowHasChanged = yes
      {
         Gosub, cd_sub_RestoreTempDeskWindows
;         WinSet, Redraw,, ahk_class Progman
      }
   }

   cd_activeWindowHasChanged = ; no
   cd_DragStartWinID =
   cd_DraggingActive =
Return

; whrend eine Operation ESC gedrckt
cd_main_ComfortDrag_ESC:
   cd_DraggingActive =
   SetTimer, cd_tim_ShowTree, Off
   SetTimer, cd_tim_whileDragging, Off
   SetTimer, cd_tim_activateUnderMouse, Off

   If cd_temporaryTreeID <>
   {
      If (cd_HTMouseWinControl <> "SysTreeView321")
      {
         PostMessage, 0x111, 41525, 0, , ahk_id %cd_temporaryTreeID%
         cd_STMouseStartWinID =
         cd_hideTreeTimer =
         cd_temporaryTreeID =
      }

   }

   If HiddenWindows <>
   {
      GetKeyState, cd_CapsLockState, CapsLock, P

      If cd_CapsLockState = D
      {
         Send,{CapsLock}
         MouseGetPos,,, cd_activeStartWinID
         WinActivate, ahk_id %cd_activeStartWinID%
      }
      Gosub, cd_sub_RestoreHiddenWindows
   }
   If TempDeskWindows <>
   {
      Gosub, cd_sub_RestoreTempDeskWindows
   }

   If cd_activeWindowHasChanged = yes
   {
      WinGetTitle, test, ahk_id %cd_activeStartWinID%
      cd_activateUnderMouseTimer = off
      WinActivate, ahk_id %cd_activeStartWinID%
      WinSet, Redraw,, ahk_id %cd_activeStartWinID%
   }

   If cd_DragStartWinID <>
   {
      WinHide, ahk_class Progman
      WinShow, ahk_class Progman
   }
   cd_DragStartWinID =

   Send,{LButton Up}
Return

; Timer der so lange ausgefhrt wird, wie die linke Maustaste gerdckt ist
cd_tim_whileDragging:
   CoordMode,Mouse,Screen
   MouseGetPos, cd_actMouseX, cd_actMouseY, cd_actWinID

   If ( cd_lastMouseX = cd_actMouseX AND cd_lastMouseY = cd_actMouseY )
      Return

   cd_lastMouseX = %cd_actMouseX%
   cd_lastMouseY = %cd_actMouseY%
   cd_diffX := cd_MouseStartDragX - cd_actMouseX
   cd_diffY := cd_MouseStartDragY - cd_actMouseY
   Transform, cd_diffX, abs, %cd_diffX%
   Transform, cd_diffY, abs, %cd_diffY%
   If ( (cd_diffY < 5 AND cd_diffX < 5) OR cd_MouseStartControl = "")
      Return

   If ( cd_MouseStartCursor = "" OR (cd_actWinID = cd_DragStartWinID AND cd_MouseStartCursor = "Arrow") )
   {
      cd_MouseStartCursor = %A_Cursor%
      cd_DragStartWinID = %cd_actWinID%

      SetTimer, cd_tim_whileDragging, 500
   }

   cd_DraggingActive = 1
   ;sleep, 250

   ; Dragging beginnt (Maus hat sich mehr als 5 Pixel bewegt)
   If ( cd_MouseStartCursor = "IBeam" )
   {
      SetTimer, cd_tim_activateUnderMouse, Off
      cd_activateUnderMouseTimer = off
      Return
   }
   If cd_MouseStartCursor In Unknown,No
   {
      GetKeyState,cd_LButtonstate,LButton

      If cd_LButtonstate = D
      {
         WinGet, cd_activeWinID, ID, A
         MouseGetPos,cd_MouseX,,cd_MouseWinID
         WinGetTitle, cd_MouseWinTitle, ahk_id %cd_MouseWinID%
         WinGetClass, cd_MouseWinClass, ahk_id %cd_MouseWinID%

         If ( (cd_MouseX = WorkAreaLeft OR cd_MouseX = WorkAreaRight - 1 ) AND TempDeskWindows = "")
         {
            If cd_ExcludeApps <>
               If cd_MouseStartProcName contains %cd_ExcludeApps%
                  Return
            If (cd_TempDeskTimer = "")
            {
               SetTimer, cd_tim_activateUnderMouse, Off
               SetTimer, cd_tim_activateTempDesk, 480
               cd_TempDeskTimer = on
               cd_activateUnderMouseTimer = off
               cd_LastWin = TMPDSKaid
            }
         }
         Else
         {
            If (cd_activeWinID <> cd_MouseWinID)
            {
               cd_makeActiveWinID = %cd_MouseWinID%

               If cd_MouseWinClass not in Shell_TrayWnd,Progman,WorkerW,BaseBar
               {
                  If ( cd_activateUnderMouseTimer <> "on" )
                  {
                     cd_activateUnderMouseTimer = on
                     MouseGetPos, cd_startMouseX , cd_startMouseY
                     SetTimer, cd_tim_activateUnderMouse, 480
                  }
               }
               IfNotInstring, cd_MouseStartControl, TMPDSKaid
                  cd_LastWin =
            }
            Else
            {
               If cd_temporaryTreeID =
                  SetTimer, cd_tim_ShowTree, 450
            }
         }
      }
   }
Return

; Fenster unter der Maus aktivieren
cd_tim_activateUnderMouse:
   SetTimer, cd_tim_activateTempDesk, off
   cd_TempDeskTimer =

   CoordMode,Mouse,Screen
   MouseGetPos,,,cd_MouseStartWinID
   MouseGetPos, cd_endMouseX , cd_endMouseY
   cd_diffX := cd_startMouseX - cd_endMouseX
   cd_diffY := cd_startMouseY - cd_endMouseY
   Transform, cd_diffX, abs, %cd_diffX%
   Transform, cd_diffY, abs, %cd_diffY%

   If ( (cd_diffY < 5 AND cd_diffX < 5) )
   {
      If cd_makeActiveWinID = %cd_MouseStartWinID%
      {
         IfInString, cd_MouseWinTitle, TMPDSKaid
         {
            if cd_LastWin <> TMPDSKaid
            {
;               Run, nomousy.exe -h
               Gosub, cd_sub_RestoreTempDeskWindows
;               Run, nomousy.exe
               WinHide, ahk_class Progman
               WinShow, ahk_class Progman
            }
         }
         Else
         {
            cd_onlyHiddenWin =
            WinActivate, ahk_id %cd_makeActiveWinID%
            cd_activatedWindowsList = %cd_activatedWindowsList%%cd_makeActiveWinID%|
            cd_activeWindowHasChanged = yes
            WinGetClass, cd_WinClass, ahk_id %cd_makeActiveWinID%

            If cd_WinClass in CabinetWClass,ExploreWClass
               SetTimer, cd_tim_ShowTree, 450
         }
      }
   }

   SetTimer, cd_tim_activateUnderMouse, Off
   cd_activateUnderMouseTimer = off
Return

cd_tim_activateTempDesk:
   SetTimer, cd_tim_activateUnderMouse, Off
   SetTimer, cd_tim_activateTempDesk, Off
   cd_activeWindowHasChanged = yes
   Gosub, cd_main_ComfortDrag_TempDesk
   cd_TempDeskTimer =
Return

cd_sub_actImmediately:
   MouseGetPos,,,cd_makeActiveWinID
   cd_onlyHiddenWin =
   WinActivate, ahk_id %cd_makeActiveWinID%
   cd_activatedWindowsList = %cd_activatedWindowsList%%cd_makeActiveWinID%|
   cd_activeWindowHasChanged = yes
   SetTimer, cd_tim_activateUnderMouse, Off
   cd_activateUnderMouseTimer = off
Return

; Ordnerleiste einblenden
cd_tim_ShowTree:
   CoordMode, Mouse, RELATIVE

   If cd_temporaryTreeID <>
   {
      MouseGetPos, cd_MouseX,,cd_STMouseWinID,cd_STMouseWinControl
      If ((cd_STMouseWinID <> cd_temporaryTreeID OR cd_STMouseWinControl <> "SysTreeView321") and (cd_MouseX > 10 or cd_MouseX < 0))
      {
         If cd_hideTreeTimer <> on
         {
            SetTimer, cd_tim_HideTree, 400
            cd_hideTreeTimer = on
         }
      }

      Return
   }
   MouseGetPos, cd_MouseX,, cd_STMouseWinID
   WinGet, cd_STactiveWinID, ID, A
   WinGetClass, cd_WinClass, ahk_id %cd_STactiveWinID%

   If cd_STactiveWinID = %cd_STMouseWinID%
   {
      If cd_WinClass in CabinetWClass,ExploreWClass
      {
         If cd_MouseX < 10
         {
            ControlGet, cd_TreeVis, Visible,, SysTreeView321, ahk_id %cd_STactiveWinID%

            If cd_TreeVis < 1
            {
               SendMessage, 0x111, 41525, 0, , ahk_id %cd_STactiveWinID%

               cd_temporaryTreeID = %cd_STactiveWinID%
            }
            Else If cd_temporaryTreeID <>
            {
               MouseGetPos, cd_MouseX,,cd_STMouseWinID,cd_STMouseWinControl

               If ((cd_STMouseWinID <> cd_temporaryTreeID OR cd_STMouseWinControl <> "SysTreeView321") and (cd_MouseX > 10 or cd_MouseX < 0))
                  SetTimer, cd_tim_HideTree, 400
            }
         }
      }
   }
Return

; Ordnerleiste wieder verstecken
cd_tim_HideTree:
   CoordMode, Mouse, RELATIVE
   MouseGetPos, cd_MouseX,,cd_HTMouseWinID,cd_HTMouseWinControl

   If ((cd_HTMouseWinID <> cd_temporaryTreeID OR cd_HTMouseWinControl <> "SysTreeView321") and (cd_MouseX > 10 or cd_MouseX < 0))
   {
      SendMessage, 0x111, 41525, 0, , ahk_id %cd_temporaryTreeID%

      SetTimer, cd_tim_HideTree, Off
      cd_STMouseStartWinID =
      cd_hideTreeTimer =
      cd_temporaryTreeID =
   }
Return

; zustzlich rechte Maustaste gedrckt
cd_main_ComfortDrag_RButton:
   If Enable_ComfortDrag = 1
      Gosub, cd_sub_HideWindow
Return

; mit rechts angeklicktes Fenster verstecken
cd_sub_HideWindow:
   If (cd_HideOnlyOnDragging = 1 AND cd_DraggingActive = "")
      Return

   MouseGetPos, , , cd_actID, cd_actClass

   if (cd_onGestures = 1 AND cd_DraggingActive = "")
      If cd_actClass Contains %Gesture_Exclusions%
         If ( cd_actID = cd_MouseStartWinID AND HiddenWindows = "" AND cd_activeWindowHasChanged ="" )
         {
            Send, {RButton}
            Return
         }

   if (HiddenWindows = "" AND cd_activeWindowHasChanged = "")
      cd_onlyHiddenWin = yes

   MouseGetPos,,,cd_HWMouseWinID
   WinGetClass,cd_actClass, ahk_id %cd_HWMouseWinID%

   If cd_actClass not in Progman,Shell_TrayWnd,WorkerW,BaseBar
   {
      StringReplace, HiddenWindows, HiddenWindows, %cd_actID%|,
      HiddenWindows = %cd_actID%|%HiddenWindows%

      IniWrite, %HiddenWindows%, %ConfigFile%, HiddenWindows, WindowList

      WinMinimize, ahk_id %cd_actID%
      If cd_DragStartWinID <>
      {
         WinHide, ahk_class Progman
         WinShow, ahk_class Progman
      }
   }
   cd_activeWindowHasChanged = yes
Return

; zustzlich mittlere Maustaste gedrckt
cd_main_ComfortDrag_MButton:
   GetKeyState,cd_LButtonstate,LButton,P

   If cd_LButtonstate = D
      Gosub, cd_sub_ShowWindow
Return

; zuletzt verstecktes Fenster wiederholen oder zwischen zwei bereinander liegenden Fenstern wechseln
cd_sub_ShowWindow:
   MouseGetPos,,,cd_SWMouseWinID
   WinGet,cd_SWactiveWinID,ID,A

   If HiddenWindows <>
   {
      StringGetPos,cd_NextWinPos,HiddenWindows,|

      StringLeft, cd_Temp, HiddenWindows, %cd_NextWinPos%
      If cd_Temp =
         cd_Temp = %HiddenWindows%
      StringReplace, cd_Temp, cd_Temp, |,, a

      WinRestore, ahk_id %cd_Temp%

      If cd_Temp = cd_activeStartWinID
         WinActivate, ahk_id %cd_Temp%

      StringReplace, HiddenWindows, HiddenWindows, %cd_Temp%|,
      IniWrite, %HiddenWindows%, %ConfigFile%, HiddenWindows, WindowList

   }
   Else If A_Cursor <> IBeam
   {
      If ( cd_SWactiveWinID = cd_SWMouseWinID and cd_allWindowsRestored = "" )
      {
         Gosub, cd_sub_WindowBehind

         If cd_FoundID
         {
            WinActivate, ahk_id %cd_FoundID%
            cd_activeStartWinID = %cd_FoundID%
         }
      }
      Else
      {
         If cd_allWindowsRestored =
         {
            WinActivate, ahk_id %cd_SWMouseWinID%
         }
         Else
         {
            WinActivate, ahk_id %cd_activeStartWinID%
            cd_allWindowsRestored =
         }
      }
   }

   cd_activeWindowHasChanged = yes

   MButton_send = no
Return

; kurzfristiger Desktop
cd_main_ComfortDrag_TempDesk:
   DetectHiddenWindows, Off

;   If Debug = 1
;      tooltip, cd_main_ComfortDrag_TempDesk:`nzuletzt erkanntes Hotkey: %A_ThisHotkey%`n`nDieser Hinweis verschwindet`, wenn Debug in der ac'tivAid.ini auf 0 gesetzt wird.

   If cd_NoTempDesk = 1
      Return
   If Enable_ComfortDrag = 1
   If cd_onTempDesk = 1
   {
      If cd_DraggingActive = 1
      {
         WinSet, Redraw,, ahk_class Progman
      }
      StringReplace, cd_LastHotkey, A_ThisHotkey, $,

      If TempDeskWindows =
      {
         ;Hotkey, $+ESC, On
         ;Hotkey, $ESC, On
         Hotkey,~*ESC, On

         SetTimer, cd_tim_activateUnderMouse, Off
         cd_activateUnderMouseTimer = off

         CoordMode, Mouse, Screen
         MouseGetPos, cd_MouseX, cd_MouseY, testID

         DetectHiddenWindows, Off
         WinGet, cd_List, List,,, Program Manager ; Lister alle sichtbaren Fenster auer Desktop

         cd_FirstWindowFound := False

         Gosub, sub_temporarySuspend

         TempDeskWindows =
         cd_FirstMax =
         WinGet, cd_WinBeforeTD, ID, A

         ;FileDelete, ErrorLog.txt

         Loop, %cd_MoveStepsOut%
         {
            cd_MoveCount := A_Index

            Loop %cd_List%  ; Alle sichtbaren Fenster durchgehen
            {
               cd_Index := A_Index

               cd_ID := cd_List%cd_Index%
               WinGetClass, cd_class, ahk_id %cd_ID%

               If cd_class Not In Progman,Shell_TrayWnd,WorkerW,BaseBar
               {
                  WinGetPos, cd_ListX, cd_ListY,cd_ListW,cd_ListH, ahk_id %cd_ID%
                  WinGet, cd_ListMax, MinMax, ahk_id %cd_ID%

                  If (cd_ListMax = 1 AND cd_FullScreenFix <> 0)
                  {
                     WinRestore, ahk_id %cd_ID%
                     WinGetPos, cd_2ListX, cd_2ListY,cd_2ListW,cd_2ListH, ahk_id %cd_ID%

                     StringReplace, TempDeskWindowsToMaximize, TempDeskWindowsToMaximize, %cd_ID%|,,
                     TempDeskWindowsToMaximize = %TempDeskWindowsToMaximize%%cd_ID%|
                     If cd_FirstMax =
                        cd_FirstMax = %cd_Index%
                  }
                  If cd_MoveCount <> 1
                  {
                     cd_ListX := TempDeskWindowX[%cd_ID%]
                     cd_ListY := TempDeskWindowY[%cd_ID%]
                  }
                  If (cd_MoveCount = 1 AND cd_Index <= cd_FirstMax)
                     WinSet, Top,, ahk_id %cd_ID%

                  If (cd_ListX = -32000 OR cd_ListY = -32000 OR cd_ListMax = -1)
                     continue

                  If (cd_ListX-WorkAreaLeft > WorkAreaRight-(cd_ListX+cd_ListW))
                     WinMove, ahk_id %cd_ID%,,% cd_ListX+((WorkAreaRight-cd_ListX-20)/(cd_MoveStepsOut) * (cd_MoveCount)),%cd_ListY%,%cd_ListW%,%cd_ListH%
                  Else
                     WinMove, ahk_id %cd_ID%,,% cd_ListX+((WorkAreaLeft+20-cd_ListW-cd_ListX)/(cd_MoveStepsOut) * (cd_MoveCount)),%cd_ListY%,%cd_ListW%,%cd_ListH%

                  If cd_MoveCount = 1
                  {
                     ;FileAppend, %cd_class%`n, ErrorLog.txt

                     TempDeskWindows := TempDeskWindows cd_ID "|"
                     TempDeskWindowsRwd := cd_ID "|" TempDeskWindows
                     TempDeskWindowX[%cd_ID%] := cd_ListX
                     TempDeskWindowY[%cd_ID%] := cd_ListY
                     TempDeskWindowMax[%cd_ID%] := cd_ListMax
                     TempDeskWindowX2[%cd_ID%] := cd_2ListX
                     TempDeskWindowY2[%cd_ID%] := cd_2ListY
                     TempDeskWindowH2[%cd_ID%] := cd_2ListH
                     TempDeskWindowW2[%cd_ID%] := cd_2ListW
                  }
               }
            }
         }

         WorkAreaRight := WorkAreaRight-20
         SplashImage,6:,B X%WorkAreaLeft% Y%WorkAreaTop% W20 H%WorkAreaHeight% CW000000,,,TMPDSKaid1
;         WinMove, TMPDSKaid1,, %WorkAreaLeft%
         WinSet,Transparent,128,TMPDSKaid1
         SplashImage,7:,B X%WorkAreaRight% Y%WorkAreaTop% W20 H%WorkAreaHeight% CW000000,,,TMPDSKaid2
;         WinMove, TMPDSKaid2,, %WorkAreaRight%
         WinSet,Transparent,128,TMPDSKaid2

         WorkAreaRight := WorkAreaRight+20

         IniWrite, %TempDeskWindows%, %ConfigFile%, TemporaryDesktop, Windows
         IniWrite, %TempDeskWindowsToMaximize%, %ConfigFile%, TemporaryDesktop, WindowsToMaximize
         Loop, Parse , TempDeskWindows, |
         {
            IniWrite, % TempDeskWindowX[%A_LoopField%], %ConfigFile%, TemporaryDesktop, WindowPosX%A_LoopField%
            IniWrite, % TempDeskWindowY[%A_LoopField%], %ConfigFile%, TemporaryDesktop, WindowPosY%A_LoopField%
            IniWrite, % TempDeskWindowMax[%A_LoopField%], %ConfigFile%, TemporaryDesktop, WindowMax%A_LoopField%
         }

         WinActivate, ahk_class Progman
;         WinSet, Redraw,, ahk_class Progman
         WinGet, cd_lastTDwinID, ID, A

         Gosub, sub_temporarySuspend
         SetTimer, cd_tim_TempDeskWatcher, 100
      }
      Else
      {
         ;Hotkey,$+ESC, Off
         ;Hotkey,$ESC, Off
         Hotkey,~*ESC, off
         Gosub, cd_sub_RestoreTempDeskWindows
;         WinSet, Redraw,, ahk_class Progman
      }
      If cd_DraggingActive = 1
      {
         WinSet, Redraw,, ahk_class Progman
         WinActivate, ahk_class Progman
         Send, {F5}
      }
   }
Return

; Fenster fr kurzfristigen Desktop wiederherstellen
cd_sub_RestoreTempDeskWindows:
   SetTimer, cd_tim_TempDeskWatcher, Off
   DetectHiddenWindows, On
   SplashImage,6:Off
   SplashImage,7:Off
   Sleep,10

   Gosub, sub_temporarySuspend

   If TempDeskWindows <>
   {
      TempDeskWindowsNew = %TempDeskWindows%
      Loop, % cd_MoveStepsIn
      {
         cd_MoveCount := cd_MoveStepsIn-A_Index
         Loop, Parse, TempDeskWindows, |
         {
            If (cd_MoveCount = cd_MoveStepsIn-1 AND cd_FullScreenFix = 1)
               WinRestore, ahk_id %A_LoopField%

            cd_ListX := TempDeskWindowX[%A_LoopField%]
            cd_ListY := TempDeskWindowY[%A_LoopField%]
            cd_ListMax := TempDeskWindowMax[%A_LoopField%]
            If (A_LoopField = "" OR cd_ListMax = -1 OR cd_ListX = -32000 OR cd_ListY = -32000)
               continue
            WinGetPos,,,cd_ListW,, ahk_id %A_LoopField%


            ;If (cd_ListX + cd_XAdd  > WorkAreaRight-cd_ListX-cd_ListW)
            If cd_ListX-WorkAreaLeft > WorkAreaRight-(cd_ListX+cd_ListW)
               WinMove, ahk_id %A_LoopField%,,% cd_ListX+((WorkAreaRight-cd_ListX-20)/(cd_MoveStepsIn) * (cd_MoveCount))
            Else
               WinMove, ahk_id %A_LoopField%,,% cd_ListX+((WorkAreaLeft+20-cd_ListW-cd_ListX)/(cd_MoveStepsIn) * (cd_MoveCount))

            If cd_MoveCount = 0
            {
               StringReplace,TempDeskWindowsNew,TempDeskWindowsNew,%A_LoopField%|,
               TempDeskWindowX[%A_LoopField%] =
               TempDeskWindowY[%A_LoopField%] =
               TempDeskWindowMax[%A_LoopField%] =
               IniDelete, %ConfigFile%, TemporaryDesktop, WindowPosX%A_LoopField%
               IniDelete, %ConfigFile%, TemporaryDesktop, WindowPosY%A_LoopField%
               IniDelete, %ConfigFile%, TemporaryDesktop, WindowMax%A_LoopField%
            }


            If (cd_ListMax = 1 AND cd_MoveCount = 0 )
            {
               StringReplace, TempDeskWindowsToMaximize, TempDeskWindowsToMaximize, %A_LoopField%|,,
               TempDeskWindowsToMaximize = %TempDeskWindowsToMaximize%%A_LoopField%|
            }

         }
      }

      TempDeskWindows = %TempDeskWindowsNew%
      IniWrite, %TempDeskWindows%, %ConfigFile%, TemporaryDesktop, Windows
   }

   If (cd_WinBeforeTD <> "" AND cd_activeWindowHasChanged = "")
   {
      WinActivate, ahk_id %cd_WinBeforeTD%
      IfInString, TempDeskWindowsToMaximize, %cd_WinBeforeTD%|
      {
         StringReplace, TempDeskWindowsToMaximize, TempDeskWindowsToMaximize, %cd_WinBeforeTD%|,,
         If cd_FullScreenFix = 1
            WinMove, ahk_id %cd_WinBeforeTD%,, % TempDeskWindowX2[%cd_WinBeforeTD%], % TempDeskWindowY2[%cd_WinBeforeTD%], % TempDeskWindowW2[%cd_WinBeforeTD%], % TempDeskWindowH2[%cd_WinBeforeTD%]
         WinMaximize, ahk_id %cd_WinBeforeTD%
      }
   }
   IniWrite, %TempDeskWindowsToMaximize%, %ConfigFile%, TemporaryDesktop, WindowsToMaximize

   cd_WinBeforeTD =

   Gosub, sub_temporarySuspend
Return

cd_tim_TempDeskWatcher:
   WinGet, cd_TDwinID, ID, A
   if cd_TDwinID = %cd_lastTDwinID%
      return

   cd_lastTDwinID = %cd_TDwinID%

   IfInString, TempDeskWindows, %cd_TDwinID%|
      cd_Temp = %cd_TDwinID%
   Else
      cd_Temp =

   cd_ListX := TempDeskWindowX[%cd_Temp%]
   cd_ListY := TempDeskWindowY[%cd_Temp%]
   cd_ListMax := TempDeskWindowMax[%cd_Temp%]
   WinGetPos,,,cd_ListW,, ahk_id %cd_Temp%

   If (cd_Temp = "" OR cd_ListX = "" OR cd_ListMax = -1 OR cd_ListX = -32000 OR cd_ListY = -32000)
      return

   Gosub, sub_temporarySuspend

   Loop, % cd_MoveStepsIn
   {
      cd_MoveCount := cd_MoveStepsIn-A_Index

      If (cd_ListX > WorkAreaRight-cd_ListX-cd_ListW)
         WinMove, ahk_id %cd_temp%,,% cd_ListX+((WorkAreaRight-cd_ListX-20)/(cd_MoveStepsIn) * (cd_MoveCount))
      Else
         WinMove, ahk_id %cd_temp%,,% cd_ListX+((WorkAreaLeft+20-cd_ListW-cd_ListX)/(cd_MoveStepsIn) * (cd_MoveCount))

      If (cd_ListMax = 1 AND cd_MoveCount = 0)
      {
         If cd_FullScreenFix = 1
            WinMove, ahk_id %cd_temp%,, % TempDeskWindowX2[%cd_temp%], % TempDeskWindowY2[%cd_temp%], % TempDeskWindowW2[%cd_temp%], % TempDeskWindowH2[%cd_temp%]
         WinMaximize, ahk_id %cd_temp%
      }

   }
   StringReplace,TempDeskWindows,TempDeskWindows,%cd_temp%|,
   TempDeskWindowX[%cd_temp%] =
   TempDeskWindowY[%cd_temp%] =
   TempDeskWindowMax[%cd_temp%] =
   IniDelete, %ConfigFile%, TemporaryDesktop, WindowPosX%cd_temp%
   IniDelete, %ConfigFile%, TemporaryDesktop, WindowPosY%cd_temp%
   IniDelete, %ConfigFile%, TemporaryDesktop, WindowMax%cd_temp%
   IniWrite, %TempDeskWindows%, %ConfigFile%, TemporaryDesktop, Windows

   cd_WinBeforeTD = %cd_Temp%
   cd_List%cd_TempIndex% =

   If TempDeskWindows =
      Gosub, cd_sub_RestoreTempDeskWindows

   Gosub, sub_temporarySuspend
Return

; Einzeln versteckte Fenster wiederherstellen
cd_sub_RestoreHiddenWindows:
   If HiddenWindows <>
   {
      Loop, Parse, HiddenWindows, |
      {
         If A_LoopField =
            continue

         WinRestore, ahk_id %A_LoopField%
         StringReplace, HiddenWindows, HiddenWindows, %A_LoopField%|
      }

      IniWrite, %HiddenWindows%, %ConfigFile%, HiddenWindows, WindowList
      IfWinNotActive, ahk_id %cd_activeStartWinID%
         WinActivate, ahk_id %cd_activeStartWinID%
   }
Return

; Unterroutine, um zwischen zwei verdeckten Fenstern zu wechseln.
cd_sub_WindowBehind:
   CoordMode, Mouse
   MouseGetPos, cd_MouseX, cd_MouseY
   WinGet, cd_List, List,,, Program Manager

   cd_FirstWindowFound := False
   cd_FoundID =

   Loop %cd_List%
   {
      cd_ID := cd_List%A_Index%
      WinGetPos, cd_WinX, cd_WinY, cd_WinW, cd_WinH, ahk_id %cd_ID%

      If (cd_MouseX > cd_WinX and cd_MouseY > cd_WinY and cd_MouseX < cd_WinX+cd_WinW and cd_MouseY < cd_WinY+cd_WinH)
      {
         If cd_FirstWindowFound
         {
            cd_FoundID := cd_ID
            Break
         }
         Else
            cd_FirstWindowFound := True
      }
   }
Return

;<---ComfortDrag---



;---MouseClip--->
; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               MouseClip
; -----------------------------------------------------------------------------
; Prefix:             mc_
; Version:            0.8
; Date:               2006-01-25
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================mc==
; -----------------------------------------------------------------------------

init_MouseClip:
   Prefix = mc
   %Prefix%_ScriptName   = MouseClip
   %Prefix%_ScriptVersion = 0.8
   %Prefix%_Author        = Wolfgang Reszel

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName  = %mc_ScriptName% - Kopieren/Einfgen mit der Maus
      Description = Kopieren und Einfgen mit der mittleren Maustaste
      lng_mc_copied               = kopiert
      lng_mc_PasteOnSingleClick   = Zwischenablage an Mausposition einfgen, wenn die mittlere Maustaste kurz gedrckt wird.
      lng_mc_PasteOnSingleClick1  = nein
      lng_mc_PasteOnSingleClick2  = ja
      lng_mc_PasteOnSingleClick3  = nur wenn Text markiert ist
      lng_mc_AlwaysAllowClasses   = MouseClip in folgenden Fenster-Klassen auch bei nicht sichtbaren Einfge-Cursor erlauben (Die programmeigene Untersttzung der mittleren Maustaste wird dabei grtenteils auer Kraft gesetzt!)
      lng_mc_DisableClasses       = `n`nMouseClip in folgenden Fenster-Klassen ignorieren (Programme verhalten sich wie bei deaktiviertem MouseClip)
   }
   else        ; = other languages (english)
   {
      MenuName  = %mc_ScriptName% - Copy/Paste with Mouse
      Description = copy and paste with the middle mousebutton
      lng_mc_copied = copied
      lng_mc_PasteOnSingleClick   = Paste clipboard to cursor-position wit the middle mouse-button.
      lng_mc_PasteOnSingleClick1  = no
      lng_mc_PasteOnSingleClick2  = yes
      lng_mc_PasteOnSingleClick3  = only if text is selected
      lng_mc_AlwaysAllowClasses   = `n`nAllow MouseClip also in the following controls or window classes, even if there is no text-cursor visible
      lng_mc_DisableClasses       = `n`n`nDisable MouseClip in in the following controls or window classes
   }

   IniRead, mc_PasteOnSingleClick, %ConfigFile%, %mc_ScriptName%, PasteOnSingleClick, 2

   IniRead, mc_AllowClasses, %ConfigFile%, %mc_ScriptName%, AlwaysAllowClasses, MozillaWindowClass1,MozillaWindowClass2,MozillaWindowClass11,MozillaWindowClass9
   IniRead, mc_DisableClasses, %ConfigFile%, %mc_ScriptName%, DisableClasses, PuTTY,ConsoleWindowClass
Return

SettingsGui_MouseClip:
   StringReplace, mc_AllowClassesCR, mc_AllowClasses, `,, `n, a
   StringReplace, mc_DisableClassesCR, mc_DisableClasses, `,, `n, a

   Gui, Add, Text, xs+10 y+10, %lng_mc_PasteOnSingleClick%
   Gui, Add, Radio, xs+10 y+5 -Wrap gsub_CheckIfSettingsChanged vmc_PasteOnSingleClick1,%lng_mc_PasteOnSingleClick1%
   Gui, Add, Radio, x+5 -Wrap gsub_CheckIfSettingsChanged vmc_PasteOnSingleClick2,%lng_mc_PasteOnSingleClick2%
   Gui, Add, Radio, x+5 -Wrap gsub_CheckIfSettingsChanged vmc_PasteOnSingleClick3,%lng_mc_PasteOnSingleClick3%
   GuiControl,,mc_PasteOnSingleClick%mc_PasteOnSingleClick%, 1
   Gui, Add, Text, xs+10 ys+63 r5 w220, %lng_mc_AlwaysAllowClasses%:
   Gui, Add, Edit, xs+10 ys+135 W200 R10 gsub_CheckIfSettingsChanged vmc_AllowClasses,%mc_AllowClassesCR%
   Gui, Add, Button, xs+215 yp+0 W21 gmc_sub_GetClass, +
   Gui, Add, Text, xs+270 ys+63 r5 w220, %lng_mc_DisableClasses%:
   Gui, Add, Edit, xs+270 ys+135 W200 R10 gsub_CheckIfSettingsChanged vmc_DisableClasses,%mc_DisableClassesCR%
   Gui, Add, Button, xs+475 yp+0 W21 gmc_sub_GetDisableClass, +
Return

SaveSettings_MouseClip:
   If mc_PasteOnSingleClick1 = 1
      mc_PasteOnSingleClick = 1
   If mc_PasteOnSingleClick2 = 1
      mc_PasteOnSingleClick = 2
   If mc_PasteOnSingleClick3 = 1
      mc_PasteOnSingleClick = 3
   IniWrite, %mc_PasteOnSingleClick%, %ConfigFile%, %mc_ScriptName%, PasteOnSingleClick
   StringReplace, mc_AllowClasses, mc_AllowClasses, `n, `,, a
   StringReplace, mc_DisableClasses, mc_DisableClasses, `n, `,, a
   IniWrite, %mc_AllowClasses%, %ConfigFile%, %mc_ScriptName%, AlwaysAllowClasses
   IniWrite, %mc_DisableClasses%, %ConfigFile%, %mc_ScriptName%, DisableClasses
Return

CancelSettings_MouseClip:
Return

DoEnable_MouseClip:
   Hotkey, $MButton, On
   Hotkey, $MButton Up, On
Return

DoDisable_MouseClip:
   Hotkey, $MButton, Off
   Hotkey, $MButton Up, Off
Return

DefaultSettings_MouseClip:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =============================================================mc==
; -----------------------------------------------------------------------------


; -----------------------------------------------------------------------------
; === Subroutines =========================================================mc==
; -----------------------------------------------------------------------------

mc_main_MouseClip:
   SetKeyDelay,0,0
   SetMouseDelay,-1

   CoordMode,Mouse,Screen

   MouseGetPos, mc_MouseStartX, mc_MouseStartY, mc_MouseStartWinID, mc_mouseStartClass
   WinGetTitle, mc_mouseStartTitle, ahk_id %mc_mouseStartWinID%

   If mc_mouseStartClass =
      WinGetClass, mc_mouseStartClass, ahk_id %mc_mouseStartWinID%

   If mc_mouseStartClass in %mc_DisableClasses%
      Return

   ; Adobe-Anwendung erkennen
   StringLeft, mc_mouseStartTitle, mc_mouseStartTitle, 6
   If (mc_mouseStartTitle = "Adobe ")
      mc_mouseStartTitle = Adobe

   mc_doit =
   ; wenn mittlere Maustaste gedrckt und der Textmauspfeil (IBeam) sichtbar ist
   If (A_Cursor = "IBeam" OR (A_Cursor = "Unknown" AND mc_mouseStartClass="_WwG1") OR (A_Cursor = "Arrow" AND mc_mouseStartClass="_WwG1") OR (A_Cursor = "Unknown" AND mc_mouseStartTitle = "Adobe") )
      mc_doit = 1

   If mc_mouseStartClass in %mc_AllowClasses%
      mc_doit = 1

   If mc_doit = 1
   {
      func_GetSelection(0, 0, 0.1)
      mc_cliptemp_text := Selection
      Send,{LButton Down}

      mc_TimeTillRelease = %A_Tickcount%

      KeyWait,MButton

      mc_TimeTillRelease := A_Tickcount - mc_TimeTillRelease

      MouseGetPos, mc_MouseEndX, mc_MouseEndY
      mc_diffX := abs(mc_MouseStartX - mc_MouseEndX)
      mc_diffY := abs(mc_MouseStartY - mc_MouseEndY)

      Send, {LButton Up}

      If mc_mouseStartTitle contains Adobe
         SetKeyDelay,20,10

      If ( mc_TimeTillRelease > 100 AND ( mc_diffX > 4 OR mc_diffY > 4 ) )
      {
         func_GetSelection(0,1)
         ToolTip, %lng_mc_copied%

         If mc_mouseStartTitle contains Adobe
         {
            WinActivate,ahk_class Progman           ; Aktiviert kurz den Desktop
            ClipWait,1
            WinActivate,ahk_ID %mc_MouseStartWinID% ; und dann wieder die ursprngliche Anwendung
         }

         Sleep,400
         ToolTip
      }
      Else
      {
         If mc_TimeTillRelease < 600
         {
            If (mc_cliptemp_text <> "" AND mc_PasteOnSingleClick > 1)
            {
               Clipboard = %mc_cliptemp_text%
               ToolTip, %lng_mc_copied%
            }

            Clipboard = %Clipboard%

            MouseGetPos,,,mc_actID
            IfWinNotActive, ahk_id %mc_actID%
            {
               WinActivate, ahk_id %mc_actID%
               WinWaitActive, ahk_id %mc_actID%
            }

            If mc_mouseStartTitle contains Adobe,Microsoft Word
            {
               WinActivate,ahk_class Progman           ; Aktiviert kurz den Desktop
               WinActivate,ahk_ID %mc_MouseStartWinID% ; und dann wieder die ursprngliche Anwendung
            }

            If ( mc_PasteOnSingleClick = 2 OR ( mc_cliptemp_text <> "" AND mc_PasteOnSingleClick = 3 ) )
            {
               If mc_NoPaste =
                  Send,^v
               ToolTip
            }
         }
      }
      MButton_send = no
   }
   Else
   {
      If Enable_WebSearchOnMButton = 1
         MButton_send = no2
      Else
         MButton_send =
   }
Return

mc_sub_GetDisableClass:
   mc_ClassList = 1
mc_sub_GetClass:
   Gui, 1:Cancel
   Gosub, sub_temporarySuspend
   MsgBox, 1, ,%lng_getClassMsg%
   IfMsgBox, OK
   {
      SetTimer, mc_tim_GetClass, 10
      Input,mc_GetKey,,{Enter}{ESC}
      SetTimer, mc_tim_GetClass, Off
      ToolTip
   }
   Else
      ErrorLevel = Endkey:Escape
   Gosub, sub_temporarySuspend
   Gui, 1:Show
   If ErrorLevel = Endkey:Escape
      Return
   If mc_ClassList =
   {
      GuiControlGet, mc_AllowClasses_tmp,, mc_AllowClasses
      StringReplace, mc_AllowClasses_tmp, mc_AllowClasses_tmp, `n, %A_Tab%, All
      AutoTrim, On
      mc_AllowClasses_tmp = %mc_AllowClasses_tmp%
      AutoTrim, Off
      StringReplace, mc_AllowClasses_tmp, mc_AllowClasses_tmp, %A_Tab%, `n, All
      GuiControl,,mc_AllowClasses, %mc_AllowClasses_tmp%`n%mc_GetClass%
      GuiControl,Focus,mc_AllowClasses
   }
   Else
   {
      GuiControlGet, mc_DisableClasses_tmp,, mc_DisableClasses
      StringReplace, mc_DisableClasses_tmp, mc_DisableClasses_tmp, `n, %A_Tab%, All
      AutoTrim, On
      mc_DisableClasses_tmp = %mc_DisableClasses_tmp%
      AutoTrim, Off
      StringReplace, mc_DisableClasses_tmp, mc_DisableClasses_tmp, %A_Tab%, `n, All
      GuiControl,,mc_DisableClasses, %mc_DisableClasses_tmp%`n%mc_GetClass%
      GuiControl,Focus,mc_DisableClasses
   }
   Send,^{End}{Space}{BS}
   mc_ClassList =
Return

mc_tim_GetClass:
   MouseGetPos,,,,mc_getClass
   If mc_getClass =
      WinGetClass,mc_getClass,A
   ToolTip, %mc_getClass%
Return

;<---MouseClip---

; -----------------------------------------------------------------------------
; === Functions ===============================================================
; -----------------------------------------------------------------------------

func_HotkeyAddGuiControl( Text, Variable, Options, SingleKey="" )
{
   global

   gsub_Hotkey =
   IfNotInstring, Options, sub_
      gsub_Hotkey = gsub_HotkeyButton

   If SingleKey <>
      SingleHotkey_%Variable% = 1
   Else
      SingleHotkey_%Variable% =

   If Text =
   {
      Gui, Add, Button, -Wrap +0x100 +0x8000 H20 %Options% vHotkey_%Variable% %gsub_Hotkey%, % "  " func_HotkeyDecompose(Hotkey_%Variable%, 0 )
      func_CreateListOfHotkeys( Hotkey_%Variable%, Function " (" Variable ")", Function )
   }
   Else
   {
      Gui, Add, Text, %Options%, %Text%:
      Gui, Add, Button, -Wrap +0x100 +0x8000 H20 W300 X+5 YP-3 vHotkey_%Variable% %gsub_Hotkey%, % "  " func_HotkeyDecompose(Hotkey_%Variable%, 0 )
      Hotkey_ExtensionText[%Variable%] := Text
      func_CreateListOfHotkeys( Hotkey_%Variable%, Text, Function )
   }
}

func_CreateListOfHotkeys( Hotkey, Text, Extension )
{
   Global

   If Hotkey  <>
   {
      HotkeyIndent := func_StrLeft( " " func_HotkeyDecompose(Hotkey) "                                                   ", 40 )
      If Readme_Hotkeys_LastExt <> %Extension%
         Readme_Hotkeys := Readme_Hotkeys "`r`n`r`n_____________________________________________________________________________`r`n " Function "`r`n"
      If Text = %lng_Hotkey%
         Text = %Extension%
      StringReplace, Text, Text, `n, %A_Space%, A
      Readme_Hotkeys := Readme_Hotkeys "`r`n" func_StrLeft(HotkeyIndent Text,77)
      Readme_Hotkeys_LastExt = %Extension%
   }
}

func_HotkeyRead( OutputVar, Filename, Section, Key, SubRoutine, DefaultValue, Prefix="" )
{
   global

   IniRead, Hotkey_%OutputVar%, %Filename%, %Section%, %Key%
   if Hotkey_%OutputVar% = ERROR
      Hotkey_%OutputVar% = %DefaultValue%

   HotkeyPrefix_%OutputVar% = %Prefix%

   if Hotkey_%OutputVar% <>
   {
      Hotkey, % HotkeyPrefix_%OutputVar% Hotkey_%OutputVar%, %SubRoutine%
      Hotkey_AllHotkeys := Hotkey_AllHotkeys "" Hotkey_%OutputVar% ""
      Hotkey_Extension[%Section%$%OutputVar%] := Hotkey_%OutputVar%
      Hotkey_Extensions := Hotkey_Extensions Section "$" OutputVar "|"
      Hotkey_%OutputVar%_new := Hotkey_%OutputVar%
   }

   Hotkey_%OutputVar%_Sub := SubRoutine
   Hotkey_%OutputVar%_old := Hotkey_%OutputVar%
}

func_HotkeyWrite( OutputVar, Filename, Section, Key, SubRoutine="", Prefix="" )
{
   global

   If Prefix <>
      HotkeyPrefix_%OutputVar% = %Prefix%
   If Hotkey_%OutputVar%_old <>
   {
      Hotkey, % HotkeyPrefix_%OutputVar% Hotkey_%OutputVar%_old, Off
   }

   If ( Hotkey_%OutputVar%_new <> Hotkey_%OutputVar% OR Hotkey_%OutputVar%_del = "1")
   {
      If Hotkey_%OutputVar%_del = 1
         Hotkey_%OutputVar% =
      Else
         Hotkey_%OutputVar% := Hotkey_%OutputVar%_new
      Hotkey_%OutputVar%_del =
      StringReplace, Hotkey_AllHotkeys, Hotkey_AllHotkeys, % "" Hotkey_%OutputVar%_old "", , A
      Hotkey_Extension[%Section%$%OutputVar%] := Hotkey_%OutputVar%
      StringReplace, Hotkey_Extensions, Hotkey_Extensions, % Section "$" OutputVar "|", , A
   }


   IniWrite, % Hotkey_%OutputVar%, %Filename%, %Section%, %Key%

   if Hotkey_%OutputVar% <>
   {
      If SubRoutine <>
         Hotkey_%OutputVar%_Sub = %SubRoutine%
      Hotkey, % HotkeyPrefix_%OutputVar% Hotkey_%OutputVar%, % Hotkey_%OutputVar%_Sub
      StringReplace, Hotkey_AllHotkeys, Hotkey_AllHotkeys, % "" Hotkey_%OutputVar%_Old "", , A
      Hotkey_AllHotkeys := Hotkey_AllHotkeys "" Hotkey_%OutputVar% ""
      Hotkey_Extension[%Section%$%OutputVar%] := Hotkey_%OutputVar%
      Hotkey_Extensions := Hotkey_Extensions Section "$" OutputVar "|"
   }

   Hotkey_%OutputVar%_old := Hotkey_%OutputVar%
}

func_HotkeyEnable( Variable )
{
   global

   If Hotkey_%Variable% <>
      Hotkey, % HotkeyPrefix_%Variable% Hotkey_%Variable%, On
}

func_HotkeyDisable( Variable )
{
   global

   If Hotkey_%Variable% <>
      Hotkey, % HotkeyPrefix_%Variable% Hotkey_%Variable%, Off
}

func_HotkeyGetNumber( Array, Amount, Prefix="", Hotkey="" )
{
   global

   StringLen, PrefixLen, Prefix
   If Hotkey =
      StringTrimLeft, ThisHotkey, A_ThisHotkey, %PrefixLen%
   Else
      ThisHotkey = %Hotkey%

   Loop, %Amount%
   {
      If ( Hotkey_%Array%%A_Index% = ThisHotkey )
         Return %A_Index%
   }
}

func_HotkeyGetVar( HotkeyArray, Amount, GetArray, CustomHotkey="",Prefix=""  )
{
   global
   StringLen, PrefixLen, Prefix
   StringTrimLeft, ThisHotkey, A_ThisHotkey, %PrefixLen%
   Loop, %Amount%
   {
      If ( Hotkey_%HotkeyArray%%A_Index% = ThisHotkey AND CustomHotkey = "")
         Return % %GetArray%%A_Index%
      Else If ( Hotkey_%HotkeyArray%%A_Index% = CustomHotkey AND CustomHotkey <> "")
         Return % %GetArray%%A_Index%
   }
}

sub_HotkeyButton:
   Critical
   If (PreWinStateD <> 2)
   {
      StringReplace, VarHK, A_GuiControl, Button,

      StringReplace, VarHKCL, A_GuiControl, Button,CapsLock
      StringReplace, VarHKW, A_GuiControl, Button,Win
      Gui,+Disabled

      If A_OSversion = WIN_NT4
         StringReplace, Hotkey_DupMessage, Hotkey_DupMessage, , --, All

      If Single%VarHK% = 1
         SplashImage,,b1 cwFFFF80 FS9 WS700 w400, %Hotkey_DupMessage%%lng_GetSingleKey%
      Else
         SplashImage,,b1 cwFFFF80 FS9 WS700 w400, %Hotkey_DupMessage%%lng_GetKey%
   }
   Hotkey_DupMessage =

   Gosub, sub_temporarySuspend
   Input,GetKey, L1 *,{PrintScreen}{ScrollLock}{Pause}{PgUp}{PgDn}{Home}{End}{Ins}{Del}{BackSpace}{F1}{F2}{F3}{F4}{F5}{F6}{F7}{F8}{F9}{F10}{F11}{F12}{F13}{F14}{F15}{F16}{F17}{F18}{F19}{F20}{F21}{F22}{F23}{F24}{F25}{F26}{F27}{F28}{F29}{F30}{Space}{Left}{Right}{Up}{Down}{NumLock}{NumPad1}{NumPad2}{NumPad3}{NumPad4}{NumPad5}{NumPad6}{NumPad7}{NumPad8}{NumPad9}{NumPad0}{NumPadAdd}{NumPadSub}{NumPadMult}{NumPadDiv}{NumPadDot}{NumPadEnter}{NumPadDot}abcdefghijklmnopqrstuvwxyz1234567890!"$`%&/()=+#-.`,*'_:`;<>^``{AppsKey}{Esc}{Tab}{Enter}{CtrlBreak}{Help}{Sleep}{Browser_Back}{Browser_Forward}{Browser_Refresh}{Browser_Stop}{Browser_Search}{Browser_Favorites}{Browser_Home}{Volume_Mute}{Volume_Down}{Volume_Up}{Media_Next}{Media_Prev}{Media_Stop}{Media_Play_Pause}{Launch_Mail}{Launch_Media}{Launch_App1}{Launch_App2}{NumpadDel}{NumpadIns}{NumpadClear}{NumpadUp}{NumpadDown}{NumpadLeft}{NumpadRight}{NumpadHome}{NumpadEnd}{NumpadPgUp}{NumpadPgDn}[]\?|~{{}{}}
   Gosub, sub_temporarySuspend

   If ErrorLevel contains Endkey:
      StringReplace, GetKey, ErrorLevel, Endkey:,

   If (GetKey = Chr(34) And Lng = 07)
      GetKey = 2
   If (GetKey = "AKUT" OR GetKey = "ACUTE" OR GetKey = "ACCENT")
      GetKey = 
   If (GetKey = "ZIRKUMFLEX" OR GetKey = "ZIRCUMFLEX" OR GetKey = "CIRCUMFLEX")
      GetKey = ^

   If Lng=07
      GetKey := func_StrTranslate(Getkey,"!$%&/()=?*':;","134567890+#.,")

   Getkeystate,GetKeyCtrl,Ctrl
   Getkeystate,GetKeyAlt,Alt
   Getkeystate,GetKeyShift,Shift
   Getkeystate,GetKeyLWin,LWin,
   Getkeystate,GetKeyRWin,RWin,
   Getkeystate,GetKeyCapsLock,CapsLock
   Getkeystate,GetKeyLCtrl,LCtrl
   Getkeystate,GetKeyRAlt,RAlt

   If Single%VarHK% =
   {
      If GetKeyShift = D
         GetKey = +%GetKey%
      If (GetKeyLCtrl = "D" AND GetKeyRAlt = "D")
         GetKey = <^>!%GetKey%
      Else
      {
         If GetKeyAlt = D
            GetKey = !%GetKey%
         If GetKeyCtrl = D
            GetKey = ^%GetKey%
      }
      If (GetKeyLWin = "D" OR GetKeyRWin = "D" OR PreWinState = "D")
         GetKey = #%GetKey%
      If GetKeyCapsLock = D
         GetKey = ~CapsLock & %GetKey%
   }

   If (PreWinStateD >= 1 AND GetKey = "#" Hotkey_wc_SimWin)
   {
      PreWinStateD = 2
      goto, sub_HotkeyButton
   }

   SplashImage, Off
   Gui,-Disabled

   If ((GetKey = "#" Hotkey_wc_SimWin OR GetKey = Hotkey_wc_SimWin) AND Enable_WindowsControl = 1)
   {
      PreWinState = D
      PreWinStateD = 1
      Hotkey_DupMessage = %lng_wc_HotkeyButtonMsg%`n`n
      goto, sub_HotkeyButton
   }

   PreWinState =
   PreWinStateD =

   If (GetKey = "Escape" OR GetKey = "Enter")
      Return

   If (Getkey = "Backspace" OR Getkey = "Delete")
   {
      Getkey =
      %VarHK%_del = 1
   }

   Hotkey_AllHotkeys_tmp := Hotkey_AllNewHotkeys ; Hotkey_AllHotkeys
   IfNotInstring, Hotkey_AllHotkeys_tmp , % "" GetKey ""
   {
      StringReplace, Hotkey_AllNewHotkeys, Hotkey_AllNewHotkeys, % "" %VarHK%_new "" , , A
      %VarHK%_new = %GetKey%
      GuiControl,,%VarHK%,% "  " func_HotkeyDecompose(GetKey, 0)
      If %VarHK%_del <> 1
         Hotkey_AllNewHotkeys := Hotkey_AllNewHotkeys "" GetKey ""
   }
   Else
   {
      Loop, Parse, Hotkey_Extensions, |
      {
         FunctionTmp := A_LoopField
         If Hotkey_Extension[%FunctionTmp%] = %GetKey%
            break
         FunctionTmp =
         FunctionTmp1 =
      }
      StringSplit, FunctionTmp, FunctionTmp, $
      If FunctionTmp1 =
         Hotkey_DupMessage = % lng_DuplicateTempHotkey "`n`n"
      Else
         Hotkey_DupMessage = % lng_DuplicateHotkey "`n" FunctionTmp1 ": " Hotkey_ExtensionText[%FunctionTmp2%] "`n`n"
      goto, sub_HotkeyButton
   }

   ; sub_CheckIfSettingsChanged
   If MainGuiVisible <> 2
      Return

   GuiControlGet, activeTab,,DlgTabs
   StringReplace, ChangedSettings[%activeTab%], ChangedSettings[%activeTab%], %A_GuiControl%|,,A
   If %A_GuiControl% <> %GetKey%
   {
      ChangedSettings[%activeTab%] := ChangedSettings[%activeTab%] A_GuiControl "|"
      Gosub, sub_EnableDisable_ApplyButton
   }
   ;Tooltip, % activeTab " : " ChangedSettings[%activeTab%] "---" %A_Guicontrol% "-" GetKey
Return

func_HotkeyDecompose(Hotkey, ShortName=0 )
{
   global
   AutoTrim, Off

   StringUpper, Hotkey, Hotkey

   StringReplace, Hotkey, Hotkey, NumpadAdd, NumpadPlus
   StringReplace, Hotkey, Hotkey, NumpadDiv, Numpad
   StringReplace, Hotkey, Hotkey, NumpadSub, NumpadMinus
   StringReplace, Hotkey, Hotkey, NumpadMult, Numpad*

   If ShortName = 1
   {
      StringReplace, Hotkey, Hotkey, Numpad, %lng_KbNumpadShort%
      Hotkey_Sep := "+"
      Hotkey_Win = Win
   }
   Else
   {
      StringReplace, Hotkey, Hotkey, Numpad, %lng_KbNumpad%
      Hotkey_Sep := " + "
      Hotkey_Win = %lng_KbWin%
   }
   StringReplace, Hotkey, Hotkey, End, %lng_KbEnd%

   StringReplace, Hotkey, Hotkey, Help              , %lng_KbHelp%
   StringReplace, Hotkey, Hotkey, Sleep             , %lng_KbSleep%
   StringReplace, Hotkey, Hotkey, Browser_Back      , %lng_KbBrowser_Back%
   StringReplace, Hotkey, Hotkey, Browser_Forward   , %lng_KbBrowser_Forward%
   StringReplace, Hotkey, Hotkey, Browser_Refresh   , %lng_KbBrowser_Refresh%
   StringReplace, Hotkey, Hotkey, Browser_Stop      , %lng_KbBrowser_Stop%
   StringReplace, Hotkey, Hotkey, Browser_Search    , %lng_KbBrowser_Search%
   StringReplace, Hotkey, Hotkey, Browser_Favorites , %lng_KbBrowser_Favorites%
   StringReplace, Hotkey, Hotkey, Browser_Home      , %lng_KbBrowser_Home%
   StringReplace, Hotkey, Hotkey, Volume_Mute       , %lng_KbVolume_Mute%
   StringReplace, Hotkey, Hotkey, Volume_Down       , %lng_KbVolume_Down%
   StringReplace, Hotkey, Hotkey, Volume_Up         , %lng_KbVolume_Up%
   StringReplace, Hotkey, Hotkey, Media_Next        , %lng_KbMedia_Next%
   StringReplace, Hotkey, Hotkey, Media_Prev        , %lng_KbMedia_Prev%
   StringReplace, Hotkey, Hotkey, Media_Stop        , %lng_KbMedia_Stop%
   StringReplace, Hotkey, Hotkey, Media_Play_Pause  , %lng_KbMedia_Play_Pause%
   StringReplace, Hotkey, Hotkey, Launch_Mail       , %lng_KbLaunch_Mail%
   StringReplace, Hotkey, Hotkey, Launch_Media      , %lng_KbLaunch_Media%
   StringReplace, Hotkey, Hotkey, Launch_App1       , %lng_KbLaunch_App1%
   StringReplace, Hotkey, Hotkey, Launch_App2       , %lng_KbLaunch_App2%

   StringReplace, Hotkey, Hotkey, ScrollLock, %lng_KbScrollLock%
   StringReplace, Hotkey, Hotkey, PgUp, %lng_KbPgUp%
   StringReplace, Hotkey, Hotkey, PgDn, %lng_KbPgDn%
   StringReplace, Hotkey, Hotkey, Delete, %lng_KbDel%
   StringReplace, Hotkey, Hotkey, Home, %lng_KbHome%
   StringReplace, Hotkey, Hotkey, Insert, %lng_KbIns%
   StringReplace, Hotkey, Hotkey, PrintScreen, %lng_KbPrintScreen%
   StringReplace, Hotkey, Hotkey, Backspace, %lng_KbBackspace%
   StringReplace, Hotkey, Hotkey, Space, %lng_KbSpace%
   StringReplace, Hotkey, Hotkey, ENTER, %lng_KbEnter%
   StringReplace, Hotkey, Hotkey, ESCAPE, ESC
   StringReplace, Hotkey, Hotkey, Tab, %lng_KbTab%
   StringReplace, Hotkey, Hotkey, Pause, %lng_KbPause%
   StringReplace, Hotkey, Hotkey, CtrlBreak, %lng_KbCtrlBreak%
   StringReplace, Hotkey, Hotkey, Left, %lng_KbCurLeft%
   StringReplace, Hotkey, Hotkey, Right, %lng_KbCurRight%
   StringReplace, Hotkey, Hotkey, Up, %lng_KbCurUp%
   StringReplace, Hotkey, Hotkey, Down, %lng_KbCurDown%
   StringReplace, Hotkey, Hotkey, % "~CapsLock & ", %A_Space%
   StringReplace, Hotkey, Hotkey, NUMLOCK, NumLock

   If (func_StrLeft(Hotkey,1) = "~" OR func_StrLeft(Hotkey,1) = "$")
      StringTrimLeft, Hotkey, Hotkey, 1
   If (func_StrLeft(Hotkey,1) = "~" OR func_StrLeft(Hotkey,1) = "$")
      StringTrimLeft, Hotkey, Hotkey, 1

   If (func_StrRight(Hotkey,1) = "+")
      Hotkey := func_StrLeft( Hotkey, StrLen(Hotkey)-1 ) "Plus"

   Len := StrLen(Hotkey)
   HotkeyDecomposed =
   IfInString, Hotkey, <^>!
      StringReplace, Hotkey, Hotkey, <^>!, AltGr%Hotkey_Sep%
   Loop, Parse, Hotkey
   {
      HotkeyDecomp =
      If (A_Index < Len)
      {
         If A_LoopField = #
            HotkeyDecomp := Hotkey_Win Hotkey_Sep
         If A_LoopField = +
            HotkeyDecomp := lng_KbShift Hotkey_Sep
         If A_LoopField = ^
            HotkeyDecomp := lng_KbCtrl Hotkey_Sep
         If A_LoopField = !
            HotkeyDecomp := lng_KbAlt Hotkey_Sep
         If (A_LoopField = " " AND A_Index = 1)
            HotkeyDecomp := lng_KbCapsLock Hotkey_Sep
      }
      If HotkeyDecomp =
         HotkeyDecomp = %A_LoopField%
      HotkeyDecomposed = %HotkeyDecomposed%%HotkeyDecomp%
   }

   Return %HotkeyDecomposed%
}

sub_ListBox_addApp:
   StringReplace, VarApp, A_GuiControl, Add_,
   WinSet,Bottom,, %ScriptTitle%
   SplashImage,,b1 cwFFFF80 FS9 WS700, %lng_AddApps%
   Gui,1:+Disabled
   Input,GetKey,,{Enter}{ESC}
   StringReplace,GetKey,ErrorLevel,Endkey:
   SplashImage, Off
   Gui,1:-Disabled
   WinGet, GetProcName, ProcessName, A
   If Getkey = Enter
   {
      IfNotInstring, %VarApp%, %GetProcName%
      {
         GuiControl,,%VarApp%_tmp,%GetProcName%
         %VarApp% := %VarApp% "|" GetProcName
         StringReplace,%VarApp%,%VarApp%,||,|,a
      }
   }
   Gui,1:Show
   WinSet, Top, , %ScriptTitle%

   If (MainGuiVisible <> 2 OR GetKey = "ESCAPE")
      Return

   StringReplace, VarAppOrg, VarApp, _Box,
   If ( func_StrLeft(%VarApp%,1) = "|" )
   {
      StringTrimLeft, %VarApp%, %VarApp%, 1
   }
   If ( func_StrRight(%VarApp%,1) = "|" )
   {
      StringTrimRight, %VarApp%, %VarApp%, 1
   }
   GuiControlGet, activeTab,,DlgTabs
   StringReplace, ChangedSettings[%activeTab%], ChangedSettings[%activeTab%], %VarApp%|,,A
   If (%VarApp% <> ChangedSettings[%activeTab%])
      ChangedSettings[%activeTab%] := ChangedSettings[%activeTab%] %VarApp% "|"
   Gosub, sub_EnableDisable_ApplyButton
;   Tooltip, % activeTab " : " ChangedSettings[%activeTab%]
Return

sub_ListBox_addFolder:
   Gui +OwnDialogs
   StringReplace, VarApp, A_GuiControl, Add_,
   FileSelectFolder,GetKey
   If GetKey =
      Return
   IfNotInstring, %VarApp%, %GetKey%
   {
      If %VarApp%_DontAllowSubfolders = 1
      {
         Loop, Parse, %VarApp%, |
         {
            If A_LoopField =
               continue
            If ( func_StrLeft( GetKey, StrLen(A_LoopField) ) = A_LoopField)
            {
               MsgBox, 16,%qc_ScriptName%, %lng_IsSubfolder% %A_LoopField%
               return
            }
         }
      }

      GuiControl,,%VarApp%_tmp,%GetKey%
      %VarApp% := %VarApp% "|" GetKey
      StringReplace,%VarApp%,%VarApp%,||,|,a
   }
   Else
   {
      If %VarApp%_DontAllowSubfolders = 1
         MsgBox, 16,%qc_ScriptName%, %lng_HasSubfolder%
      Else
         MsgBox, 16,%qc_ScriptName%, %lng_IsInList%
      return
   }

   If MainGuiVisible <> 2
      Return

   StringReplace, VarAppOrg, VarApp, _Box,
   If ( func_StrLeft(%VarApp%,1) = "|" )
   {
      StringTrimLeft, %VarApp%, %VarApp%, 1
   }
   If ( func_StrRight(%VarApp%,1) = "|" )
   {
      StringTrimRight, %VarApp%, %VarApp%, 1
   }
   GuiControlGet, activeTab,,DlgTabs
   StringReplace, ChangedSettings[%activeTab%], ChangedSettings[%activeTab%], %VarApp%|,,A

   If (%VarApp% <> ChangedSettings[%activeTab%])
      ChangedSettings[%activeTab%] := ChangedSettings[%activeTab%] %VarApp% "|"
   Gosub, sub_EnableDisable_ApplyButton
;   Tooltip, % activeTab " : " ChangedSettings[%activeTab%]
Return

sub_ListBox_remove:
   StringReplace, VarApp, A_GuiControl, Remove_,
   GuiControlGet, App_selected, , %VarApp%_tmp
   %VarApp% := "|" %VarApp% "|"
   StringReplace,%VarApp%,%VarApp%,|%App_selected%|,|,a
   StringReplace,%VarApp%,%VarApp%,||,|,a
   StringReplace,%VarApp%,%VarApp%,||,|,a
   GuiControl,,%VarApp%_tmp,% %VarApp%

   If MainGuiVisible <> 2
      Return

   StringReplace, VarAppOrg, VarApp, _Box,
   If ( func_StrLeft(%VarApp%,1) = "|" )
   {
      StringTrimLeft, %VarApp%, %VarApp%, 1
      StringTrimRight, %VarApp%, %VarApp%, 1
   }
   GuiControlGet, activeTab,,DlgTabs
   StringReplace, ChangedSettings[%activeTab%], ChangedSettings[%activeTab%], %VarApp%|,,A
   If (%VarAppOrg% <> %VarApp%)
      ChangedSettings[%activeTab%] := ChangedSettings[%activeTab%] VarApp "|"
   Gosub, sub_EnableDisable_ApplyButton
;   Tooltip, % activeTab " : " ChangedSettings[%activeTab%] "`n" %VarAppOrg%  "<>" %VarApp%
Return

func_StrLeft(String,Len)
{
   StringLeft, Output, String, %Len%
   Return Output
}

func_StrRight(String,Len)
{
   StringRight, Output, String, %Len%
   Return Output
}

func_StrMid(String,Left,Len)
{
   StringMid, Output, String, %Left%, %Len%
   Return Output
}
func_StrTranslate(String,TransFrom,TransTo)
{
   Loop, Parse, TransFrom
   {
      StringMid, TransToChar, TransTo, %A_Index%, 1
      StringReplace, String, String, %A_LoopField%, %TransToChar%, All
   }
   Return %String%
}

func_ChangeDir(retPath,NewWindow=0,FolderTree=0)
{
   Global lng_ChangeDirFailed, ScriptTitle, lng_FolderDoesNotExist, ChangeDirClasses
   SetKeyDelay,20,20

   WinGet     , activeWinID, ID, A             ; ID es aktiven Fensters
   WinGetClass, activeClass, ahk_id %activeWinID%  ; Fensterklasse ermitteln
   WinGetText, activeWinText, ahk_id %activeWinID%

   Edit1Pos =

   ; Prfen ob Fensterklasse untersttzt wird
   If activeClass contains %ChangeDirClasses%
   {
      ; Ermitteln ob ein Edit1-Control vorhanden ist (Eingabezeile)
      IfInString, activeWinText, MSNTB_Window ; MSN-Toolbar?
         EditClass = Edit2
      Else
         EditClass = Edit1

      ControlGetPos, Edit1Pos,,,, %EditClass% , ahk_id %activeWinID%
   }

   If Edit1Pos =  ; Wenn kein Edit1-Control gefunden ...
   {
      ; Ermitteln ob ein RichEdit-Control vorhanden ist (MS-Office)
      EditClass = RichEdit20W2
      ControlGetPos, Edit1Pos,,,, %EditClass% , ahk_id %activeWinID%
   }

   If activeClass = AfxMDIFrame80su
   {
      EditClass = ComboBox3
      ControlGetPos, Edit1Pos,,,, %EditClass% , ahk_id %activeWinID%
   }

   FileGetAttrib, isFolder, %retPath%
   If (func_StrLeft(retPath,3) = "`:`:{")
      isFolder = D

   If NewWindow < 1 ; Verzeichnis im aktuellen Fenster wechseln
   {
      IfNotInString, isFolder, D
         Return

      ; Verzeichnis in Dateidialogen wechseln
      If activeClass contains #32770,bosa_sdm
      {
         If Edit1Pos <>
         {
            WinActivate ahk_id %activeWinID%
            ControlGetText, text, %EditClass%, ahk_id %activeWinID%
            ControlSetText, %EditClass%, %retPath%, ahk_id %activeWinID%
            WinGet,Process, ProcessName, ahk_id %activeWinID%
            func_AddToRecentDir(retPath)
            If Process in WinRar.exe
               Return
            if Process in Acad.exe
            {
               ControlSend   , %EditClass%, {SPACE}{BS} , ahk_id %activeWinID%
               Sleep, 200
            }
            If activeClass = bosa_sdm
               ControlSend   , %EditClass%, {Tab} , ahk_id %activeWinID%
            Else
               ControlSend   , %EditClass%, {Enter} , ahk_id %activeWinID%
            Sleep, 100
            ControlSetText, %EditClass%, %text%, ahk_id %activeWinID%
            Return
         }
      }
      ; Verzeichnis in Explorer-Fenstern wechseln
      Else If activeClass in ExploreWClass,CabinetWClass,WinRarWindow
      {
         If Edit1Pos <>
         {
            ControlSetText, %EditClass%, %retPath%      , ahk_id %activeWinID%
            ControlSend   , %EditClass%, {Right}{Enter}, ahk_id %activeWinID%
            Sleep,200
            Send, +{Tab}
            func_AddToRecentDir(retPath)
            Return
         }
      }
      ; Verzeichnis im CubicExplorer wechseln
      Else If activeClass in TMainForm
      {
         ControlGetPos, Edit1Pos,,,, TComboEdit.UnicodeClass2 , ahk_id %activeWinID%
         If Edit1Pos <>
         {
            ControlSetText, TComboEdit.UnicodeClass2, %retPath%, ahk_id %activeWinID%
            ControlSend   , TComboEdit.UnicodeClass2, {Enter}{Tab} , ahk_id %activeWinID%
            func_AddToRecentDir(retPath)
            Return
         }
      }
      ; Verzeichnis in AcdSee, Filezilla, SpeedCommander wechseln
      Else If activeClass in Afx:400000:0,FileZilla Main Window,SC11MainFrame,SC10MainFrame
      {
         If Edit1Pos <>
         {
            ControlSetText, %EditClass%, %retPath%, ahk_id %activeWinID%
            ControlSend   , %EditClass%, {Enter} , ahk_id %activeWinID%
            func_AddToRecentDir(retPath)
            Return
         }
      }
      ; Total Commander
      Else If activeClass = TTOTAL_CMD
      {
         PostMessage 1075, 2912,,, ahk_id %activeWinID% ; added by MayorA for TotalCommander (send cm_EditPath)
         Sleep,50
         ControlGetFocus, activeControl, ahk_id %activeWinID%
         ControlSetText, %activeControl%, %retPath%, ahk_id %activeWinID%
         ControlSend   , %activeControl%, {Left}{Right}{Enter} , ahk_id %activeWinID%
         func_AddToRecentDir(retPath)
         Return
      }
      ; Verzeichnis in der Eingabeaufforderung wechseln
      Else If activeClass = ConsoleWindowClass
      {
         WinGetActiveTitle, wTitle

         If wTitle contains cmd.exe,4NT
         {
            WinActivate, ahk_id %activeWinID%
            SetKeyDelay, 0

            IfInString, retPath, :
            {
               StringLeft, path_Drive, retPath, 1
               Send {ESC}%path_Drive%:{Enter}
            }

            Send, {ESC}
            SendRaw, cd "%retPath%"
            Send, {Enter}
            func_AddToRecentDir(retPath)
            Return
         }
      }
   }
   If NewWindow <> 0
   {
      ; Explorer-Fenster ffnen (fhrt auch Programme aus)
      If (FileExist(retPath) OR func_StrLeft(retPath,3) = "::{")
      {
         If ( isFolder contains "D" AND FolderTree = "1")
            Run, explorer /e`,%retPath%
         Else
            Run, %retPath%
         func_AddToRecentDir(retPath)
      }
      Else
         BalloonTip(ScriptTitle, lng_FolderDoesNotExist "`n" retPath, "Info")
   }
   Else
      BalloonTip(ScriptTitle, lng_ChangeDirFailed, "Info", 1)
}

func_AddToRecentDir(retPath)
{
   global RecentPath
   SplitPath, retPath, Name, parentDir,,,Drive
   If Name =
      StringReplace, Name, Drive, :, ,
   FileDelete, %RecentPath%\%Name%
   FileCreateShortcut, %retPath%, %RecentPath%\%Name%.lnk
}

func_GetDir( WindowID, Message="", Repeat="", AddToTitle="" )
{
   global Enable_Freespace,lng_fs_FreeSpace,lng_fs_FreeSpaceShort, lng_CheckYourFolderOptions, ScriptTitle, UserProfile

   WinGetTitle, activeWinTitle, ahk_id %WindowID%
   WinGetText, activeWinText, ahk_id %WindowID%
   WinGetClass, activeWinClass, ahk_id %WindowID%

   IfInString, activeWinText, MSNTB_Window ; MSN-Toolbar?
      EditClass = Edit2
   Else
      EditClass = Edit1

   ControlGetText, retPath, %EditClass%, ahk_id %WindowID%
   retPathErrorLevel = %ErrorLevel%
   If activeWinTitle contains - Microsoft Internet Explorer
      Return
   If Repeat = Once
      Repeat = 1
   Else If Repeat <> Never
      Repeat =
   If AddToTitle <>
      AddToTitle := " - " AddToTitle

   If A_OSversion = WIN_NT4
   {
      RegRead, FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,Settings
      StringMid, FullPath, FullPath,10,1
      If FullPath = B
         FullPath = 1
      Else
         FullPath = 0
   }
   Else
   {
      RegRead, FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
      RegRead, FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress
      If FullPath =
         FullPath = 0
      If FullPathAddress =
         FullPathAddress = 1
   }

   RegRead, RegDesktop, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Desktop
   StringReplace, RegDesktop, RegDesktop, `%USERPROFILE`%\

   RegRead, RegPersonal, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Personal
   RegRead, MyDocs, HKEY_CURRENT_USER,Software\Microsoft\Office\11.0\Common\General,MyDocuments
   StringReplace, RegPersonal, RegPersonal, `%USERPROFILE`%, %UserProfile%
   StringReplace, RegPersonal, RegPersonal, `%USERNAME`%, %A_Username%
   SplitPath, RegPersonal, RegDir

   If (retPathErrorLevel = 1 AND WinExist("ahk_id " WindowID) AND WinActive("ahk_id " WindowID))
   {
      WinWaitClose, ahk_id %WindowID%,,1
   }

   If activeWinClass in CabinetWClass,ExploreWClass
   {
      If (( (FullPath = 0 AND FullPathAddress = 0 ) OR (FullPathAddress = 1 AND retPathErrorLevel = 1) ) AND (WinExist("ahk_id " WindowID) AND WinActive("ahk_id " WindowID)) )
      {
         If Message = ShowBalloonTip
         {
            If Repeat = 1
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",WindowID,0)
            Else If Repeat <> Never
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",0,0)
         }
         Else If Message = ShowMessage
         {
            If Repeat = 1
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",WindowID,1)
            Else If Repeat <> Never
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",0,1)
         }
         Return
      }

      ; Aktuellen Pfad anhand der Adress- oder Titelleiste ermitteln
      If FullPathAddress = 1
      {
         If retPathErrorLevel = 1
            return
      }
      Else If FullPath = 1
      {
         WinGetTitle, retPath, ahk_id %WindowID%
         If A_OSversion = WIN_NT4
            StringReplace, retPath, retPath, % "Explorer - "
         If Enable_FreeSpace = 1
         {
            IfInString, retPath, % " (" lng_fs_FreeSpace " "
            {
               StringGetPos, FSpos, retPath, % " (" lng_fs_FreeSpace " "
               StringLeft, retPath, retPath, %FSpos%
            }
            StringRight, retPathR, retPath, % StrLen(lng_fs_FreeSpaceShort)+2
            IfInString, retPathR, % " " lng_fs_FreeSpaceShort ")"
            {
               StringGetPos, FSpos, retPath, % " (", R1
               StringLeft, retPath, retPath, %FSpos%
            }
         }
      }

      ; Prfe, ob 'Desktop' im Explorer ausgewhlt wurde
      If RegDesktop = %retPath%
         retPath = %USERPROFILE%\%RegDesktop%

      ; Prfe, ob 'Eigene Dateien' im Explorer ausgewhlt wurde
      If retPath in Eigene Dateien,My Documents,mijn documenten,%MyDocs%,%RegDir%
         retPath = %RegPersonal%

      If (retPathErrorLevel=1 And WinActive("ahk_id " WindowID) )
      {
         If Message = ShowBalloonTip
         {
            If Repeat = 1
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",1,0)
            Else If Repeat <> Never
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",0,0)
         }
         Else If Message = ShowMessage
         {
            If Repeat = 1
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",1,1)
            Else If Repeat <> Never
               BalloonTip(ScriptTitle AddToTitle, lng_CheckYourFolderOptions,"Info",0,1)
         }
      }

      Return %retPath%
   }
   Else If activeWinClass in Progman,WorkerW
   {
      retPath = %USERPROFILE%\%RegDesktop%
      Return %retPath%
   }
}

func_CheckIfOnline()
{
   Return 1
}

func_AddMessage( Message, SubRoutine )
{
   Global
   StringReplace, Messages%Message%, Messages%Message%, %SubRoutine%|
   Messages%Message% := Messages%Message% SubRoutine "|"
   OnMessage( Message, "func_CallMessages" )
}

func_RemoveMessage( Message, SubRoutine )
{
   Global
   StringReplace, Messages%Message%, Messages%Message%, %SubRoutine%|
   If Messages%Message% =
      OnMessage( Message, "" )
   Else
      OnMessage( Message, "func_CallMessages" )
}

func_CallMessages(wParam,lParam, msg, hwnd)
{
   Global
   Loop, Parse, Messages%msg%, |
   {
      If A_LoopField =
         continue
      #wParam = %wParam%
      #lParam = %lParam%
      #msg    = %msg%
      #hwnd   = %hwnd%
      #Return =
      Gosub,%A_LoopField%
      If #Return <>
      {
         Return %#Return%
      }
   }
}

; Konvertiert Stings in Hex-Werte
func_Hex(String,Unicode = 0)
{
   OldFormat = %A_FormatInteger%
   SetFormat, Integer, hex

   Loop, Parse, String
   {
      TransForm, Asc, Asc, %A_LoopField%
      Asc += 0
      StringTrimLeft, Hex, Asc, 2
      If Unicode = 0
         Result = %Result%%Hex%
      Else
         Result = %Result%%Hex%00
   }
   SetFormat, Integer, %OldFormat%
   StringUpper, Result, Result

   Return Result
}

func_StrLower(String)
{
   StringLower, String, String
   Return String
}

func_Download( URL, File, Splashtext, Title="", Size=0, URL2="", File2="", URL3="", File3="" )
{
   Suspend, On
   SetTimer, tim_Loading, Off
   ToolTip
   SetTimer, tim_UPDATEDSCRIPT, Off

   Setbatchlines, 15
   global DownloadProgressSplashtext,DownloadProgressFile,DownloadProgressFileSize,DownloadProgressTotalSize,DownloadProgressAddSize,DownloadProgressTitle,Random1,Random2
   DownloadProgressTotalSize = %Size%

   DownloadProgressAddSize = 0
   DownloadProgressSplashtext = %Splashtext%
   DownloadProgressTitle = %Title%
   DownloadProgressFile = %File%
   If Size > 5
      Progress, M2 FM10 FS10 WM400 WS400 P0 w400, %File%, %DownloadProgressSplashtext%, AutoHotkey Update
   Else
      SplashImage,,M2 FS9 W400, %DownloadProgressSplashtext%
   SetTimer, tim_DownloadProgress, 10
   URLDownloadToFile, %URL%?dl=%Random1%&ul=%Random2%, %File%
   ReturnVal = %ErrorLevel%
   If (URL2 <> "" AND File2 <> "")
   {
      If Size > 5
      {
         Progress, M2 P%DownloadProgressPercentage% FM10 FS10 WM400 WS400 w400, %File2%, %DownloadProgressSplashtext%, AutoHotkey Update
      }
      DownloadProgressFile = %File2%
      DownloadProgressAddSize = %DownloadProgressFileSize%
      URLDownloadToFile, %URL2%?dl=%Random2%&ul=%Random1%, %File2%
      ReturnVal := ReturnVal + ErrorLevel
   }
   If (URL3 <> "" AND File3 <> "")
   {
      If Size > 5
      {
         ;Progress, Off
         Progress, M2 P%DownloadProgressPercentage% FM10 FS10 WM400 WS400 w400, %File3%, %DownloadProgressSplashtext%, AutoHotkey Update
      }
      DownloadProgressFile = %File3%
      DownloadProgressAddSize = %DownloadProgressFileSize%
      URLDownloadToFile, %URL3%?dl=%Random1%&ul=%Random2%, %File3%
      ReturnVal := ReturnVal + ErrorLevel
   }
   Sleep,50
   SetTimer, tim_DownloadProgress, off
   SplashImage, Off
   Progress, Off
   Return %ReturnVal%
}

tim_DownloadProgress:
   Critical
   FileGetSize, DownloadProgressFileSize, %DownloadProgressFile%, K
   DownloadProgressFileSize := DownloadProgressAddSize + DownloadProgressFileSize
   If DownloadProgressFileSize = %DownloadProgressFileSizeLast%
      return
   If DownloadProgressTotalSize > 5
   {
      DownloadProgressPercentage := Round(DownloadProgressFileSize / DownloadProgressTotalSize * 100,0)
      Progress, %DownloadProgressPercentage%
   }
   Else
   {
      SplashImage,,M2 FS9 W400, %DownloadProgressSplashtext% (%DownloadProgressFileSize% Kb)
   }
   DownloadProgressFileSizeLast = %DownloadProgressFileSize%
Return

func_BeautifyIniFile( IniFile )
{
   FileDelete, %IniFile%.tmp
   IniFileNewContent =
   FileRead, IniFileContent, %IniFile%
   Loop, Parse, IniFileContent, `n, `r
   {
      If A_LoopField =
         continue

      If A_LoopField = `;____________________________________________________________________________
         continue

      If A_LoopField = `;
         continue

      If ( func_StrLeft(A_LoopField,1) = "[" )
      {
         IniFileNewContent = %IniFileNewContent%`r`n`;____________________________________________________________________________`r`n
         IniFileNewContent = %IniFileNewContent%%A_LoopField%`r`n
         IniFileNewContent = %IniFileNewContent%`;`r`n
         continue
      }

      StringGetPos, ReadLinePos, A_LoopField, =
      ReadLinePos := 32-ReadLinePos
      ReadLineIndent := "                                                     "
      StringRight, ReadLineIndent, ReadLineIndent, %ReadLinePos%
      StringReplace, ReadLine, A_LoopField, =, % "" ReadLineIndent "="
      IniFileNewContent = %IniFileNewContent%%ReadLine%`r`n
   }
   FileAppend, %IniFileNewContent%, %IniFile%.tmp

   FileMove, %IniFile%.tmp, %IniFile%, 1
}

func_GetMonitorNumber(Mode)
{
   global

   If Mode = Mouse
   {
      CoordMode, Mouse, Screen
      MouseGetPos, MouseX, MouseY

      Loop, %NumOfMonitors%
      {
         If (MouseX >= Monitor%A_Index%Left AND MouseX <= Monitor%A_Index%Right AND MouseY >= Monitor%A_Index%Top AND MouseY <= Monitor%A_Index%Bottom)
            Return %A_Index%
      }
   }
   If Mode = ActiveWindow
   {
      WinGetPos, WinX, WinY, WinW, WinH, A
      WinCenX := WinX + WinW/2
      WinCenY := WinY + WinH/2

      Loop, %NumOfMonitors%
      {
         If (WinCenX >= Monitor%A_Index%Left AND WinCenX <= Monitor%A_Index%Right AND WinCenY >= Monitor%A_Index%Top AND WinCenY <= Monitor%A_Index%Bottom)
            Return %A_Index%
      }

   }
   Return 1
}

func_WildcardMatch( Haystack, Needle, Case=0)
{
   If Case = 1
      StringCaseSense, On
   Else
      StringCaseSense, Off

   StringReplace, ext_temp, Needle, *, *, A UseErrorLevel
   NumOfParts := ErrorLevel+1

   notFound = 0
   Loop, Parse, Needle, *
   {
      If A_LoopField =
         continue

      StringLen, PartLen, A_LoopField

      If A_Index = 1
      {
         StringLeft, CompareString, Haystack, %PartLen%
         StringTrimLeft, Haystack, Haystack, %PartLen%
         StringTrimLeft, Needle, Needle, % PartLen+1
         If A_LoopField != %CompareString%
            notFound++
      }
      Else If A_Index = %NumOfParts%
      {
         StringRight, CompareString, Haystack, %PartLen%
         StringTrimRight, Haystack, Haystack, %PartLen%
         StringTrimRight, Needle, Needle, % PartLen+1
         If A_LoopField != %CompareString%
            notFound++
      }
   }
   If NumOfParts > 2
   {
      Loop, Parse, Needle, *
      {
         IfNotInstring, Haystack, %A_LoopField%
            notFound++
      }
   }
   If notFound > 0
      return false
   Else
      return true
}

func_GetSelection(copyAsText=1,copyOnly=0,clipWaitTime=0.5)
{
   global Selection
   theModifiers = LCtrl,RCtrl,LWin,RWin,LAlt,RAlt,LShift,RShift
   resetModifiers =
   restoreModifiers =
   Loop, Parse, theModifiers, `,
   {
      If (GetKeyState(A_LoopField))
      {
         resetModifiers = %resetModifiers%{%A_LoopField% up}
         restoreModifiers = {%A_LoopField% down}%restoreModifiers%
      }
   }

   SavedClipboard := ClipboardAll
   Clipboard =

   Send, {Blind}%resetModifiers%^c%restoreModifiers%
   ClipWait, %clipWaitTime%, 1

   If copyAsText = 1
      Selection = %Clipboard%
   Else
      Selection = %ClipboardAll%

   If copyOnly = 0
      Clipboard := SavedClipboard
}

func_UnpackSplash( file )
{
   global UnpackSplashStyle
   SplashImage,,%UnpackSplashStyle%, Dateien werden ausgepackt ... / Unpacking files ...`n%file%
   UnpackSplashStyle =
}

func_prepareHotkeyForSend(Hotkey)
{
   SendHotkey =
   FirstNonModifier = 0
   Loop, Parse, Hotkey
   {
      If A_LoopField in $,*,~
         continue
      If A_LoopField in !,#,^,+
         SendHotkey = %SendHotkey%%A_LoopField%
      Else If FirstNonModifier = 0
      {
         SendHotkey = %SendHotkey%{%A_LoopField%
         FirstNonModifier++
      }
      Else
         SendHotkey = %SendHotkey%%A_LoopField%
   }
   SendHotkey = %SendHotkey%%A_LoopField%}
   StringLower, SendHotkey, SendHotkey
   Return %SendHotkey%
}

sub_GetAllEnv:
   EnvGet, ALLUSERSPROFILE, ALLUSERSPROFILE
   EnvGet, APPDATA, APPDATA
   EnvGet, CLASSPATH, CLASSPATH
   EnvGet, CLIENTNAME, CLIENTNAME
   EnvGet, CommonProgramFiles, CommonProgramFiles
   EnvGet, COMPUTERNAME, COMPUTERNAME
   EnvGet, HOMEDRIVE, HOMEDRIVE
   EnvGet, HOMEPATH, HOMEPATH
   EnvGet, LOGONSERVER, LOGONSERVER
   EnvGet, NUMBER_OF_PROCESSORS, NUMBER_OF_PROCESSORS
   EnvGet, OS, OS
   EnvGet, Path, Path
   EnvGet, PATHEXT, PATHEXT
   EnvGet, PROCESSOR_ARCHITECTURE, PROCESSOR_ARCHITECTURE
   EnvGet, PROCESSOR_IDENTIFIER, PROCESSOR_IDENTIFIER
   EnvGet, PROCESSOR_LEVEL, PROCESSOR_LEVEL
   EnvGet, PROCESSOR_REVISION, PROCESSOR_REVISION
   EnvGet, PROMPT, PROMPT
   EnvGet, SESSIONNAME, SESSIONNAME
   EnvGet, SystemDrive, SystemDrive
   EnvGet, SystemRoot, SystemRoot
   EnvGet, TEMP, TEMP
   EnvGet, TMP, TMP
   EnvGet, USERDOMAIN, USERDOMAIN
   EnvGet, USERNAME, USERNAME
   EnvGet, USERPROFILE, USERPROFILE
   EnvGet, windir, windir
   FormatTime, DATE,,ShortDate
   FormatTime, Time,,Time
Return
