; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               ac'tivAid
; -----------------------------------------------------------------------------
; Version:            1.0.7.20
; Date:               2006-06-06 12:09
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; AutoHotkey Version: 1.0.44.04
; Language:           German/Dutch (+ English GUI)
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Prft auf die richtige AutoHotkey-Version, startet dann das eigentliche
; Skript.

; #################################################################EndHeader###

; -----------------------------------------------------------------------------
; === Global Settings =========================================================
; -----------------------------------------------------------------------------

#singleinstance force

; -----------------------------------------------------------------------------
; === Initialisation ======================================================cd==
; -----------------------------------------------------------------------------

ScriptName         = ac'tivAid
ScriptNameClean    = activAid
ScriptVersion      = 1.0.7.20
neededAHKversion   = 1.0.44.04
ConfigFile         = settings\%ScriptName%.ini
ConfigFile_QuickChangeDir   = settings\QuickChangeDir.ini
qc_ScriptName      = QuickChangeDir

ScriptTitle        = %ScriptName% v%ScriptVersion%

; -----------------------------------------------------------------------------

SplitPath, A_AhkPath,,A_AutoHotkeyPath

If A_AHKPath =
   RegRead, A_AutoHotkeyPath, HKLM, SOFTWARE\AutoHotkey, InstallDir

; sprachabhngige Variablen, Systemsprache wird ermittelt
IniRead, Lng, %ConfigFile%, %ScriptNameClean%, Language
If Lng = ERROR
   StringRight, Lng, A_Language, 2 ; Sprache ermitteln, wenn nicht in INI festgelegt

If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   lng_wrongAHK         = AutoHotkey %neededAHKversion% oder hher wird bentigt.`nSoll die neueste Version automatisch heruntergeladen und installiert werden?
   lng_downloadingAHK   = Die neueste Version von AutoHotkey wird heruntergeladen ...
   lng_wr_UpdateCFG     = Wegen der neuen Mglichkeiten von WebSearch sollte die Konfigurations-Datei mit den Suchmaschinen (URLs.cfg) neu angelegt werden.`nAlle manuell hinzugefgte URLs werden gelscht. Von der alten Konfigurations-Datei wird aber eine Sicherung (URLs.bak) angelegt.
   lng_dontcompile      = Sie haben das Start-Skript von ac'tivAid kompliert.`nac'tivAid.ahk muss vor der Kompilierung einmal gestartet werden.`nSie knnen auch mit der Erweiterung PackAndGo die Kompilierung automatisieren.
   lng_RunAsAdmin       = Beim ersten Start muss ac'tivAid mit Administrator-Rechten ausgefhrt werden.
   lng_AdminName        = Benutzer mit Administrator-Rechten
   lng_Password         = Passwort
   lng_WrongAdmin       = Bitte berprfen Sie den Benutzernamen und das Passwort.`nDer angegebene Benutzer muss Administrator-Rechte besitzen.
   lng_OK               = OK
   lng_cancel           = Abbrechen
}
else        ; = other languages (english)
{
   lng_wrongAHK         = AutoHotkey %neededAHKversion% or higher will be needed.`nShould it be downloaded and installed automatically?
   lng_downloadingAHK   = Downloading the newest version of AutoHotkey ...
   lng_wr_UpdateCFG     = Due to new capabilities of WebSearch the config-file (URLs.cfg) should be recreated.`nAll added urls will be deleted. A backup of the old config-file (URLs.bak) will be created.
   lng_dontcompile      = You've compiled the start-script of ac'tivAid.`nPlease run ac'tivAid.ahk once before compiling it.`nYou could also try the extension PackAndGo to automate compiling.
}

If A_IsCompiled = 1
{
   Msgbox, 16, %ScriptTitle%, %lng_dontcompile%
   ExitApp
}

SetWorkingDir, %A_ScriptDir%

FileAppend, write, _temp.tmp
If ErrorLevel <> 0
   MainDirNotWriteable = 1
FileDelete, _temp.tmp

If MainDirNotWriteable = 1
   Goto, sub_RunAsAdmin

; Prfen, ob richtige AutoHotkey-Version installiert ist
IfExist, updateAHK.cmd
   FileDelete, AutoHotkeyInstall.exe
FileDelete, updateAHK.cmd
If A_AHKversion < %neededAHKversion%
{
   If (A_IsAdmin = 0 AND MainDirNotWriteable = 1)
      Goto, sub_RunAsAdmin
   IfExist, AutoHotkeyInstall.exe
   {
      msgbox = exist
   }
   Else
   {
      MsgBox, 19, %ScriptTitle%, %lng_wrongAHK%
      IfMsgBox, yes
         msgbox = yes

      IfMsgBox, cancel
         ExitApp

      IfMsgBox, no
      {
         Run, http://www.autohotkey.com/download/
         ExitApp
      }
   }

   If msgbox <>
   {
      If msgbox = yes
         Downloaded := func_Download( "http://home.tampabay.rr.com/kodi/ahk/AutoHotkeyInstall.exe", "AutoHotkeyInstall.exe", lng_downloadingAHK, "AutoHotkey Update", 1600 )
      If (Downloaded = 0 OR msgbox = "exist" )
      {
         FileAppend, AutoHotkeyInstall.exe /S`n, updateAHK.cmd
         FileAppend, "%A_AutoHotkeyPath%\AutoHotkey.exe" "%A_ScriptFullPath%"`n, updateAHK.cmd
         Run, updateAHK.cmd,,Hide
         DetectHiddenWindows, On
         Loop
         {
            Process, Exist, AutoHotkey.exe
            IfEqual, ErrorLevel, 0, Break
            Process, Close, AutoHotkey.exe
         }
         ExitApp
      }
   }

}

IfNotInString, A_Scriptname, -Checker
   FileMove, %ScriptName%_main.ahk, %ScriptName%.ahk, 1

; nderungen an der Verzeichnisstruktur durchfhren
IfExist, WebResearch
{
   FileCreateDir, WebSearch
   FileMove, WebResearch\*.*, WebSearch\, 1
   FileRemoveDir, WebResearch, 1
   IfExist, WebSearch\URLs.cfg
   {
      MsgBox, 36, %ScriptTitle%, %lng_wr_UpdateCFG%
      IfMsgBox,yes
      {
         FileMove, WebSearch\URLs.cfg, WebSearch\URLs.bak
      }
   }
}
IfExist, WebSearch
{
   FileMoveDir, WebSearch, settings\WebSearch
   FileRemoveDir, WebSearch, 1
   IfExist, settings\WebSearch\URLs.cfg
   {
      MsgBox, 36, %ScriptTitle%, %lng_wr_UpdateCFG%
      IfMsgBox,yes
      {
         FileMove, settings\WebSearch\URLs.cfg, settings\WebSearch\URLs.bak
      }
   }
}
IfExist, ac'tivAid.ini
   FileMove, ac'tivAid.ini, settings\ac'tivAid.ini, 1
IfExist, includes
   FileRemoveDir, includes, 1
IfExist, settings\extensions_main.ahk
   FileMove, settings\extensions_main.ahk, extensions\_main.ahk
FileDelete, settings\extensions_main.ahk
IfExist, settings\extensions_header.ahk
   FileMove, settings\extensions_header.ahk, extensions\_header.ahk
FileDelete, settings\extensions_header.ahk
IfExist, extensions\Hotstrings.ahk
   FileMove, extensions\Hotstrings.ahk, settings\Hotstrings.ini
FileDelete, extensions\Hotstrings.ahk
IfExist, extensions\Hotstrings.ini
   FileMove, extensions\Hotstrings.ini, settings\Hotstrings.ini
FileDelete, extensions\Hotstrings.ini

FileDelete, ac'tivAid_ct.ico
FileDelete, ac'tivAid.ico
FileDelete, ac'tivAid_off.ico
FileDelete, ac'tivAid_on.ico
FileDelete, ac'tivAid Readme.txt
FileDelete, extensions\Vol.gif
FileDelete, extensions\Vol2.gif
FileDelete, extensions\Vol.wav
FileDelete, extensions\mute.gif
FileDelete, extensions\Eject.gif

FileDelete, extensions\simwin.ahk
FileDelete, extensions\ac'tivAid_Winamp.ahk
FileDelete, extensions\ac'tivAid_Winamp_Vol.gif
FileDelete, extensions\ac'tivAid_Winamp_Vol2.gif
FileDelete, extensions\ac'tivAid_Winamp_Vol.wav
FileDelete, betatester.ini

FileDelete, development\unzip.exe


IfExist, backup\ac'tivAid_main.exe
{
   FileDelete, ac'tivAid.exe
   FileMove, backup\ac'tivAid_main.exe, backup\ac'tivAid.exe
}

IniDelete,%ConfigFile%, WinAmp

IniDelete, %ConfigFile%, %ScriptNameClean%, UpdateURL

   IniRead, qc_PathsToIndex, %ConfigFile%, %qc_ScriptName%, PathsToIndex
   IniRead, qc_IndexPath, %ConfigFile%, %qc_ScriptName%, IndexPath
   IniRead, qc_AutoIndexingSpace, %ConfigFile%, %qc_ScriptName%, AutoIndexingSpace
   IniRead, qc_IndexThreshold, %ConfigFile%, %qc_ScriptName%, IndexThreshold
   IniRead, qc_AutoIndexingTime, %ConfigFile%, %qc_ScriptName%, AutoIndexingTime
   IniRead, qc_AutoIndexingTimeFailure, %ConfigFile%, %qc_ScriptName%, AutoIndexingTimeFailure
   IniRead, qc_IndexTimeValues, %ConfigFile%, %qc_ScriptName%, IndexTimeValues
   IniRead, qc_AutoIndexingInterval, %ConfigFile%, %qc_ScriptName%, AutoIndexingInterval
   IniRead, qc_IndexInterval, %ConfigFile%, %qc_ScriptName%, IndexInterval
   IniRead, qc_NoBalloonTips, %ConfigFile%, %qc_ScriptName%, NoBalloonTips
   IniRead, qc_FolderTree, %ConfigFile%, %ld_ScriptName%, FolderTree

   If (qc_IndexPath <> "ERROR" AND qc_PathsToIndex <> "ERROR")
   {

     IniWrite, %qc_IndexPath%, %ConfigFile_QuickChangeDir%, Config, IndexPath
     IniWrite, %qc_PathsToIndex%, %ConfigFile_QuickChangeDir%, Config, PathsToIndex
     IniWrite, %qc_AutoIndexingSpace%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingSpace
     IniWrite, %qc_IndexThreshold%, %ConfigFile_QuickChangeDir%, Schedule, IndexThreshold
     IniWrite, %qc_AutoIndexingTime%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingTime
     IniWrite, %qc_AutoIndexingTimeFailure%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingTimeFailure
     IniWrite, %qc_IndexTimeValues%, %ConfigFile_QuickChangeDir%, Schedule, IndexTimeValues
     IniWrite, %qc_AutoIndexingInterval%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingInterval
     IniWrite, %qc_IndexInterval%, %ConfigFile_QuickChangeDir%, Schedule, IndexInterval
     IniWrite, %qc_NoBalloonTips%, %ConfigFile_QuickChangeDir%, Config, NoBalloonTips
     IniWrite, %qc_FolderTree%, %ConfigFile_QuickChangeDir%, Config, FolderTree


     IniRead, qc_WinX, %ConfigFile%, %qc_ScriptName%, SearchWindowX, %A_Space%
     IniRead, qc_WinY, %ConfigFile%, %qc_ScriptName%, SearchWindowY, %A_Space%
     IniWrite, %qc_WinX%, %ConfigFile_QuickChangeDir%, Window, SearchWindowX
     IniWrite, %qc_WinY%, %ConfigFile_QuickChangeDir%, Window, SearchWindowY

     IniRead, qc_WinW, %ConfigFile%, %qc_ScriptName%, ResultWindowWidth, 620  ; Fensterbreite
     IniRead, qc_WinH, %ConfigFile%, %qc_ScriptName%, ResultWindowHeight, 460 ; Fensterhhe
     IniRead, qc_WinX, %ConfigFile%, %qc_ScriptName%, ResultWindowX, %A_Space%  ; Fenster X
     IniRead, qc_WinY, %ConfigFile%, %qc_ScriptName%, ResultWindowY, %A_Space% ; Fenster Y
     IniWrite, %qc_WinW%, %ConfigFile_QuickChangeDir%, Window, ResultWindowWidth
     IniWrite, %qc_WinH%, %ConfigFile_QuickChangeDir%, Window, ResultWindowHeight
     IniWrite, x%qc_WinX%, %ConfigFile_QuickChangeDir%, Window, ResultWindowX
     IniWrite, y%qc_WinY%, %ConfigFile_QuickChangeDir%, Window, ResultWindowY

     IniDelete, %ConfigFile%, QuickChangeDir
   }

IfNotInString, A_Scriptname, -Checker
   Reload

Return

func_Download( URL, File, Splashtext, Title, Size )
{
   Thread,Priority,-1000
   global DownloadProgressSplashtext,DownloadProgressFile,DownloadProgressFileSize,DownloadProgressTotalSize,DownloadProgressAddSize,DownloadProgressTitle
   Random, Random1, 1, 99999
   Random, Random2, 1, 99999
   DownloadProgressTotalSize = %Size%

   Suspend, On
   DownloadProgressAddSize = 0
   DownloadProgressSplashtext = %Splashtext%
   DownloadProgressTitle = %Title%
   DownloadProgressFile = %File%
   If Size > 5
      Progress, T FM10 FS10 WM400 WS400 P0 w400 M2, %File%, %DownloadProgressSplashtext%, AutoHotkey Update
   Else
      SplashImage,, T FS9 W400 M2, %DownloadProgressSplashtext%
   SetTimer, tim_DownloadProgress, 10, 1000
   URLDownloadToFile, %URL%?dl=%Random1%&ul=%Random2%, %File%
   ReturnVal = %ErrorLevel%

   SetTimer, tim_DownloadProgress, off
   SplashImage, Off
   Progress, Off
   Return %ReturnVal%
}

tim_DownloadProgress:
   FileGetSize, DownloadProgressFileSize, %DownloadProgressFile%, K
   DownloadProgressFileSize := DownloadProgressAddSize + DownloadProgressFileSize
   If DownloadProgressFileSize = %DownloadProgressFileSizeLast%
      return
   If DownloadProgressTotalSize > 5
   {
      DownloadProgressPercentage := Round(DownloadProgressFileSize / DownloadProgressTotalSize * 100,0)
      Progress, %DownloadProgressPercentage%
   }
   Else
   {
      SplashImage,,b1 FS9 W400, %DownloadProgressSplashtext% (%DownloadProgressFileSize% Kb)
   }
   DownloadProgressFileSizeLast = %DownloadProgressFileSize%
Return

sub_RunAsAdmin:
   Gui, 5:-Minimizebox
   IniRead, AdminName, %ConfigFile%, %ScriptName%, AdminName, Administrator
   Gui, 5:Add, Text, w200, %lng_RunAsAdmin%`n`n%lng_AdminNAme%:
   Gui, 5:Add, Edit, w200 vAdminName, %AdminName%
   Gui, 5:Add, Text, , %lng_Password%:
   Gui, 5:Add, Edit, w200 vAdminPass Password, %AdminPass%
   Gui, 5:Add, Button, -Wrap x25 w80 Default gsub_RunAsAdminOk, %lng_Ok%
   Gui, 5:Add, Button, -Wrap x+5 w80 g5GuiClose, %lng_Cancel%
   Gui, 5:Show, w220, %ScriptTitle%
Return

sub_RunAsAdminOK:
   Gui, 5:Submit
   Gui, 5:Destroy
   If AdminName <>
   {
      IniWrite, %AdminName%, %ConfigFile%, %ScriptName%, AdminName
      RunAs, %AdminName%, %AdminPass%, @%USERDOMAIN%
      Run, %A_AutoHotkeyPath%\AutoHotkey.exe "%A_ScriptFullPath%" ,%A_ScriptDir%, UseErrorLevel
      If ErrorLevel = ERROR
      {
         RunAs
         Msgbox, 16, %ScriptTitle% %lng_RunAsAdmin%, %lng_WrongAdmin%
         Goto, sub_RunAsAdmin
      }
   }
Return

5GuiClose:
5GuiEscape:
   Gui, 5:Destroy
   ExitApp
Return
