/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: timer.c
 * Info: Routinen fr die Timer
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.04
*/
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include "mcu.h"
#include "led.h"
#include "key.h"
#include "adc.h"
#include "display.h"


#define TIMER_CLOCK	2	//Timer interrupt freq in Hz
#define TIMER_0_CLOCK	1000	//Timer 0 frequency in Hz (5ms)

volatile int dummy;	
/* Interrupt Handler for Timer/Counter 1 */
SIGNAL (SIG_OUTPUT_COMPARE1A){
	// Lauftext
	ticks++;
	if (ticks == TICKER_LENGTH-20)
		ticks=0;
	ticker = TICKER_TEXT + ticks;
	display_update=1;
	// Ende Lauftext
	
//	OCR1B=100;	//reset auch fr den anderen Timer
}

/* Interrupt Handler for Timer/Counter 1 */
SIGNAL (SIG_OUTPUT_COMPARE1B){
	OCR1B+=dummy;	// weiter setzen, da fr Compare B kein rcksetzen
			// des Timers!

}

/* Interrupt Handler for Timer/Counter 0 */
SIGNAL (SIG_OUTPUT_COMPARE0){
	adc_isr();
	//dreh_isr();
}

/* initilaisiert Timer 0 und startet ihn */
void timer_0_init(void){
	TCNT0  = 0x00;            // TIMER0 vorladen
	// use CLK/1024 prescale value, clear timer/counter on compare0 match   
	TCCR0 = _BV(WGM01) | _BV(CS00) | _BV(CS02);
	
	//Compare Register !!!Achtung nur 8-Bit breit --> evtl. teiler anpassen
	OCR0 = ((XTAL/1024/TIMER_0_CLOCK) - 1 );
	//OCR0=42;
	
	// enable Output Compare 0 overflow interrupt
	TIMSK  |= _BV(OCIE0);
	sei();                       // enable interrupts
}


void timer_1_init(void){
	
	TCCR1A = 0;	// Normal operation Output pins disconnected
	//TCCR1B = 5;	// Clock Source divisor= 1024
	TCNT1= 0x000;	//reset counter
	//OCR1A= 0xFFFF;	// Compare value A

	// use CLK/1024 prescale value, clear timer/counter on compareA match   
	TCCR1B = _BV(CS10) | _BV(CS12)  | _BV(WGM12);
	
	// preset timer1 high/low byte
	OCR1A = ((XTAL/1024/TIMER_CLOCK) - 1 );	
	
	//OCR1B = ((XTAL/2/64/(TIMER_CLOCK*4)) - 1 );
	//dummy=OCR1B;
	
	// enable Output Compare 1 overflow interrupt
	TIMSK|= _BV(OCIE1A);//| _BV(OCIE1B);

	sei();                       // enable interrupts
}
