/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: key.c 
 * Info: Routinen zum Einlesen der Taster
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <io.h>
#include <delay.h>
#include "key.h"
#include "led.h"
#include "tools.h"
#include "display.h"


#define DREH_A 0x10
#define DREH_B 0x20
#define DREH_TAST 0x40
#define DREH_ALL (DREH_A+DREH_B+DREH_TAST)

// Anzahl der Aufrufe von dreh_isr, die zum entprellen genutzt werden
#define ENTPRELLEN 5	

void dreh_init(void){
	DDRC &= ~ DREH_ALL; 	//Drehkontakte als Input
	PORTC |= DREH_ALL;	// Alle Pullups an.
	drehgeber=0x000;
}


const int8_t graytab[] = { 0,-1,1,0, 1,0,0,-1, -1,0,0,+1, 0,1,-1,0 };
volatile static unsigned char graycode = 0;
int drehgeber;
char drehtaste=0;	// muss per hand zurckgesetzt werden!
volatile static char drehtaste_tmp=0;	

/* Interrupt Routine, die den Drehgeber ausliest und die Taste entprellt */
void dreh_isr(void){
  graycode >>= 2;          		// old state to bit 1, 0

  if( (PINC & DREH_A) ==DREH_A )	//A=1 ?
    graycode |= 0x04;                   // new A state to bit 4
  if( (PINC & DREH_B) ==DREH_B )	//B=1 ?
    graycode |= 0x08;			// new B state to bit 5
  
  drehgeber += graytab[graycode];	// +/- 1 if state change
  
  if ((PINC & DREH_TAST) ==0){		// Taste gedrckt?
	  if (drehtaste_tmp < ENTPRELLEN){
		drehtaste_tmp++;	// Entpreller hochzhlen
	  	if (drehtaste_tmp ==ENTPRELLEN)	//Genug entprellt? 
			drehtaste++;
	  }
  } else {	// Wenn Taste nicht gedrckt, dann Entpreller lschen
  	drehtaste_tmp=0;
  }
}

/* Liest den Zustand der Taste des Drehgebers aus
   Gibt die Anzahl der Tastendrcke seit dem letzten Aufruf aus.
*/
char dreh_read(){
	char retVal=drehtaste;
	drehtaste=0;
	return retVal;
}

//Liest alle Tasten aus. Wartet bis zu timeout und kehrt dann auch zurck, wenn keine nderung erfolgt ist. Liefert die Hex Werte der Keys zurck, wenn diese nicht gedrckt sind (d.h. alles ist negiert, da Taster als Pull-Downs)
char key_read(char timeout){
	char old_DDRD= DDRD;	// Alte Einstellungen sichern
	char old_PORTD= PORTD;
	
	char key,old,temp;	//Tastenpuffer
	char i,j,k;		//Zhler
	
	DDRD  &= ~ KEY_ALL;	// All Key-Ports as Input	
	PORTD |=   KEY_ALL;	// Alle Pullups an.

	key = PIND;		//  Einlesen 
	key &= KEY_ALL;		// und maskieren
	old=key;
	
	k=0; i=0;
	while ((old == key) & (i < timeout)){   // warten, bis Taste gedrckt
		
	 	k++;				// Innenzhler erhhen
	 	if (k==0) i++;			// jeden 8-Bit berlauf den
						// aussen Zhler erhhen

		key = PIND;			// Neu Einlesen 
		key &= KEY_ALL;			// und maskieren
						
		// whrend wir warten alten Zustand
		DDRD= (DDRD & ~KEY_ALL) | (old_DDRD &KEY_ALL);
		PORTD=(PORTD & ~KEY_ALL) | (old_PORTD &KEY_ALL);
		
		for (j=0; j< 255; j++){}	// warten
		DDRD  &= ~ KEY_ALL;	// All Key-Ports as Input	
		PORTD |=   KEY_ALL;	// Alle Pullups an.
		
		temp = PIND;			// zum entprellem nochmal lesen
		temp &= KEY_ALL;		// und maskieren
		
		if (key != temp)		// falls unterschiedliches
			key=old;		// gelesen, lauf wiederholen
	}

	//Alter Zustand	
	DDRD= (DDRD & ~KEY_ALL) | (old_DDRD &KEY_ALL);
	PORTD=(PORTD & ~KEY_ALL) | (old_PORTD &KEY_ALL);
	
	if (i == timeout) 
		return KEY_TIMEOUT;
	else
		return key;
}
