#include "expensehelper.h"

#include <QStringList>
#include <QTableWidgetItem>

static const int EXPENSE_DESCRIPTION_COLUMN = 0;
static const int ORIGINAL_AMOUNT_COLUMN = 1;
static const int CONVERSION_RATE_COLUMN = 2;
static const int CONVERTED_AMOUNT_COLUMN = 3;

ExpenseHelper::ExpenseHelper(QWidget *parent)
: QDialog(parent), Ui::ExpenseHelperDialog()
{
  // call the generated code from Qt Designer
	setupUi(this);

  // Set the labels for the table headers
  QStringList headerLabels;
  headerLabels  << "Description"
                << "Original amount"
                << "Conversion rate"
                << "Converted Amount";
  tableWidget->setColumnCount( headerLabels.count() );
  tableWidget->setHorizontalHeaderLabels( headerLabels );
}

ExpenseHelper::~ExpenseHelper()
{
}

void ExpenseHelper::on_addRowButton_clicked()
{
  int curRow = tableWidget->rowCount();
  tableWidget->insertRow( curRow );

  // Create the items for each cell and insert them in the table widget
  QTableWidgetItem *descriptionCell = new QTableWidgetItem();
  QTableWidgetItem *originalCell = new QTableWidgetItem();
  QTableWidgetItem *rateCell = new QTableWidgetItem();
  QTableWidgetItem *convertedCell = new QTableWidgetItem();
  convertedCell->setFlags( convertedCell->flags() & ~Qt::ItemIsEditable ); // read-only

  tableWidget->setItem( curRow, EXPENSE_DESCRIPTION_COLUMN, descriptionCell );
  tableWidget->setItem( curRow, ORIGINAL_AMOUNT_COLUMN, originalCell );
  tableWidget->setItem( curRow, CONVERSION_RATE_COLUMN, rateCell );
  tableWidget->setItem( curRow, CONVERTED_AMOUNT_COLUMN, convertedCell );

  // This triggers the in-cell editor for the expense description cell
  tableWidget->editItem( descriptionCell );
}

void ExpenseHelper::on_removeRowButton_clicked()
{
  tableWidget->removeRow( tableWidget->currentRow() );
}

void ExpenseHelper::on_computeButton_clicked()
{
  // Parse every line of the table
  for( int i = 0 ; i < tableWidget->rowCount() ; i++ ) {
    QString cellOriginal = tableWidget->item( i, ORIGINAL_AMOUNT_COLUMN )->text();
    QString cellRate = tableWidget->item( i, CONVERSION_RATE_COLUMN )->text();

    if( !cellOriginal.isEmpty() && !cellRate.isEmpty() ) {
      bool amountOk, rateOk;
      float original = cellOriginal.toFloat( &amountOk );
      float rate = cellRate.toFloat( &rateOk );
      QString result;
      if( amountOk && rateOk ) {
        result.setNum( original * rate );
      } else {
        result = "Error";
      }
      tableWidget->item( i, CONVERTED_AMOUNT_COLUMN )->setText( result );
    }
  }
}
