/*
 * Decompiled with CFR 0.152.
 */
package de.ct.wortschatz;

import de.ct.wortschatz.thesaurus.DataMatrix;
import de.ct.wortschatz.thesaurus.DataVector;
import de.ct.wortschatz.thesaurus.RequestParameter;
import de.ct.wortschatz.thesaurus.ResponseParameter;
import de.ct.wortschatz.thesaurus.ThesaurusServiceLocator;
import de.ct.wortschatz.thesaurus.ThesaurusSoapBindingStub;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class Wortschatz {
    private final String userName = "ct-thesaur";
    private final String password = "ct-thesaurus";
    private final String wordParm = "Wort";
    private final String limitParm = "Limit";
    private String term = null;
    private int limit = 100;
    private String corpus = "de";
    private Logger logger = null;
    private ThesaurusSoapBindingStub thesBinding = null;
    private DataMatrix thesObjParameters = null;
    private RequestParameter thesRequestParm = null;
    private boolean connected = false;
    private String lastExecutionTime = null;

    public Wortschatz() {
    }

    public Wortschatz(String term) {
        this.term = term;
    }

    public Wortschatz(String term, int limit) {
        this.term = term;
        this.limit = limit;
    }

    public Wortschatz(String term, int limit, String corpus) {
        this.term = term;
        this.limit = limit;
        this.corpus = corpus;
    }

    public Wortschatz(String term, String corpus) {
        this.term = term;
        this.corpus = corpus;
    }

    protected void connect() {
        try {
            this.thesBinding = (ThesaurusSoapBindingStub)new ThesaurusServiceLocator().getThesaurus();
        }
        catch (ServiceException se) {
            this.writeErrorLog(se.getMessage());
        }
        this.thesBinding.setUsername("ct-thesaur");
        this.thesBinding.setPassword("ct-thesaurus");
        this.connected = true;
    }

    public String[] getSynonyms() {
        if (!this.connected) {
            this.connect();
        }
        this.thesObjParameters = new DataMatrix();
        DataVector[] v = new DataVector[]{new DataVector(new String[]{"Wort", this.term}), new DataVector(new String[]{"Limit", String.valueOf(this.limit)})};
        this.thesObjParameters.setDataVectors(v);
        this.thesRequestParm = new RequestParameter();
        this.thesRequestParm.setCorpus(this.corpus);
        this.thesRequestParm.setParameters(this.thesObjParameters);
        ResponseParameter thesResult = null;
        DataVector[] res = null;
        String[] synonyms = null;
        try {
            thesResult = this.thesBinding.execute(this.thesRequestParm);
        }
        catch (Exception e) {
            this.writeErrorLog(e.getMessage());
        }
        res = thesResult.getResult().getDataVectors();
        this.lastExecutionTime = thesResult.getExecutionTime();
        if (res != null) {
            int numResults;
            int n = numResults = res.length < this.limit ? res.length : this.limit;
            if (numResults > 0) {
                synonyms = new String[numResults];
                int i = 0;
                while (i < numResults) {
                    synonyms[i] = res[i].getDataRow(0);
                    ++i;
                }
            }
        }
        return synonyms;
    }

    public String getStatus() {
        if (!this.connected) {
            this.connect();
        }
        String res = null;
        try {
            res = this.thesBinding.ping();
        }
        catch (Exception e) {
            this.writeErrorLog(e.getMessage());
        }
        return res;
    }

    public String getExecutionTime() {
        return this.lastExecutionTime != null ? this.lastExecutionTime : new String("");
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void writeLog(String entry) {
        if (this.logger != null) {
            this.logger.info((Object)entry);
        } else {
            System.out.println(entry);
        }
    }

    protected void writeErrorLog(String entry) {
        if (this.logger != null) {
            this.logger.error((Object)entry);
        } else {
            System.err.println(entry);
        }
    }
}

