using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;

namespace ctEuroCalc
{
	/// <summary>
	/// Zusammenfassung fr Service1.
	/// </summary>
	
	public class ctEuroCalc : System.Web.Services.WebService
	{

		protected string[] Currencies = {"ATS", "BEF", "DEM",
				"ESP", "FIM", "FRF", "GRO", "IEP", "ITL", "LUF", "NLG", "PTE"};
		protected double[] Rates = { 13.76, 40.34, 1.96,
 		  166.39, 5.95, 6.56, 340.75, 0.79, 1936.27, 40.34, 2.20, 200.48 };
		
		protected System.Double GetRate(string Currency)
		{
			for (int x = 0; x < 12; x++)
				if (Currency == Currencies[x])
					return Rates[x];
			return -1;
		}


		public ctEuroCalc()
		{
			//CODEGEN: Dieser Aufruf ist fr den ASP.NET-Webdienst-Designer erforderlich.
			InitializeComponent();
		}

		[WebMethod]
		public System.Double FromEuro(string Currency, System.Double Amount) 
		{
		
			return (System.Double) (Amount * GetRate(Currency));
	  }


		[WebMethod]
		public System.Double ToEuro(string Currency, System.Double Amount) 
		{
			return (System.Double) (Amount / GetRate(Currency));
		}

		#region Vom Komponenten-Designer generierter Code
		
		//Erforderlich fr den Webdienst-Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion

	}
}
