import ui.UIComponent;
import ui.events.UIChangeListener;
class ui.controls.UICheckBox extends UIComponent {
	public static var symbolName:String = "UICheckBox";
	private static var ICON_HOLDER_DEPTH:Number = 0;
	private static var TEXT_HOLDER_DEPTH:Number = 1;
	public var checkBoxTrueSkin:String = "checkBoxTrue";
	public var checkBoxFalseSkin:String = "checkBoxFalse";
	private var _label:String = "";
	private var _value:Boolean = false;
	private var _iconHolder:MovieClip = null;
	private var _textHolder:TextField = null;
	private var _changeListeners:Array = null;
	function UICheckBox() {
	}
	private function init():Void {
		_changeListeners = new Array();
		draw();
	}
	public function addChangeListener(listener:UIChangeListener):Void {
		// Merke Listener
		_changeListeners.push(listener);
	}
	private function onValueChanged():Void {
		// Teile Listenern eine Zustandänderung mit
		var i:Number;
		var listener:UIChangeListener;
		for (i=0; i<_changeListeners.length; i++) {
			listener = UIChangeListener(_changeListeners[i]);
			listener.valueChanged();
		}
	}
	private function draw():Void {
		drawIcon();
		drawLabel();
	}
	private function drawIcon():Void {
		// Zeichne Kontrollkästchen
		if (getValue()) {
			_iconHolder = attachMovie(checkBoxTrueSkin, "_iconHolder", ICON_HOLDER_DEPTH);
		} else {
			_iconHolder = attachMovie(checkBoxFalseSkin, "_iconHolder", ICON_HOLDER_DEPTH);
		}
	}
	private function drawLabel():Void {
		// Zeichne Beschriftung
		createTextField("_textHolder", TEXT_HOLDER_DEPTH, 15, 0, null, null);
		_textHolder.autoSize = true;
		_textHolder.text = getLabel();
	}
	public function onRelease():Void {
		setValue(!_value);
	}
	public function getValue():Boolean {
		return _value;
	}
	public function setValue(v:Boolean):Void {
		// Ändere Zustand
		_value = v;
		drawIcon();
		onValueChanged();
	}
	public function getLabel():String {
		return _label;
	}
	public function setLabel(v:String):Void {
		_label = v;
		drawLabel();
	}
}
