import ui.containers.UIGrid;
import ui.controls.UICheckBox;
import ui.controls.UIImage;
import ui.events.UIChangeListener;
import models.Property;
import models.PropertyModel;
class core.Application implements UIChangeListener {
	private var _desktop:MovieClip;
	private var _garageCheckBox:UICheckBox;
	private var _gardenCheckBox:UICheckBox;
	private var _chimneyCheckBox:UICheckBox;
	private var _imageGrid:UIGrid;
	private var _model:PropertyModel;
	public function Application() {
		init();
	}
	private function init():Void {
		_desktop = _root;
		createModel();
		drawControls();
		drawImageGrid();
	}
	private function createModel():Void {
		// Erzeuge Modell
		var property:Property;
		_model = new PropertyModel();
		property = new Property();
		property.setChimney(false);
		property.setGarage(false);
		property.setGarden(true);
		property.setImageSource("church");
		_model.push(property);
		property = new Property();
		property.setChimney(false);
		property.setGarage(true);
		property.setGarden(false);
		property.setImageSource("skyscraper");
		_model.push(property);
		property = new Property();
		property.setChimney(true);
		property.setGarage(true);
		property.setGarden(false);
		property.setImageSource("factory");
		_model.push(property);
		property = new Property();
		property.setChimney(true);
		property.setGarage(true);
		property.setGarden(true);
		property.setImageSource("dwelling");
		_model.push(property);
		property = new Property();
		property.setChimney(false);
		property.setGarage(false);
		property.setGarden(true);
		property.setImageSource("villa");
		_model.push(property);
	}
	private function drawControls():Void {
		// Erzeuge Kontrollkaestchen
		_garageCheckBox = UICheckBox(_desktop.attachMovie(UICheckBox.symbolName, "_garageCheckBox", 1));
		_garageCheckBox.setX(20);
		_garageCheckBox.setY(20);
		_garageCheckBox.setLabel("Garage");
		_garageCheckBox.addChangeListener(this);
		_gardenCheckBox = UICheckBox(_desktop.attachMovie(UICheckBox.symbolName, "_gardenCheckBox", 2));
		_gardenCheckBox.setX(20);
		_gardenCheckBox.setY(40);
		_gardenCheckBox.setLabel("Garten");
		_gardenCheckBox.addChangeListener(this);
		_chimneyCheckBox = UICheckBox(_desktop.attachMovie(UICheckBox.symbolName, "_chimneyCheckBox", 3));
		_chimneyCheckBox.setX(20);
		_chimneyCheckBox.setY(60);
		_chimneyCheckBox.setLabel("Kamin");
		_chimneyCheckBox.addChangeListener(this);
	}
	private function drawImageGrid():Void {
		var property:Property;
		var image:UIImage;
		var enabled:Boolean;
		var i:Number;
		// Erzeuge Gitter
		_imageGrid = UIGrid(_desktop.attachMovie(UIGrid.symbolName, "_imageGrid", 0));
		_imageGrid.setWidth(500);
		_imageGrid.setHeight(500);
		_imageGrid.setColumnCount(3);
		_imageGrid.setRowCount(3);
		_imageGrid.setX(200);
		_imageGrid.setY(20);
		// Fuege Bilder hinzu
		for (i=0; i<_model.length; i++) {
			property = Property(_model.getPropertyAt(i));
			image = UIImage(_imageGrid.addChild(UIImage.symbolName));
			image.setSource(property.getImageSource());
			// Überprüfe Status
			enabled = true;
			if (_garageCheckBox.getValue()) {
				enabled = enabled && property.getGarage();
			}
			if (_gardenCheckBox.getValue()) {
				enabled = enabled && property.getGarden();
			}
			if (_chimneyCheckBox.getValue()) {
				enabled = enabled && property.getChimney();
			}
			image.setEnabled(enabled);
		}
	}
	public function valueChanged():Void {
		// Aktualisiere Anzeige
		drawImageGrid();
	}
}
