/*
 * Copyright 1998-2004 VIA Technologies, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef VIA_ACE_H
#define VIA_ACE_H

#ifdef __cplusplus
extern "C" {
#endif

// The Maximum Size for padlock_ace_alloc_buf is 64kb 
#define MAX_CIPHER_BUFFER_SIZE            (64 * 1024)

#define PUSHREG	asm("pushl %eax\n pushl %ebx\n pushl %ecx\n pushl %edx\n pushl %edx\n pushl %esi\n pushl %edi\n");
#define POPREG  asm("popl %edi\n popl %esi\n popl %edx\n popl %ecx\n popl %ebx\n popl %eax\n");
#define XSTORERNG	asm(".byte 0x0F, 0xA7, 0xC0\n");

#define NEH_GEN_KEY 	0x00000000	// generate key schedule
#define NEH_LOAD_KEY 	0x00000080	// load key schedule from memory

#define NEH_ENCRYPT 	0x00000000	// encryption
#define NEH_DECRYPT 	0x00000200	// decryption

#define NEH_KEY128 	0x000 + 0x00a	// 128 bit key
#define NEH_KEY192 	0x400 + 0x00c	// 192 bit key
#define NEH_KEY256 	0x800 + 0x00e	// 256 bit key

struct ace_aes_context
{
	ACE_AES_MODE mode;
	KEY_LENGTH key_length;
	unsigned char *iv;
	unsigned char last_iv[16];
	unsigned int encrypt_extended_key[60];
	unsigned int decrypt_extended_key[60];
};

struct aligned_memory_context
{
	int size;
	int offset;                     // the length of buf used
	unsigned char *temp_buf;
	unsigned char *p_alignedbuf;
};

#define ALIGN16(x) (unsigned char *)((((unsigned long)x) + 15 )&(~15UL))
#define UNALIGNED(addr) ((unsigned int)(addr) & 0x0000000F)

static __inline volatile void ace_ecb_op5(
				const void *key, 
				const void *ctrl, 
				const void *src, 
				void *dst, 
				int count) 
{
	__asm__ __volatile__ ("pushfl\n popfl\n\t \
		\
		movl %0, %%ebx\n\t \
		movl %1, %%ecx\n\t \
		movl %2, %%edx\n\t \
		movl %3, %%esi\n\t \
		movl %4, %%edi\n\t \
		\
		rep\n  \
		.byte 0x0F, 0xA7, 0xC8\n "\
		: \
		:"m"(key), "m"(count), "m"(ctrl), "m"(src), "m"(dst) \
		:"ebx", "ecx", "edx", "esi", "edi");
}

static __inline volatile void ace_cbc_op6(
				const void *key, 
				const void *ctrl, 
				const void *src, 
				void *dst, 
				int count,
				void *iv) 
{
	__asm__ __volatile__ ("	pushfl\n popfl\n\t \
		\
		movl %0, %%eax\n\t \
		movl %1, %%ebx\n\t \
		movl %2, %%ecx\n\t \
		movl %3, %%edx\n\t \
		movl %4, %%esi\n\t \
		movl %5, %%edi\n\t \
		\
		rep\n  \
		.byte 0x0F, 0xA7, 0xD0\n" \
		: \
		:"m"(iv),"m"(key), "m"(count), "m"(ctrl), \
		 "m"(src), "m"(dst) \
		:"eax","ebx", "ecx", "edx", "esi", "edi");
}

static __inline volatile void ace_cfb_op6(
				const void *key, 
				const void *ctrl, 
				void *src, 
				void *dst, 
				int count,
				void *iv) 
{
	__asm__ __volatile__ ("	pushfl\n popfl\n\t \
		\
		movl %0, %%eax\n\t \
		movl %1, %%ebx\n\t \
		movl %2, %%ecx\n\t \
		movl %3, %%edx\n\t \
		movl %4, %%esi\n\t \
		movl %5, %%edi\n\t \
		\
		rep\n  \
		.byte 0x0F, 0xA7, 0xE0\n" \
		: \
		:"m"(iv),"m"(key), "m"(count), "m"(ctrl), \
		 "m"(src), "m"(dst) \
		:"eax","ebx", "ecx", "edx", "esi", "edi");
}

static __inline volatile void ace_ofb_op6(
				const void *key, 
				const void *ctrl, 
				void *src, 
				void *dst, 
				int count,
				void *iv) 
{
	__asm__ __volatile__ ("	pushfl\n popfl\n\t \
		\
		movl %0, %%eax\n\t \
		movl %1, %%ebx\n\t \
		movl %2, %%ecx\n\t \
		movl %3, %%edx\n\t \
		movl %4, %%esi\n\t \
		movl %5, %%edi\n\t \
		\
		rep\n  \
		.byte 0x0F, 0xA7, 0xE8\n" \
		: \
		:"m"(iv),"m"(key), "m"(count), "m"(ctrl), \
		 "m"(src), "m"(dst) \
		:"eax","ebx", "ecx", "edx", "esi", "edi");
}

AES_RESULT
ace_aes_atomic_crypt(struct ace_aes_context *ctx, 
                          int enc,
                          unsigned char *src, 
						  unsigned char *dst, 
						  int nbytes);

#if defined(__cplusplus)
}
#endif

#endif /* VIA_ACE_H */
