/* $Id: benchmark.h 30 2005-05-02 15:14:01Z olau $ */

#ifndef _BENCHMARK_H_
#define _BENCHMARK_H_

#include "../timer/timer.h"

#define PARAM_BLOCKSIZE         "blocksize"
#define PARAM_REPETITIONS       "repetitions"
#define PARAM_ITERATIONS        "iterations"
#define PARAM_KEY               "key"
#define PARAM_KEYSIZE           "keysize"
#define PARAM_IV                "iv"
#define PARAM_MODE              "mode"
#define PARAM_LOG               "log"

#define MODESTRING_ECB          "ecb"
#define MODESTRING_CBC          "cbc"
#define MODESTRING_OFB          "ofb"
#define MODESTRING_CFB          "cfb"

enum {
  MODE_ECB,
  MODE_CBC,
  MODE_OFB,
  MODE_CFB
};

#define DEFAULT_MODE            MODE_CBC

enum {
  SELECT_BLOCKSIZE,
  SELECT_REPETITIONS,
  SELECT_ITERATIONS,
  SELECT_KEY,
  SELECT_KEYSIZE,
  SELECT_IV,
  SELECT_MODE,
  SELECT_LOG
};

#define DEFAULT_REPETITIONS                5
#define DEFAULT_ITERATIONS               100
#define DEFAULT_BLOCKSIZE               1024
#define DEFAULT_ROUNDS                    14
#define DEFAULT_KEYSIZE               (256/8)
#define DEFAULT_IVSIZE                    16

#ifdef DEBUG
#  define DPRINTF(s) printf(s); fflush(stdout);
#else
#  define DPRINTF(s)
#endif

#endif /* _BENCHMARK_H_ */
