using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using WSClient.uk.co.drbob42.www;

namespace WSClient
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ComboBox comboBox1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton rToEuro;
		private System.Windows.Forms.RadioButton rFromEuro;
		private System.Windows.Forms.Button bConvert;
		private System.Windows.Forms.TextBox eOldCurr;
		private System.Windows.Forms.TextBox eEuro;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label lOldCurr;
		private System.Windows.Forms.Button bBench;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

	
		public Form1()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();
      comboBox1.SelectedIndex = 0;
			rToEuro.Checked = true;
			eOldCurr.Text = "0"; eEuro.Text = "0";
			
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.bConvert = new System.Windows.Forms.Button();
			this.comboBox1 = new System.Windows.Forms.ComboBox();
			this.eOldCurr = new System.Windows.Forms.TextBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.rFromEuro = new System.Windows.Forms.RadioButton();
			this.rToEuro = new System.Windows.Forms.RadioButton();
			this.eEuro = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.lOldCurr = new System.Windows.Forms.Label();
			this.bBench = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// bConvert
			// 
			this.bConvert.Location = new System.Drawing.Point(48, 112);
			this.bConvert.Name = "bConvert";
			this.bConvert.TabIndex = 1;
			this.bConvert.Text = "bConvert";
			this.bConvert.Click += new System.EventHandler(this.bConvert_Click);
			// 
			// comboBox1
			// 
			this.comboBox1.DisplayMember = "0";
			this.comboBox1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBox1.Items.AddRange(new object[] {
																									 "ATS",
																									 "BEF",
																									 "DEM",
																									 "ESP",
																									 "FIM",
																									 "FRF",
																									 "GRO",
																									 "IEP",
																									 "ITL",
																									 "LUF",
																									 "NLG",
																									 "PTE"});
			this.comboBox1.Location = new System.Drawing.Point(48, 16);
			this.comboBox1.Name = "comboBox1";
			this.comboBox1.Size = new System.Drawing.Size(121, 21);
			this.comboBox1.Sorted = true;
			this.comboBox1.TabIndex = 2;
			this.comboBox1.SelectedIndexChanged += new System.EventHandler(this.comboBox1_SelectedIndexChanged);
			// 
			// eOldCurr
			// 
			this.eOldCurr.Location = new System.Drawing.Point(48, 48);
			this.eOldCurr.Name = "eOldCurr";
			this.eOldCurr.TabIndex = 3;
			this.eOldCurr.Text = "eOldCurr";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.rFromEuro);
			this.groupBox1.Controls.Add(this.rToEuro);
			this.groupBox1.Location = new System.Drawing.Point(184, 16);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(112, 88);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Conversion";
			// 
			// rFromEuro
			// 
			this.rFromEuro.Location = new System.Drawing.Point(8, 56);
			this.rFromEuro.Name = "rFromEuro";
			this.rFromEuro.Size = new System.Drawing.Size(80, 24);
			this.rFromEuro.TabIndex = 1;
			this.rFromEuro.Text = "FromEuro";
			// 
			// rToEuro
			// 
			this.rToEuro.Location = new System.Drawing.Point(8, 32);
			this.rToEuro.Name = "rToEuro";
			this.rToEuro.Size = new System.Drawing.Size(80, 24);
			this.rToEuro.TabIndex = 0;
			this.rToEuro.Text = "To Euro";
			// 
			// eEuro
			// 
			this.eEuro.Location = new System.Drawing.Point(48, 72);
			this.eEuro.Name = "eEuro";
			this.eEuro.TabIndex = 5;
			this.eEuro.Text = "eEuro";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(24, 76);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(8, 16);
			this.label1.TabIndex = 6;
			this.label1.Text = "";
			// 
			// lOldCurr
			// 
			this.lOldCurr.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lOldCurr.Location = new System.Drawing.Point(8, 52);
			this.lOldCurr.Name = "lOldCurr";
			this.lOldCurr.Size = new System.Drawing.Size(34, 16);
			this.lOldCurr.TabIndex = 7;
			this.lOldCurr.Text = "XXX";
			this.lOldCurr.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// bBench
			// 
			this.bBench.Location = new System.Drawing.Point(192, 112);
			this.bBench.Name = "bBench";
			this.bBench.TabIndex = 8;
			this.bBench.Text = "bBench";
			this.bBench.Visible = false;
			this.bBench.Click += new System.EventHandler(this.bBench_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(352, 149);
			this.Controls.Add(this.bBench);
			this.Controls.Add(this.lOldCurr);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.eEuro);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.eOldCurr);
			this.Controls.Add(this.comboBox1);
			this.Controls.Add(this.bConvert);
			this.Name = "Form1";
			this.Text = "WS Client: Euro Conversion";
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void bConvert_Click(object sender, System.EventArgs e)
		{ 
			if (rToEuro.Checked)
			{
				IEuroservice IS = new IEuroservice(); 
				try
				{ 
					double InVal = Convert.ToDouble(eOldCurr.Text);
					double Res = IS.ToEuro(comboBox1.Text, InVal);
					eEuro.Text = Res.ToString("F2");
				}
				catch
				{
					eEuro.Text = "## N/A ##";
				}
			}
			else
			{
				IEuroservice IS = new IEuroservice(); 
				try
				{ 
					double InVal = Convert.ToDouble(eEuro.Text);
					double Res = IS.FromEuro(comboBox1.Text, InVal);
					eOldCurr.Text = Res.ToString("F2");
				}
				catch
				{
					eOldCurr.Text = "## N/A ##";
				}
			}
		}

		private void comboBox1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			lOldCurr.Text = comboBox1.Text;
		}

		private void bBench_Click(object sender, System.EventArgs e)
		{ DateTime STime = DateTime.Now;
			TimeSpan TS;

			bBench.Enabled = false;

			for (int x = 1; x <= 100; x++)
			{ 
				bConvert_Click(null, null);
				bBench.Text = x.ToString();
				Application.DoEvents();
			}

			TS = DateTime.Now-STime;

			MessageBox.Show("100 Calls: "+ TS.TotalMilliseconds.ToString()+" ms");

			bBench.Enabled = true;
			bBench.Text = "bBench";
  
		}
	}
}
