@echo off %debug%

rem Autor: Johannes Endres
rem Stand: 21.4.05
rem
rem Dieses Skript aktiviert die "Unsolicited Remote Assistance" (URA),
rem auf einem Rechner, der nicht zu einer Windows-Domain gehrt.
rem
rem Es legt dazu einen neuen Administrator-Account mit Passwort an,
rem versteckt diesen Account vor unbedarften Usern, schaltet die URA frei,
rem bohrt Lcher in die Windows-Firewall, deaktiviert die "Einfachen Freigaben"
rem und trgt das Windows-Hilfecenter in die Internet-Explorer-Zone
rem "Arbeitsplatz" ein, um Active Scripting zu erlauben.
rem
rem Details in c't 10/05, ab Seite 102

setlocal

rem Einige Variablen zur Konfiguration

rem Wer mag, kann hier Benutzername und Passwort eintragen, um 
rem sich Tipparbeit zu sparen. Per Default kommen die Daten von
rem der Kommandozeile. Ohne Passwort fragt das Skript nach.
set User=
set Passwd=

rem Falls das Skript von einem Nicht-Admin aufgerufen wird, wechselt
rem es selbst in einen Admin-Account. Dessen Name ist hier konfigurierbar.
set Admin=Administrator

rem Aus welchen Netzwerken soll der Zugriff erlaubt sein?
rem Diese Einstellung wirkt sich auf die Firewall-Konfiguration aus.
rem Mglich sind: "subnet" fr das lokale Netzwerk, "all" fr alle Adressen
rem und detaillierte Einstellungen, deren Syntax der Aufruf
rem netsh firewall add portopening help
rem offenbart.
set scope=subnet

rem So heit die Administratoren-Gruppe
set Group=Administratoren

rem --- Ende der Konfiguration ---

if '/calledmyself=='%1 (
	set calledmyself=yes
	shift
)

rem Wenn ein Benutzername als Argument mitgegeben wurde, nehmen wir das.
if not '=='%1 set User=%1
if '=='%User% (
	echo Dieses Skript braucht einen Usernamen und ein Passwort fr den neu anzulegenden
	echo Remote-Hilfe-Account. Die Angaben kommen normalerweise von der Kommandozeile:
	echo.
	echo %~n0 Username [Passwort]
	echo.
	echo Wenn das Passwort fehlt, fragt das Skript interaktiv danach.
	echo Wer genau wei, was er tut, kann fr beides auch einen Default in die
	echo Skriptdatei eintragen.
	pause
	exit /b
)
if not '=='%2 set Passwd=%2
if '=='%Passwd% set Passwd=*

if not 'yes=='%calledmyself% (
	rem Falls das Skript sich selbst mit Admin-Rechten gestartet hat (siehe unten),
	rem ist diese Prfung schon gelaufen und kann bersprungen werden.
	
	rem Sind die bentigten Programme da?
	call :isda %windir%\System32\reg "/?"
	if errorlevel 9009 exit /b

	call :isda %windir%\System32\net help
	if errorlevel 9009 exit /b

	call :isda %windir%\System32\netsh "/?"
	if errorlevel 9009 exit /b

	rem Zuerst ActiveScripting fr das HelpCenter aktivieren, indem
	rem es in die Arbeitsplatz-Zone eingetragen wird. Es gibt andere
	rem Methoden, aber diese funktioniert mit der grten Wahrscheinlichkeit.
	rem Das passiert vor dem Admin-Check, weil diese Eintragung fr
	rem den aktuellen User sein muss.
	%windir%\system32\reg.exe add "HKCU\Software\Microsoft\Windows\CurrentVersion\Internet Settings\ZoneMap\Domains\//system" /f /v hcp /t REG_DWORD /d 0

	rem Der Rest des Skripts muss mit Administrator-Rechten laufen
	net localgroup %Group% | more +6 | find /i "%username%" >nul
	if errorlevel 1 (
		echo.
		echo Dieses Skript muss mit Administrator-Rechten laufen.
		echo Daher versucht es nun, in den Account "%Admin%" zu wechseln.
		%windir%\system32\runas.exe /user:%Admin% "%~s0 /calledmyself %*"
		exit /b
	)
)

rem Unsolicited Remote Assistance aktivieren
%windir%\system32\reg.exe add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\Terminal Services" /f /v fAllowUnsolicited /t REG_DWORD /d 1
if errorlevel 1 (
  echo.
  echo Registry-Eintragung gescheitert.
  pause
  exit /b
)

rem Die Anforderung der Kontrolle erlauben
%windir%\system32\reg.exe add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\Terminal Services" /f /v fAllowUnsolicitedFullControl /t REG_DWORD /d 1

rem Und den Hilfe-User als solchen eintragen
%windir%\system32\reg.exe add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\Terminal Services\RAUnsolicit" /f /v "%User%" /t REG_SZ /d "%User%"

rem "Einfache Freigaben" ausschalten
%windir%\system32\reg.exe add HKLM\SYSTEM\CurrentControlSet\Control\Lsa /v forceguest /d 0 /t REG_DWORD /f

rem User anlegen...
%windir%\system32\net.exe user %User% %Passwd% /add
if errorlevel 1 (
	rem Den Fehler, dass der User schon existiert, ignorieren
	if %errorlevel% neq 2 (
	  echo.
	  echo Anlegen des Benutzerkontos %User% gescheitert.
	  pause
	  exit /b
	)
)

rem ... und zum Admin machen
%windir%\system32\net.exe localgroup %Group% %User% /ADD

rem User auf dem Willkommensbildschirm und in der einfachen Benutzerverwaltung verstecken
%windir%\system32\reg.exe add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon\SpecialAccounts\UserList" /f /v "%User%" /t REG_DWORD /d 0
if errorlevel 1 (
  echo.
  echo Manipulation des "Willkommen"-Bildschirms gescheitert.
  pause
  exit /b
)

rem Dann bohren wir noch die erforderlichen drei Lcher in die Firewall
%windir%\system32\netsh.exe firewall add allowedprogram %windir%\system32\sessmgr.exe Remoteuntersttzung enable
if errorlevel 1 (
  echo.
  echo nderung der Firewall-Einstellungen fehlgeschlagen
  pause
  exit /b
)
%windir%\system32\netsh.exe firewall add allowedprogram %windir%\PCHEALTH\HELPCTR\Binaries\helpsvc.exe Hilfedienst enable %scope%
%windir%\system32\netsh.exe firewall add portopening TCP 135 "RPC/DCOM" enable %scope%

rem Diese drei Eintrge haben nur einen Sinn, wenn die Firewall berhaupt Ausnahmen zulsst
%windir%\system32\netsh.exe firewall set opmode mode=enable exceptions=enable

exit /b 0

:isda
%1 %2 >nul
if errorlevel 9009 (
  echo.
  echo Dieses Skript bentigt das Programm %1.exe,
  echo kann es aber im System32-Ordner nicht finden.
  echo.
  echo Programmabbruch.
  pause
  exit /b 9009
)
exit /b 0