#!/usr/bin/python

import sys, os             # Standardmodule
import photoshopy as pspy  # PS Zugriff via COM/OLE
comc = pspy.constants      # einfacherer Zugriff auf Konstanten

class PhotoshopEnv(object):
    #
    # Photoshop Dokument Handhabung
    #
    def handleDocument(self, doc):
        """Operiere an geoeffnetemDokument. === UEBERSCHREIBEN! === """
        print "doc:", doc.Name,            # ',' verhindert '\n'

    def finishDocument(self, doc, trgname=None):
        """Speichere Dokument wenn 'trgname' angegeben wurde."""
        if trgname:
            doc.SaveAs(trgname, self.jopt) # benutze vorher definierte Opts
            print "  (saved to %s)" % trgname,
        doc.Close(comc.psDoNotSaveChanges) # nichts nachfragen
        print

    #
    # Einfacher Weg Konfigurationes-Optionen zu definieren
    #
    JPG_QUALITY = 4               # 0..12
    # EXTENSIONS = ['PSD','CRW']  # Lade Dateien mit diesen Endungen
    EXTENSIONS = ['JPG']
    ARCHIVE_NAME = '-psjob'       # Anhaengsel an Dateinamen beim Speichern
    VERBOSE = False

    #
    # Programmfluss-Kontrolle
    #
    def __init__(self, argv1):
        """Verbinde zu Photoshop und fuere einige Initialisierungen aus."""
        if type(argv1) == type(""):
            argv1 = ( argv1, ) # one arg only: interpret as srcdir
        assert len(argv1)>0 and type(argv1)==type(()), (
            "usage: psjobBasic.py {srcdir} [trgdir]")
        self.args = argv1
        self.ps = pspy.Application() # this connects or starts it
        self.ps.DisplayDialogs = comc.psDisplayNoDialogs
        self.ps.Preferences.RulerUnits = comc.psPixels

    def prepare(self):
        """Erster Schritt in 'run()', einmal fuer ganzen Job."""
        self.jopt = pspy.JPEGSaveOptions()
        self.jopt.EmbedColorProfile = False
        self.jopt.FormatOptions = comc.psOptimizedBaseline
        self.jopt.Quality = self.JPG_QUALITY    # 0..12
        return

    def run(self):
        """PS ist schon geoeffnet. Steuert Job auf den Dateien aus."""
        self.prepare()
        topdir, trgdir = (self.args+(None,))[:2] # trgdir wird stdmaessig None.
        if self.VERBOSE: print "TOPDIR:", topdir
        if self.VERBOSE: print "TRGDIR:", trgdir
        # durchlaufe directories
        for srcdir, srcname in self._imageWalk(topdir):
            srcfile = os.path.join(srcdir, srcname)
            if trgdir: # if given
                root2 = srcdir.replace(topdir,trgdir)
                # gespeicherte Dateien sollen Anhaengsel erkennbar sein
                trgfile = os.path.join(root2,
                    srcname+self.ARCHIVE_NAME+'.jpg')
            else:
                trgfile = None  # nicht speichern
            # do job on a filename
            if self.VERBOSE: print "    FILE: %s" % srcfile, # ',' kein '\n'
            doc = self.ps.Open(srcfile)
            self.handleDocument(doc)
            self.finishDocument(doc, trgfile)  # scliessen und/oder speichern
        self.finish()

    def finish(self):
        """Letzer Schritt in 'run()', einmal pro Job. """
        pass

    def _imageWalk(self, topdir):
        """Iterator ueber alle Bilddateien eines Verzeichnisses; rekursiv."""
        fAcc = lambda fn: fn.rsplit('.')[-1].upper() in self.EXTENSIONS
        for root, dirs, files in os.walk(topdir): # 'walk()' ist rekursiv
            if self.VERBOSE: print "DIR: %s" % root
            for filename in filter(fAcc, files):
                yield root, filename # 'yield' macht imageWalk() iterierbar
        return                       # beendet Iteration
# end class PhotoshopEnvBasic

def main(srcdir): # fuer Aufruf von IDLE aus
   job = PhotoshopEnv(srcdir)
   job.run()

if __name__ == '__main__':  # fuer Aufruf von Kommandozeile und Drag&Drop
   main(sys.argv[1])

