import sys
import psjobBasic as psjob
import photoshopy as pspy
comc = pspy.constants

_MODE_NAMES = { comc.psRGB: 'RGB',
                comc.psGrayscale: 'Gray',
                comc.psIndexedColor:'Idx',
                comc.psCMYK: 'CMYK', }

class InfoPsEnv(psjob.PhotoshopEnv):
  EXTENSIONS = ['PSD','CRW','JPG']  # lade Dateien mit diesen Endungen
  VERBOSE = False
  def handleDocument(self, doc):
    exif = dict(doc.Info.EXIF or ())
    vals = {'dir': doc.Path.rsplit('\\',2)[1],
            'nm' : doc.Name,
            'w' : int(doc.Width),
            'h' : int(doc.Height),
            'mode' : _MODE_NAMES[doc.Mode],
            'bits' : doc.BitsPerChannel,
            'ch': len(doc.Channels),
            'nl': len(doc.Layers),
            'autor': doc.Info.Author,
            'f': exif.get(u'Aperture Value','?'),
            't': exif.get(u'Exposure Time','?'),
            'iso': exif.get(u'ISO Speed Ratings', '?'),
            'brw': exif.get(u'Focal Length', '?'),
            'exif': exif,
            }
    print ("'%(dir)s\\%(nm)s' (%(autor)s)\n"
           "  \t%(mode)s %(w)sx%(h)s %(ch)sx%(bits)sbits Layers:%(nl)s\n"
           "  \tBlende:%(f)s Zeit:%(t)s ISO:%(iso)s %(brw)s\n"
           #"  \t%(exif)s\n"
           ) % vals,

job = InfoPsEnv(sys.argv[1])
job.run()

