; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               LikeDirkey-Menu
; -----------------------------------------------------------------------------
; Prefix:             rd_
; Version:            0.2
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_RecentDirs:
   Prefix = rd
   %Prefix%_ScriptName    = RecentDirs
   %Prefix%_ScriptVersion = 0.2
   RequireExtensions =

   CustomHotkey_RecentDirs = 1           ; Benutzerdefiniertes Hotkey
   Hotkey_RecentDirs       = #Backspace  ; Standard-Hotkey
   HotkeyPrefix_RecentDirs =

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %rd_ScriptName% - zuletzt besuchte Verzeichnisse
      Description                   = Ein spezielles Men listet die zuletzt besuchten Verzeichnisse auf. Es wird dabei das Recent-Verzeichnis von Windows verwendet, welches auch automatisch aufgerumt werden kann.
      lng_rd_NumberOfItems          = Anzahl der anzuzeigenden Verzeichnisse (neustes Verzeichnis oben)
      lng_rd_CleanRecentDir         = RecentDirs basiert auf dem Recent-Verzeichnis (zuletzt verwendete Dateien) von Windows.`nDas Verzeichnis kann bei jedem Aufruf gesubert werden, wodurch RecentDirs schneller wird
      lng_rd_CleanOption1           = nicht verndern
      lng_rd_CleanOption2           = nicht angezeigte Verzeichnis-Verknpfungen entfernen
      lng_rd_CleanOption3           = nicht angezeigte Verzeichnis- und alle Datei-Verknpfungen entfernen
      lng_rd_CleanOption4           = Verzeichnis- und Datei-Verknpfungen entfernen die lter sind als
      lng_rd_CleanOption5           = periodische Suberung im Hintergrund (alle 5 Minuten)
      lng_rd_Days                   = Tage
      lng_rd_LikeDirkey             = Eintrge von LikeDirkey anzeigen
      lng_rd_LikeDirkeyOption1      = nicht anzeigen
      lng_rd_LikeDirkeyOption2      = am Anfang des Mens
      lng_rd_LikeDirkeyOption3      = am Ende des Mens
      lng_rd_Tooltip                = RecentDirs ...
   }
   else        ; = other languages (english)
   {
      MenuName                      = %rd_ScriptName% - last visited folders
      Description                   = A special menu lists all recently used folders to let you go to them. %rd_ScriptName% uses windows own recent-directory, which also could be cleaned up.
      lng_rd_NumberOfItems          = number of folders to show (newest first)
      lng_rd_CleanRecentDir         = RecentDirs is based onto windows' recent-directory.`nIt could be cleaned every time you call RecentDirs to improves its performance
      lng_rd_CleanOption1           = don't change
      lng_rd_CleanOption2           = remove all folder-entries which are not shown by the menu
      lng_rd_CleanOption3           = remove all folder- and file-entries which are not shown
      lng_rd_CleanOption4           = remove the folder- and file-shortcuts older than
      lng_rd_CleanOption5           = periodical clean-up in background (every 5 minute)
      lng_rd_Days                   = days
      lng_rd_LikeDirkey             = show entries from LikeDirkey
      lng_rd_LikeDirkeyOption1      = no
      lng_rd_LikeDirkeyOption2      = at the top of the menu
      lng_rd_LikeDirkeyOption3      = at the bottom of the menu
      lng_rd_Tooltip                = RecentDirs ...
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   rd_IndexSymbols := "ABCDEFGHIJKLMNOPQRSTUVWXYZ "

   IniRead, rd_NumberOfItems, %ConfigFile%, %rd_ScriptName%, NumberOfItems, 10
   IniRead, rd_CleanOption, %ConfigFile%, %rd_ScriptName%, CleanOption, 1
   IniRead, rd_CleanAfter, %ConfigFile%, %rd_ScriptName%, CleanAfter, 7
   IniRead, rd_LikeDirkeyOption, %ConfigFile%, %rd_ScriptName%, LikeDirkeyOption, 1
   IniRead, rd_PeriodicCleanUp, %ConfigFile%, %rd_ScriptName%, PeriodicCleanUp, 0
Return

SettingsGui_RecentDirs:
   Gui, Add, Text, xs+10 y+10, %lng_rd_NumberOfItems%:
   Gui, Add, ComboBox, x+10 yp-4 w40 gsub_CheckIfSettingsChanged vrd_NumberOfItems, 5|10|15|20|25|30|35
   Gui, Add, Text, xs+10 y+25, %lng_rd_CleanRecentDir%:
   Gui, Add, Radio, y+7 Checked gsub_CheckIfSettingsChanged vrd_CleanOption, %lng_rd_CleanOption1%
   Gui, Add, Radio, y+7 gsub_CheckIfSettingsChanged, %lng_rd_CleanOption2%
   Gui, Add, Radio, y+7 gsub_CheckIfSettingsChanged, %lng_rd_CleanOption3%
   Gui, Add, Radio, y+7 gsub_CheckIfSettingsChanged, %lng_rd_CleanOption4%
   Gui, Add, ComboBox, x+5 yp-4 w40 gsub_CheckIfSettingsChanged vrd_CleanAfter, 1|2|3|4|5|6|7|14|21|28|30|31
   Gui, Add, Text, x+5 yp+4, %lng_rd_Days%
   Gui, Add, CheckBox, xs+10 y+15 vrd_PeriodicCleanUp Checked%rd_PeriodicCleanUp% gsub_CheckIfSettingsChanged, %lng_rd_CleanOption5%
   GuiControl, , % lng_rd_CleanOption%rd_CleanOption%, 1
   GuiControl, Text, rd_NumberOfItems, %rd_NumberOfItems%
   GuiControl, Text, rd_CleanAfter, %rd_CleanAfter%
   If Enable_LikeDirkey = 1
   {
      Gui, Add, Text, xs+10 y+20, %lng_rd_LikeDirkey%:
      Gui, Add, Radio, gsub_CheckIfSettingsChanged y+7 Checked vrd_LikeDirkeyOption, %lng_rd_LikeDirkeyOption1%
      Gui, Add, Radio, gsub_CheckIfSettingsChanged x+10, %lng_rd_LikeDirkeyOption2%
      Gui, Add, Radio, gsub_CheckIfSettingsChanged x+10, %lng_rd_LikeDirkeyOption3%
      GuiControl, , % lng_rd_LikeDirkeyOption%rd_LikeDirkeyOption%, 1
   }
Return

SaveSettings_RecentDirs:
   IniWrite, %rd_NumberOfItems%, %ConfigFile%, %rd_ScriptName%, NumberOfItems
   IniWrite, %rd_CleanOption%, %ConfigFile%, %rd_ScriptName%, CleanOption
   IniWrite, %rd_CleanAfter%, %ConfigFile%, %rd_ScriptName%, CleanAfter
   IniWrite, %rd_PeriodicCleanUp%, %ConfigFile%, %rd_ScriptName%, PeriodicCleanUp
   IniWrite, %rd_LikeDirkeyOption%, %ConfigFile%, %rd_ScriptName%, LikeDirkeyOption
Return

CancelSettings_RecentDirs:
Return

DoEnable_RecentDirs:
   If rd_PeriodicCleanUp = 1
      SetTimer, rd_tim_PeriodicCleanUp, 60000 ; 6000*5
Return

DoDisable_RecentDirs:
   SetTimer, rd_tim_PeriodicCleanUp, Off
Return

DefaultSettings_RecentDirs:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_RecentDirs:
   If Enable_RecentDirs = 1
      Gosub, rd_main_RecentDirs
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

rd_main_RecentDirs:
   If rd_CleanUpOnly =
       SetTimer, rd_tim_ToolTip, 200
   RegRead, rd_RecentPath, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders, Recent
   rd_MenuItemPos = 1

   If rd_CleanUpOnly =
   {
      If (rd_LikeDirkeyOption = 2 AND Enable_LikeDirkey = 1)
         Gosub, rd_AddLikeDirkeyMenu
      If rd_MenuItemPos <> 1
      {
         Menu, RecentMenu, Add
         rd_MenuItemPos++
      }
      Menu, RecentMenu, Add, %rd_ScriptName%, rd_sub_MenuItem
   }
   rd_MenuItemPos++
   If rd_CleanUpOnly =
   {
      Menu, RecentMenu, Disable, %rd_ScriptName%
      Menu, RecentMenu, Add
   }
   rd_MenuItemPos++
   rd_Index = 0
   rd_Paths =
   rd_AllPaths =
   rd_AllTargets =
   rd_RecentMenuBegin = %rd_MenuItemPos%
   Loop, %rd_RecentPath%\*.*,0,0
   {
      If A_LoopFileName = desktop.ini
         continue
      StringTrimRight, rd_StripLNK, A_LoopFileFullPath, 4
      SplitPath, rd_StripLNK, , , rd_Extension, rd_Name,
      If rd_CleanOption < 3
         If rd_Extension in .pdf,.doc,.ppt,.xls,.dot,.xlt,.indd,.indt,.eps,.tif,.jpg,.png,.gif,.ppd,.ai,.ps,.fh5,.fh7,.fh8,.fh9,.fh10,.exe,.bat,.ahk,.cmd,.txt,.ini,.site,.nri,.php,.html,.css,.js
            continue

      FileGetShortcut, %A_LoopFileFullPath%, rd_ShortcutTarget
      FileGetTime, rd_ShortCutTime, %A_LoopFileFullPath%
      If ((func_StrLeft(A_Now,8) - func_StrLeft(rd_ShortCutTime,8) >= rd_CleanAfter) AND rd_CleanOption = 4)
      {
         FileDelete, %A_LoopFileFullPath%
         continue
      }

      FileGetAttrib, rd_ShortcutAttrib, %rd_ShortcutTarget%
      IfInString, rd_ShortcutAttrib, D
      {
         IfNotInString, rd_AllTargets, /%rd_ShortcutTarget%`n
         {
            rd_AllTargets = %rd_AllPaths%/%rd_ShortcutTarget%`n
            rd_AllPaths = %rd_AllPaths%%rd_ShortCutTime%%A_LoopFileFullPath%`n
         }
         Else
         {
            FileDelete, %A_LoopFileFullPath%
         }
      }
      Else
      {
         If (rd_CleanOption = 3)
            FileDelete, %A_LoopFileFullPath%
      }
   }
   Sort, rd_AllPaths, RU

   Loop, Parse, rd_AllPaths, `n
   {
      StringTrimLeft, rd_current, A_LoopField, 14   ; Datum entfernen
      If A_Index < %rd_NumberOfItems%
      {
         If A_LoopField =
            break
         FileGetShortcut, %rd_current%, rd_current
         rd_RecentArray%A_Index% = %rd_current%

         StringReplace, rd_current, rd_current, &, &&, a

         SplitPath, rd_current, rd_currentFileName, rd_currentDir,,, rd_currentDrive
         SplitPath, rd_currentDir, rd_currentParentDir
         StringSplit, rd_dirs, rd_currentDir, \

         StringLen, rd_len, rd_current

         If rd_currentFileName =
            rd_currentFileName = %rd_currentDir%

         If rd_len > 40
            rd_current = %rd_currentFileName%`t%rd_currentDrive%\%rd_dirs2%\...\%rd_currentParentDir%\
         Else If rd_current <>
            rd_current = %rd_currentFileName%`t%rd_currentDir%\


         StringMid, rd_Symbol, rd_IndexSymbols, A_Index, 1
         If rd_CleanUpOnly =
         {
            If (rd_Symbol <> "" AND rd_Symbol <> " ")
               Menu, RecentMenu, Add, &%rd_Symbol% - %rd_current%, rd_sub_MenuItem
            Else
               Menu, RecentMenu, Add, %rd_current%, rd_sub_MenuItem
         }

         rd_MenuItemPos++
      }
      Else
      {
         If (rd_CleanOption = 2 OR rd_CleanOption = 3)
            FileDelete, %rd_current%
      }
   }
   If rd_CleanUpOnly =
   {
      If (rd_LikeDirkeyOption = 3 AND Enable_LikeDirkey = 1)
         Gosub, rd_AddLikeDirkeyMenu

      SetTimer, rd_tim_ToolTip, Off
      ToolTip

      WinGet, rd_WinID, ID, A
      Menu, RecentMenu, Show
      WinActivate, ahk_id %rd_WinID%
      Menu, RecentMenu, DeleteAll
   }
Return

rd_tim_PeriodicCleanUp:
   rd_CleanUpOnly = 1
   Gosub, rd_main_RecentDirs
   rd_CleanUpOnly =
Return

rd_tim_ToolTip:
   ToolTip, %lng_rd_Tooltip%
   SetTimer, rd_tim_ToolTip, 20
Return

rd_sub_MenuItem:
   rd_Index := A_ThisMenuItemPos - rd_RecentMenuBegin + 1
   GetKeyState, rd_State1, Shift, P
   GetKeyState, rd_State2, Ctrl, P
   GetKeyState, rd_State3, LWin, P
   GetKeyState, rd_State4, RWin, P
   WinActivate, ahk_id %rd_WinID%
   WinWaitActive, ahk_id %rd_WinID%
   If (rd_State1 = "D" OR rd_State2 = "D" OR rd_State3 = "D" OR rd_State4 = "D")
      func_ChangeDir(rd_RecentArray%rd_Index%,1)
   Else
      func_ChangeDir(rd_RecentArray%rd_Index%,0)
Return

rd_AddLikeDirkeyMenu:
   If rd_MenuItemPos <> 1
   {
      Menu, RecentMenu, Add
      rd_MenuItemPos++
   }
   Menu, RecentMenu, Add, %ld_ScriptName%, rdld_sub_MenuItem
   rd_MenuItemPos++
   Menu, RecentMenu, Disable, %ld_ScriptName%
   Menu, RecentMenu, Add
   rd_MenuItemPos++
   rd_LikeDirkeyMenuBegin = %rd_MenuItemPos%
   Loop, 10
   {
      rdld_Index :=  A_Index-1
      rdld_current := ld_Folder[%rdld_Index%] ; Pfad auslesen

      StringLeft, rdld_check, rdld_current, 5

      If rdld_check = HKEY_
      {
         StringSplit, rdld_current, rdld_current, `,
         RegRead, rdld_current, %rdld_current1%,%rdld_current2%,%rdld_current3%
      }

      StringLeft, rdld_check, rdld_current, 1

      If rdld_check = `%
      {
         StringReplace, rdld_current, rdld_current, `% ,, A
         rdld_current := %rdld_current%
      }

      StringReplace, rdld_current, rdld_current, &, &&, a

      SplitPath, rdld_current, rdld_currentFileName, rdld_currentDir,,, rdld_currentDrive
      SplitPath, rdld_currentDir, rdld_currentParentDir
      StringSplit, rdld_dirs, rdld_currentDir, \

      StringLen, rdld_len, rdld_current

      If rdld_currentFileName =
         rdld_currentFileName = %rdld_currentDir%

      If rdld_len > 40
         rdld_current = %rdld_currentFileName%`t%rdld_currentDrive%\%rdld_dirs2%\...\%rdld_currentParentDir%\
      Else If rdld_current <>
         rdld_current = %rdld_currentFileName%`t%rdld_currentDir%\

      If rdld_current <> ; Wenn nicht leer
      {
         If rdld_Index = 0
         {
            rdld_0 = &%rdld_Index% - %rdld_current%
         }
         Else
         {
            Menu, RecentMenu, Add, &%rdld_Index% - %rdld_current%, rdld_sub_MenuItem
            rd_MenuItemPos++
         }
      }
   }
   If rdld_0 <>
   {
      Menu, RecentMenu, Add, %rdld_0% , rdld_sub_MenuItem
      rd_MenuItemPos++
   }
Return

rdld_sub_MenuItem:
   StringMid, rdld_keyIndex, A_ThisMenuItem, 2, 1

   rdld_path := ld_Folder[%rdld_keyIndex%] ; Pfad auslesen

   tooltip, % A_ThisMenuItemPos " - " rd_LikeDirkeyMenuBegin " : " rdld_path

   StringLeft, rdld_check, rdld_path, 5

   If rdld_check = HKEY_
   {
      StringSplit, rdld_path, rdld_path, `,
      RegRead, rdld_path, %rdld_path1%,%rdld_path2%,%rdld_path3%
   }

   StringLeft, rdld_check, rdld_path, 1

   If rdld_check = `%
   {
      StringReplace, rdld_path, rdld_path, `% ,, A
      rdld_path := %rdld_path%
   }

   GetKeyState, rd_State1, Shift, P
   GetKeyState, rd_State2, Ctrl, P
   GetKeyState, rd_State3, LWin, P
   GetKeyState, rd_State4, RWin, P
   If (rd_State1 = "D" OR rd_State2 = "D" OR rd_State3 = "D" OR rd_State4 = "D")
      func_ChangeDir(rdld_Path,1)
   Else
      func_ChangeDir(rdld_Path,-1)
Return


