; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               QuickChangeDir
; -----------------------------------------------------------------------------
; Prefix:             qc_
; Version:            0.4
; Date:               2005-04-27
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_QuickChangeDir:
   ; Programmname und Version
   Prefix           = qc
   %Prefix%_ScriptName    = QuickChangeDir
   %Prefix%_ScriptVersion = 0.4
   %Prefix%_Titel = %qc_ScriptName% v%qc_ScriptVersion%

   CustomHotkey_QuickChangeDir = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_QuickChangeDir       = #-   ; Standard-Hotkey
   HotkeyPrefix_QuickChangeDir =

   SubMenu = QuickChangeDir_Menu

   ; Name der Index-Dateien
   qc_IndexFile = QCD_Index_

   qc_selectedDrives = %qc_PathsToIndex%

   if Lng = 07  ; = Deutsch (0407, 04807, 0c07 ...)
   {
      MenuName                      = %qc_ScriptName% - Schneller Verzeichniswechsel
      Description                   = Schneller Verzeichniswechsel durch Eingabe eines Teils des gesuchten Verzeichnisnamens.
      QuickChangeDir_EnableMenu     = %qc_ScriptName% aktiviert
      lng_qc_Untersuche             = Untersuche Laufwerk
      lng_qc_Indiziere              = Erstelle Verzeichnisindex
      lng_qc_Wechseln               = &Verzeichnis wechseln
      lng_qc_ReIndizierung          = Verzeichnisindex &aktualisieren
      lng_qc_Suchen                 = &Suchen
      lng_qc_Aktualisieren          = 8
      lng_qc_AktualisierenEinzeln   = ### aktualisieren
      lng_qc_AktualisierenAlle      = alle Verzeichnisse aktualisieren
      lng_qc_NeuesFenster           = &Neues Fenster
      lng_qc_VerzWechseln           = &OK, wechseln
      lng_qc_berVerzHinzu          = berverzeichnis hinzufgen
      lng_qc_AusIndexEntf           = Verzeichnis samt Unterverzeichnisse aus Index entfernen
      lng_qc_LaufwerkERR            = Laufwerk existiert nicht
      lng_qc_SucheERR               = Nichts gefunden
      lng_qc_SuchEingabe            = Suchbegriff eingeben:
      lng_qc_DosBox                 = &DOS-Box
      lng_qc_AddToIndexList         = Laufwerke/Verzeichnisse, die indexiert werden:
      lng_qc_IndexPath              = Verzeichnis, wo die Indexdateien abgelegt werden:
      lng_qc_NoIndex                = Es wurde noch kein Verzeichnisindex angelegt, die Suche funktioniert nachdem die Indexierung beendet wurde.
      lng_qc_AutoIndexing           = Automatisch neu indexieren, wenn sich der freie Speicher um folgenden Wert verndert hat:
      lng_qc_NoBalloonTips          = Sprechblasenhinweise deaktivieren
      lng_qc_SucheNach              = Suche nach:
      tooltip_a                     = Index fr den ausgewhlten Pfad aktualisieren
   }
   else        ; = andere Sprachen
   {
      MenuName                      = %qc_ScriptName% - fast folder-switching
      Description                   = Change the folder of the actual window to a pre-indexed folder by typing a part of its name.
      QuickChangeDir_EnableMenu     = %qc_ScriptName% active
      lng_qc_Untersuche             = scanning drive
      lng_qc_Indiziere              = creating directory-index
      lng_qc_Wechseln               = &change directory
      lng_qc_ReIndizierung          = &update directory-index
      lng_qc_Suchen                 = &Search
      lng_qc_Aktualisieren          = 8
      lng_qc_AktualisierenEinzeln   = update ###
      lng_qc_AktualisierenAlle      = update all directories
      lng_qc_NeuesFenster           = &new window
      lng_qc_VerzWechseln           = &OK, change
      lng_qc_berVerzHinzu          = add upper directory
      lng_qc_AusIndexEntf           = remove folder and sub-folders from index
      lng_qc_LaufwerkERR            = drive does not exist
      lng_qc_SucheERR               = nothing found
      lng_qc_SuchEingabe            = Enter search term:
      lng_qc_DosBox                 = &DOS-Box
      lng_qc_AddToIndexList         = Drives/Paths to index:
      lng_qc_IndexPath              = Directory to store the index-files:
      lng_qc_NoIndex                = No index-files found. You can use the search after the indexing has finished.
      lng_qc_AutoIndexing           = Automatic indexing, if the drive-space changed about:
      lng_qc_NoBalloonTips          = no BalloonTips
      lng_qc_SucheNach              = search for:
      tooltip_a                     = update index for the selected path
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, qc_PathsToIndex, %ConfigFile%, %qc_ScriptName%, PathsToIndex
   If (qc_PathsToIndex = "ERROR" OR qc_PathsToIndex = "")
      qc_PathsToIndex = C:\

   IniRead, qc_IndexPath, %ConfigFile%, %qc_ScriptName%, IndexPath
   If (qc_IndexPath = "ERROR" OR qc_IndexPath = "")
      qc_IndexPath = %A_Scriptdir%\settings\%qc_ScriptName%

   IniRead, qc_History, %qc_IndexPath%\%qc_IndexFile%Data.ini, History, SearchHistory
   If (qc_History = "ERROR")
      qc_History =

   ;StringReplace, qc_History, qc_History, ||,|, A

   IfNotExist, %qc_IndexPath%
      FileCreateDir, %qc_IndexPath%

   IniRead, qc_AutoIndexing, %ConfigFile%, %qc_ScriptName%, AutoIndexing, 0
   IniRead, qc_AutoIndexThreshold, %ConfigFile%, %qc_ScriptName%, AutoIndexingThreshold, 10
   IniRead, qc_NoBalloonTips, %ConfigFile%, %qc_ScriptName%, NoBalloonTips, 0

   ; Traymen erweitern
   Menu, QuickChangeDir_Menu, Add, %QuickChangeDir_EnableMenu%, sub_MenuCall
   Menu, QuickChangeDir_Menu, Add

   ; Untermen fr die Laufwerksaktualisierung erzeugen
   Loop, Parse, qc_PathsToIndex, `,
   {
      StringReplace, qc_SubMenuItem, lng_qc_AktualisierenEinzeln, ###, %A_LoopField%
      Menu, QuickChangeDir_Menu, Add, %qc_SubMenuItem%, qc_submenu_IndexDrives
   }
   Menu, QuickChangeDir_Menu, Add, %lng_qc_AktualisierenAlle%, qc_sub_IndexDrives
Return

SettingsGui_QuickChangeDir:
   If (qc_IndexPath = "ERROR" OR qc_IndexPath = "")
      qc_IndexPath = %A_Scriptdir%\settings\%qc_ScriptName%

   Gui, Add, Text, Y+5 XS+10, %lng_qc_AddToIndexList%
   StringReplace, qc_PathsToIndex_Box, qc_PathsToIndex , `, , | , a
   Gui, Add, ListBox, Y+5 vqc_PathsToIndex_Box_tmp W530 R10, %qc_PathsToIndex_Box%
   qc_PathsToIndex_Box_DontAllowSubfolders = 1
   Gui, Add, Button, -Wrap x+4 w21 vqc_Add_PathsToIndex_Box gsub_ListBox_addFolder, +
   Gui, Add, Button, -Wrap y+4 w21 vqc_Remove_PathsToIndex_Box gsub_ListBox_remove, 
   Gui, Font, s10, Marlett
   Gui, Add, Button, -Wrap y+59 w21 gqc_sub_ListBox_DoIndex, a
   Gui, Font

   Gui, Add, CheckBox, xs+10 y+8 Checked%qc_AutoIndexing% gsub_CheckIfSettingsChanged vqc_AutoIndexing, %lng_qc_AutoIndexing%
   Gui, Add, ComboBox, x+5 yp-4 w50 gsub_CheckIfSettingsChanged vqc_AutoIndexThreshold, 2|5|10|15|20|30|50|75|100|250|500|1000
   GuiControl,Text, qc_AutoIndexThreshold, %qc_AutoIndexThreshold%
   Gui, Add, Text, yp+4 x+5, MB

   Gui, Add, CheckBox, xs+10 y+8 Checked%qc_NoBalloonTips% gsub_CheckIfSettingsChanged vqc_NoBalloonTips, %lng_qc_NoBalloonTips%

   Gui, Add, Text, xs+10 y+10 , %lng_qc_IndexPath%
   Gui, Add, Edit, gsub_CheckIfSettingsChanged w450 vqc_IndexPath, %qc_IndexPath%
   Gui, Add, Button, -Wrap X+5 YP-1 W100 gqc_sub_Browse, %lng_Browse%
Return

qc_sub_ListBox_DoIndex:
   GuiControlGet, qc_selectedDrives, , qc_PathsToIndex_Box_tmp
   gosub, qc_sub_IndexDrives
Return

qc_sub_Browse:
   Gui +OwnDialogs
   FileSelectFolder, qc_IndexPath, %qc_IndexPath%, 3
   GuiControl,,qc_IndexPath,%qc_IndexPath%
Return

SaveSettings_QuickChangeDir:
   If qc_IndexPath = %A_Scriptdir%\settings\%qc_ScriptName%
      qc_IndexPath =
   StringReplace, qc_PathsToIndex, qc_PathsToIndex_Box, |, `, ,a
   If (func_StrLeft(qc_PathsToIndex,1) = ",")
      StringTrimLeft, qc_PathsToIndex, qc_PathsToIndex, 1
   If (func_StrRight(qc_PathsToIndex,1) = ",")
      StringTrimRight, qc_PathsToIndex, qc_PathsToIndex, 1

   IniWrite, %qc_IndexPath%, %ConfigFile%, %qc_ScriptName%, IndexPath
   IniWrite, %qc_PathsToIndex%, %ConfigFile%, %qc_ScriptName%, PathsToIndex
   IniWrite, %qc_AutoIndexing%, %ConfigFile%, %qc_ScriptName%, AutoIndexing
   IniWrite, %qc_AutoIndexThreshold%, %ConfigFile%, %qc_ScriptName%, AutoIndexingThreshold
   IniWrite, %qc_NoBalloonTips%, %ConfigFile%, %qc_ScriptName%, NoBalloonTips

   If qc_IndexPath =
      qc_IndexPath = %A_Scriptdir%\settings\%qc_ScriptName%
Return

CancelSettings_QuickChangeDir:
Return

DoEnable_QuickChangeDir:
   If qc_AutoIndexing = 1
      SetTimer, qc_tim_AutoIndexing, 1000
Return

DoDisable_QuickChangeDir:
   SetTimer, qc_tim_AutoIndexing, Off
   Gui, 8:Destroy
   Gui, 9:Destroy
   qc_GUI=
Return

DefaultSettings_QuickChangeDir:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_QuickChangeDir:
   gosub, qc_main_QuickChangeDir
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

; ---------------------------------------------------------------------
qc_main_QuickChangeDir: ; Unterroutine fr das Eingabefenster
   If Enable_QuickChangeDir = 1
   {
      WinGet     , qc_window_id, ID, A             ; ID es aktiven Fensters
      WinGetClass, qc_class, ahk_id %qc_window_id%  ; Fensterklasse ermitteln
      If qc_GUI <> 8 ; Fenster aufbauen, wenn es noch nicht existiert
      {
         If qc_GUI = 9
            Gosub, 9GuiClose

         qc_WinH   = 80   ; Fensterhhe
         qc_WinW   = 300  ; Fensterbreite
         IniRead, qc_WinX, %ConfigFile%, %qc_ScriptName%, SearchWindowX, %A_Space%
         IniRead, qc_WinY, %ConfigFile%, %qc_ScriptName%, SearchWindowY, %A_Space%

         ; Fenster aufbauen
         Gui, 8:Add, Text    ,                                    , %lng_qc_SuchEingabe%
         Gui, 8:Font, Ccc0000 ; Text Rot (#CC0000)
         Gui, 8:Add, Text    , x+5, %qc_ErrorMsg%
         Gui, 8:Add, ComboBox, vqc_FindString x10 w280, %qc_History%
         Gui, 8:Font,,Marlett
         Gui, 8:Add, Button  , -Wrap gqc_sub_IndexingMenu w20, %lng_qc_Aktualisieren%
         Gui, 8:Font
         Gui, 8:Add, Button  , -Wrap g8GuiClose x+115 w70, %lng_Cancel%
         Gui, 8:Add, Button  , -Wrap gqc_sub_SearchOK x+5 w70 Default, %lng_qc_Suchen%
         Gui, 8:-Maximize
         Gui, 8:Show, w%qc_WinW% h%qc_WinH% %qc_WinX% %qc_WinY%, %qc_Titel%
         qc_ErrorMsg =
         qc_GUI = 8

         Loop, Parse, qc_PathsToIndex, `,
         {
            qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
            qc_IndexTemp = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat ; Dateiname Verzeichnisindex
            IfNotExist, %qc_IndexTemp%
            {
               gosub, qc_sub_IndexDrives
               msgbox, 64, %qc_Titel%, %lng_qc_NoIndex%
               break
            }
         }
      }
      else ; ... wenn Fenster existiert ...
      {
         WinActivate, %qc_Titel% ; .. in den Vordergrund
      }
   }
Return

8GuiEscape:
8GuiClose:
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile%, %qc_ScriptName%, SearchWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile%, %qc_ScriptName%, SearchWindowY
   Gui,8:Destroy
   qc_GUI =
Return

; ---------------------------------------------------------------------
qc_sub_SearchOK: ;    Suchen-Schaltflche
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile%, %qc_ScriptName%, SearchWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile%, %qc_ScriptName%, SearchWindowY

   GetKeyState, qc_ctrlState, Ctrl ; Status der Strg-Taste ermitteln
   if qc_ctrlState = U             ; wenn nicht gedruckt
      qc_ctrlState =               ; Statusvariable lschen, damit sie im Ergebnisfenster nochmals abgefragt wird
   Gosub, qc_sub_Result
Return


; ---------------------------------------------------------------------
; -- Ergebnisfenster der Suche ----------------------------------------
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
qc_sub_Result: ; Unterroutine fr die Verzeichnissuche [Suchen-Schaltflche]

   Gui, 8:Submit  ; Eingaben des Fenster in die Variablen bertragen
   Gui, 8:Destroy ; Eingabefenster beenden

   ; Rechte Maustaste und die Entf-Taste fr das kommende Fenster zulassen
   ;Hotkey, ~RButton, On

   StringReplace, qc_History, qc_History, %qc_FindString%| ; Doppelter Eintrag in Historie entfernen
   qc_History = %qc_FindString%|%qc_History%               ; Suchbegriffhistorie erweitern
   StringReplace, qc_History, qc_History, ||,|, A
   StringGetPos, qc_HistoryPos, qc_History, |, L20
   If qc_HistoryPos > 1
      StringLeft, qc_History, qc_History, % qc_HistoryPos+1
   IniWrite, %qc_History%, %qc_IndexPath%\%qc_IndexFile%Data.ini, History, SearchHistory

   ; Wenn Suchbegriff lnger als ein Zeichen
   ifNotExist, %qc_FindString%
   {
      qc_NumDirs  = 0      ; Anzahl der gefundenen Verzeichnisse auf 0 setzen

      IniRead, qc_WinW, %ConfigFile%, %qc_ScriptName%, ResultWindowWidth, 620  ; Fensterbreite
      IniRead, qc_WinH, %ConfigFile%, %qc_ScriptName%, ResultWindowHeight, 460 ; Fensterhhe
      IniRead, qc_WinX, %ConfigFile%, %qc_ScriptName%, ResultWindowX, %A_Space%  ; Fenster X
      IniRead, qc_WinY, %ConfigFile%, %qc_ScriptName%, ResultWindowY, %A_Space% ; Fenster Y
      qc_MinW     = 520   ; minimale Fensterbreite
      qc_MinH     = 200   ; minimale Fensterhhe
      qc_ListY    = 30    ; Y-Position der Ergebnisliste
      qc_ListW    := qc_WinW-20  ; Breite der Ergebnisliste
      qc_ListH    := qc_WinH-90   ; Hhe der Ergebnisliste
      qc_EditY    := qc_WinH-60   ; Position der Statuszeile
      qc_ButtonY  := qc_WinH-30   ; Y-Position der Schaltflchen
      qc_Button2X := qc_WinW-395   ; X-Position von "Abbrechen"
      qc_Button5X := qc_WinW-295   ; X-Position von "DOS-Box"
      qc_Button3X := qc_WinW-195   ; X-Position von "gleiches Fenster"
      qc_Button4X := qc_WinW-100   ; X-Position von "neues Fenster"

      Gui, 9:Add, Edit, w%qc_ListW% vqc_SearchTheList gqc_sub_SearchTheList

      Gui, 9:Add, ListBox, x10 y%qc_ListY% h%qc_ListH% w%qc_ListW% +HScroll Choose1 vqc_varResults gqc_sub_ResultList ; Ergebnisliste
      qc_AllResults =
      Loop, Parse, qc_PathsToIndex, `, ; alle Laufwerke duchgehen
      {
         If A_LoopField =
            break
         qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
         qc_IndexTemp = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat ; Dateiname Verzeichnisindex
         Loop, Read, %qc_IndexTemp%                         ; Verzeichnisindex laden
         {
            SplitPath, A_LoopReadLine, CheckFile, CheckDir ; Pfad aufteilen
            If CheckFile contains %qc_FindString%         ; Wenn Suchbegriff vorhanden
            {
               qc_AllResults = %A_LoopReadLine%`n%qc_AllResults%
               qc_NumDirs++                               ; Anzahl gefundener Verz. erhhen
            }
         }
         GuiControl, 9:Choose, qc_varResults, 1             ; erstes Verz. auswhlen
      }
      qc_AllResultsRevers = %qc_AllResults%
      Sort, qc_AllResults
      Sort, qc_AllResultsRevers, R

      StringReplace, qc_AllResultsBox, qc_AllResults, `n, |, A

      GuiControl,9:,qc_varResults,%qc_AllResultsBox% ; Pfad zum Fenster hinzufgen

      ; Fenster zeigen, wenn mehr als ein Verz. gefunden
      if qc_NumDirs > 1
      {
         Gui, 9:Add, Edit  ,                        x10             y%qc_EditY%   w%qc_ListW% vStatusBar ReadOnly
         Gui, 9:Font,, Marlett
         Gui, 9:Add, Button, -Wrap gqc_sub_IndexingMenu x10             y%qc_ButtonY% w20        , %lng_qc_Aktualisieren%
         Gui, 9:Font
         Gui, 9:Add, Button, -Wrap g9GuiClose             x%qc_Button2X% y%qc_ButtonY% w90        , %lng_Cancel%
         Gui, 9:Add, Button, -Wrap gqc_sub_ResultOK2         x%qc_Button3X% y%qc_ButtonY% w90 , %lng_qc_NeuesFenster%
         Gui, 9:Add, Button, -Wrap gqc_sub_ResultOK          x%qc_Button4X% y%qc_ButtonY% w90 Default, %lng_qc_VerzWechseln%
         Gui, 9:Add, Button, -Wrap gqc_sub_ResultOK3         x%qc_Button5X% y%qc_ButtonY% w90 , %lng_qc_DosBox%
         Gui, 9:+Resize
         Gui, 9:Show, w%qc_WinW% h%qc_WinH% %qc_WinX% %qc_WinY%, %qc_Titel% - %lng_qc_SucheNach% %qc_FindString%
         qc_GUI = 9
         func_AddMessage(0x100,"qc_func_Edit1Keys")
         IniRead, qc_varResults, %qc_IndexPath%\%qc_IndexFile%Data.ini, Favourites, % func_Hex(func_StrLower(qc_FindString))
         If qc_varResults <> ERROR
            GuiControl, 9:ChooseString, qc_varResults, %qc_varResults%
      }

      ; Wenn nur ein Verzeichnis gefunden, direkt dort hin wechseln
      if qc_NumDirs = 1
      {
         StringTrimRight, qc_varResults, qc_AllResultsBox, 1
         gosub, qc_sub_ResultOK
      }

      ; Wenn kein Verzeichnis gefunden, dann Suchfenster wieder aufrufen
      if qc_NumDirs = 0
      {
         Gui,9:Destroy                    ; Fenster beenden
         qc_GUI =
         qc_ErrorMsg = %lng_qc_SucheERR%   ; Fehlermeldung setzen
         Gosub, qc_main_QuickChangeDir     ; Suchfenster wieder aufrufen
      }

   }
   Else
   {
      qc_path = %qc_FindString%                 ; Pfad setzen
      gosub, qc_sub_ChangeDir                    ; Unterroutine um Pfad zu ffnen oder zu wechseln
      qc_ctrlState =                             ; Status der Strg-Taste zurcksetzen
   }
Return

; ---------------------------------------------------------------------
qc_sub_IndexingMenu:    ;    Indizierung von der Ergebnisliste aufrufen
   CoordMode, Menu, Relative
   Menu, QuickChangeDir_Menu, Show, % A_CaretX+20, %A_CaretY%
Return

qc_sub_SearchTheList:
   GuiControlGet, qc_SearchTheList, 9:
   GuiControl, 9:+Altsubmit, qc_varResults
   GuiControlGet, qc_varResults, 9:
   GuiControl, 9:-Altsubmit, qc_varResults
   If (StrLen(qc_SearchTheList) < 2)
      qc_varResults = 0
   Loop, Parse, qc_AllResults, `n
   {
      If ( A_Index < qc_varResults)
         continue

      IfInString, A_LoopField, %qc_SearchTheList%
      {
         GuiControl, 9:ChooseString, qc_varResults, %A_LoopField%
         Gosub, qc_sub_ResultList
         break
      }
   }
Return

qc_sub_SearchTheListNext:
   GuiControlGet, qc_SearchTheList, 9:
   GuiControl, 9:+Altsubmit, qc_varResults
   GuiControlGet, qc_varResults
   GuiControl, 9:-Altsubmit, qc_varResults
   Loop, Parse, qc_AllResults, `n
   {
      If A_LoopField =
         continue

      If ( A_Index <= qc_varResults )
         continue

      IfInString, A_LoopField, %qc_SearchTheList%
      {
         GuiControl, 9:ChooseString, qc_varResults, %A_LoopField%
         Gosub, qc_sub_ResultList
         break
      }
   }
Return

qc_sub_SearchTheListPrevious:
   GuiControlGet, qc_SearchTheList, 9:
   GuiControl, 9:+Altsubmit, qc_varResults
   GuiControlGet, qc_varResults
   GuiControl, 9:-Altsubmit, qc_varResults
   test := qc_varResults - 1 "`n"
   Loop, Parse, qc_AllResultsRevers, `n
   {
      If A_LoopField =
         continue
      If ( qc_NumDirs - A_Index >= qc_varResults - 1)
         continue

      IfInString, A_LoopField, %qc_SearchTheList%
      {
         GuiControl, 9:ChooseString, qc_varResults, %A_LoopField%
         Gosub, qc_sub_ResultList
         break
      }
   }
Return


qc_func_Edit1Keys:
   qc_Key = %#wParam%
   If A_GuiControl <> qc_SearchTheList
      return

   GetKeyState, qc_CtrlState, Ctrl
   If qc_CtrlState = D
      qc_Key := qc_Key + 1000
   GetKeyState, qc_ShiftState, Shift
   If qc_ShiftState = D
      qc_Key := qc_Key + 2000
   GetKeyState, qc_AltState, Alt
   If qc_AltState = D
      qc_Key := qc_Key + 4000

   If qc_Key = 33
   {
      ControlSend,ListBox1,{PgUp}, A
      #Return = 0
   }
   If qc_Key = 34
   {
      ControlSend,ListBox1,{PgDn}, A
      #Return = 0
   }
   If qc_Key = 1035
   {
      ControlSend,ListBox1,{End}, A
      #Return = 0
   }
   If qc_Key = 1036
   {
      ControlSend,ListBox1,{Home}, A
      #Return = 0
   }
   If qc_Key = 40
   {
      ControlSend,ListBox1,{Down}, A
      #Return = 0
   }
   If qc_Key = 38
   {
      ControlSend,ListBox1,{Up}, A
      #Return = 0
   }

   If qc_Key = 1040
   {
      Gosub, qc_sub_SearchTheListNext
      #Return = 0
   }
   If qc_Key = 1038
   {
      Gosub, qc_sub_SearchTheListPrevious
      #Return = 0
   }
   If qc_Key = 1008
   {
      Send,+^{Left}{Del}
      #Return = 0
   }
Return

; ---------------------------------------------------------------------
9GuiSize: ;    Fenstergren-berwachung
; - sorgt dafr, dass beim Vergrern des Sucherergebnisfensters die Schaltflchen
; und die Ergebnisliste mit angepasst werden

   wingetpos qc_newWinX,qc_newWinY,qc_newWinW,qc_newWinH, %qc_Titel% ; Fenstermae ermitteln
   if qc_newWinW < %qc_MinW%                                            ; Breitenlimit unterschritten ...
      WinMove, %qc_Titel%,,,,%qc_MinW%                                  ; ... dann auf Minimalbreite setzen
   if qc_newWinH < %qc_MinH%                                            ; Hhenlimit unterschritten ...
      WinMove, %qc_Titel%,,,,,%qc_MinH%                                 ; ... dann auf Minimalhhe setzen

   wingetpos qc_newWinX,qc_newWinY,qc_newWinW,qc_newWinH, %qc_Titel% ; nochmals Fenstermae ermitteln
   WinGet, win_id, ID, A         ; ID des aktiven Fensters
   SysGet,qc_TitleH,30          ; Hhe der Titelzeile
   SysGet,qc_BorderH,33         ; Hhe des Fensterrands
   SysGet,qc_BorderW,32         ; Breite des Fensterrands
   qc_TitleH += %qc_BorderH%
   qc_TitleH += %qc_BorderH%

   ; Differenz des vernderten Fensters zu der Originalgre errechnen
   qc_DiffH = %qc_newWinH%
   qc_DiffH -= %qc_TitleH%
   qc_DiffH -= %qc_WinH%

   qc_DiffW = %qc_newWinW%
   qc_DiffW -= %qc_BorderW%
   qc_DiffW -= %qc_BorderW%
   qc_DiffW -= %qc_WinW%

   if qc_DiffW = %qc_lastDiffW%
   if qc_DiffH = %qc_lastDiffH%
      return

   qc_lastDiffW = %qc_DiffW%
   qc_lastDiffH = %qc_DiffH%

   ; Neue Positionen und Gren berechnen
   qc_newListW    =  %qc_ListW%
   qc_newListW    += %qc_DiffW%
   qc_newListH    =  %qc_ListH%
   qc_newListH    += %qc_DiffH%
   qc_newEditY    =  %qc_EditY%
   qc_newEditY    += %qc_DiffH%
   qc_newButtonY  =  %qc_ButtonY%
   qc_newButtonY  += %qc_DiffH%
   qc_newButton2X =  %qc_Button2X%
   qc_newButton2X += %qc_DiffW%
   qc_newButton3X =  %qc_Button3X%
   qc_newButton3X += %qc_DiffW%
   qc_newButton4X =  %qc_Button4X%
   qc_newButton4X += %qc_DiffW%
   qc_newButton5X =  %qc_Button5X%
   qc_newButton5X += %qc_DiffW%

   ; Fensterelemente anpassen
   GuiControl, 9:move, Edit1,                                      w%qc_newListW%
   GuiControl, 9:move, ListBox1,                  y%qc_ListY%      w%qc_newListW% h%qc_newListH%
   GuiControl, 9:move, Edit2,                     y%qc_newEditY%   w%qc_newListW%
   GuiControl, 9:move, Button1,                   y%qc_newButtonY%
   GuiControl, 9:move, Button2, x%qc_newButton2X% y%qc_newButtonY%
   GuiControl, 9:move, Button3, x%qc_newButton3X% y%qc_newButtonY%
   GuiControl, 9:move, Button4, x%qc_newButton4X% y%qc_newButtonY%
   GuiControl, 9:move, Button5, x%qc_newButton5X% y%qc_newButtonY%

   SetTimer, qc_tim_SizeSaveChanges, 5
Return

qc_tim_SizeSaveChanges:
   SetTimer, qc_tim_SizeSaveChanges, Off
   IniWrite, %qc_newWinW%, %ConfigFile%, %qc_ScriptName%, ResultWindowWidth
   IniWrite, %qc_newWinH%, %ConfigFile%, %qc_ScriptName%, ResultWindowHeight
Return

; ---------------------------------------------------------------------
qc_sub_ResultOK: ;    Verzeichnis wechseln (OK-Schaltflche)
   if qc_NumDirs > 1
   {
      wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
      IniWrite, x%qc_newWinX%, %ConfigFile%, %qc_ScriptName%, ResultWindowX
      IniWrite, y%qc_newWinY%, %ConfigFile%, %qc_ScriptName%, ResultWindowY
      Gui, 9:Submit
      Gui, 9:Destroy
   }

   func_RemoveMessage(0x100,"qc_func_Edit1Keys")
   qc_GUI =

   IfExist,%qc_varResults% ; nur wechslen wenn Verzeichnis existiert
   {
      IniWrite, %qc_varResults%, %qc_IndexPath%\%qc_IndexFile%Data.ini, Favourites, % func_Hex(func_StrLower(qc_FindString))
      qc_path = %qc_varResults%
      gosub, qc_sub_ChangeDir
      qc_ctrlState =
   }
return

; ---------------------------------------------------------------------
qc_sub_ResultOK2: ;    neues Explorer-Fenster (Explorer-Schaltflche)
   qc_GUI =
   qc_ctrlState = D   ; gedrckte Strg-Taste vortuschen
   gosub, qc_sub_ResultOK
Return

; ---------------------------------------------------------------------
qc_sub_ResultOK3: ;    DOS-Fenster
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile%, %qc_ScriptName%, ResultWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile%, %qc_ScriptName%, ResultWindowY

   Gui, 9:Submit
   Gui, 9:Destroy
   func_RemoveMessage(0x100,"qc_func_Edit1Keys")
   qc_GUI =

   IfExist,%qc_varResults% ; nur wechseln wenn Verzeichnis existiert
   {
      StringSplit,splittedpath,qc_varResults,:,,
      Run, cmd.exe /K %splittedpath1%: && cd "%splittedpath2%"
      qc_ctrlState =
   }
Return

; ---------------------------------------------------------------------
9GuiEscape: ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
9GuiCancel: ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
9GuiClose:  ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
   qc_GUI =
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile%, %qc_ScriptName%, ResultWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile%, %qc_ScriptName%, ResultWindowY
   Gui, 9:Destroy            ; Fenster schlieen
Return

; ---------------------------------------------------------------------
qc_sub_ResultList: ;    Klick auf Ergebnisliste

   ; Statuszeile mit dem Namen ohne Pfad setzen
   GuiControlGet, qc_ListLine,9:,qc_varResults
   SplitPath,qc_ListLine,qc_FName,qc_FDir
   GuiControl, 9:,StatusBar,%qc_FName%

   GuiControl, 9:Focus, qc_SearchTheList

   ; Bei Doppelklick "neues Fenster" ausfhren
   if A_GuiControlEvent = DoubleClick
      gosub, qc_sub_ResultOK
return

; Kontextmen der Ergebnisliste
9GuiContextMenu: ; HotkeyDef
   IfWinActive, %qc_Titel%    ; nur wenn Fenster aktiv
   {
      MouseGetPos,,,,qc_MouseControl  ; Control unter Maus ermitteln
      if qc_MouseControl = ListBox1   ; Wenn Control Ergebnisliste ...
      {
         ; ... dann Kontextmen aufbauen
         Send, {LButton} ; An Mauspositoin einen Klick ausfhren, damit die Zeile markiert wird
         Menu, context, add, %lng_qc_NeuesFenster%, qc_sub_ResultOK
         Menu, context, add, %lng_qc_VerzWechseln%, qc_sub_ResultOK2
         Menu, context, add, %lng_qc_DosBox%, qc_sub_ResultOK3
         Menu, context, add
         Menu, context, add, %lng_qc_AusIndexEntf%, qc_menu_DeleteEntry
         Menu, context, add, %lng_qc_berVerzHinzu%, qc_sub_AddParent
         Menu, context, show
         Menu, context, DeleteAll
      }
    }
Return

; ---------------------------------------------------------------------
qc_menu_DeleteEntry: ;    Menpunkt Eintrag aus der Verzeichnisindex entfernen

   GuiControlGet, qc_ListLine,9:,qc_varResults ; aktuelle Zeile ermitteln
   gosub, qc_sub_DeleteEntry
Return

; ---------------------------------------------------------------------
qc_sub_AddParent: ;    Menpunkt berverzeichnis zur Liste hinzufgen

   GuiControlGet, qc_ListLine,9:,qc_varResults
   SplitPath, qc_ListLine,,qc_ListLine
   GuiControl, 9:Choose, qc_varResults, 1
   GuiControl, 9:ChooseString, qc_varResults, %qc_ListLine%
   GuiControlGet, SelLine,9:,qc_varResults
   if qc_ListLine  <> %SelLine%
      GuiControl,9:, qc_varResults, %qc_ListLine%
   GuiControl, 9:ChooseString, qc_varResults, %qc_ListLine%
   WinActivate, %qc_Titel%
Return

; ---------------------------------------------------------------------
qc_sub_DeleteEntry: ;    Unterroutine fr Eintrag aus der Verzeichnisindex entfernen

   ; Schaltflchen deaktivieren
   GuiControl, 9:Disable, Button1
   GuiControl, 9:Disable, Button2
   GuiControl, 9:Disable, Button3
   GuiControl, 9:Disable, Button4
   GuiControl, 9:Disable, ListBox1

   qc_ActDrive := qc_func_GetDrive( qc_ListLine ) ; Laufwerksbuchstabe des ausgewhlten Pfads

   qc_IndexTemp = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%_tmp.dat ; Temporrer Index
   qc_IndexDest = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat ; Verzeichnisindex
   GuiControl,9:+AltSubmit,qc_varResults ; ... damit nicht der Name, sondern die ListenNr ermittelt wird

   Loop, Read, %qc_IndexDest%   ; Verzeichnisindex laden
   {
      StringLen,qc_Len,qc_ListLine                       ; Lnge des ausgewhlten Pfads
      StringLeft, qc_MatchLine, A_LoopReadLine, %qc_Len% ; geladener Eintrag aus Verzeichnisindex krzen

      If qc_MatchLine <> %qc_ListLine%                   ; Wenn ausgewhlter Pfad <> geladener Eintrag
      {
         FileAppend, %A_LoopReadLine%`n, %qc_IndexTemp%   ; ... wieder in Verzeichnisindex schreiben
      }
      else                                                 ; ... sonst nicht schreiben ...
      {
         GuiControl,9:ChooseString,qc_varResults, %A_LoopReadLine% ; Eintrag in Ergebnisliste auswhlen
         GuiControlGet,qc_ListN,9:,qc_varResults                  ; ListenNr ermitteln
         Control, Delete, %qc_ListN%, ListBox1, %qc_Titel%      ; Eintrag lschen
      }
   }
   GuiControl,9:-AltSubmit,qc_varResults         ; ... damit wieder der Name von Listenelementen ermittelt wird
   FileMove, %qc_IndexTemp%, %qc_IndexDest%,1 ; Verzeichnisindex durch temporren Index ersetzen

   ; Schaltflche wieder aktivieren
   GuiControl, 9:Enable, Button1
   GuiControl, 9:Enable, Button2
   GuiControl, 9:Enable, Button3
   GuiControl, 9:Enable, Button4
   GuiControl, 9:Enable, ListBox1
   GuiControl, 9:Focus , ListBox1
Return


; ---------------------------------------------------------------------
; -- Laufwerke indizieren ---------------------------------------------
; ---------------------------------------------------------------------
qc_sub_IndexDrives: ; Laufwerke indizieren
   DetectHiddenwindows,On
   SetTitleMatchMode, 2
   IfWinExist, ac'tivAid_QuickChangeDir Indexer
      return
   IfInString, qc_selectedDrives, %A_Space%
      qc_selectedDrives = "%qc_selectedDrives%"

   If A_IsCompiled = 1
      Run, extensions\ac'tivAid_QuickChangeDir Indexer.exe %qc_selectedDrives%%qc_tmpNoBallon%
   Else
   {
      Run, %A_AutoHotkeyPath%\AutoHotkey.exe "extensions\ac'tivAid_QuickChangeDir Indexer.ahk" %qc_selectedDrives%%qc_tmpNoBallon%
      Sleep,100
   }
   qc_tmpNoBallon =
Return

; ---------------------------------------------------------------------
qc_submenu_IndexDrives: ; Laufwerke indizieren:Aufruf vom Untermen
   if A_ThisMenuItem = %lng_qc_AktualisierenAlle%
   {
      qc_selectedDrives =
   }
   else
   {
      StringReplace, qc_GetDriveLtr, lng_qc_AktualisierenEinzeln, ###,,
      StringReplace, qc_selectedDrives, A_ThisMenuItem, %qc_GetDriveLtr%,
   }
   gosub, qc_sub_IndexDrives
Return


; ---------------------------------------------------------------------
; -- Unterroutine fr den Verzeichniswechsel --------------------------
; ---------------------------------------------------------------------
qc_sub_ChangeDir: ; Unterroutine fr den Verzeichniswechsel
   Sleep,50

   If qc_ctrlState =
      qc_NewWindow = -1
   Else
      qc_NewWindow = 1

   func_ChangeDir(qc_Path,qc_NewWindow,0)
Return

qc_tim_AutoIndexing:
   DetectHiddenwindows,On
   SetTitleMatchMode, 2
   IfWinExist, ac'tivAid_QuickChangeDir Indexer
      return
   Loop, Parse, qc_PathsToIndex, `,
   {
      If A_LoopField =
         break
      qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
      IniRead, qc_DriveSpace, %qc_IndexPath%\%qc_IndexFile%Data.ini, Drives, %qc_ActDrive%, -1
      DriveSpaceFree, qc_actSpace, % qc_func_GetDrive( A_LoopField, "RealPath" )
      If (qc_actSpace <> qc_LastActSpace_%qc_ActDrive%)
      {
         qc_LastActSpace_%qc_ActDrive% := qc_actSpace
         continue
      }
      qc_LastActSpace_%qc_ActDrive% := qc_actSpace

      If (qc_actSpace > qc_DriveSpace)
         qc_Diff := qc_actSpace-qc_DriveSpace
      Else
         qc_Diff := qc_DriveSpace-qc_actSpace

      If (qc_Diff > qc_AutoIndexThreshold OR qc_DriveSpace = "ERROR" )
      {
         qc_selectedDrives = %A_LoopField%
         IniWrite, %qc_actSpace%, %qc_IndexPath%\%qc_IndexFile%Data.ini, Drives, %qc_ActDrive%
         qc_tmpNoBallon := " NoBalloonTips"

         Gosub, qc_sub_IndexDrives
         break
      }
   }
Return

qc_func_GetDrive( Path, RealPath = "" )
{
   StringLeft, Drive, Path, 1
   If Drive = \
   {
      StringSplit, Path, Path, \
      If RealPath = RealPath
         Drive = \\%Path3%\%Path4%
      Else
         Drive := func_StrTranslate(Path3 "#" Path4, "-+ !&()'", "______[]_")
   }
   Else If RealPath = RealPath
      Drive = %Drive%:\

   Return %Drive%
}
