; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               LikeDirkey
; -----------------------------------------------------------------------------
; Prefix:             ld_
; Version:            0.6
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_LikeDirkey:
   Prefix = ld
   %Prefix%_ScriptName    = LikeDirkey
   %Prefix%_ScriptVersion = 0.6

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %ld_ScriptName% - Ordnerkrzel`tStrg/Win 0-9
      Description                   = Verzeichniswechsel (Strg 0-9) oder neues Explorerfenster (Win 0-9) ber Tastaturkrzel.
      lng_ld_MenuNumPad             = Krzel auf Ziffernblock
      lng_ld_MenuFolderTree         = Explorer mit Verzeichnisbaum ffnen
      lng_ld_NoDialog               = Das Setzen eines Verzeichnisses funktioniert nicht in Dialogen!
      lng_ld_FolderOptions          = Verzeichnis kann nicht ermittelt werden.`nin den Ordneroptionen muss eingestellt werden, `ndass im Fenstertitel oder in der Adressleiste der vollstndige Pfad angezeigt wird.
   }
   else        ; = other languages (english)
   {
      MenuName                      = %ld_ScriptName% - folder-hotkeys`tCtrl/Win 0-9
      Description                   = Change directory (Ctrl 0-9) or opens a new window (Win 0-9) with hotkeys.
      lng_ld_MenuNumPad             = use Numpad
      lng_ld_MenuFolderTree         = open Explorer with folder-tree
      lng_ld_NoDialog               = assigning a folder doesn't work in dialogs!
      lng_ld_FolderOptions          = Can't change directory.`nPlease configure windows explorer to show the `nfull path either in the window-title or the address-bar.
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, ld_onNumPad, %ConfigFile%, %ld_ScriptName%, NumPad, 1

   If ld_onNumPad = 1
      ld_NumPadPrefix = NumPad

   IniRead, ld_FolderTree, %ConfigFile%, %ld_ScriptName%, FolderTree, 0

   ; Belegung aus Datei einlesen
   Loop, 10
   {
      ld_Index := A_Index - 1
      IniRead, ld_Folder[%ld_Index%], %ConfigFile%, %ld_ScriptName%, Folder[%ld_Index%]
   }

   if (ld_Folder[0] = "ERROR" AND ld_Folder[1] = "ERROR") ; Wenn Definition nicht exisitert > Standardbelegung
   {
      ld_Folder[1] = C:\
      ld_Folder[2] = D:\
      ld_Folder[3] =
      ld_Folder[4] = `%A_Desktop`%
      ld_Folder[5] = HKEY_LOCAL_MACHINE,SOFTWARE\AutoHotkey,InstallDir
      ld_Folder[6] =
      ld_Folder[7] =
      ld_Folder[8] =
      ld_Folder[9] = `%A_Programfiles`%
      ld_Folder[0] = `%A_ScriptDir`%
   }

   ; Alle 10 Strings aus Pseudo-Array mit Krzeln belegen
   Loop, 10
   {
      ld_Index :=  A_Index -1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
         Hotkey_AllHotkeys := Hotkey_AllHotkeys "#" ld_KeyName ""
         Hotkey_Extension[LikeDirkey$1%ld_Index%] := "#" ld_KeyName
         Hotkey_Extensions := Hotkey_Extensions "LikeDirkey$1" ld_Index "|"
         Hotkey_AllHotkeys := Hotkey_AllHotkeys "^" ld_KeyName ""
         Hotkey_Extension[LikeDirkey$2%ld_Index%] := "^" ld_KeyName
         Hotkey_Extensions := Hotkey_Extensions "LikeDirkey$2" ld_Index "|"
      }

      Hotkey, ~^#%ld_KeyName% , ld_main_LikeDirkey_set ; Strg+Win+ Krzel zuweisen
      Hotkey_AllHotkeys := Hotkey_AllHotkeys "#^" ld_KeyName ""
      Hotkey_Extension[LikeDirkey$3%ld_Index%] := "#^" ld_KeyName
      Hotkey_Extensions := Hotkey_Extensions "LikeDirkey$3" ld_Index "|"
   }
Return

SettingsGui_LikeDirkey:
   Gui, Add, CheckBox, XS+10 ys+15 vld_onNumPad gsub_CheckIfSettingsChanged Checked%ld_onNumPad%, %lng_ld_MenuNumPad%
   Gui, Add, CheckBox, XS+10 y+5 vld_FolderTree gsub_CheckIfSettingsChanged Checked%ld_FolderTree%, %lng_ld_MenuFolderTree%

   Loop, 10
   {
      ld_Index :=  A_Index-1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      If ld_NumPadPrefix =
         ld_KeyName = Win+%ld_Index%
      Else
         ld_KeyName = Win+Num&%ld_Index%

      If ld_Index = 0
      {
         ld_0 = %ld_current%
         ld_0key = %ld_KeyName%
      }
      Else
      {
         Gui, Add, Text, XS+10 YP+25, %ld_KeyName%:
         Gui, Add, Edit, gsub_CheckIfSettingsChanged X+5 YP-2 W443 R1 vld_Folder[%ld_Index%], %ld_current%
         Gui, Add, Button, x+4 h21 W24 vld_Folder_Browse[%ld_Index%] gld_sub_Browse, ...
      }
    }

   Gui, Add, Text, XS+10 YP+25, %ld_0key%:
   Gui, Add, Edit, gsub_CheckIfSettingsChanged X+5 YP-2 W443 vld_Folder[0], %ld_0%
   Gui, Add, Button, -Wrap x+4 h21 W24 vld_Folder_Browse[0] gld_sub_Browse, ...
Return

ld_sub_Browse:
   Gui +OwnDialogs
   StringReplace, ld_Var, A_GuiControl, _Browse,
   Gosub, DoDisable_ComfortDrag
   FileselectFolder, ld_FileNew,,0,%lng_ld_FileType%
   Gosub, DoEnable_ComfortDrag
   If ld_FileNew <>
      GuiControl,,%ld_Var%, %ld_FileNew%
Return


SaveSettings_LikeDirkey:
   Gosub, ld_sub_NumPad
   IniWrite, %ld_onNumPad%, %ConfigFile%, %ld_ScriptName%, NumPad
   IniWrite, %ld_FolderTree%, %ConfigFile%, %ld_ScriptName%, FolderTree

   Loop, 10
   {
      ld_Index :=  A_Index-1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
         Hotkey, ~^%ld_KeyName%, On
         Hotkey, #%ld_KeyName% , On
      }

      Hotkey, ~^#%ld_KeyName% , ld_main_LikeDirkey_set ; Strg+Shift+ Krzel zuweisen
      Hotkey, ~^#%ld_KeyName% , On

      IniWrite, % ld_Folder[%ld_Index%], %ConfigFile%, %ld_ScriptName%, Folder[%ld_Index%]
   }
Return

CancelSettings_LikeDirkey:
Return

DoEnable_LikeDirkey:
   Loop, 10
   {
      ld_Index :=  A_Index-1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
         Hotkey, ~^%ld_KeyName%, On
         Hotkey, #%ld_KeyName% , On
      }

      Hotkey, ~^#%ld_KeyName% , ld_main_LikeDirkey_set ; Strg+Shift+ Krzel zuweisen
      Hotkey, ~^#%ld_KeyName% , On
   }
Return

DoDisable_LikeDirkey:
   Loop, 10
   {
      ld_Index :=  A_Index-1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, Off
         Hotkey, #%ld_KeyName% , Off
      }

      Hotkey, ~^#%ld_KeyName% , Off
   }
Return

DefaultSettings_LikeDirkey:
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

; --- Unterroutine fr Tastaturkrzel -----------------------------------------
ld_main_LikeDirkey_call:
   If Enable_LikeDirkey = 1
   {
      StringRight, ld_keyIndex, A_ThisHotkey, 1 ; Nur die Zahl des Krzels
      ld_path := ld_Folder[%ld_keyIndex%] ; Pfad auslesen

      StringLeft, ld_check, ld_path, 5

      If ld_check = HKEY_
      {
         StringSplit, ld_path, ld_path, `,
         RegRead, ld_path, %ld_path1%,%ld_path2%,%ld_path3%
      }

      StringLeft, ld_check, ld_path, 1

      If ld_check = `%
      {
         StringReplace, ld_path, ld_path, `% ,, A
         ld_path := %ld_path%
      }

      GetKeyState, ld_ctrlState, Ctrl ; Status der Strg-Taste ermitteln

      Gosub, ld_sub_ChangeDir ; Verzeichniswechsel aufrufen
   }
Return

; --- Unterroutine fr Tastaturkrzel-Belegung -------------------------------
ld_main_LikeDirkey_set:
   if Enable_LikeDirkey = 1
   {
      StringRight, ld_keyIndex, A_ThisHotkey, 1 ; Nur die Zahl des Krzels
      Gosub, ld_sub_SetDir ; Verzeichniswechsel aufrufen

      If ld_path <>
      {
         IfExist, %ld_path%
         {
            ld_Folder[%ld_keyIndex%] = %ld_path%

            SetTimer, ld_tim_ToolTip, 10

            Hotkey, ~^%ld_NumPadPrefix%%ld_keyIndex%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
            Hotkey, #%ld_NumPadPrefix%%ld_keyIndex% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen

            Loop, 10
            {
               ld_Index := A_Index - 1
               IniWrite, % ld_Folder[%ld_Index%], %ConfigFile%, %ld_ScriptName%, Folder[%ld_Index%]
            }

            Sleep,2500

            SetTimer, ld_tim_ToolTip, Off

            ToolTip
         }
      }
   }
Return

; -----------------------------------------------------------------------------
ld_tim_ToolTip:
   ToolTip, Krzel %ld_keyIndex% wurde neu belegt: %ld_path%, 4,4
Return

; --- Unterroutine fr den Verzeichniswechsel ---------------------------------
ld_sub_ChangeDir:
   If ld_ctrlState = D
      func_ChangeDir(ld_Path,0,ld_FolderTree)
   Else
      func_ChangeDir(ld_Path,1,ld_FolderTree)

Return

; --- Unterroutine zum Setzen eines neuen Verzeichnisses ----------------------
ld_sub_SetDir:
   ld_path =
   WinGet     , ld_activeWinID, ID, A             ; ID es aktiven Fensters
   WinGetClass, ld_activeClass, ahk_id %ld_activeWinID%  ; Fensterklasse ermitteln

   If ld_activeClass = #32770
   {
      MsgBox,16, %ld_ScriptName% %ld_ScriptVersion%, %lng_ld_NoDialog%
      Return
   }

   ; Prfen ob Fensterklasse untersttzt wird
   If ld_activeClass contains ExploreWClass,CabinetWClass,Afx:400000:0,FileZilla Main Window,bosa_sdm
   {
      ; Ermitteln ob ein Edit1-Control vorhanden ist (Eingabezeile)
      ld_EditClass = Edit1
      ControlGetPos, ld_Edit1Pos,,,, %ld_EditClass% , ahk_id %ld_activeWinID%
   }

   ; Verzeichnis in Explorer-Fenstern wechseln
   If ld_activeClass in ExploreWClass,CabinetWClass,Progman
   {
      If ld_Edit1Pos <>
      {
         RegRead, ld_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
         RegRead, ld_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

         ; Aktuellen Pfad anhand der Adressleiste ermitteln
         If ld_FullPath = 1
            WinGetTitle, ld_CurrentExplorerDirectory, ahk_class %ld_activeClass%

         If ld_FullPathAddress = 1
            ControlGetText, ld_CurrentExplorerDirectory, Edit1, ahk_class %ld_activeClass%

         If ld_activeClass = Progman
            ld_CurrentExplorerDirectory = %A_Desktop%

         Sleep,200

         If ld_CurrentExplorerDirectory =
         {
            MsgBox, 16, %ld_ScriptName% %ld_ScriptVersion%, %lng_ld_FolderOptions%
            Return
         }

         ld_path = %ld_CurrentExplorerDirectory%
         Return
      }
   }
   ; Verzeichnis aus AcdSee auslesen
   Else if ld_activeClass = Afx:400000:0
   {
      If ld_Edit1Pos <>
      {
         ControlGetText, ld_path, Edit1, ahk_id %ld_activeWinID%
         Return
      }
   }
   ; Verzeichnis aus FireFox auslesen
   Else if ld_activeClass = FileZilla Main Window
   {
      If ld_Edit1Pos <>
      {
         ControlGetText, ld_path, Edit1, ahk_id %ld_activeWinID%
         Return
      }
   }
   ; Verzeichnis aus EmFtp auslesen
   Else if ld_activeClass = EmftpMainFrame
   {
      If ld_Edit1Pos <>
      {
         ControlGetText, ld_path, Edit5, ahk_id %ld_activeWinID%
         Return
      }
   }
Return

; --- Unterroutine fr das NumPad-Men ----------------------------------------
ld_sub_NumPad:
   Loop, 10
   {
      ld_Index :=  A_Index -1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
         Hotkey, ~^%ld_KeyName%, Off ; Strg+ Krzel lschen
         Hotkey, #%ld_KeyName% , Off ; Win+ Krzel lschen
         StringReplace, Hotkey_AllHotkeys, Hotkey_AllHotkeys, % "#" ld_KeyName "" ,, A
         StringReplace, Hotkey_AllHotkeys, Hotkey_AllHotkeys, % "^" ld_KeyName "" ,, A
      }
      Hotkey, ~^#%ld_KeyName% , Off ; Strg+Shift+ Krzel lschen
      StringReplace, Hotkey_AllHotkeys, Hotkey_AllHotkeys, % "#^" ld_KeyName "" ,, A
   }


   If ld_onNumPad = 1
      ld_NumPadPrefix = NumPad
   Else
      ld_NumPadPrefix =

   Loop, 10
   {
      ld_Index :=  A_Index -1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
         Hotkey, ~^%ld_KeyName%, On
         Hotkey, #%ld_KeyName% , On
         Hotkey_AllHotkeys := Hotkey_AllHotkeys "#" ld_KeyName ""
         Hotkey_Extension[LikeDirkey$1%ld_Index%] := "#" ld_KeyName
         Hotkey_Extensions := Hotkey_Extensions "LikeDirkey$1" ld_Index "|"
         Hotkey_AllHotkeys := Hotkey_AllHotkeys "^" ld_KeyName ""
         Hotkey_Extension[LikeDirkey$2%ld_Index%] := "^" ld_KeyName
         Hotkey_Extensions := Hotkey_Extensions "LikeDirkey$2" ld_Index "|"
      }
      Hotkey, ~^#%ld_KeyName% , ld_main_LikeDirkey_set ; Strg+Shift+ Krzel zuweisen
      Hotkey, ~^#%ld_KeyName% , On
      Hotkey_AllHotkeys := Hotkey_AllHotkeys "#^" ld_KeyName ""
      Hotkey_Extension[LikeDirkey$3%ld_Index%] := "#^" ld_KeyName
      Hotkey_Extensions := Hotkey_Extensions "LikeDirkey$3" ld_Index "|"
   }
Return

