; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               ac'tivAid
; -----------------------------------------------------------------------------
; Version:            1.0.0
; Date:               2005-10-14 11:15
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; AutoHotkey Version: 1.0.40.00
; Language:           German/Dutch (+ English GUI)
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Prft auf die richtige AutoHotkey-Version, startet dann das eigentliche
; Skript.

; #################################################################EndHeader###

; -----------------------------------------------------------------------------
; === Global Settings =========================================================
; -----------------------------------------------------------------------------

#singleinstance force

; -----------------------------------------------------------------------------
; === Initialisation ======================================================cd==
; -----------------------------------------------------------------------------

ScriptName         = ac'tivAid
ScriptNameClean    = activAid
ScriptVersion      = 1.0.0
neededAHKversion   = 1.0.40.00
ConfigFile         = settings\%ScriptName%.ini

ScriptTitle        = %ScriptName% v%ScriptVersion%

; -----------------------------------------------------------------------------

RegRead, A_AutoHotkeyPath, HKLM, SOFTWARE\AutoHotkey, InstallDir

; sprachabhngige Variablen, Systemsprache wird ermittelt
IniRead, Lng, %ConfigFile%, %ScriptNameClean%, Language
If Lng = ERROR
   StringRight, Lng, A_Language, 2 ; Sprache ermitteln, wenn nicht in INI festgelegt

If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   lng_wrongAHK         = AutoHotkey %neededAHKversion% oder hher wird bentigt.`nSoll die neuste Version automatisch heruntergeladen und installiert werden?
   lng_downloadingAHK   = Die neuste Version von AutoHotkey wird heruntergeladen ...
   lng_wr_UpdateCFG     = Wegen der neuen Mglichkeiten von WebSearch sollte die Konfigurations-Datei mit den Suchmaschinen (URLs.cfg) neu angelegt werden.`nAlle manuell hinzugefgte URLs werden gelscht. Von der alten Konfigurations-Datei wird aber eine Sicherung (URLs.bak) angelegt.
}
else        ; = other languages (english)
{
   lng_wrongAHK         = AutoHotkey %neededAHKversion% or high will be needed.`nPlease download the newest version.
   lng_downloadingAHK   = Downloading the newest version of AutoHotkey ...
   lng_wr_UpdateCFG     = Due to new capabilities of WebSearch the config-file (URLs.cfg) should be recreated.`nAll added urls will be deleted. A backup of the old config-file (URLs.bak) will be created.
}

; Prfen, ob richtige AutoHotkey-Version installiert ist
FileDelete, AutoHotkeyInstall.exe
FileDelete, updateAHK.cmd
If A_AHKversion < %neededAHKversion%
{
   MsgBox, 19, %ScriptTitle%, %lng_wrongAHK%
   IfMsgBox, yes
   {
      If func_Download( "http://home.tampabay.rr.com/kodi/ahk/AutoHotkeyInstall.exe", "AutoHotkeyInstall.exe", lng_downloadingAHK, "AutoHotkey Update", 1600 ) = 0
      {
         FileAppend, AutoHotkeyInstall.exe`n, updateAHK.cmd
         FileAppend, "%A_AutoHotkeyPath%\AutoHotkey.exe" "%A_ScriptFullPath%"`n, updateAHK.cmd
         Run, updateAHK.cmd,,Hide
         DetectHiddenWindows, On
         Loop
         {
            Process, Exist, AutoHotkey.exe
            IfEqual, ErrorLevel, 0, Break
            Process, Close, AutoHotkey.exe
         }
         ExitApp
      }
   }

   IfMsgBox, cancel
      ExitApp

   Run, http://www.autohotkey.com./download/
   ExitApp
}

FileMove, %ScriptName%_main.ahk, %ScriptName%.ahk, 1

; nderungen an der Verzeichnisstruktur durchfhren
IfExist, WebResearch
{
   FileCreateDir, WebSearch
   FileMove, WebResearch\*.*, WebSearch\, 1
   FileRemoveDir, WebResearch, 1
   IfExist, WebSearch\URLs.cfg
   {
      MsgBox, 36, %ScriptTitle%, %lng_wr_UpdateCFG%
      IfMsgBox,yes
      {
         FileMove, WebSearch\URLs.cfg, WebSearch\URLs.bak
      }
   }
}
IfExist, WebSearch
{
   FileMoveDir, WebSearch, settings\WebSearch
   FileRemoveDir, WebSearch, 1
   IfExist, settings\WebSearch\URLs.cfg
   {
      MsgBox, 36, %ScriptTitle%, %lng_wr_UpdateCFG%
      IfMsgBox,yes
      {
         FileMove, settings\WebSearch\URLs.cfg, settings\WebSearch\URLs.bak
      }
   }
}
IfExist, ac'tivAid.ini
   FileMove, ac'tivAid.ini, settings\ac'tivAid.ini, 1
IfExist, includes
   FileRemoveDir, includes, 1
IfExist, settings\extensions_main.ahk
   FileMove, settings\extensions_main.ahk, extensions\_main.ahk
FileDelete, settings\extensions_main.ahk
IfExist, settings\extensions_header.ahk
   FileMove, settings\extensions_header.ahk, extensions\_header.ahk
FileDelete, settings\extensions_header.ahk
IfExist, extensions\Hotstrings.ahk
   FileMove, extensions\Hotstrings.ahk, settings\Hotstrings.ini
FileDelete, extensions\Hotstrings.ahk
IfExist, extensions\Hotstrings.ini
   FileMove, extensions\Hotstrings.ini, settings\Hotstrings.ini
FileDelete, extensions\Hotstrings.ini

FileDelete, ac'tivAid_ct.ico
FileDelete, ac'tivAid.ico
FileDelete, ac'tivAid_off.ico
FileDelete, ac'tivAid_on.ico
FileDelete, ac'tivAid Readme.txt
FileDelete, extensions\Vol.gif
FileDelete, extensions\Vol2.gif
FileDelete, extensions\Vol.wav
FileDelete, extensions\mute.gif
FileDelete, extensions\Eject.gif

FileDelete, extensions\ac'tivAid_Winamp.ahk
FileDelete, extensions\ac'tivAid_Winamp_Vol.gif
FileDelete, extensions\ac'tivAid_Winamp_Vol2.gif
FileDelete, extensions\ac'tivAid_Winamp_Vol.wav

IfExist, backup\ac'tivAid_main.exe
{
   FileDelete, ac'tivAid.exe
   FileMove, backup\ac'tivAid_main.exe, backup\ac'tivAid.exe
}

IniDelete,%ConfigFile%, WinAmp

IniWrite, http://dev.rumborak.de/ahk-versions.ini?dl=yes, %ConfigFile%, %ScriptNameClean%, UpdateURL

IfNotInString, A_Scriptname, -Checker
   Reload

Return

func_Download( URL, File, Splashtext, Title="", Size=0, URL2="", File2="" )
{
   Thread,Priority,-1000
   global DownloadProgressSplashtext,DownloadProgressFile,DownloadProgressFileSize,DownloadProgressTotalSize,DownloadProgressAddSize,DownloadProgressTitle
   Random, Random1, 1, 99999
   Random, Random2, 1, 99999
   DownloadProgressTotalSize = %Size%

   Suspend, On
   DownloadProgressAddSize = 0
   DownloadProgressSplashtext = %Splashtext%
   DownloadProgressTitle = %Title%
   DownloadProgressFile = %File%
   If Size > 5
      Progress, FM10 FS10 WM400 WS400 P0 w400, %File%, %DownloadProgressSplashtext%, AutoHotkey Update
   Else
      SplashImage,,b1 FS9 W400, %DownloadProgressSplashtext%
   SetTimer, tim_DownloadProgress, 10, 1000
   URLDownloadToFile, %URL%?dl=%Random1%&ul=%Random2%, %File%
   ReturnVal = %ErrorLevel%
   If (URL2 <> "" AND File2 <> "")
   {
      If Size > 5
         Progress, FM10 FS10 WM400 WS400 w400, %File2%, %DownloadProgressSplashtext%, AutoHotkey Update
      DownloadProgressFile = %File2%
      DownloadProgressAddSize = %DownloadProgressFileSize%
      URLDownloadToFile, %URL2%?dl=%Random1%&ul=%Random2%, %File2%
      ReturnVal := ReturnVal + ErrorLevel
   }
   SetTimer, tim_DownloadProgress, off
   SplashImage, Off
   Progress, Off
   Return %ReturnVal%
}

tim_DownloadProgress:
   FileGetSize, DownloadProgressFileSize, %DownloadProgressFile%, K
   DownloadProgressFileSize := DownloadProgressAddSize + DownloadProgressFileSize
   If DownloadProgressFileSize = %DownloadProgressFileSizeLast%
      return
   If DownloadProgressTotalSize > 5
   {
      DownloadProgressPercentage := Round(DownloadProgressFileSize / DownloadProgressTotalSize * 100,0)
      Progress, %DownloadProgressPercentage%
   }
   Else
   {
      SplashImage,,b1 FS9 W400, %DownloadProgressSplashtext% (%DownloadProgressFileSize% Kb)
   }
   DownloadProgressFileSizeLast = %DownloadProgressFileSize%
Return
