/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.util.Iterator;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;

public class PDRadioButton {
    private static final COSName KEY = COSName.getPDFName("AS");
    private static final COSName OFF_VALUE = COSName.getPDFName("Off");
    private COSDictionary obj;

    public PDRadioButton(COSDictionary objValue) {
        this.obj = objValue;
    }

    public boolean isChecked() {
        boolean retval = false;
        String value = this.getOnValue();
        COSName radioValue = (COSName)this.obj.getDictionaryObject(KEY);
        if (radioValue != null && value != null && radioValue.getName().equals(value)) {
            retval = true;
        }
        return retval;
    }

    public void check() {
        this.obj.setName(KEY, this.getOnValue());
    }

    public void unCheck() {
        this.obj.setName(KEY, this.getOffValue());
    }

    public String getOffValue() {
        return OFF_VALUE.getName();
    }

    public String getOnValue() {
        String value = null;
        COSDictionary ap = (COSDictionary)this.obj.getDictionaryObject(COSName.getPDFName("AP"));
        COSBase n = ap.getDictionaryObject(COSName.getPDFName("N"));
        if (n instanceof COSDictionary) {
            Iterator li = ((COSDictionary)n).keyList().iterator();
            while (li.hasNext()) {
                Object key = li.next();
                if (key.equals(OFF_VALUE)) continue;
                value = ((COSName)key).getName();
            }
        }
        return value;
    }

    public boolean representsValue(COSName repValue) {
        return repValue.getName().equals(this.getOnValue());
    }
}

