/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.fdf.FDFCatalog;
import org.pdfbox.pdmodel.fdf.FDFDictionary;
import org.pdfbox.pdmodel.fdf.FDFDocument;
import org.pdfbox.pdmodel.fdf.FDFField;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.pdmodel.interactive.form.PDFieldFactory;

public class PDAcroForm {
    private COSDictionary acroForm;
    private PDDocument document;
    private Map fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.acroForm = new COSDictionary();
        COSArray fields = new COSArray();
        this.acroForm.setItem(COSName.getPDFName("Fields"), (COSBase)fields);
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.acroForm = form;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public COSDictionary getDictionary() {
        return this.acroForm;
    }

    public void importFDF(FDFDocument fdf) throws IOException {
        List fields = fdf.getCatalog().getFDF().getFields();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                FDFField fdfField = (FDFField)fields.get(i);
                PDField docField = this.getField(fdfField.getPartialFieldName());
                if (docField == null) continue;
                docField.importFDF(fdfField);
            }
        }
    }

    public FDFDocument exportFDF() throws IOException {
        FDFDocument fdf = new FDFDocument();
        FDFCatalog catalog = fdf.getCatalog();
        FDFDictionary fdfDict = new FDFDictionary();
        catalog.setFDF(fdfDict);
        ArrayList<FDFField> fdfFields = new ArrayList<FDFField>();
        List fields = this.getFields();
        Iterator fieldIter = fields.iterator();
        while (fieldIter.hasNext()) {
            PDField docField = (PDField)fieldIter.next();
            String fieldValue = docField.getValue();
            if (fieldValue == null) continue;
            FDFField fdfField = new FDFField();
            fdfField.setPartialFieldName(docField.getName());
            fdfField.setValue(fieldValue);
            fdfFields.add(fdfField);
        }
        fdfDict.setID(this.document.getDocument().getDocumentID());
        if (fdfFields.size() > 0) {
            fdfDict.setFields(fdfFields);
        }
        return fdf;
    }

    public List getFields() throws IOException {
        COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
        ArrayList<PDField> retval = new ArrayList<PDField>();
        for (int i = 0; i < fields.size(); ++i) {
            PDField field;
            COSDictionary element = (COSDictionary)fields.getObject(i);
            if (element == null || (field = PDFieldFactory.createField(this, element)) == null) continue;
            retval.add(field);
        }
        return retval;
    }

    public void setCacheFields(boolean cache) throws IOException {
        if (cache) {
            this.fieldCache = new HashMap();
            List fields = this.getFields();
            Iterator fieldIter = fields.iterator();
            while (fieldIter.hasNext()) {
                PDField next = (PDField)fieldIter.next();
                this.fieldCache.put(next.getName(), next);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDField getField(String name) throws IOException {
        PDField retval = null;
        if (this.fieldCache != null) {
            retval = (PDField)this.fieldCache.get(name);
        } else {
            COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
            for (int i = 0; i < fields.size() && retval == null; ++i) {
                COSString fieldName;
                COSDictionary element = (COSDictionary)fields.getObject(i);
                if (element == null || !(fieldName = (COSString)element.getDictionaryObject(COSName.getPDFName("T"))).getString().equals(name)) continue;
                retval = PDFieldFactory.createField(this, element);
            }
        }
        return retval;
    }

    public PDResources getDefaultResources() {
        PDResources retval = null;
        COSDictionary dr = (COSDictionary)this.acroForm.getDictionaryObject(COSName.getPDFName("DR"));
        if (dr != null) {
            retval = new PDResources(dr);
        }
        return retval;
    }

    public void setDefaultResources(PDResources dr) {
        COSDictionary drDict = null;
        if (dr != null) {
            drDict = dr.getCOSDictionary();
        }
        this.acroForm.setItem(COSName.getPDFName("DR"), (COSBase)drDict);
    }
}

