/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FilterManager;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSDictionaryMap;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.COSStreamArray;
import org.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

public class PDStream
implements COSObjectable {
    private COSStream stream;

    public PDStream(PDDocument document) {
        this.stream = new COSStream(document.getDocument().getScratchFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDStream(PDDocument doc, InputStream str) throws IOException {
        block6: {
            OutputStream output = null;
            try {
                this.stream = new COSStream(doc.getDocument().getScratchFile());
                output = this.stream.createUnfilteredStream();
                byte[] buffer = new byte[1024];
                int amountRead = -1;
                while ((amountRead = str.read(buffer)) != -1) {
                    output.write(buffer, 0, amountRead);
                }
                Object var7_6 = null;
                if (output == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (output != null) {
                    output.close();
                }
                if (str != null) {
                    str.close();
                }
                throw throwable;
            }
            output.close();
        }
        if (str != null) {
            str.close();
        }
    }

    public void addCompression() {
        ArrayList<COSName> filters = this.getFilters();
        if (filters == null) {
            filters = new ArrayList<COSName>();
            filters.add(COSName.FLATE_DECODE);
            this.setFilters(filters);
        }
    }

    public PDStream(COSStream str) {
        this.stream = str;
    }

    public static PDStream createFromCOS(COSBase base) throws IOException {
        PDStream retval = null;
        if (base instanceof COSStream) {
            retval = new PDStream((COSStream)base);
        } else if (base instanceof COSArray) {
            retval = new PDStream(new COSStreamArray((COSArray)base));
        } else if (base != null) {
            throw new IOException("Contents are unknown type:" + base.getClass().getName());
        }
        return retval;
    }

    public COSBase getCOSObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() throws IOException {
        return this.stream.createUnfilteredStream();
    }

    public InputStream createInputStream() throws IOException {
        return this.stream.getUnfilteredStream();
    }

    public InputStream getPartiallyFilteredStream(List stopFilters) throws IOException {
        FilterManager manager = this.stream.getFilterManager();
        InputStream is = this.stream.getFilteredStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List filters = this.getFilters();
        Iterator iter = filters.iterator();
        String nextFilter = null;
        boolean done = false;
        while (iter.hasNext() && !done) {
            os.reset();
            nextFilter = (String)iter.next();
            if (stopFilters.contains(nextFilter)) {
                done = true;
                continue;
            }
            Filter filter = manager.getFilter(COSName.getPDFName(nextFilter));
            filter.decode(is, os, this.stream.getDictionary());
            is = new ByteArrayInputStream(os.toByteArray());
        }
        return is;
    }

    public COSStream getStream() {
        return this.stream;
    }

    public int getLength() {
        return this.stream.getDictionary().getInt("Length", 0);
    }

    public List getFilters() {
        List retval = null;
        COSBase filters = this.stream.getDictionary().getDictionaryObject("Filter");
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList(name.getName(), name, this.stream.getDictionary(), "Filter");
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFilters(List filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.getDictionary().setItem("Filter", (COSBase)obj);
    }

    public List getDecodeParams() throws IOException {
        COSArrayList retval = null;
        COSBase dp = this.stream.getDictionary().getDictionaryObject("DecodeParms");
        if (dp == null) {
            dp = this.stream.getDictionary().getDictionaryObject("DP");
        }
        if (dp instanceof COSDictionary) {
            COSDictionaryMap map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList(map, dp, this.stream.getDictionary(), "DecodeParams");
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap> actuals = new ArrayList<COSDictionaryMap>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setDecodeParams(List decodeParams) {
        this.stream.getDictionary().setItem("DecodeParams", (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public PDFileSpecification getFile() {
        COSBase f = this.stream.getDictionary().getDictionaryObject("F");
        PDFileSpecification retval = PDFileSpecification.createFS(f);
        return retval;
    }

    public void setFile(PDFileSpecification f) {
        this.stream.getDictionary().setItem("F", (COSObjectable)f);
    }

    public List getFileFilters() {
        List retval = null;
        COSBase filters = this.stream.getDictionary().getDictionaryObject("FFilter");
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList(name.getName(), name, this.stream.getDictionary(), "FFilter");
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFileFilters(List filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.getDictionary().setItem("FFilter", (COSBase)obj);
    }

    public List getFileDecodeParams() throws IOException {
        COSArrayList retval = null;
        COSBase dp = this.stream.getDictionary().getDictionaryObject("FDecodeParms");
        if (dp instanceof COSDictionary) {
            COSDictionaryMap map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList(map, dp, this.stream.getDictionary(), "FDecodeParams");
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap> actuals = new ArrayList<COSDictionaryMap>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setFileDecodeParams(List decodeParams) {
        this.stream.getDictionary().setItem("FDecodeParams", (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream is = null;
        try {
            is = this.createInputStream();
            int amountRead = -1;
            while ((amountRead = is.read(buf)) != -1) {
                output.write(buf, 0, amountRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return output.toByteArray();
    }
}

