/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;

public class ShowSignature {
    public static void main(String[] args) throws Exception {
        ShowSignature show = new ShowSignature();
        show.showSignature(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSignature(String[] args) throws Exception {
        if (args.length != 2) {
            ShowSignature.usage();
        } else {
            String password = args[0];
            String infile = args[1];
            PDDocument document = null;
            try {
                document = PDDocument.load(infile);
                if (document.isEncrypted()) {
                    document.decrypt(password);
                } else {
                    System.err.println("Warning: Document is not encrypted.");
                }
                COSDictionary trailer = document.getDocument().getTrailer();
                COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
                COSDictionary acroForm = (COSDictionary)root.getDictionaryObject(COSName.getPDFName("AcroForm"));
                COSArray fields = (COSArray)acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
                for (int i = 0; i < fields.size(); ++i) {
                    COSDictionary field = (COSDictionary)fields.getObject(i);
                    COSName type = (COSName)field.getDictionaryObject(COSName.getPDFName("FT"));
                    if (type == null || !type.getName().equals("Sig")) continue;
                    COSDictionary cert = (COSDictionary)field.getDictionaryObject(COSName.getPDFName("V"));
                    System.out.println("Certificate found");
                    System.out.println("Name=" + cert.getDictionaryObject(COSName.getPDFName("Name")));
                    System.out.println("Modified=" + cert.getDictionaryObject(COSName.getPDFName("M")));
                    COSName subFilter = (COSName)cert.getDictionaryObject(COSName.getPDFName("SubFilter"));
                    if (subFilter != null) {
                        if (subFilter.getName().equals("adbe.x509.rsa_sha1")) {
                            COSString certString = (COSString)cert.getDictionaryObject(COSName.getPDFName("Cert"));
                            byte[] certData = certString.getBytes();
                            CertificateFactory factory = CertificateFactory.getInstance("X.509");
                            Collection<? extends Certificate> certs = factory.generateCertificates(new ByteArrayInputStream(certData));
                            System.out.println("certs=" + certs);
                            continue;
                        }
                        System.err.println("Unknown certificate type:" + subFilter);
                        continue;
                    }
                    throw new IOException("Missing subfilter for cert dictionary");
                }
            }
            finally {
                document.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java org.pdfbox.examples.signature.ShowSignature <password> <inputfile>");
    }
}

