unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Registry, ExtCtrls,
  OpDialog;

const KEYNAME: String = '\SYSTEM\CurrentControlSet\Control\Session Manager';
      PFRO: String = 'PendingFileRenameOperations';


type
  TForm1 = class(TForm)
    btnAdd: TButton;
    btnDel: TButton;
    btnEdit: TButton;
    btnRefresh: TButton;
    Panel1: TPanel;
    lstFiles: TListView;
    Panel2: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    btnApply: TButton;
    procedure btnRefreshClick(Sender: TObject);
    procedure lstFilesChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure btnDelClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure FillTheList;
    function SaveTheList: Boolean;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ *** Private Helpers *** }

procedure TForm1.FillTheList;
var reg: TRegistry;
    sFiles, sSrc, sDest: String;
    cbFiles: Integer;
    li: TListItem;

  function ExtractFilename: String;
  var p: Integer;
  begin
    p := Pos(#0, sFiles);
    if p >= 1 then begin
      Result := Copy(sFiles, 1, p - 1);
      Delete(sFiles, 1, p);
      p := Pos('?', Result);
      if (p > 0) and (p < 4)
      then Delete(Result, 1, 4);
    end
    else Result := '';
  end;

begin
  cbFiles := 0;
  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    if reg.OpenKeyReadOnly(KEYNAME)
    then begin
      cbFiles := reg.GetDataSize(PFRO);
      if cbFiles > 0
      then begin
        SetLength(sFiles, cbFiles);
        reg.ReadBinaryData(PFRO, sFiles[1], cbFiles);
      end;
    end;
  finally
    reg.CloseKey;
    reg.Free;
  end;
  if cbFiles > 0
  then begin
    repeat
      sSrc := ExtractFilename;
      sDest := ExtractFilename;
      if sDest = ''
      then sDest := '<Lschen>';
      li := lstFiles.Items.Add;
      li.Caption := sSrc;
      li.SubItems.Add(sDest);
    until Length(sFiles) <= 1;
    SetLength(sFiles, 0);
  end;
end;

function TForm1.SaveTheList: Boolean;
var reg: TRegistry;
    sSrc, sDest: String;
    i: Integer;
    li: TListItem;
begin
  Result := false;
  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    if reg.OpenKey(KEYNAME, false)
    then begin
      if reg.ValueExists(PFRO)
      then Result := reg.DeleteValue(PFRO)
      else Result := true;
    end;
  finally
    reg.CloseKey;
    reg.Free;
  end;
  if Result
  then begin
    for i := 0 to lstFiles.Items.Count - 1 do
    begin
      li := lstFiles.Items[i];
      sSrc := li.Caption;
      sDest := li.SubItems[0];
      if sDest = '<Lschen>'
      then MoveFileEx(PChar(sSrc), nil, MOVEFILE_DELAY_UNTIL_REBOOT)
      else MoveFileEx(PChar(sSrc), PChar(sDest), MOVEFILE_DELAY_UNTIL_REBOOT);
    end;
  end
  else
    Application.MessageBox('Zugriff gescheitert. Haben Sie Administratorrechte?', nil, MB_OK or MB_ICONSTOP);
end;

{ *** Event Handlers *** }

procedure TForm1.FormShow(Sender: TObject);
begin
  FillTheList;
end;

procedure TForm1.btnRefreshClick(Sender: TObject);
begin
  lstFiles.Items.Clear;
  FillTheList;
  btnApply.Enabled := false;
end;

procedure TForm1.lstFilesChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var bSel: Boolean;
begin
  bSel := (lstFiles.Selected <> nil);
  btnDel.Enabled := bSel;
  btnEdit.Enabled := bSel;
end;

procedure TForm1.btnDelClick(Sender: TObject);
var it: TListItem;
    idx: Integer;
begin
  it := lstFiles.Selected;
  if it <> nil
  then begin
    idx := lstFiles.Items.IndexOf(it);
    lstFiles.Items.Delete(idx);
    if idx < lstFiles.Items.Count
    then lstFiles.Selected := lstFiles.Items[idx]
    else lstFiles.Selected := lstFiles.Items[idx-1];
    btnApply.Enabled := true;
  end;
end;

procedure TForm1.btnOKClick(Sender: TObject);
begin
  if btnApply.Enabled
  then SaveTheList;
  Close;
end;

procedure TForm1.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.btnApplyClick(Sender: TObject);
begin
  if SaveTheList
  then btnApply.Enabled := false;
end;

procedure TForm1.btnAddClick(Sender: TObject);
var li: TListItem;
begin
  with OperationDialog
  do begin
    Clear;
    if ShowModal = mrOK
    then begin
      li := lstFiles.Items.Add;
      with li
      do begin
        Caption := edtSrc.Text;
        if radDel.Checked then
          SubItems.Add('<Lschen>')
        else if radRen.Checked then
          SubItems.Add(edtDestRen.Text)
        else if radMov.Checked then
          SubItems.Add(edtDestMov.Text);
        Selected := true;
      end;
      btnApply.Enabled := true;
    end;
  end;
end;

procedure TForm1.btnEditClick(Sender: TObject);
var li: TListItem;
begin
  li := lstFiles.Selected;
  if li <> nil
  then begin
    with OperationDialog, li
    do begin
      Clear;
      edtSrc.Text := Caption;
      if SubItems[0] <> '<Lschen>'
      then begin
        edtDestMov.Text := SubItems[0];
        radMov.Checked := true;
      end;
      if ShowModal = mrOK
      then begin
        Caption := edtSrc.Text;
        if radDel.Checked then
          SubItems[0] := '<Lschen>'
        else if radRen.Checked then
          SubItems[0] := edtDestRen.Text
        else if radMov.Checked then
          SubItems[0] := edtDestMov.Text;
        btnApply.Enabled := true;
      end;
    end;
  end;
end;

end.
