VERSION 5.00
Begin VB.UserControl Control1 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "Control1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

' 2005, Ralf Nebelo

Dim objWD As Word.Application

Private Sub UserControl_Initialize()
    Set objWD = GetObject(, "Word.Application")
End Sub

Public Sub AutoExecAX()
    Dim objMen As CommandBarControl
    Dim objBefehl As CommandBarButton

    If MenVorhanden("&Makros") = False Then
        Set objMen = objWD.CommandBars("Menu Bar").Controls.Add(Type:=msoControlPopup, Before:=10)
        With objMen
            .Caption = "&Makros"

            Set objBefehl = .Controls.Add(Type:=msoControlButton)
            With objBefehl
                .Caption = "&Wortliste generieren"
                .FaceId = 278
                .Style = msoButtonIconAndCaption
                .OnAction = "XLWortlisteGenerieren"
            End With
            
            Set objBefehl = .Controls.Add(Type:=msoControlButton)
            With objBefehl
                .BeginGroup = True
                .Caption = "&Markierung vorlesen"
                .FaceId = 68
                .Style = msoButtonIconAndCaption
                .OnAction = "MarkierungVorlesen"
            End With

            Set objBefehl = .Controls.Add(Type:=msoControlButton)
            With objBefehl
                .Caption = "&Dokument vorlesen"
                .FaceId = 27
                .Style = msoButtonIconAndCaption
                .OnAction = "DokumentVorlesen"
            End With

        End With
    End If
End Sub

Public Sub AutoExitAX()
    If MenVorhanden("&Makros") = True Then
        objWD.CommandBars("Menu Bar").Controls("&Makros").Delete
    End If
End Sub

Private Function MenVorhanden(strMenName As String) As Boolean
    Dim objMen As CommandBarControl

    For Each objMen In objWD.CommandBars("Menu Bar").Controls
        If objMen.Caption = strMenName Then
            MenVorhanden = True
            Exit For
        End If
    Next
End Function

Public Sub XLWortlisteGenerierenAX()
    Dim objActDoc As Document
    Dim objWort As Range
    Dim strWort As String
    Dim intI As Integer
    Dim blnVorhanden As Boolean
    Dim colWrter As New Collection
    Dim colHufigkeiten As New Collection
    Dim vntWert As Integer
    Dim objXL As Object

    If objWD.Documents.Count = 0 Then
        MsgBox "Es ist kein Dokument geffnet.", vbExclamation, "Wortliste generieren"
        Exit Sub
    End If

    objWD.System.Cursor = wdCursorWait

    Set objActDoc = objWD.ActiveDocument
    
    For Each objWort In objActDoc.Words
        strWort = Trim(objWort.Text)
        'Satzzeichen aussortieren
        If Len(strWort) > 1 Then
            'Steuerzeichen aussortieren
            If Asc(strWort) > 31 Then
                'Zahlen aussortieren
                If Val(strWort) = 0 Then
                    'Wort schon in der Liste?
                    For intI = 1 To colWrter.Count
                        blnVorhanden = False
                        If LCase(colWrter(intI)) = LCase(strWort) Then
                            blnVorhanden = True
                            vntWert = colHufigkeiten(intI)
                            colHufigkeiten.Add Item:=vntWert + 1, Before:=intI
                            colHufigkeiten.Remove intI + 1
                            Exit For
                        End If
                    Next

                    If blnVorhanden = False Then
                        colWrter.Add Item:=strWort
                        colHufigkeiten.Add Item:="1"
                    End If
                End If
            End If
        End If
    Next

    objWD.System.Cursor = wdCursorNormal

    If colWrter.Count > 0 Then
        Set objXL = CreateObject("Excel.Application")
        If objXL Is Nothing Then
            MsgBox "Excel kann nicht gestartet werden."
            Exit Sub
        End If

        With objXL
            .Visible = True
            .Workbooks.Add
            With .ActiveSheet
                .Columns("A:A").NumberFormat = "@"
                .Columns("B:B").NumberFormat = "General"

                With .Cells(1, 1)
                    .Value = "Wortliste: " & objActDoc.Name
                    .Font.Size = 12
                    .Font.Bold = True
                End With

                For intI = 1 To colWrter.Count
                    .Cells(intI + 1, 1) = colWrter(intI)
                    .Cells(intI + 1, 2) = colHufigkeiten(intI)
                Next
                .UsedRange.Select
            End With
            .Selection.Sort Key1:=.Range("A2"), Order1:=1, Header:=1
        End With

        MsgBox "Wortliste mit " & CStr(colWrter.Count) & " Eintrgen in neuer Excel-Arbeitsmappe gespeichert.", vbInformation, "Wortliste generieren"
        Set objXL = Nothing
    End If
End Sub

Public Sub MarkierungVorlesenAX()
    Dim strDlgTitel As String

    strDlgTitel = "Markierung vorlesen"

    If objWD.Documents.Count = 0 Then
        MsgBox "Es ist kein Dokument geffnet.", vbExclamation, strDlgTitel
        Exit Sub
    End If

    If objWD.Selection.Type = wdSelectionIP Then
        MsgBox "Sie haben keinen Text markiert.", vbInformation, strDlgTitel
        Exit Sub
    End If

    With frmMarkierungVorlesen
        .Caption = strDlgTitel
        .wspMund.SetText objWD.Selection.Text
        .Show
    End With
End Sub

Public Sub DokumentVorlesenAX()
    Dim strDlgTitel As String
    Dim objAktSelection As Range

    strDlgTitel = "Dokument vorlesen"

    If objWD.Documents.Count = 0 Then
        MsgBox "Es ist kein Dokument geffnet.", vbExclamation, strDlgTitel
        Exit Sub
    End If

    Set objAktSelection = objWD.Selection.Range
    objWD.ActiveDocument.Content.Select

    With frmMarkierungVorlesen
        .Caption = strDlgTitel
        .wspMund.SetText objWD.Selection.Text
        .Show
    End With

    objAktSelection.Select
End Sub

Private Sub UserControl_Terminate()
    Set objWD = Nothing
End Sub
