#include "prime.h"
#include <cmath>

//---------------------------------------------------------------
void Prime::Search()
{
	this->InitStartUp();
	this->InitArrays();
	this->BucketInit();

	time[0] = clock();
	this->SetRepField();
	time[1] = clock();

	stp = rsp;
	sta = rsa;

	if(sta > _EC_SHIFT) sta -= _EC_SHIFT;
	if(stp > _EC_SHIFT) stp -= _EC_SHIFT;

	if(sta % 30)
		sta = sta - sta % 30;
	if(stp % 30)
		stp += 30 - stp % 30;

	this->SievePrimes();
	this->PrintCount();
	this->PrintTimes();
}
//---------------------------------------------------------------
void Prime::SievePrimes()
{
	this->BucketSetUse(); /*needs sta */

	uint32 sl = 
		(uint32) sqrt( (double)rsp );
	uint32 ml = 
		(uint32) sqrt( (double)sl );

	this->SPrimesModulo( ml );
	this->SPrimesEratos( sl );

	ind = 0;

	seg = ((stp - sta) / 30 > size) 
		?size :(stp - sta) / 30;

	dat = &data2[0];

	this->DoData(sta, data2);
	this->SetPos(sta);

	time[2] = clock();
	this->Cyrene();
	time[3] = clock();
}
//-------------------------------------------------------------
uint32 Prime::Correct(uint32 i)
{
	uint32 n = 0;

	for(uint32 j = 0; j < 8; j++) {
		if(i > bitv[j]) n |= (1 << j);
	}

	return n;
}
//--------------------------------------------------------------
void Prime::Cyrene()
{
	this->Copyf();

	if(!sta)
		*sieve = 0xff; /*reset primes < 37 */

	*sieve &= 
		~Correct( (uint32)(rsa - sta) );

	uint32 upl;

	upl =  size * 30;
	seg = gsize;

	while(sta + upl < stp) {

		this->Bucket(sta);

		ind = 0;

		while(ind < size) {

			this->Sieve(sta + incr + 1); /* + 1 = + _EC_ADJUST */
			this->Count();
			this->PGaps(sta);
			this->Print(sta);
			this->Copyf();

			sta += incr; /*incr = (gsize * 30) */
			ind += seg;
		}
	}

	this->Bucket(sta); 

	ind = 0;

	while(sta + incr < stp) { 

		this->Sieve(sta + incr + 1);
		this->Count();
		this->PGaps(sta);
		this->Print(sta);

		sta += incr;
		ind += seg;
	}

	seg = (uint32)(stp - sta) / 30;

	this->Sieve(rsp); 
	this->Coend(sta); /*count, print, correct */
	this->PGaps(sta);
}
//-------------------------------------------------------------
