#include "prime.h"
#include <climits>
#include <cstring>

static const uint8 mask[37] = {255,

	bit7,255,255,255,255, 255,
	bit0,255,255,255,bit1,255,
	bit2,255,255,255,bit3,255,
	bit4,255,255,255,bit5,255,
	 255,255,255,255,bit6,255,
	bit7,255,255,255,255, 255	/*_EC_SHIFT suplementary values */
};


//-------------------------------------------------------------
void Prime::InitRepField()
{
	if(prp < 7 || prp > 23) { /*7 min, 23 max */

		prp = _EC_STD_RSIZE;
	}

	rsize = product(prp) / 30;
}
//-------------------------------------------------------------
void Prime::SetRepField()
{
	memset(repf, 255, 7); /*initialization */ 

	uint32 a,b,c,d,e,i;

	for(i = 0; bitv[i] <= prp; i++) {

		if(i > 0) {

			b = bitv[i];

			c /= 30;

			for(a = 1; a < b; a++) {

				memcpy(repf + (a * c), repf, c);
			}
		}

		a = bitv[i];

		c = product(a) + 1;

		for(b = a + a; a <= c; a += b) {

			d = (a - 6) /* - 6, - _EC_SHIFT */
				/ 30;
			e =  a - d 
				* 30;

			repf[d] &= mask[e];
		}
	}

	dat = data1 + (i + 2);

	dat->prime = UINT_MAX;
}
//-------------------------------------------------------------
void Prime::SetPos(uint64 n)
{
	pos = (uint32)(n % product(prp)) / 30;
}
//-------------------------------------------------------------
void Prime::Copyf()
{
	uint8* s = ind + sieve;
	uint8* e = seg + s;

	uint32 i = rsize - pos;

	if(i > seg) { /*repf > gsize */

		memcpy(s, pos +  repf, seg);
		          pos += seg;
	}
	else { /*repf <= gsize */
		memcpy(s, repf + pos, i);

		s += i;

		for(;s +  rsize < e;
			 s += rsize)

			memcpy(s, repf, rsize);

		pos = e - s;

		memcpy(s, repf, pos);
	}
}
//-------------------------------------------------------------

