#include "prime.h"
#include "sieve.h"

//------------------------------------------------------------------
void Prime::BucketSieve()
{
	bucket *c, *b = lists[curr];

	uint32 k,p,r;
	uint32 i,n;

	while(b != NULL) {

		for(i = 0; i < b->count; i++) {

			n = b->data[i].prime;
			p = b->data[i].pos;

			r = p >> 24;
			p = p  & 16777215; /*2^24 -1 */

			do {
				sieve[p] &= s30[r][0];

				p += s30[r][1] * n;
				p += s30[r][2];
				r  = s30[r][3];

				k = p >> logd;
			}
			 while(!k); /*(p < size) */

			p = (r << 24)
				| (p & modd);

			k = (k + curr) & lsize;

			c = lists[k];

			r = c->count++;

			c->data[r].prime = n;
			c->data[r].pos   = p;

			if(r == _get_new_bucket) {

				BucketGet(k);
			}
		}

		c       = b;
		b       = b->next;
		c->next = buckets;
		buckets = c;
	}

	this->BucketSet();
}
//------------------------------------------------------------------
