using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Diagnostics; 
using System.Security.Permissions; 
using System.Reflection; 
using System.Security.Principal; 

namespace Rollen
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	/// 

	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.Button bLogin;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.TextBox txtUsername;
		private System.Windows.Forms.TextBox txtPassword;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ListBox listBox1;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.txtUsername = new System.Windows.Forms.TextBox();
			this.txtPassword = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.bLogin = new System.Windows.Forms.Button();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.label3 = new System.Windows.Forms.Label();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.SuspendLayout();
			// 
			// txtUsername
			// 
			this.txtUsername.Location = new System.Drawing.Point(96, 16);
			this.txtUsername.Name = "txtUsername";
			this.txtUsername.Size = new System.Drawing.Size(136, 20);
			this.txtUsername.TabIndex = 0;
			this.txtUsername.Text = "";
			// 
			// txtPassword
			// 
			this.txtPassword.Location = new System.Drawing.Point(96, 48);
			this.txtPassword.Name = "txtPassword";
			this.txtPassword.PasswordChar = '*';
			this.txtPassword.Size = new System.Drawing.Size(136, 20);
			this.txtPassword.TabIndex = 1;
			this.txtPassword.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(24, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 16);
			this.label1.TabIndex = 2;
			this.label1.Text = "Benutzer";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(24, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 16);
			this.label2.TabIndex = 3;
			this.label2.Text = "Kennwort";
			// 
			// bLogin
			// 
			this.bLogin.Location = new System.Drawing.Point(248, 32);
			this.bLogin.Name = "bLogin";
			this.bLogin.Size = new System.Drawing.Size(96, 24);
			this.bLogin.TabIndex = 9;
			this.bLogin.Text = "Anmelden";
			this.bLogin.Click += new System.EventHandler(this.bLogin_Click);
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 461);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(352, 22);
			this.statusBar1.TabIndex = 10;
			this.statusBar1.Text = "statusBar1";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(24, 88);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(344, 16);
			this.label3.TabIndex = 12;
			this.label3.Text = "Rollen fr Benutzer ";
			// 
			// listBox1
			// 
			this.listBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.listBox1.Location = new System.Drawing.Point(32, 112);
			this.listBox1.Name = "listBox1";
			this.listBox1.ScrollAlwaysVisible = true;
			this.listBox1.Size = new System.Drawing.Size(304, 342);
			this.listBox1.TabIndex = 11;
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(352, 483);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.bLogin);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.txtPassword);
			this.Controls.Add(this.txtUsername);
			this.Name = "Form1";
			this.Text = "Rollen abfragen";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			statusBar1.Text = "Sie sind angemeldet als " + WindowsIdentity.GetCurrent().Name; 
			AppDomain.CurrentDomain.SetPrincipalPolicy(PrincipalPolicy.WindowsPrincipal);
			ShowRoles(); 
		}

		// Defs in C:\Programme\Microsoft Visual Studio .NET 2003\Vc7\PlatformSDK\Include\winbase.h
		const int LOGON32_LOGON_INTERACTIVE   = 2; 
		const int LOGON32_PROVIDER_DEFAULT    = 0; 
 
		[DllImport("advapi32.dll", SetLastError = true)]
		extern static bool LogonUser(
			string lpszUsername,
			string lpszDomain, 
			string lpszPassword,
			int dwLogonType,   // wir nehmen Interactive
			int dwLogonProvider,  // wir nehmen Default
			[Out] out IntPtr phToken
			);

		[DllImport("kernel32.dll")]
		public extern static bool CloseHandle(IntPtr TokenHandle);

		// Deklarative Sicherheit:
		// [PrincipalPermission(SecurityAction.Demand, Role = @"vordefiniert\administratoren")]
		// alternativ (Pfad anpassen!!!):
		// [PermissionSetAttribute(SecurityAction.Demand, File = @"D:\Eigene Dateien auf Athlon\Artikel\ct\Net 10b - FSK\Code\Rollen\bin\Debug\Permissions4.xml")] 
		
		private void bLogin_Click(object sender, System.EventArgs e)
		{
			// Imperative Sicherheit:
			// PrincipalPermission pp = new PrincipalPermission(@"vordefiniert\administratoren"); 
			// pp.Demand(); 
			IntPtr ptr; 
			bool res; 
			WindowsIdentity wi; 
			res = LogonUser(txtUsername.Text, ".", txtPassword.Text, LOGON32_LOGON_INTERACTIVE, LOGON32_PROVIDER_DEFAULT, out ptr);  
			if (res)
			{
				statusBar1.Text = "Logon erfolgreich fr " + txtUsername.Text; 
				wi = new WindowsIdentity(ptr);
				WindowsImpersonationContext impersonatedUser = wi.Impersonate(); 
				ShowRoles(); 
				impersonatedUser.Undo(); 
			}
			else
			{
				statusBar1.Text = "Logon fehlgeschlagen"; 
			}
			if (ptr != IntPtr.Zero)
				CloseHandle(ptr);
		}

		private void ShowRoles()
		{
			listBox1.Items.Add ("Rollen fr Benutzer " + WindowsIdentity.GetCurrent().Name); 

			//Ermittelt die Windows-Rollen des angemeldeten Benutzers ber Reflection.
			MethodInfo getroles = typeof(WindowsIdentity).GetMethod("GetRoles",
				BindingFlags.Instance | BindingFlags.NonPublic);
			string[] roles = (string[])getroles.Invoke(WindowsIdentity.GetCurrent(), null);
			foreach(string role in roles)
				if (role != null) 
					listBox1.Items.Add("    " + role); 
		}
	}
}
