// OtherStrongName.cs -- 
//    Klasse prft imperativ, ob Aufrufer denselben starken Namen trgt.
//    Demand() lst Security-Exception aus, wenn Aufrufer nicht mit dem 
//    Schlssel UnsignedAssbly.snk (siehe AssemblyInfo.cs) signiert wurde
//    Hinweis: Damit Demand() funktionieren kann, muss der Aufrufer den 
//       Stackwalk fr die StrongNameIdentiyPermission mit Assert() 
//       unterbrechen, da sich die StrongNameIdentity nicht auf den Loader
//       fortsetzt. 

using System;
using System.Security.Permissions; 
using System.Security.Policy; 

namespace StrongNamePermisson
{
	public class OtherStrongName
	{
    public string hello = "Hello from OtherStrongName"; 
		// Dieser Konstruktor wertet das AppDomain-Evidence-Objekt aus
		public OtherStrongName()
    {
      Type t = this.GetType(); 
      Evidence ev = t.Assembly.Evidence; 
      StrongNameIdentityPermission snip = new StrongNameIdentityPermission(PermissionState.None);

      StrongName sn = null; 
      foreach(object o in ev)
        if (o.GetType() == typeof(StrongName))
          sn = (StrongName) o; 
      snip.PublicKey = sn.PublicKey;   // Schlssel aus eigener Assembly
      ev = AppDomain.CurrentDomain.Evidence; 
      foreach(object o in ev)
        if (o.GetType() == typeof(StrongName))
          sn = (StrongName) o; 
      snip.Version = sn.Version;   // Version und Name aus AppDomain
      snip.Name = sn.Name; 
      snip.Demand(); 
    }

		// Diesem Konstruktor muss der Aufrufer Namen und Version mitgeben
		public OtherStrongName(string name, Version version)
    {
      Type t = this.GetType(); 
      Evidence ev = t.Assembly.Evidence; 
      StrongNameIdentityPermission snip = new StrongNameIdentityPermission(PermissionState.None);

      StrongName sn = null; 
      foreach(object o in ev)
        if (o.GetType() == typeof(StrongName))
          sn = (StrongName) o; 
      snip.PublicKey = sn.PublicKey;   // Schlssel aus eigener Assembly
      snip.Version = version; 
      snip.Name = name; 
      snip.Demand(); 
    }

	}
}
