; ---------------------------------------------------------------------
; Name:             QuickChangeDir v0.2
; Author:           Wolfgang Reszel fr c't
; Datum:            7.12.2004
;
; Language:         german/english
; Platform:         tested with XP
; #Includeable:     yes
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Mit QCD kann man schnell zu einem gewnschten Verzeichnis wechseln,
; ohne dass man genau wei wo es liegt. QCD durchsucht einen vorher
; erstellten Verzeichnisindex der gewnschten Laufwerke.
;
; QCD wird entweder per Doppelklick auf das Trayicon oder mit Strg+<
; aufgerufen. Man gibt in dem erscheinenden Fenster den Suchbegriff ein
; drckt Enter oder auf Suchen. Gibt es nur ein zum Suchbegriff
; passendes Verzeichnis, wird es direkt geffnet. Ansonsten bekommt man
; eine Liste aller zum Suchbegriff passenden Verzeichnisse angezeigt.
; Dort kann man per Doppelklick oder mit der Schaltflche
;  "OK, wechseln" das Verzeichnis wechseln. Mit der Schaltflche
; "Explorer" oder auch bei gedrckter Strg+Taste wird eine neues
; Explorer-Fenster geffnet, statt im aktuellen Fenster das Verzeichnis
; zu wechseln.
;
; Ruft man das Skript mit einem beliebigen Parameter auf, wird
; direkt der Verzeichnisindex erstellt.
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; -- Konfiguration: ---------------------------------------------------
; ---------------------------------------------------------------------

; Welche Laufwerke sollen bercksichtigt werden?
Drives_qcd = CDE  ; Laufwerksbuchstaben (direkt hintereinander)

; Wo werden die Verzeichnisindexe gespeichert
IndexPath_qcd = %AppData%
IndexFile_qcd = QCD_Index_

; ---------------------------------------------------------------------
; -- Initialisierung --------------------------------------------------
; ---------------------------------------------------------------------

; Programmname und Version
Version_qcd = 0.1
Titel_qcd = QuickChangeDir v%Version_qcd%

selectedDrives_qcd = %Drives_qcd%

#Singleinstance force
Coordmode, Caret, Screen

; Systemsprache ermitteln
StringRight, Lng, A_Language, 2
if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   lngUntersuche           = Untersuche Laufwerk
   lngIndiziere            = Erstelle Verzeichnisindex
   lngWechseln             = &Verzeichnis wechseln
   lngReIndizierung        = Verzeichnisindex &aktualisieren
   lngReIndizierungBreak   = &Aktualisierung abbrechen
   lngAbbruch              = &Abbrechen
   lngSuchen               = &Suchen
   lngAktualisieren        = A&ktualisieren
   lngAktualisierenAlle    = alle Laufwerke aktualisieren
   lngNeuesFenster         = &Explorer
   lngVerzWechseln         = &OK, wechseln
   lngberVerzHinzu        = berverzeichnis hinzufgen
   lngAusIndexEntf         = Verzeichnisbaum aus Index entfernen
   lngLaufwerkERR          = Laufwerk existiert nicht
   lngSucheERR             = Nichts gefunden
   lngSuchEingabe          = Suchbegriff eingeben:
   lngEnde                 = Beende
}
else        ; = andere Sprachen
{
   lngUntersuche           = Looking at drive
   lngIndiziere            = Creating directorylist
   lngWechseln             = &change directory
   lngReIndizierung        = &update directorylist
   lngReIndizierungBreak   = &cancel updating
   lngAbbruch              = &cancel
   lngSuchen               = &search
   lngAktualisieren        = &update
   lngAktualisierenAlle    = &update all drives
   lngNeuesFenster         = &Explorer
   lngVerzWechseln         = &OK, change
   lngberVerzHinzu        = add parent directory
   lngAusIndexEntf         = delete directorytree
   lngLaufwerkERR          = drive does noct exist
   lngSucheERR             = nothing found
   lngSuchEingabe          = Enter query:
   lngEnde                 = Exit
}

; History laden
FileReadLine, HistoryFile_qcd, %IndexPath_qcd%\QCD_History.dat, 1
Loop, Parse, HistoryFile_qcd,|
{
   If A_LoopField <>
      History_qcd = %History_qcd%%A_LoopField%|
   if A_Index > 20
      break
}

; Tooltip und Icon anpassen
Menu, TRAY, Tip, %Titel_qcd%
Menu, TRAY, Icon, %SystemRoot%\system32\SHELL32.dll, 46

; Traymen erweitern
Menu, TRAY, Add
Menu, TRAY, Add, %lngEnde% %Titel_qcd%, Quit
Menu, TRAY, Add

; Untermen fr die Laufwerksaktualisierung erzeugen
Loop, Parse, Drives_qcd
{
   Menu, IndexLwf, Add, %A_Loopfield%:, subIndexDrives_qcd
}
Menu, IndexLwf, Add, %lngAktualisierenAlle%, subIndexDrives_qcd

; Erzeugtes Untermen einem Menpunkt im Hauptmen zuweisen.
Menu, TRAY, Add, %lngReIndizierung%, :IndexLwf
Menu, TRAY, Add, %lngWechseln%, QCD
; Default-Menpunkt auf 'Verzeichnis wechseln' setzen,
; somit wird beim Doppelklick auf das Trayicon dieser
; Befehl direkt ausgefhrt
Menu, TRAY, Default, %lngWechseln%

; Wenn das Skript mit einem Parameter aufgerufen wird,
; dann direkt die Indizierung der Verzeichnisse starten
if 1 <>
   gosub, IndexDrives_qcd

Hotkey, ~RButton, Off
Hotkey, ~Del, Off

Return ; Auto-Execute-Bereich ist hier zu Ende

; ---------------------------------------------------------------------
; -- Eingabefenster fr QCD ------------------------------------
; ---------------------------------------------------------------------

; Hotkey mit Strg+<
^SC056::gosub, QCD ; HotkeyDef

; ---------------------------------------------------------------------
QCD: ; Unterroutine fr das Eingabefenster
   WinGet     , q_window_id, ID, A             ; ID es aktiven Fensters
   WinGetClass, q_class, ahk_id %q_window_id%  ; Fensterklasse ermitteln

   IfWinNotExist, %Titel_qcd% ; Fenster aufbauen, wenn es noch nicht existiert
   {
      WinH_qcd   = 80   ; Fensterhhe
      WinW_qcd   = 300  ; Fensterbreite

      ; Fenster aufbauen
      Gui, Add, Text    ,                                    , %lngSuchEingabe%
      Gui, Font, Ccc0000 ; Text Rot (#CC0000)
      Gui, Add, Text    ,                   x+5              , %ErrorMsg_qcd%
      Gui, Add, ComboBox, vFindString_qcd   x10  w280        , %History_qcd%
      Gui, Add, Button  , gIndexDrives_qcd       w75         , %lngAktualisieren%
      Gui, Add, Button  , gGuiCancel        x+60 w70         , %lngAbbruch%
      Gui, Add, Button  , gSearchOK_qcd     x+5  w70  Default, %lngSuchen%
      Gui, -Maximize
      Gui, Show, w%WinW_qcd% h%WinH_qcd%, %Titel_qcd%
      ErrorMsg_qcd =
   }
   else ; ... wenn Fenster existiert ...
   {
      WinActivate, %Titel_qcd% ; .. in den Vordergrund
   }
Return

; ---------------------------------------------------------------------
SearchOK_qcd: ;    Suchen-Schaltflche

   GetKeyState, ctrlState_qcd, Ctrl ; Status der Strg-Taste ermitteln
   if ctrlState_qcd = U             ; wenn nicht gedruckt
      ctrlState_qcd =               ; Statusvariable lschen, damit sie im Ergebnisfenster nochmals abgefragt wird
   Gosub, Result_qcd
Return


; ---------------------------------------------------------------------
; -- Ergebnisfenster der Suche ----------------------------------------
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
Result_qcd: ; Unterroutine fr die Verzeichnissuche [Suchen-Schaltflche]

   Gui, Submit  ; Eingaben des Fenster in die Variablen bertragen
   Gui, Destroy ; Eingabefenster beenden

   ; Rechte Maustaste und die Entf-Taste fr das kommende Fenster zulassen
   Hotkey, ~RButton, On
   Hotkey, ~Del, On

   StringLen, Len_qcd, FindString_qcd                         ; Lnge des Suchbegriffs
   StringReplace, History_qcd, History_qcd, %FindString_qcd%| ; Doppelter Eintrag in Historie entfernen
   History_qcd = %FindString_qcd%|%History_qcd%               ; Suchbegriffhistorie erweitern
   FileDelete,%IndexPath_qcd%\QCD_History.dat
   FileAppend,%History_qcd%,%IndexPath_qcd%\QCD_History.dat

   ; Wenn Suchbegriff lnger als ein Zeichen
   if Len_qcd > 1
   {
      NumDirs_qcd  = 0      ; Anzahl der gefundenen Verzeichnisse auf 0 setzen

      WinW_qcd     = 620   ; Fensterbreite
      WinH_qcd     = 460   ; Fensterhhe
      MinW_qcd     = 420   ; minimale Fensterbreite
      MinH_qcd     = 200   ; minimale Fensterhge
      ListW_qcd    = 600   ; Breite der Ergebnisliste
      ListH_qcd    = 400   ; Hhe der Ergebnisliste
      EditY_qcd    = 400   ; Position der Statuszeile
      ButtonY_qcd  = 430   ; Y-Position der Schaltflchen
      Button2X_qcd = 325   ; X-Position von "Abbrechen"
      Button3X_qcd = 425   ; X-Position von "gleiches Fenster"
      Button4X_qcd = 520   ; X-Position von "neues Fenster"

      Gui, Add, ListBox, h%ListH_qcd% w%ListW_qcd% Choose1 vvarResults_qcd gResultList_qcd Sort ; Ergebnisliste

      Loop, Parse, Drives_qcd ; alle Laufwerke duchgehen
      {
         ActDrive_qcd = %A_LoopField%                        ; aktuelles Laufwerk
         IndexTemp_qcd = %IndexPath_qcd%\%IndexFile_qcd%%ActDrive_qcd%.dat ; Dateiname Verzeichnisindex
         Loop, Read, %IndexTemp_qcd%                         ; Verzeichnisindex laden
         {
            SplitPath, A_LoopReadLine, CheckFile, CheckDir ; Pfad aufteilen
            If CheckFile contains %FindString_qcd%         ; Wenn Suchbegriff vorhanden
            {
               GuiControl,,varResults_qcd,%A_LoopReadLine% ; Pfad zum Fenster hinzufgen
               NumDirs_qcd++                               ; Anzahl gefundener Verz. erhhen
            }
         }
         GuiControl, Choose, varResults_qcd, 1             ; erstes Verz. auswhlen
      }

      ; Fenster zeigen, wenn mehr als ein Verz. gefunden
      if NumDirs_qcd > 1
      {
         Gui, Add, Edit  ,                        x10             y%EditY_qcd%   w%ListW_qcd% vStatusBar ReadOnly
         Gui, Add, Button, gResultIndexDrives_qcd x10             y%ButtonY_qcd% w90        , %lngAktualisieren%
         Gui, Add, Button, gGuiCancel             x%Button2X_qcd% y%ButtonY_qcd% w90        , %lngAbbruch%
         Gui, Add, Button, gResultOK_qcd2         x%Button3X_qcd% y%ButtonY_qcd% w90        , %lngNeuesFenster%
         Gui, Add, Button, gResultOK_qcd          x%Button4X_qcd% y%ButtonY_qcd% w90 Default, %lngVerzWechseln%
         Gui, +Resize
         Gui, Show, w%WinW_qcd% h%WinH_qcd%, %Titel_qcd%
         SetTimer, ResultResize_qcd, 0 ; Fenstergren-berwachungsroutine stndig aufrufen
      }

      ; Wenn nur ein Verzeichnis gefunden, direkt dort hin wechseln
      if NumDirs_qcd = 1
      {
         gosub, ResultOK_qcd
      }

      ; Wenn kein Verzeichnis gefunden, dann Suchfenster wieder aufrufen
      if NumDirs_qcd = 0
      {
         SetTimer,ResultResize_qcd,Off  ; Grenberwachung ausschalten
         Gui,Destroy                    ; Fenster beenden
         Hotkey, ~RButton, Off
         Hotkey, ~Del, Off
         ErrorMsg_qcd = %lngSucheERR%   ; Fehlermeldung setzen
         Gosub, QCD                     ; Suchfenster wieder aufrufen
      }
   }

   ; Wenn Suchbegriff ein Zeichen lang, dann ist der Suchbegriff ein Laufwerksbuchstabe
   if Len_qcd = 1
   {
      DriveGet, AllDrives_qcd, List              ; Liste aller verfgbaren Laufwerksbuchstaben
      if AllDrives_qcd contains %FindString_qcd% ; Ist Suchbegriff in der Liste ...
      {                                          ; ... ja
         q_path = %FindString_qcd%:              ; Pfad setzen
         gosub, q_ChangeDir                      ; Unterroutine um Pfad zu ffnen oder zu wechseln
         ctrlState_qcd =                         ; Status der Strg-Taste zurcksetzen
      }
      else                                       ; ... nein
      {
         ErrorMsg_qcd = %lngLaufwerkERR%         ; Fehhlermeldung setzen
         Hotkey, ~RButton, Off
         Hotkey, ~Del, Off
         Gosub, QCD                              ; Suchfenster wieder aufrufen
      }
   }
Return

; ---------------------------------------------------------------------
ResultIndexDrives_qcd:    ;    Indizierung von der Ergebnisliste aufrufen
   gosub, IndexDrives_qcd ; Indizierung starten
   gosub, GuiCancel       ; Ergebnisliste schlieen ...
   gosub, SearchOK_qcd    ; ... und neu laden
Return

; ---------------------------------------------------------------------
ResultResize_qcd: ;    Fenstergren-berwachung
; - sorgt dafr, dass beim Vergrern des Sucherergebnisfensters die Schaltflchen
; und die Ergebnisliste mit angepasst werden

   wingetpos newWinX_qcd,newWinY_qcd,newWinW_qcd,newWinH_qcd, %Titel_qcd% ; Fenstermae ermitteln
   if newWinW_qcd < %MinW_qcd%                                            ; Breitenlimit unterschritten ...
      WinMove, %Titel_qcd%,,,,%MinW_qcd%                                  ; ... dann auf Minimalbreite setzen
   if newWinH_qcd < %MinH_qcd%                                            ; Hhenlimit unterschritten ...
      WinMove, %Titel_qcd%,,,,,%MinH_qcd%                                 ; ... dann auf Minimalhhe setzen

   wingetpos newWinX_qcd,newWinY_qcd,newWinW_qcd,newWinH_qcd, %Titel_qcd% ; nochmals Fenstermae ermitteln
   WinGet, win_id, ID, A         ; ID des aktiven Fensters
   SysGet,TitleH_qcd,30          ; Hhe der Titelzeile
   SysGet,BorderH_qcd,33         ; Hhe des Fensterrands
   SysGet,BorderW_qcd,32         ; Breite des Fensterrands
   TitleH_qcd += %BorderH_qcd%
   TitleH_qcd += %BorderH_qcd%

   ; Differenz des vernderten Fensters zu der Originalgre errechnen
   DiffH_qcd = %newWinH_qcd%
   DiffH_qcd -= %TitleH_qcd%
   DiffH_qcd -= %WinH_qcd%

   DiffW_qcd = %newWinW_qcd%
   DiffW_qcd -= %BorderW_qcd%
   DiffW_qcd -= %BorderW_qcd%
   DiffW_qcd -= %WinW_qcd%

   if DiffW_qcd = %lastDiffW_qcd%
   if DiffH_qcd = %lastDiffH_qcd%
      return

   lastDiffW_qcd = %DiffW_qcd%
   lastDiffH_qcd = %DiffH_qcd%

   ; Neue Positionen und Gren berechnen
   newListW_qcd    =  %ListW_qcd%
   newListW_qcd    += %DiffW_qcd%
   newListH_qcd    =  %ListH_qcd%
   newListH_qcd    += %DiffH_qcd%
   newEditY_qcd    =  %EditY_qcd%
   newEditY_qcd    += %DiffH_qcd%
   newButtonY_qcd  =  %ButtonY_qcd%
   newButtonY_qcd  += %DiffH_qcd%
   newButton2X_qcd =  %Button2X_qcd%
   newButton2X_qcd += %DiffW_qcd%
   newButton3X_qcd =  %Button3X_qcd%
   newButton3X_qcd += %DiffW_qcd%
   newButton4X_qcd =  %Button4X_qcd%
   newButton4X_qcd += %DiffW_qcd%

   ; Fensterelemente anpassen
   GuiControl, move, ListBox1,                                     w%newListW_qcd% h%newListH_qcd%
   GuiControl, move, Edit1,                      y%newEditY_qcd%   w%newListW_qcd%
   GuiControl, move, Button1,                    y%newButtonY_qcd%
   GuiControl, move, Button2, x%newButton2X_qcd% y%newButtonY_qcd%
   GuiControl, move, Button3, x%newButton3X_qcd% y%newButtonY_qcd%
   GuiControl, move, Button4, x%newButton4X_qcd% y%newButtonY_qcd%
Return


; ---------------------------------------------------------------------
ResultOK_qcd: ;    Verzeichnis wechseln (OK-Schaltflche)

   SetTimer,ResultResize_qcd,Off
   Gui, Submit
   Gui, Destroy
   Hotkey, ~RButton, Off
   Hotkey, ~Del, Off
   IfExist,%varResults_qcd% ; nur wechslen wenn Verzeichnis existiert
   {
      q_path = %varResults_qcd%
      gosub, q_ChangeDir
      ctrlState_qcd =
   }
return

; ---------------------------------------------------------------------
ResultOK_qcd2: ;    neues Explorer-Fenster (Explorer-Schaltflche)

   ctrlState_qcd = D   ; gedrckte Strg-Taste vortuschen
   gosub, ResultOK_qcd
Return

; ---------------------------------------------------------------------
GuiEscape: ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
GuiCancel: ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
GuiClose:  ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)

   if BreakIndexing_qcd =     ; Wenn Indizierung inaktiv
   {
      SetTimer,ResultResize_qcd,Off
      Gui, Destroy            ; Fenster schlieen
      Hotkey, ~RButton, Off
      Hotkey, ~Del, Off
   }
   else                       ; Wenn Indizierung aktiv
   {
      BreakIndexing_qcd = yes ; Indizierung wird abgebrochen
   }
Return

; ---------------------------------------------------------------------
ResultList_qcd: ;    Klick auf Ergebnisliste

   ; Statuszeile mit dem Namen ohne Pfad setzen
   GuiControlGet, ListLine_qcd,,varResults_qcd
   SplitPath,ListLine_qcd,FName_qcd,FDir_qcd
   GuiControl, ,StatusBar,%FName_qcd%

   ; Bei Doppelklick "neues Fenster" ausfhren
   if A_GuiControlEvent = DoubleClick
      gosub, ResultOK_qcd
return

; Kontextmen der Ergebnisliste
~RButton:: ; HotkeyDef
   IfWinActive, %Titel_qcd%    ; nur wenn Fenster aktiv
   {
      MouseGetPos,,,,MouseControl_qcd  ; Control unter Maus ermitteln
      if MouseControl_qcd = ListBox1   ; Wenn Control Ergebnisliste ...
      {
         ; ... dann Kontextmen aufbauen
         Send, {LButton} ; An Mauspositoin einen Klick ausfhren, damit die Zeile markiert wird
         Menu, context, add, %lngNeuesFenster%, ResultOK_qcd
         Menu, context, add, %lngVerzWechseln%, ResultOK_qcd2
         Menu, context, add
         Menu, context, add, %lngAusIndexEntf%, DeleteEntry_qcd
         Menu, context, add, %lngberVerzHinzu%, AddParent_qcd
         Menu, context, show
         Menu, context, DeleteAll
      }
    }
Return

~Del:: ; HotkeyDef
   IfWinActive, %Titel_qcd% ; nur wenn Fenster aktiv
   {
      Gosub, DeleteEntry_qcd
   }
Return

; ---------------------------------------------------------------------
DeleteEntry_qcd: ;    Menpunkt Eintrag aus der Verzeichnisindex entfernen

   GuiControlGet, ListLine_qcd,,varResults_qcd ; aktuelle Zeile ermitteln
   gosub, SubDeleteEntry_qcd
Return

; ---------------------------------------------------------------------
AddParent_qcd: ;    Menpunkt berverzeichnis zur Liste hinzufgen

   GuiControlGet, ListLine_qcd,,varResults_qcd
   SplitPath, ListLine_qcd,,ListLine_qcd
   GuiControl, Choose, varResults_qcd, 1
   GuiControl, ChooseString, varResults_qcd, %ListLine_qcd%
   GuiControlGet, SelLine,,varResults_qcd
   if ListLine_qcd  <> %SelLine%
      GuiControl,, varResults_qcd, %ListLine_qcd%
   GuiControl, ChooseString, varResults_qcd, %ListLine_qcd%
   WinActivate, %Titel_qcd%
Return

; ---------------------------------------------------------------------
SubDeleteEntry_qcd: ;    Unterroutine fr Eintrag aus der Verzeichnisindex entfernen

   ; Schaltflchen deaktivieren
   GuiControl, Disable, Button1
   GuiControl, Disable, Button2
   GuiControl, Disable, Button3
   GuiControl, Disable, Button4
   GuiControl, Disable, ListBox1

   StringLeft, ActDrive_qcd, ListLine_qcd, 1 ; Laufwerksbuchstabe des ausgewhlten Pfads

   IndexTemp_qcd = %IndexPath_qcd%\%IndexFile_qcd%%ActDrive_qcd%_tmp.dat ; Temporrer Index
   IndexDest_qcd = %IndexPath_qcd%\%IndexFile_qcd%%ActDrive_qcd%.dat ; Verzeichnisindex
   GuiControl,+AltSubmit,varResults_qcd ; ... damit nicht der Name, sondern die ListenNr ermittelt wird

   Loop, Read, %IndexDest_qcd%   ; Verzeichnisindex laden
   {
      StringLen,Len_qcd,ListLine_qcd                       ; Lnge des ausgewhlten Pfads
      StringLeft, MatchLine_qcd, A_LoopReadLine, %Len_qcd% ; geladener Eintrag aus Verzeichnisindex krzen

      If MatchLine_qcd <> %ListLine_qcd%                   ; Wenn ausgewhlter Pfad <> geladener Eintrag
      {
         FileAppend, %A_LoopReadLine%`n, %IndexTemp_qcd%   ; ... wieder in Verzeichnisindex schreiben
      }
      else                                                 ; ... sonst nicht schreiben ...
      {
         GuiControl,ChooseString,varResults_qcd, %A_LoopReadLine% ; Eintrag in Ergebnisliste auswhlen
         GuiControlGet,ListN_qcd,,varResults_qcd                  ; ListenNr ermitteln
         Control, Delete, %ListN_qcd%, ListBox1, %Titel_qcd%      ; Eintrag lschen
      }
   }
   GuiControl,-AltSubmit,varResults_qcd         ; ... damit wieder der Name von Listenelementen ermittelt wird
   FileMove, %IndexTemp_qcd%, %IndexDest_qcd%,1 ; Verzeichnisindex durch temporren Index ersetzen

   ; Schaltflche wieder aktivieren
   GuiControl, Enable, Button1
   GuiControl, Enable, Button2
   GuiControl, Enable, Button3
   GuiControl, Enable, Button4
   GuiControl, Enable, ListBox1
   GuiControl, Focus , ListBox1
Return


; ---------------------------------------------------------------------
; -- Laufwerke indizieren ---------------------------------------------
; ---------------------------------------------------------------------
IndexDrives_qcd: ; Laufwerke indizieren

   If BreakIndexing_qcd = IndexingActiv ; Wenn Indizierung im Gange
   {
      BreakIndexing_qcd = yes           ; Indizierung abbrechen (Aufruf kam also vom Traymen)
      Return                            ; und nicht weiter machen
   }
   If BreakIndexing_qcd =               ; Wenn Indizierung nicht im Gange
      BreakIndexing_qcd = IndexingActiv ; Status setzen

   ; Traymen anpassen
   Menu, TRAY, Disable, %lngWechseln%                               ; Verzeichniswechsel nicht erlauben
   Menu, TRAY, Disable, %lngReIndizierung%                          ; Aktualisierung nicht erlauben
   Menu, TRAY, Add , %lngReIndizierungBreak%, IndexDrives_qcd       ; Menpunkt fr Aktualisierung abbrechen
   Menu, TRAY, NoDefault                                            ; Doppelklick (Standardmeneintrag) verhindern

   ; Alle Schaltflchen bis auf "Abbrechen" deaktivieren
   GuiControl, Disable, Button1
   GuiControl, Disable, Button3
   GuiControl, Disable, Button4
   GuiControl, Disable, ListBox1

   ; Tastaturkrzel deaktivieren, womit auch vermieden wird,
   ; dass der Hook die Maus und Tastatur blockiert
   Hotkey, ^SC056, Off
   Hotkey, ~RButton, Off
   Hotkey, ~Del, Off

   ; Sprechblase, dass die Indizierung beginnt
   TrayTip, %Titel_qcd%, %lngIndiziere%,10

   ; Alle Laufwerksbuchstaben durchgehen
   Loop, Parse, selectedDrives_qcd
   {
      ActDrive_qcd   = %A_LoopField%                      ; Aktuelles Laufwerk
      IndexTemp_qcd  = %IndexPath_qcd%\%IndexFile_qcd%%ActDrive_qcd%_tmp.dat ; Temporrer Index
      IndexDest_qcd  = %IndexPath_qcd%\%IndexFile_qcd%%ActDrive_qcd%.dat     ; Verzeichnisindex
      PercentInt_qcd = 0                            ; 0 %

      ; Tooltip fr das Trayicon ndern
      Menu,tray,Tip, %Titel_qcd%`n%lngUntersuche% %ActDrive_qcd%:

      ; Laufwerk durchgehen und anzahl der Verzeichnisse ermitteln
      Loop, %ActDrive_qcd%:\*.* , 2, 1 ; Nur Verzeichnisse und Rekursiv
      {
         NumFolders_qcd = %A_Index%
         gosub, Animate_qcd            ; Trayicon animieren
         If BreakIndexing_qcd = yes    ; Abbruch?
            break
       }

      ; 100 / Anzahl der Verzeichnisse = Hochzhlwert fr den Prozentwert
      PercentInc_qcd = 100
      PercentInc_qcd /= %NumFolders_qcd%.0 ; .0, weil sonst keine Nachkommastellen errechnet werden

      Percent_qcd     = 0
      PercentLast_qcd = 0

      ; Laufwerk durchgehen und Verzeichnisse in Verzeichnisindex schreiben
      Loop, %ActDrive_qcd%:\*.* , 2, 1
      {
         FileAppend, %A_LoopFileFullPath%`n, %IndexTemp_qcd% ; in Verzeichnisindex schreiben
         Percent_qcd += %PercentInc_qcd%                     ; Prozentwert erhhen

         Transform, PercentInt_qcd, Round, %Percent_qcd%  ; gerundeter Prozentwert (fr Anzeige)

         if PercentInt_qcd <> %PercentLast_qcd% ; Wenn sich Prozentwert gendert hat ...
         {
            ; ... Tooltip anpassen und Trayicon animieren
            ; durch den gerundeten Wert werden die folgende Befehle seltener ausgefhrt
            ; womit die Geschwindigkeit erhht wird (Tooltip anpassen bremst)
            Menu, TRAY, Tip, %Titel_qcd%`n%lngUntersuche% %ActDrive_qcd%: %PercentInt_qcd%`% (%A_Index%/%NumFolders_qcd%)
            IconDelay_qcd  = 150                ; Animation erzwingen
            gosub, Animate_qcd                  ; Trayicon animieren
            PercentLast_qcd = %PercentInt_qcd%  ; letzen Prozentwert merken
         }
         gosub, Animate_qcd                     ; Trayicon animieren

         If BreakIndexing_qcd = yes             ; Abbruch?
            break
      }

      FileMove, %IndexTemp_qcd%, %IndexDest_qcd%,1 ; Verzeichnisindex durch temporren Index ersetzen

      If BreakIndexing_qcd = yes                   ; Abbruch?
        break
   }
   TrayTip                      ; Sprechblase entfernen
   BreakIndexing_qcd =          ; Indizierung beendet

   ; Tastaturkrzel wieder zulassen
   Hotkey, ~RButton,On
   Hotkey, ^SC056,On
   Hotkey, ~Del,On

   ; Trayicon und Tooltip zurcksetzen
   Menu, TRAY, Icon   , %SystemRoot%\system32\SHELL32.dll,46
   Menu, TRAY, Tip    , %Titel_qcd%

   ; Traymen zurcksetzen
   Menu, TRAY, Enable , %lngWechseln%
   Menu, TRAY, Enable , %lngReIndizierung%
   Menu, TRAY, Delete , %lngReIndizierungBreak%
   Menu, TRAY, Default, %lngWechseln%

   ; Schaltflchen wieder aktivieren
   GuiControl, Enable, Button1
   GuiControl, Enable, Button3
   GuiControl, Enable, Button4
   GuiControl, Enable, ListBox1

   ; Fenstertitel zurcksetzen (wegen Animation)
   WinSetTitle ,,, %Titel_qcd%

   selectedDrives_qcd = %Drives_qcd%
Return

; ---------------------------------------------------------------------
subIndexDrives_qcd: ; Laufwerke indizieren:Aufruf vom Untermen
   if A_ThisMenuItem = %lngAktualisierenAlle%
   {
      selectedDrives_qcd = %Drives_qcd%
   }
   else
   {
      StringLeft, selectedDrives_qcd, A_ThisMenuItem, 1
   }
   gosub, IndexDrives_qcd
Return

; ---------------------------------------------------------------------
Animate_qcd: ;    Animiertes Trayicon und Fenstertitel

   FirstIcon = 3  ; erste IconNr
   LastIcon  = 13 ; letzte IconNr

   ; Verzgerung, damit nich bei jedem Aufruf die Icondateien geladen werden
   ; ansonsten wrde das Skript stark gebremst
   IconDelay_qcd++         ; Verzgerungswert
   if IconDelay_qcd < 150  ; kleiner 150 ...
      return               ; ... dann Unterroutine verlassen

   IconDelay_qcd = 0

   ; IconNr hochzhlen
   TrayIcon_qcd++
   If TrayIcon_qcd < %FirstIcon%
      TrayIcon_qcd = %FirstIcon%
   If TrayIcon_qcd > %LastIcon%
      TrayIcon_qcd = %FirstIcon%

   ; Icon ndern
   Menu,TRAY,Icon,%SystemRoot%\system32\taskmgr.exe,%TrayIcon_qcd%

   ; Titelleisten-Animation
   NumAni_qcd++       ; Animationstufe hochzhlen
   If NumAni_qcd > 6
      NumAni_qcd = 1

   ; linke animierte Klammer
   AnimL_qcd1 = [
   AnimL_qcd2 = (
   AnimL_qcd3 = 
   AnimL_qcd4 = -
   AnimL_qcd5 = 
   AnimL_qcd6 = (

   ; rechte animierte Klammer
   AnimR_qcd1 = ]
   AnimR_qcd2 = )
   AnimR_qcd3 = 
   AnimR_qcd4 = -
   AnimR_qcd5 = 
   AnimR_qcd6 = )

   ; Mit StringTrimLeft Arrays simulieren
   StringTrimLeft, AnimL_qcd, AnimL_qcd%NumAni_qcd%, 0
   StringTrimLeft, AnimR_qcd, AnimR_qcd%NumAni_qcd%, 0

   ; Titelleiste anpassen
   WinSetTitle ,,, %Titel_qcd%  %AnimL_qcd% %ActDrive_qcd%: %PercentInt_qcd% `% %AnimR_qcd%
Return

; ---------------------------------------------------------------------
; -- Unterroutine fr den Verzeichniswechsel --------------------------
; ---------------------------------------------------------------------
q_ChangeDir: ; Unterroutine fr den Verzeichniswechsel

   WinWaitNotActive, %Titel_qcd%               ; Warte bis QCD-Fenster verschwunden
   WinActivate, qhk_class q_class              ; Fenster anzeigen, wo QCD aufgerufen wurde

   ; Prfen ob Fensterklasse untersttzt wird
   if q_class contains #32770,ExploreWClass,CabinetWClass,Afx:400000:0,FileZilla Main Window,bosa_sdm
   {
      ; Ermitteln ob ein Edit1-Control vorhanden ist (Eingabezeile)
      q_EditClass = Edit1
      ControlGetPos, q_Edit1Pos,,,, %q_EditClass% , ahk_id %q_window_id%
   }
   if q_Edit1Pos =  ; Wenn kein Edit1-Control gefunden ...
   {
      ; Ermitteln ob ein RichEdit-Control vorhanden ist (MS-Office)
      q_EditClass = RichEdit20W2
      ControlGetPos, q_Edit1Pos,,,, %q_EditClass% , ahk_id %q_window_id%
   }

   if ctrlState_qcd =                  ; Wenn keine vorgetuschte Strg-Taste
      GetKeyState, ctrlState_qcd, Ctrl ; Stauts der Strg-Taste ermitteln

   if ctrlState_qcd <> D ; wenn Strg-Taste nicht gedrckt ...
   {
      ; Verzeichnis in Dateidialogen wechseln
      if q_class contains #32770,bosa_sdm
      {
         if q_Edit1Pos <>
         {
            WinActivate ahk_id %q_window_id%
            ControlGetText, q_text, %q_EditClass%, ahk_id %q_window_id%
            ControlSetText, %q_EditClass%, %q_path%, ahk_id %q_window_id%
            ControlSend   , %q_EditClass%, {Enter} , ahk_id %q_window_id%
            Sleep, 100
            ControlSetText, %q_EditClass%, %q_text%, ahk_id %q_window_id%
            return
         }
      }

      ; Verzeichnis in Explorer-Fenstern wechseln
      else if q_class in ExploreWClass,CabinetWClass
      {
         if q_Edit1Pos <>
         {
            ControlSetText, Edit1, %q_path%      , ahk_id %q_window_id%
            ControlSend   , Edit1, {Right}{Enter}, ahk_id %q_window_id%
            return
         }
      }

      ; Verzeichnis in AcdSee wechseln
      else if q_class = Afx:400000:0
      {
         if q_Edit1Pos <>
         {
            ControlSetText, Edit1, %q_path%, ahk_id %q_window_id%
            ControlSend   , Edit1, {Enter} , ahk_id %q_window_id%
            return
         }
      }

      ; Verzeichnis in FireFox wechseln
      else if q_class = FileZilla Main Window
      {
         if q_Edit1Pos <>
         {
            ControlSetText, Edit1, %q_path%, ahk_id %q_window_id%
            ControlSend   , Edit1, {Enter} , ahk_id %q_window_id%
            return
         }
      }

      ; Verzeichnis in der Eingabeaufforderung wechseln
      else if q_class = ConsoleWindowClass
      {
         WinGetActiveTitle, wTitle
         if wTitle contains cmd.exe
         {
            WinActivate, ahk_id %q_window_id%
            SetKeyDelay, 0
            IfInString, q_path, :
            {
               StringLeft, q_path_drive, q_path, 1
               Send %q_path_drive%:{enter}
            }
            Send, cd %q_path%{Enter}
            return
         }
      }
   }

   ; Wenn alles nicht passt oder Strg gedrckt war, einfach nur den Explorer aufrufen
   Run, Explorer %q_path%
return

Quit:
   ExitApp
Return
