; ---------------------------------------------------------------------
; Name:             MacName v0.4
; Author:           Wolfgang Reszel fr c't
; Datum:            5.12.2004
;
; Language:         german
; Platform:         tested with XP
; #Includeable:     no
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Erweitert das Kontextmen des Explorers, so dass man einen
; Menpunkt erhlt, um Datienamen auf 31 Zeichen zu krzen.
;
; Die Idee kam mir, weil ich ein einem gemischten Netzwerk mit Macs
; arbeite und bei Macs die Dateinamen nur 31 Zeichen lang sein drfen.
;
; Das Skript luft nur als kompilierte EXE-Datei vernnftig, da der
; Aufruf ber das Kontextmen bei normalen Skript-Dateien zu einer
; Fehlermeldung fhrt. Fr diesen Zweck liegt ein kleines Skript namens
; compile_MacName.ahk vor, welches MacName mit einem hbschen Icon
; kompiliert.
;
; Beim ersten Start fragt das Skript, ob es installiert werden soll.
; Die Deinstallation geschieht ber Systemsteuerung/Software
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; -- Initialisierung --------------------------------------------------
; ---------------------------------------------------------------------

#SingleInstance off
#NoTrayIcon

Version   = 0.4
LongName  = Dateiname fr Mac OS Classic krzen
LongName2 = Verzeichnisname fr Mac OS Classic krzen
ShortName = MacName
Titel     = %LongName% v%Version% Freeware

; ---------------------------------------------------------------------

if 1 = ; ohne Kommandozeillenparameter
{
   ; Prfen ob MacName schon in Registry eingetragen
   RegRead, Reg_mn, HKEY_CLASSES_ROOT,Folder\shell\%LongName2%\command
   StringReplace, Reg_mn, Reg_mn ,%A_SPACE%"`%1",   ; [ "%1"] entfenren

   if Reg_mn <> %A_ScriptFullPath% ; Wenn Script noch nicht eingetragen
   {
      ; Fragen ob MacName ins Kontextmen integriert werden soll
      MsgBox, 36, %Titel%, Soll %ShortName% in das Explorer-Kontextmen integriert werden?
      IfMsgBox, Yes ; Wenn Ja
      {
         ; Prfe ob es sich um die kompilierte Version des Skripts handelt.
         SplitPath, A_ScriptName,,, Ext_mn
         if Ext_mn = AHK
         {
            MsgBox, 16, %Titel%, Die Integration Ins Kontextmen funktioniert nur mit der kompilierten Version des Skripts!
            ExitApp
         }

         ; MacName in Registry eintragen
         RegWrite, REG_SZ, HKEY_CLASSES_ROOT , *\shell\%LongName%\command        ,                , %A_ScriptFullPath% "`%1"
         RegWrite, REG_SZ, HKEY_CLASSES_ROOT , Folder\shell\%LongName2%\command  ,                , %A_ScriptFullPath% "`%1"
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName%, DisplayIcon    , %A_ScriptFullPath%
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName%, DisplayName    , %ShortName% v%Version%
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName%, DisplayVersion , v%Version%
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName%, Publisher      , Wolfgang Reszel
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName%, UninstallString, %A_ScriptFullPath% /uninstall

         MsgBox, 64, %Titel%, %ShortName% wurde installiert!
      }
   }
   else ; MacName ist schon installiert
   {
      ; Hinweis ausgeben, wie MacName zu verwenden ist
      MsgBox, 64, %Titel%, %ShortName% muss mit einem Dateinamen als Parameter aufgerufen werden!
   }
   ExitApp ; Ende
}

if 1 = /uninstall ; Wenn Kommandozeilenparameter = "/uninstall%
{
   ; Fragen ob MacName deinstalliert werden soll
   MsgBox, 36, %Titel%, Soll %ShortName% wirklich deinstalliert werden?
   IfMsgBox, Yes ; Wenn Ja
   {
      ; MacName aus der Registry entfernen
      RegDelete, HKEY_CLASSES_ROOT       , *\shell\%LongName%
      RegDelete, HKEY_CLASSES_ROOT       , Folder\shell\%LongName2%
      RegDelete, HKEY_LOCAL_MACHINE      , SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName%
      ; Eintrag in RunOnce, so dass MacName nach dem nchsten Systemstart gelscht wird
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce, %ShortName%, %comspec% /c del /q "%A_ScriptFullPath%"

      MsgBox, 64, %Titel%, %ShortName% wurde deinstalliert. %A_ScriptName% wird nach einem Neustart automatisch gelscht.
   }
   ExitApp
}

; Hier geht's weiter, wenn eine Datei als Kommandozeilenparameter bergeben wurde

SplitPath, 1, FName, FDir, FExt ; Zerleht den Dateipfad in seine Bestandteile

; berflssige Dateinamenbestandteile vorab entfernen
StringReplace, NewName, FName  , Microsoft Word -%A_SPACE% ,,1
StringReplace, NewName, NewName, Microsoft Powerpoint -%A_SPACE% ,,1
StringReplace, NewName, NewName, Microsoft PowerPoint -%A_SPACE% ,,1
StringReplace, NewName, NewName, Kopie von%A_SPACE%,,1
StringReplace, NewName, NewName, .doc.pdf,.pdf,1
StringReplace, NewName, NewName, .indd.pdf,.pdf,1

SplitPath, NewName,,,, NewNameNoExt ; (gesuberter) Name ohne Dateierweiterung

StringLen,ExtLen,FExt               ; Lnge der Dateierweiterung
if ExtLen = 0                       ; Wenn keine Dateierweiterung
{
   Dot    =                         ; dann kein Trennzeichen verwenden
   MaxLen = 31                      ; Maximallnge
}
else                                ; sonst
{
   Dot    = .                       ; Trennzeichen
   MaxLen = 30                      ; Miximallnge - Trennzeichen
}

MaxLen-=%ExtLen%                    ; Lnge der Dateierweiterung von der Maximallnge abziehen

StringLeft,NewName,NewNameNoExt,%MaxLen% ; Dateinamen auf Lnge krzen
ShortName=%NewName%%Dot%%FExt%           ; gekrzter Dateiname mit Erweiterung

; Umbenennen-Dialog anzeigen
GUI, add, Text  ,                                 , Alter Dateiname:
GUI, add, edit  ,            w445 Disabled        , %FName%
GUI, add, Text  , x10   y59                       , Neuer Dateiname (max. 31 Zeichen):
GUI, font, s10, Courier
GUI, add, edit  , x195  y55  w260 vEditName       , %ShortName%
GUI, font
GUI, add, Button, x10   y+15 w70                  , &Original
GUI, add, Button, x+220      w70                  , &Abbrechen
GUI, add, Button, x+5        w80  Default Disabled, &Umbenennen
GUI, Show,, %Titel%

; ToolTip fr Dialog starten
SetTimer, ToolTip, 100 ; alle 100ms aufrufen

Return ; Auto-Execute-Bereich beenden

; ---------------------------------------------------------------------
ToolTip: ; ToolTip fr den Dialog

   ifWinActive, ahk_class AutoHotkeyGUI,%FName%  ; Prfe, ob Dialog im Vordergrund
   {
      ; Cursorposition ermitteln
      X = %A_CaretX%
      X += 7
      Y = %A_CaretY%
      Y += 13

      ControlGetText,Name, Edit2, ahk_class AutoHotkeyGUI ; Inhalt des Edit-Felds (Dateiname) einlesen

      StringLen, Len, Name                                ; Lnge des Dateinamens im Edit-Feld
      if Len > 31                                         ; Wenn zu lang
      {
         GuiControl, Disable, Button3                         ; Umbenennen-Schaltflche deaktivieren
         ToolTip, Dateiname lnger als 31 Zeichen,%X%,%Y%    ; ToolTip zeigen (Name zu lang)
      }
      else                                                ; Wenn Name nicht zu lang
      {
         if Len < 1                                       ; Wenn Name evtl. leer
         {
            GuiControl, Disable, Button3                                ; Umbenennen-Schaltflche deaktivieren
            ToolTip, Dateiname muss mindestens 1 Zeichen haben,%X%,%Y% ; ToolTip zeigen
         }
         else                                             ; dann ist der name OK
         {
            ifExist, %FDir%\%Name%                        ; direkt prfen ob die Datei existiert
            {
                GuiControl, Disable, Button3                  ; Umbenennen-Schaltflche deaktivieren
                if Name <> %FName%                           ; ToolTip zeigen, wenn Dateiname nicht dem Ursprungsnamen entspricht
                   ToolTip, Es existiert bereits eine Datei mit diesem Namen,%X%,%Y%
            }
            else                                          ; dann scheint einer Umbenennung nichts im Wege zu stehen
            {
               GuiControl, Enable, Button3                 ; Umbenennen-Schaltflche wieder aktivieren
               ToolTip                                    ; ToolTip entfernen
            }
         }
      }

      ; ToolTip fr den Original-Button
      MouseGetPos,,, id, control ; Prfe den Control unter dem Mauszeiger
      if control = Button1     ; Wenn Button1 (Original-Button)
      {
         if Tip <> aktiv             ; Tip ist noch nicht aktiv
         {
            settimer,OrgTip,600      ; Tip in 600ms wieder ausblenden und der Maus folgen lassen
            Tip = aktiv              ; merken, dass Aktiv
         }
      }
      else                     ; dann ist die Maus wohl woanders
      {
         ToolTip,,,,2          ; Tip Nr. 2 entfernen (Nr. 1 ist schon fr die Infos am Dateinamen zustndig)
         settimer,OrgTip,Off   ; Den Timer fr die Tip-Positionierung ausschalten
         Tip =                 ; Tip ist nicht mehr aktiv
      }
   }
   else  ; dann ist Fenster wohl miniert oder ein anderes aktiviert
   {
      ToolTip        ; ToolTip 1 auscshalten
      ToolTip,,,,2   ; ToolTip 2 ausschalten
      Tip =          ; Tip ist nicht aktiv
   }
return

; ---------------------------------------------------------------------
OrgTip: ; ToolTip der Maus folgen lassen
   ToolTip, ungekrzten Dateinamen eintragen,,,2
   settimer,OrgTip,Off
return

; ---------------------------------------------------------------------
ButtonUmbenennen: ; Datei umbenennen
   GuiControlGet, OK, Enabled, Button3 ; Wenn Button aktiv (wird getestet, da Enter auch einen inaktiven Button drckt)
   if OK = 1
   {
      Gui, submit                         ; Dateinamen in Variable bergeben
      FileMove, %1%, %FDir%\%EditName%    ; Datei umbenennen
      if ErrorLevel > 0                   ; Fehler?
         MsgBox, Datei konnte nicht umbenannt werden ; dann Meldung ausgeben
      ExitApp ; Ende Gelende
   }
return

; ---------------------------------------------------------------------
ButtonOriginal:   ; Dateiname wieder auf Original zurcksetzen
  ControlSetText,Edit2,%FName%, ahk_class AutoHotkeyGUI
return

; ---------------------------------------------------------------------
ButtonAbbrechen:  ; Abbrechen
GuiEscape:
GuiCancel:
GuiClose:
   ExitApp
return
