; ---------------------------------------------------------------------
; Name:             MDIList v0.1
; Author:           Wolfgang Reszel fr c't
; Datum:            5.12.2004
;
; Language:         german
; Platform:         tested with XP
; #Includeable:     yes
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Wenn man die rechte Maustaste auf der Titelleiste einer
; Mehrfensteranwendung (MDI) gedrckt hlt, erscheint kurz darauf eine
; Liste aller MDI-Fenster. In vielen MDI-Anwendungen kann man so die
; Fenster schnell wechseln.
;
; Ist leider nicht so universell wie man es sich wnschen wrde.
; Folgende MDI-Anwendungen funktionieren bei mir:
; MED
; Photoshop
; InDesign
; Illustrator
;
; Folgende gingen bei mir nicht:
; PsPad
; Opera
; Firefox
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; Kontextmen fr MDI-Anwendungen
RButton:: ; HotkeyDef

   WinGet, win_id_mdi, ID, A   ; ID des aktuellen Fensters
   SysGet, TitleH_mdi , 30     ; Hhe der Titelzeile
   SysGet, BorderH_mdi, 33     ; RandStrke
   TitleH_mdi += %BorderH_mdi%

   MouseGetPos, MouseX_mdi, MouseY_mdi, MouseWin_mdi     ; Fenster-ID an Mausposition
   WinGetTitle, MouseWinTitle_mdi, ahk_id %MouseWin_mdi% ; Fenstertitel an Mausposition

   if MouseWinTitle_mdi <>                  ; Wenn Fenstertitle nicht leer
   if win_id_mdi = %MouseWin_mdi%           ; und Klick war im aktuellen Fenster
   if MouseY_mdi between 0 and %TitleH_mdi% ; und Mauszeige in Titelleiste ...
   {
      GetKeyState, MState_mdi, RButton, P   ; Status der rechten Maustaste lesen
      if MState_mdi = D                     ; ist sie gedrckt?
      {
         KeyWait, RButton, U T0.2           ; Warte ob in 0.2 sec die Maustaste losgelassen wird
         if ErrorLevel = 1                  ; Die Maustaste blieb weiter gedrckt
         {
            WinGet, ControlList_mdi, ControlList, A       ; Liste aller Controls
            Menu, MDIs, add, %MouseWinTitle_mdi% ,MDImenu ; Erste Menzeile mit Fenstertitel
            Menu, MDIs, add,                              ; ---

            MDIshow_mdi = 0                               ; initialisieren (Men leer)

            Loop, parse, ControlList_mdi, `n              ; Controlliste durchsuchen
            {
               If A_LoopField contains Window, MDI, child, TEXTWIN, DocC, Afx  ; Vermutlich ein MDI-Fenster
               {
                  ControlGetText, ControlText_mdi, %A_LoopField%, A            ; Titel des MDI-Fensters ermitteln
                  if ControlText_mdi <>                                        ; wenn nicht leer
                  {
                     Menu, MDIs, Add, %ControlText_mdi%, MDImenu               ; dann zum Men hinzufgen
                     MDIshow_mdi = 1                                           ; Men gilt nun als vorhanden
                  }
               }
            }
            If MDIshow_mdi = 1         ; Men vorhanden
            {
               Menu, MDIs, show        ; Men anzeigen
               Menu, MDIs, DeleteAll   ; bei Verlassen Men lschen
               return                  ; Ende
            }
            Menu, MDIs, DeleteAll      ; Wenn Men nicht vorhanden, angefangenes Men lschen
         }
      }
   }
   send,{%A_ThisHotkey%}  ; Wenn kein Men gezeigt wird, wird die rechte Maustaste gesendet
return

; ---------------------------------------------------------------------
MDImenu: ; Menpunkt ausfhren
   WinActivate, ahk_id %win_id_mdi%                       ; MDI-Anwendung in Vordergrund
   Loop, parse, ControlList_mdi, `n                       ; Controlliste durchsuchen
   {
      ControlGetText, ControlText_mdi, %A_LoopField%, A   ; Titel des MDI-Fensters ermitteln
      if ControlText_mdi = %A_ThisMenuItem%               ; Wenn Titel = ausgewhlter Menpunkt
      {
         ControlClick, %A_LoopField%, ahk_id %win_id_mdi% ; dann MDI-Fenster anklicken
      }

      ControlGetText, ControlText_mdi, %A_LoopField%, A   ; s.o.
      if ControlText_mdi = %A_ThisMenuItem%
      {
         ControlFocus, %A_LoopField%, ahk_id %win_id_mdi% ; zur Sicherheit nochmal den Focus setzen
      }
   }
return

