/* $Id: timer.h 52 2004-12-09 15:11:47Z olau $ */

#define T_RESULT_RESOLUTION       1000LL    /* milliseconds */

#ifdef WIN32

#include <windows.h>
typedef LARGE_INTEGER TIMER;
extern LONGLONG tickFreq;

#define startTimer(t) QueryPerformanceCounter(t)

#else

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <sys/time.h>

extern struct timezone tz;
#define startTimer(t) gettimeofday(t, &tz)

typedef struct timeval TIMER;
typedef long long LONGLONG;
typedef unsigned long long ULONGLONG;

LONGLONG tv2l(TIMER *);

#endif

LONGLONG stopTimer(TIMER *);
