/* $Id: search.cpp 89 2004-12-14 20:22:17Z towi $

   Mustersuche in Zeichenfolgen mit folgenden Algorithmen:
   Brute Force, Boyer-Moore, Quicksearch, Turbosearch

   Autor: Michael Tamm, c't 8/97
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>

#ifdef __GNUG__
#include <unistd.h>
#endif

// die Shifttabelle fr BM, QS und TS
static int shift[256];


/***************/
/* Brute-Force */
/***************/

int bf_search(char *text, char *p, int m)
{
   int i;
   char *t = text;
   for (;;)
   {
      i = m - 1;
      while (t[i] == p[i])
      {
         if (--i < 0)
            return (int) (t - text); // Muster gefunden
      }
      ++t; // nchste Stelle im Text untersuchen
   }
}

//towi: 
// unrolled loop, checks only every 16th time for end of text.
// this function need an overshoot behind the text.
int bf_search_safe(char *text, char *p, int n, int m)
{
   int i;
   char *t_end = text+n;

#define LOOP \
   i = m - 1; \
   while(t[i]==p[i]) \
     if(--i<0) \
       return (int)(t-text); \
     t++;

   // needs overshoot in the text!
   for (char *t=text; t < t_end; )
   {
       LOOP;
#if 1   // switch this to 0 if you want it _very_ safe, without overshoot.
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
       LOOP;
#endif
   }
   return -1;
}


/***************/
/* Boyer-Moore */
/***************/
 
void bm_init(char *p, int m)
{
   int i;
   for (i = 0; i < 256; i++)
      shift[i] = m;
   for (i = 1; i < m; i++)
      shift[(int) p[i - 1]] = m - i;
}


int bm_search(char *t, char *p, int m)
{
   int i, j, k;
   for (i = j = m - 1; j>=0; i--, j--)
   {
      while (t[i] != p[j])
      {
         k = shift[(unsigned char) t[i]];
         i += (m - j > k)? m - j : k;
         j = m - 1;
      }
   }
   return i + 1;
}


/***************/
/* Quicksearch */
/***************/

void qs_init(char *p, int m)
{
   int i;
   for (i = 0; i < 256; i++)
      shift[i] = m + 1; // Default-Sprungweite
   for (i = 0; i < m; i++)
      shift[(int) p[i]] = m - i;
}

int qs_search(char *text, char *p, int m)
{
   char *t = text;
   for (;;)
   {
      int i = m - 1;
      while (t[i] == p[i])
      {
         if (--i < 0)
            return (int) (t - text); // Muster gefunden
      }
      t += shift[(int) t[m]];
   }
}


/***************/
/*  T-Search   */
/***************/

// Verschiebung "in Gedanken" nach einem erfolgreichen Vergleich
static int look_at; 

void ts_init(char *p, int m)
{
   int i;
   for (i = 0; i < 256; i++) // Initialisierung wie bei Quicksearch
      shift[i] = m + 1;
   for (i = 0; i < m; i++)
      shift[(int) p[i]] = m - i;
   for (look_at = 0; look_at < (m - 1); look_at++)
      if (p[m - 1] == p[m - (look_at + 2)])
         break;
}

int ts_search(char *text, char *p, int m)
{
   int i;
   char *t = text;
   for (;;)
   {
      i = m - 1;
      while (t[i] != p[i])
      {
         t += shift[(int) t[m]];
      }
      --i;
      while (t[i] == p[i])
      {
         if (--i < 0)
            return (int) (t - text); // Muster gefunden
      }
      t += look_at + shift[(int) t[m + look_at]];
   }
}
